/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.domain.model.adopt;

import com.tplink.smb.device.firmware.upgrade.api.FirmwareUpgradeService;
import com.tplink.smb.device.firmware.upgrade.common.constants.FirmwareUpgradeStatusEnum;
import com.tplink.smb.device.firmware.upgrade.common.constants.device.DeviceFirmwareUpgradeError;
import com.tplink.smb.device.firmware.upgrade.common.dto.UpgradeStatusDTO;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.DeviceHolder;
import com.tplink.smb.ecsp.message.grpc.EcspAdoptInfo;
import com.tplink.smb.eventcenter.api.event.DomainEvent;
import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.log.component.client.api.LogApiService;
import com.tplink.smb.omada.async.business.h;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.EcspFirstVersionEnum;
import com.tplink.smb.omada.device.manage.message.EcspVersion;
import com.tplink.smb.omada.device.manage.message.body.adopt.BaseAdoptDeviceInfo;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogKeyEnumDTO;
import com.tplink.smb.omada.manager.device.api.web.device.dto.AdoptOneDeviceStatusResultVO;
import com.tplink.smb.omada.manager.device.application.adoption.AbstractAdoptResponseDTO;
import com.tplink.smb.omada.manager.device.application.adoption.f;
import com.tplink.smb.omada.manager.device.domain.model.adopt.A;
import com.tplink.smb.omada.manager.device.domain.model.adopt.AdoptManageService;
import com.tplink.smb.omada.manager.device.domain.model.adopt.C;
import com.tplink.smb.omada.manager.device.domain.model.adopt.ManageDeviceHandleConfigProperties;
import com.tplink.smb.omada.manager.device.domain.model.adopt.h.b;
import com.tplink.smb.omada.manager.device.domain.model.adopt.j;
import com.tplink.smb.omada.manager.device.domain.model.adopt.n;
import com.tplink.smb.omada.manager.device.domain.model.adopt.v;
import com.tplink.smb.omada.manager.device.domain.model.adopt.x;
import com.tplink.smb.omada.manager.device.domain.model.adopt.z;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.device.J;
import com.tplink.smb.omada.manager.device.domain.model.device.O;
import com.tplink.smb.omada.manager.device.domain.model.device.X;
import com.tplink.smb.omada.manager.device.domain.model.device.event.DeviceEvent;
import com.tplink.smb.omada.manager.device.domain.model.device.olt.p;
import com.tplink.smb.omada.manager.device.domain.model.device.osg.B;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.RunTimeAdoptInfo;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.b.c;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.l;
import com.tplink.smb.omada.manager.device.domain.model.message.set.e;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cache.UpgradeDeviceItem;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.CloudDeviceUpgradeService;
import com.tplink.smb.omada.manager.j.a.a.d;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

public abstract class a<T extends com.tplink.smb.omada.manager.device.domain.model.deviceimage.d, E extends AbstractAdoptResponseDTO<?>>
implements j<T, E> {
    @Generated
    private static final Logger h = LoggerFactory.getLogger(a.class);
    protected l a;
    protected C b;
    private A i;
    protected b c;
    private com.tplink.smb.omada.manager.device.domain.model.adopt.h.a j;
    private com.tplink.smb.omada.async.business.c k;
    private com.tplink.smb.omada.manager.device.domain.model.upgrade.cache.c l;
    protected O d;
    private com.tplink.smb.omada.manager.device.port.transport.h.d m;
    private FirmwareUpgradeService n;
    private AdoptManageService o;
    private com.tplink.smb.omada.manager.device.domain.model.upgrade.j p;
    private LogApiService q;
    @Autowired
    private CloudDeviceUpgradeService r;
    @Autowired
    private com.tplink.smb.omada.manager.stomp.a.a s;
    @Autowired
    @Lazy
    private e t;
    @Autowired
    private ManageDeviceHandleConfigProperties u;
    @Autowired
    private x v;
    @Autowired
    private n w;
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.upgrade.a.b x;
    @Autowired
    protected com.tplink.smb.omada.manager.device.domain.model.omadac.c e;
    @Autowired
    private com.tplink.smb.omada.manager.common.b.a.b.f y;
    private z z;
    @Autowired
    protected com.tplink.smb.omada.manager.device.domain.model.deviceimage.a f;
    @Autowired
    private com.tplink.smb.omada.manager.device.port.transport.meter.a A;
    @Autowired
    protected com.tplink.smb.omada.manager.device.domain.model.cluster.c g;
    @Autowired
    private p B;
    @Autowired
    private B C;
    @Autowired
    private v D;
    private static final String E = "handleDeviceNegotiationV2";
    private static final String F = "updateByAdoptResponseV2Operation";
    private static final String G = "handAdoptSuccessCommonOperation";
    private static final String H = "handAdoptSuccessCommon";
    private static final String I = "addRememberDeviceReAdoptLog";
    private static final String J = "delayForgetFactoryDeviceWhenCbc";
    private static final String K = "deviceImageRepository.save";
    private static final String L = "deleteAllCachedSetMsg";
    private static final String M = "saveConnectionInfoOnAdoptSucceeded";
    private static final String N = "upgradeSuccess";
    private static final String O = "saveModelFwInfo";
    private static final String P = "publishAdoptSucceeded";
    private static final long Q = 300000L;

    @Override
    public void a(@Nonnull T deviceImage, @Nonnull com.tplink.smb.omada.manager.device.application.adoption.b adoptCommand, @Nonnull Consumer<OperationResponse<?>> completeConsumer) {
        com.tplink.smb.omada.common.g.b checkRequires = this.a(deviceImage, adoptCommand.c(), adoptCommand.d());
        if (!checkRequires.a()) {
            h.debug("Adopt {} {} , errCode is {}", new Object[]{((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), checkRequires});
            completeConsumer.accept(new OperationResponse(checkRequires, (Object)X.a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).at())));
            return;
        }
        if (!this.a(deviceImage, completeConsumer, null)) {
            return;
        }
        h.debug("start adopt device {} omadac {}.", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am());
        this.a(deviceImage, adoptCommand.d(), adoptCommand.f(), adoptCommand.g());
    }

    @Override
    public void a(@Nonnull T deviceImage, @Nonnull f adoptCommand, @Nonnull Consumer<OperationResponse<?>> completeConsumer) {
        com.tplink.smb.omada.manager.j.a.a.c customerId = adoptCommand.c();
        G deviceMac = adoptCommand.e();
        DeviceTypeEnum deviceType = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).an();
        com.tplink.smb.omada.common.g.b checkRequires = this.a(deviceImage, adoptCommand.c(), adoptCommand.d());
        if (!checkRequires.a()) {
            h.debug("Adopt {} {} , errCode is {}", new Object[]{((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), checkRequires});
            completeConsumer.accept(checkRequires.a((Object)X.a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).at())));
            return;
        }
        h.info("MSP: Assigning device: {} to customer: {}", (Object)deviceMac, (Object)customerId);
        this.e.a(deviceMac, deviceType, customerId, adoptCommand.k());
        ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).a(adoptCommand.k());
        this.a.a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ap(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al());
        ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).a(customerId);
        this.a.a((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage);
        if (!this.a(deviceImage, completeConsumer, null)) {
            return;
        }
        h.debug("MSP: start adopt device {} to customer {}.", (Object)deviceMac, (Object)customerId);
        this.a(deviceImage, adoptCommand.d(), adoptCommand.f(), adoptCommand.g());
    }

    protected boolean a(@Nonnull T deviceImage, Consumer<OperationResponse<?>> completeConsumer, @Nullable Supplier doAfterAdoptSuccess) {
        com.tplink.smb.omada.manager.j.a.a.c omadacId = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am();
        G deviceMac = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al();
        com.tplink.smb.omada.async.business.e businessId = com.tplink.smb.omada.async.business.e.a();
        RunTimeAdoptInfo runTimeAdoptInfo = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).aF();
        if (runTimeAdoptInfo == null) {
            runTimeAdoptInfo = new RunTimeAdoptInfo();
            ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).a(runTimeAdoptInfo);
        }
        com.tplink.smb.omada.async.business.e fullAdoptBusinessId = com.tplink.smb.omada.async.business.e.a();
        runTimeAdoptInfo.setBusinessId(businessId);
        runTimeAdoptInfo.setFullAdoptBusinessId(fullAdoptBusinessId);
        this.a.a((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage);
        h adoptDeferredResponse = new h(businessId, Long.valueOf(70000L), (Object)com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.f.b());
        adoptDeferredResponse.a(arg_0 -> this.a(omadacId, deviceMac, businessId, deviceImage, completeConsumer, (Supplier)doAfterAdoptSuccess, arg_0));
        boolean watched = this.k.a(adoptDeferredResponse);
        if (!watched) {
            h.error("Failed to start watch an async adoptDevice business of {} {}", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al());
            completeConsumer.accept(OperationResponse.GENERAL_ERROR);
            return false;
        }
        h.info("start watching adopt result of {} {}, {}", new Object[]{((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), businessId});
        this.a(deviceImage, fullAdoptBusinessId, "manually");
        return true;
    }

    protected void a(@Nonnull T deviceImage, @Nonnull com.tplink.smb.omada.async.business.e fullAdoptBusinessId, @Nonnull String adoptType) {
        com.tplink.smb.omada.manager.j.a.a.c omadacId = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am();
        G deviceMac = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al();
        long start = System.currentTimeMillis();
        h adoptDeferredResponse = new h(fullAdoptBusinessId, Long.valueOf(300000L), (Object)com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.f.b());
        adoptDeferredResponse.a(resultInt -> {
            try {
                com.tplink.smb.omada.manager.device.domain.model.deviceimage.d currentDeviceImage;
                Optional deviceImageOpt;
                h.debug("receive full adopt watch result of {} {} {}, response:{}", new Object[]{omadacId, deviceMac, fullAdoptBusinessId, resultInt});
                Integer newResultInt = (Integer)resultInt;
                if (com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.f.b(newResultInt) && (deviceImageOpt = this.a.a(omadacId, deviceMac)).isPresent() && (currentDeviceImage = (com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImageOpt.get()).at().b()) {
                    newResultInt = com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.b.b();
                    h.debug("Set adopt watch result from timeout to success because device image is connected of {} {} {}", new Object[]{omadacId, deviceMac, fullAdoptBusinessId});
                }
                this.c((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage, newResultInt);
                if (com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.f.b(newResultInt)) {
                    h.warn("timeout wait adopt watch result of {} {} {}, response:{}", new Object[]{omadacId, deviceMac, fullAdoptBusinessId, resultInt});
                } else {
                    long end = System.currentTimeMillis();
                    long costTimeMs = end - start;
                    h.debug("Full Adopt mac: {} cost time: {}", (Object)deviceImage.al(), (Object)costTimeMs);
                    this.A.a(deviceImage.al().a(), costTimeMs, adoptType);
                }
            }
            catch (Exception e2) {
                h.warn("error deal adopt full watch result for {} {},", new Object[]{omadacId, deviceMac, e2});
            }
        });
        boolean watched = this.k.a(adoptDeferredResponse);
        if (!watched) {
            h.error("Failed to start watch an full async adoptDevice business of {} {}", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al());
            return;
        }
        h.info("start watching full adopt result of omadacId:{} mac:{}, businessId:{}", new Object[]{((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), fullAdoptBusinessId});
    }

    protected void a(T deviceImage) {
        RunTimeAdoptInfo runTimeAdoptInfo = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).aF();
        if (Objects.isNull(runTimeAdoptInfo)) {
            h.warn("handle mac: {} device negotiation but adoptInfo is null", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al());
            return;
        }
        if (Objects.nonNull(runTimeAdoptInfo.getFullAdoptBusinessId())) {
            h.debug("already watch full adopt result of mac: {} before, skip", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al());
            return;
        }
        com.tplink.smb.omada.async.business.e fullAdoptBusinessId = com.tplink.smb.omada.async.business.e.a();
        runTimeAdoptInfo.setFullAdoptBusinessId(fullAdoptBusinessId);
        this.a(deviceImage, fullAdoptBusinessId, "auto");
    }

    @Override
    public void a(@Nonnull T deviceImage, @Nonnull d siteId, @NotEmpty List<EcspAdoptInfo> adoptInfoList, boolean isAutoAdopt) {
        com.tplink.smb.omada.common.g.b checkRequires = this.a(deviceImage, ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), siteId);
        if (!checkRequires.a()) {
            h.debug("Stop adopt {} {} , errCode is {}", new Object[]{((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), checkRequires});
            ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).U();
            this.a.a((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage);
            return;
        }
        ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).a(siteId);
        ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).h();
        RunTimeAdoptInfo adoptInfo = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).aF();
        if (adoptInfo == null) {
            adoptInfo = new RunTimeAdoptInfo();
            ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).a(adoptInfo);
        }
        boolean isStack = false;
        if (deviceImage instanceof c) {
            boolean bl2 = isStack = ((c)deviceImage).bF() != null;
        }
        if (CollectionUtils.isEmpty(adoptInfoList)) {
            h.warn("auto adopt but adopt info is null, maybe something wrong. omadacId:{}, siteId:{}, mac:{}", new Object[]{((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ap(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al()});
            adoptInfo.updateBeforeAdopt(null, null, isAutoAdopt, isStack);
        } else {
            adoptInfo.updateBeforeAdopt(adoptInfoList.get(0).getUsername(), adoptInfoList.get(0).getPassword(), isAutoAdopt, isStack);
        }
        if (isAutoAdopt) {
            h.debug("autoAdopt {} {}, autoAdoptCnt: {}", new Object[]{((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), adoptInfo.getAutoAdoptCnt()});
        }
        if (!com.tplink.smb.omada.manager.device.domain.model.deviceimage.p.a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).aH()).equals((Object)com.tplink.smb.omada.manager.device.domain.model.deviceimage.p.d) && ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ar() != null) {
            com.tplink.smb.omada.manager.j.a.a.b mspId = new com.tplink.smb.omada.manager.j.a.a.b(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ar().getMspId());
            com.tplink.smb.omada.manager.j.a.a.c customerId = new com.tplink.smb.omada.manager.j.a.a.c(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am().a());
            G deviceMac = new G(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).X());
            this.a(deviceImage, (OperationResponse<?> operationResponse) -> {
                if (!operationResponse.success()) {
                    this.z.a(mspId, customerId, deviceMac);
                }
            }, null);
        } else {
            this.a(deviceImage, (OperationResponse<?> operationResponse) -> h.debug("adopt omadacId:{}, mac:{}, result: {}", new Object[]{deviceImage.am(), deviceImage.al(), operationResponse.getErrorCode()}), null);
            this.a.a((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage);
        }
        this.a(deviceImage, adoptInfoList);
        this.s.a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), siteId, ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).an(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).at());
    }

    protected OperationResponse a(long limitNum, com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        if (com.tplink.smb.omada.manager.device.domain.model.deviceimage.p.e.a().equals(deviceImage.aH()) || com.tplink.smb.omada.manager.device.domain.model.deviceimage.p.c.a().equals(deviceImage.aH()) || com.tplink.smb.omada.manager.device.domain.model.deviceimage.p.d.a().equals(deviceImage.aH())) {
            return OperationResponse.SUCCESS;
        }
        long dbCount = this.d.a(deviceImage.am(), deviceImage.an());
        long adoptingCount = this.a.a(deviceImage.am(), deviceImage.an());
        switch (deviceImage.an()) {
            case b: {
                if (limitNum <= dbCount + adoptingCount) {
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.Do);
                }
                return OperationResponse.SUCCESS;
            }
            case c: {
                long oltCount = this.d.a(deviceImage.am(), DeviceTypeEnum.d);
                long adoptingOltCount = this.a.a(deviceImage.am(), DeviceTypeEnum.d);
                if (limitNum <= dbCount + adoptingCount + oltCount * 5L + adoptingOltCount * 5L) {
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.DU);
                }
                return OperationResponse.SUCCESS;
            }
            case a: {
                if (limitNum <= dbCount + adoptingCount) {
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.BK);
                }
                return OperationResponse.SUCCESS;
            }
            case d: {
                long switchCount = this.d.a(deviceImage.am(), DeviceTypeEnum.c);
                long adoptingSwitchCount = this.a.a(deviceImage.am(), DeviceTypeEnum.c);
                if (Math.min((long)com.tplink.smb.omada.common.omadac.config.a.b.w() - dbCount - adoptingCount, ((long)com.tplink.smb.omada.common.omadac.config.a.b.u() - switchCount - adoptingSwitchCount - (dbCount + adoptingCount) * 5L) / 5L) <= 0L) {
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.Qo);
                }
                return OperationResponse.SUCCESS;
            }
        }
        if (limitNum <= dbCount + adoptingCount) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.AO);
        }
        return OperationResponse.SUCCESS;
    }

    protected OperationResponse b(long limitNum, com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        long adoptingCountOlt;
        long adoptingCountSwitch;
        long adoptingCountAP;
        long deviceDbCount = this.d.a(deviceImage.am());
        long osgDbCount = this.C.a(deviceImage.am());
        long oltDbCount = this.B.a(deviceImage.am());
        if (limitNum <= deviceDbCount + 4L * oltDbCount + (adoptingCountAP = this.a.a(deviceImage.am(), DeviceTypeEnum.a)) + (adoptingCountSwitch = this.a.a(deviceImage.am(), DeviceTypeEnum.c)) + (adoptingCountOlt = this.a.a(deviceImage.am(), DeviceTypeEnum.d)) * 5L - osgDbCount) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.AO);
        }
        return OperationResponse.SUCCESS;
    }

    protected OperationResponse a(com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage, d siteId) {
        com.tplink.smb.omada.manager.j.a.a.c omadacId = deviceImage.am();
        long dbCount = this.d.a(deviceImage.am());
        if ((long)com.tplink.smb.omada.common.omadac.config.a.b.a((String)omadacId.a()) <= dbCount) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.AO);
        }
        long dbCountOfSite = this.d.a(omadacId, siteId, (DeviceTypeEnum)null);
        long adoptingCountOfSite = this.a.a(omadacId, siteId, (DeviceTypeEnum)null);
        if ((long)com.tplink.smb.omada.common.omadac.config.a.b.b((String)omadacId.a()) <= dbCountOfSite + adoptingCountOfSite) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.AP);
        }
        return OperationResponse.SUCCESS;
    }

    @Override
    public boolean a(com.tplink.smb.omada.manager.j.a.a.c omadacId, String ecspVersion, G deviceMac) {
        this.i.a(omadacId, ecspVersion, deviceMac);
        return true;
    }

    @Override
    public void a(@Nonnull T deviceImage, @Nonnull E adoptResponseDTO) {
        if (((AbstractAdoptResponseDTO)adoptResponseDTO).isAdoptSucceeded()) {
            ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).a((AbstractAdoptResponseDTO<?>)adoptResponseDTO);
            this.d(deviceImage, adoptResponseDTO);
        } else {
            this.a(deviceImage, com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.g.b());
        }
    }

    @Override
    private void a(com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage, BaseAdoptDeviceInfo deviceInfo) {
        if (deviceImage == null || deviceInfo == null) {
            return;
        }
        String compoundModel = deviceImage.aX().x();
        String deviceVersion = deviceImage.aX().B();
        String oemId = deviceInfo.getEncryptedOemId();
        String hwId = deviceInfo.getEncryptedHwId();
        Boolean isPro = com.tplink.smb.omada.manager.device.domain.model.device.J.c(deviceImage.aW().a());
        this.r.a(compoundModel, deviceVersion, oemId, hwId, isPro);
    }

    protected void b(com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        if (deviceImage == null) {
            return;
        }
        com.tplink.smb.omada.manager.j.a.a.c omadacId = deviceImage.am();
        G deviceMac = deviceImage.al();
        String upgradeId = this.l.b(deviceImage.am(), deviceMac);
        if (upgradeId == null) {
            return;
        }
        UpgradeDeviceItem upgradeDeviceItem = this.l.b(upgradeId, deviceMac.a());
        if (upgradeDeviceItem == null) {
            return;
        }
        if (Boolean.TRUE.equals(upgradeDeviceItem.getLoged()) || T.a((String)upgradeId) || this.l.c(upgradeId) == null) {
            h.debug("not upgrade recovery device mac={}, upgradeId={}, omadacId={} adopting", new Object[]{deviceMac, upgradeId, omadacId});
            return;
        }
        h.info("{} {} upgrade recovery ...", (Object)omadacId, (Object)deviceMac);
        if (EcspFirstVersionEnum.V2.equals((Object)upgradeDeviceItem.getEcspFirstVersionEnum()) || EcspFirstVersionEnum.V3.equals((Object)upgradeDeviceItem.getEcspFirstVersionEnum())) {
            this.b(omadacId, deviceMac, upgradeId, deviceImage);
        } else {
            this.a(omadacId, deviceMac, upgradeId, deviceImage);
        }
        DomainEventBusHolder.getPublisher().publish((DomainEvent)DeviceEvent.singleDeviceEvent(omadacId, deviceImage.ap(), deviceMac, DeviceEvent.a.f, deviceImage.an(), false, null, null, false));
    }

    private void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, G deviceMac, String upgradeId, com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        if (Objects.equals(deviceImage.an(), DeviceTypeEnum.a) && !this.l.a(upgradeId, deviceMac, deviceImage.aX().u())) {
            h.info("ap{} upgrade recovery but firmware [{}] no change, set FILE_SEND_FAIL ", (Object)deviceMac, (Object)deviceImage.aX().u());
            this.l.a(omadacId, upgradeId, deviceMac, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a.g);
            this.p.a(deviceImage, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a.g, upgradeId);
            return;
        }
        if (this.l.a(omadacId, upgradeId, deviceMac, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a.n)) {
            h.info("device {} upgrade recovery success\uff0c firmware is {}", (Object)deviceMac, (Object)deviceImage.aX().u());
            this.p.a(omadacId, deviceImage.ap(), deviceMac, deviceImage.aX().A(), deviceImage.aX().u(), this.l.a(upgradeId, deviceMac.a()));
            this.p.a(deviceImage, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a.n, upgradeId);
        } else {
            h.info("ap{} recovery ok, but can't change status to RECOVERY_OK with firmware[{}]", (Object)deviceMac, (Object)deviceImage.aX().u());
            this.p.a(deviceImage, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a.g, upgradeId);
        }
        this.m.a(omadacId, deviceMac);
    }

    private void b(com.tplink.smb.omada.manager.j.a.a.c omadacId, G deviceMac, String upgradeId, com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        boolean res = this.x.a(upgradeId, deviceMac, () -> {
            UpgradeStatusDTO status = this.n.reportUpgradeFinished(deviceMac.a(), omadacId.a());
            if (status == null) {
                return true;
            }
            String oldFirmwareVersion = (String)status.getAdditionalInfo().get("oldFirmwareVersion");
            if (Objects.equals(deviceImage.an(), DeviceTypeEnum.a) && oldFirmwareVersion.equals(deviceImage.aX().u())) {
                h.info("ap[{}] upgrade recovery but firmware [{}] no change ", (Object)deviceMac, (Object)deviceImage.aX().u());
                this.l.a(omadacId, upgradeId, deviceMac, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a.i);
                this.p.a(deviceImage, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a.i, upgradeId);
                return true;
            }
            if (status.getStatus().equals((Object)FirmwareUpgradeStatusEnum.UPGRADE_FINISHED) && status.getDeviceError().equals((Object)DeviceFirmwareUpgradeError.FIRMWARE_RECONNECTED_OK)) {
                boolean abnormal;
                if (Objects.equals(deviceImage.an(), DeviceTypeEnum.c) && (abnormal = this.a(omadacId, upgradeId, deviceMac, deviceImage, oldFirmwareVersion))) {
                    return true;
                }
                this.l.a(omadacId, upgradeId, deviceMac, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a.n);
                h.info("device {} upgrade recovery success\uff0c firmware is {}", (Object)deviceMac, (Object)deviceImage.aX().u());
                this.p.a(omadacId, deviceImage.ap(), deviceMac, deviceImage.aX().A(), deviceImage.aX().u(), oldFirmwareVersion);
                this.p.a(deviceImage, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a.n, upgradeId);
                return true;
            }
            return false;
        }, () -> {
            h.warn("get lock failed when handle upgrade success for {} {} upgrade", (Object)omadacId, (Object)upgradeId);
            return false;
        });
        if (res) {
            return;
        }
        h.info("ap{} recovery ok, but can't change status to RECOVERY_OK with firmware[{}]", (Object)deviceMac, (Object)deviceImage.aX().u());
        this.p.a(deviceImage, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a.i, upgradeId);
    }

    private boolean a(com.tplink.smb.omada.manager.j.a.a.c omadacId, String upgradeId, G deviceMac, com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage, String oldFirmwareVersion) {
        com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a existedStatus = this.l.a(omadacId, upgradeId, deviceMac);
        if (Objects.equals(oldFirmwareVersion, deviceImage.aX().u()) && Objects.equals((Object)existedStatus, (Object)com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a.f)) {
            h.info("switch[{}] upgrade recovery but firmware [{}] no change, and existed upgrade status:[{}] ", new Object[]{deviceMac, deviceImage.aX().u(), existedStatus});
            this.l.a(omadacId, upgradeId, deviceMac, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a.i);
            this.p.a(deviceImage, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a.i, upgradeId);
            return true;
        }
        return false;
    }

    @Override
    public void c(T deviceImage) {
        this.a(deviceImage, com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.a.b());
    }

    @Override
    public void b(@Nonnull T deviceImage, @Nonnull E adoptResponseDTO) {
        if (((AbstractAdoptResponseDTO)adoptResponseDTO).isAdoptSucceeded()) {
            try {
                this.a(deviceImage);
            }
            catch (Exception e2) {
                h.warn("watchFullAdoptResult of mac: {}, error", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), (Object)e2);
            }
            StopWatch stopWatch = new StopWatch(E);
            stopWatch.start(F);
            ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).b((AbstractAdoptResponseDTO<?>)adoptResponseDTO);
            stopWatch.stop();
            this.a(deviceImage, F, stopWatch.getLastTaskTimeMillis());
            this.d(deviceImage, adoptResponseDTO);
        } else {
            h.warn("{} {} deviceNegotiation device report failed, {}", new Object[]{((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), adoptResponseDTO});
            this.a(deviceImage, com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.a.b());
        }
    }

    @Override
    public void a(boolean verifySuccess, com.tplink.smb.omada.manager.device.domain.model.device.b adoptInfo, T deviceImage) {
        if (Boolean.FALSE.equals(verifySuccess)) {
            h.debug("ecspv2 verify failed, omadac is {},device is {}.", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al());
            this.a(deviceImage, com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.g.b());
        } else {
            ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).a(adoptInfo);
            ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).b(adoptInfo);
            this.a.a((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage);
            this.d(deviceImage);
        }
    }

    protected void d(T deviceImage) {
        this.c.a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), deviceImage.aX().q(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), 60000L);
        h.debug("ecspv2 verify success, omadac is {}, device is {}.", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al());
    }

    @Override
    public void e(T deviceImage) {
        this.a(deviceImage, com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.a.b());
    }

    @Override
    public void a(Boolean success, T deviceImage, int errCode, long timeout) {
        if (Boolean.FALSE.equals(success)) {
            h.debug("ecspv2 receive failed initSyncResult because of {}, omadac is {},device is {}.", new Object[]{errCode, ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al()});
            this.a(deviceImage, com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.a.b());
        } else {
            h.debug("ecspv2 receive success initSyncResult, omadac is {},device is {}.", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al());
            this.j.a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), deviceImage.aX().q(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), timeout);
        }
    }

    @Override
    public void a(Boolean sendInitSyncAckSuccess, T deviceImage, int errCode) {
        if (Boolean.FALSE.equals(sendInitSyncAckSuccess)) {
            h.debug("ecspv2 send initSync ack failed because of {}, omadac is {},device is {}.", new Object[]{errCode, ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al()});
            this.a(deviceImage, errCode);
        } else {
            DeviceTypeEnum deviceType = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).an();
            if (DeviceTypeEnum.d.equals((Object)deviceType)) {
                String deviceMac = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al().a();
                String omadacId = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am().a();
                DeviceHolder deviceHolder = DeviceHolder.create((String)deviceMac, (String)omadacId);
                DomainEventBusHolder.getPublisher().publish((DomainEvent)new com.tplink.smb.omada.manager.device.application.c.b(deviceHolder));
            }
            h.debug("ecspv2 send initSync ack success, omadac is {},device is {}.", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al());
        }
    }

    protected abstract com.tplink.smb.omada.common.g.b a(T var1, com.tplink.smb.omada.manager.j.a.a.c var2, d var3);

    protected void a(@Nonnull T deviceImage, @Nonnull d siteId, @Nullable String username, @Nullable String password) {
        ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).a(siteId);
        ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).h();
        this.a(deviceImage, username, password);
    }

    protected void a(@Nonnull T deviceImage, @Nullable String username, @Nullable String password) {
        RunTimeAdoptInfo runTimeAdoptInfo = this.b(deviceImage, username, password);
        username = Optional.ofNullable(runTimeAdoptInfo.getPendingAdoptInfo()).map(RunTimeAdoptInfo.a::a).orElse(null);
        password = Optional.ofNullable(runTimeAdoptInfo.getPendingAdoptInfo()).map(RunTimeAdoptInfo.a::b).orElse(null);
        ArrayList<EcspAdoptInfo> adoptInfoList = new ArrayList<EcspAdoptInfo>();
        if (Objects.nonNull(username) && Objects.nonNull(password)) {
            adoptInfoList.add(new EcspAdoptInfo(username, password));
        }
        this.a(deviceImage, (List<EcspAdoptInfo>)adoptInfoList);
    }

    @Override
    protected void a(@Nonnull T deviceImage, List<EcspAdoptInfo> ecspAdoptInfoList) {
        if (CollectionUtils.isEmpty(ecspAdoptInfoList)) {
            h.info("send pre adopt request without username or password, mac: {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).X()));
        }
        this.b.a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ap(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ad(), EcspVersion.getFirstVersion((String)deviceImage.aX().q()), deviceImage.aX().q(), ecspAdoptInfoList);
    }

    protected RunTimeAdoptInfo b(@Nonnull T deviceImage, @Nullable String username, @Nullable String password) {
        RunTimeAdoptInfo adoptInfo = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).aF();
        if (adoptInfo == null) {
            adoptInfo = new RunTimeAdoptInfo();
            ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).a(adoptInfo);
        }
        boolean isStack = false;
        if (deviceImage instanceof c) {
            isStack = ((c)deviceImage).bF() != null;
        }
        adoptInfo.updateBeforeAdopt(username, password, false, isStack);
        this.a.a((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage);
        this.f.a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).X());
        if (com.tplink.smb.omada.common.util.system.a.b() && !com.tplink.smb.omada.common.util.system.c.c().contains(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ap().a())) {
            h.info("saveAdoptInfo for clusterAdopt :{} {}", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ap(), (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al());
            this.g.a(com.tplink.smb.omada.manager.device.domain.model.cluster.a.a.a().a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am()).a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ap()).a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al()).b(username).c(password).d(com.tplink.smb.omada.common.util.system.a.h()).a());
        }
        return adoptInfo;
    }

    protected abstract void a(com.tplink.smb.omada.manager.j.a.a.c var1, d var2, G var3, Integer var4);

    protected abstract void c(@Nonnull T var1, @Nonnull E var2);

    private void d(@Nonnull T deviceImage, @Nonnull E adoptResponseDTO) {
        StopWatch stopWatch = new StopWatch(H);
        stopWatch.start(I);
        this.i(deviceImage);
        stopWatch.stop();
        this.a(deviceImage, I, stopWatch.getLastTaskTimeMillis());
        stopWatch.start(J);
        this.h(deviceImage);
        stopWatch.stop();
        this.a(deviceImage, J, stopWatch.getLastTaskTimeMillis());
        ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).P();
        stopWatch.start(K);
        this.a.a((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage);
        stopWatch.stop();
        this.a(deviceImage, K, stopWatch.getLastTaskTimeMillis());
        stopWatch.start(L);
        this.t.b((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage);
        stopWatch.stop();
        this.a(deviceImage, L, stopWatch.getLastTaskTimeMillis());
        this.w.a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al());
        stopWatch.start(M);
        this.y.b(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).X());
        stopWatch.stop();
        this.a(deviceImage, M, stopWatch.getLastTaskTimeMillis());
        stopWatch.start(N);
        this.b((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage);
        stopWatch.stop();
        this.a(deviceImage, N, stopWatch.getLastTaskTimeMillis());
        stopWatch.start(O);
        this.a((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage, ((AbstractAdoptResponseDTO)adoptResponseDTO).getAdoptResponseBody().getDeviceInfo());
        stopWatch.stop();
        this.a(deviceImage, O, stopWatch.getLastTaskTimeMillis());
        stopWatch.start(P);
        this.c(deviceImage, adoptResponseDTO);
        stopWatch.stop();
        this.a(deviceImage, P, stopWatch.getLastTaskTimeMillis());
        if (this.u.isPrettyPrintTimeCostEnable()) {
            h.debug("handle omadacId: {}, mac: {}, timeCost percentage: {}", new Object[]{((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), stopWatch.prettyPrint()});
        }
    }

    private void h(T deviceImage) {
        if (!OmadacType.s()) {
            return;
        }
        Boolean factory = Boolean.TRUE.equals(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ay()) && !Boolean.TRUE.equals(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).aS()) && !Boolean.TRUE.equals(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).aT());
        if (factory.booleanValue()) {
            h.debug("adopt pending device success, clear preAdopt info and runtime info. device {}, omadac {}", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am());
            this.g(deviceImage);
        }
        this.f(deviceImage);
    }

    protected abstract void f(T var1);

    protected abstract void g(T var1);

    @Override
    public void a(@Nonnull T deviceImage, Integer errorCode) {
        ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).a(errorCode);
        this.a.a((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage);
        this.v.a(Optional.of(deviceImage));
        if (((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).I() && ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).aF().getAutoAdoptCnt() < 5) {
            h.debug("Auto adopt device {} failed, try angin.", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al());
            return;
        }
        h.warn("Adopt device {} {} failed, errorCode {}", new Object[]{((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), errorCode});
        Integer errCode = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).aF() == null ? null : ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).aF().getAdoptErrCode();
        this.a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ap(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), errCode);
        if (((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).j() && ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).aF().getAutoAdoptCnt() <= 5) {
            h.warn("Failed to auto adopt {} 5 times as timeout", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al());
            this.q.addLog(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am().a(), OmadaLogDTO.buildDeviceLog((String)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am().a(), (String)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ap().a(), (OmadaLogKeyEnumDTO)OmadaLogKeyEnumDTO.DEV_READOPT_FL, (Date)new Date(), Collections.singletonMap(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al().a(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).aw()), (DeviceTypeEnum)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).an(), (String[])new String[]{((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).an().c(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al().a()}).toJson());
        }
        this.s.a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ap(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).an(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).at(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).V(), com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.a(errorCode));
    }

    @Override
    public void b(@Nonnull T deviceImage, Integer errorCode) {
        ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).a(errorCode, true);
        this.a.a((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage);
        this.s.a(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ap(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).an(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).at(), -1, com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.a(errorCode));
        if (((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).I()) {
            h.debug("Auto adopt device {} Timeout, try angin.", (Object)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al());
            return;
        }
        h.warn("Adopt device {} {} Timeout, errorCode {}", new Object[]{((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), errorCode});
    }

    private void i(T deviceImage) {
        Boolean factory = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ay();
        Boolean remember = ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).aT();
        if (Boolean.TRUE.equals(factory) && Boolean.TRUE.equals(remember)) {
            HashMap<String, String> macNameMap = new HashMap<String, String>();
            macNameMap.put(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al().a(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).aw());
            this.q.addLog(((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am().a(), OmadaLogDTO.buildDeviceLog((String)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am().a(), (String)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).ap().a(), (OmadaLogKeyEnumDTO)OmadaLogKeyEnumDTO.DEV_CONN_REMEMBER, (Date)new Date(), macNameMap, (DeviceTypeEnum)((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).an(), (String[])new String[]{((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).an().c(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al().a()}).toJson());
        }
    }

    private void a(T deviceImage, String operation, long timeCostMills) {
        if (timeCostMills >= (long)this.u.getAdoptDebugThreshold()) {
            h.debug("handle omadacId: {}, mac: {}, operation: {}, cost time:{}", new Object[]{((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).am(), ((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage).al(), operation, timeCostMills});
        }
    }

    protected void c(com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage, Integer resultInt) {
        Optional.ofNullable(deviceImage.aF()).map(RunTimeAdoptInfo::getBatchAdoptId).ifPresent(batchAdoptId -> {
            h.debug("handle batchAdoptId :{}, adopt omadacId: {}, device:{}, result: {}", new Object[]{batchAdoptId, deviceImage.am(), deviceImage.al(), resultInt});
            this.D.a(deviceImage.am(), deviceImage.ap(), deviceImage.al(), (String)batchAdoptId, resultInt);
        });
    }

    @Autowired
    public void a(l deviceImageRepository) {
        this.a = deviceImageRepository;
    }

    @Autowired
    public void a(C sendPreAdoptRequestService) {
        this.b = sendPreAdoptRequestService;
    }

    @Autowired
    public void a(A sendAdoptRequestService) {
        this.i = sendAdoptRequestService;
    }

    @Autowired
    @Lazy
    public void a(b sendVerifySuccessAckService) {
        this.c = sendVerifySuccessAckService;
    }

    @Autowired
    @Lazy
    public void a(com.tplink.smb.omada.manager.device.domain.model.adopt.h.a sendInitSyncResultAckService) {
        this.j = sendInitSyncResultAckService;
    }

    @Autowired
    public void a(com.tplink.smb.omada.async.business.c asyncBusinessWatcher) {
        this.k = asyncBusinessWatcher;
    }

    @Autowired
    public void a(com.tplink.smb.omada.manager.device.domain.model.upgrade.cache.c upgradeProcessCache) {
        this.l = upgradeProcessCache;
    }

    @Autowired
    public void a(O deviceRepository) {
        this.d = deviceRepository;
    }

    @Autowired
    @Lazy
    public void a(com.tplink.smb.omada.manager.device.port.transport.h.d closeUpgradeChannelService) {
        this.m = closeUpgradeChannelService;
    }

    @Autowired
    @Lazy
    public void a(FirmwareUpgradeService firmwareUpgradeService) {
        this.n = firmwareUpgradeService;
    }

    @Autowired
    @Lazy
    public void a(AdoptManageService adoptManageService) {
        this.o = adoptManageService;
    }

    @Autowired
    @Lazy
    public void a(com.tplink.smb.omada.manager.device.domain.model.upgrade.j upgradeDeviceService) {
        this.p = upgradeDeviceService;
    }

    @Autowired
    public void a(LogApiService logApiService) {
        this.q = logApiService;
    }

    @Autowired
    @Lazy
    public void a(z mspAdoptFailedResetDeviceService) {
        this.z = mspAdoptFailedResetDeviceService;
    }

    private /* synthetic */ void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, G deviceMac, com.tplink.smb.omada.async.business.e businessId, com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage, Consumer completeConsumer, Supplier doAfterAdoptSuccess, Object resultInt) {
        try {
            h.info("receive adopt watch result of {} {} {}, response:{}", new Object[]{omadacId, deviceMac, businessId, resultInt});
            AdoptOneDeviceStatusResultVO statusResult = this.a.a(deviceImage.am(), deviceImage.al()).map(X::a).orElse(null);
            com.tplink.smb.omada.manager.device.domain.model.adopt.c.a errorCode = com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.a((Integer)resultInt);
            OperationResponse or = new OperationResponse(errorCode.a(), (Object)statusResult);
            if (com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.f.b((Integer)resultInt)) {
                h.warn("timeout wait adopt watch result of {} {} {}, response:{}", new Object[]{omadacId, deviceMac, businessId, or});
                this.o.e(omadacId, deviceMac);
            }
            completeConsumer.accept(or);
            if (com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.b == errorCode && doAfterAdoptSuccess != null) {
                doAfterAdoptSuccess.get();
            }
        }
        catch (Exception e2) {
            h.warn("error deal adopt watch result for {} {},", new Object[]{omadacId, deviceMac, e2});
            completeConsumer.accept(OperationResponse.GENERAL_ERROR);
        }
    }
}

