/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.application.upgrade.firmware;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.component.upgradefilecache.api.UpgradeFileCacheCommonService;
import com.tplink.smb.component.upgradefilecache.api.UpgradeFileInfo;
import com.tplink.smb.omada.common.access.AuditLogReturnDTO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.obfuscate.KeepMethod;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalMethodResolveClient;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalRequestDTO;
import com.tplink.smb.omada.manager.configuration.api.web.omadac.global.SiteBasicVO;
import com.tplink.smb.omada.manager.configuration.domain.model.omadac.n;
import com.tplink.smb.omada.manager.configuration.domain.model.omadac.u;
import com.tplink.smb.omada.manager.configuration.domain.model.site.F;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.CreateUpgradePlanResVO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.AllSitesVO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.FirmwareInfoVO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.ModelTypeInfoVO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.PlanUpgradeCreateVO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.PlanUpgradeSelectedModelVO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.UpgradeFirmwareInfoVO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.UploadUpgradeFileResVO;
import com.tplink.smb.omada.manager.device.application.upgrade.UpgradeDeviceApplicationService;
import com.tplink.smb.omada.manager.device.application.upgrade.firmware.b;
import com.tplink.smb.omada.manager.device.application.upgrade.firmware.c;
import com.tplink.smb.omada.manager.device.application.upgrade.firmware.f;
import com.tplink.smb.omada.manager.device.application.upgrade.manage.PlanUpgradeService;
import com.tplink.smb.omada.manager.device.application.upgrade.manage.e;
import com.tplink.smb.omada.manager.device.domain.model.device.DeviceFirmwareTypeInfoDTO;
import com.tplink.smb.omada.manager.device.domain.model.device.O;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.ModelTypeInfo;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.d;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.o;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.v;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.firmware.Firmware;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Component
public class a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    private UpgradeFileCacheCommonService b;
    @Autowired
    private UpgradeDeviceApplicationService c;
    @Autowired
    private PlanUpgradeService d;
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.upgrade.firmware.a e;
    @Autowired
    private d f;
    @Autowired
    private v g;
    @Autowired
    private O h;
    @Autowired
    private F i;
    @Autowired
    private f j;
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.upgrade.firmware.c k;
    @Autowired
    private o l;
    @Autowired
    private u m;
    @Autowired
    private OmadaClusterUniversalMethodResolveClient n;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OperationResponse<Firmware> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, MultipartFile file, UpgradeFirmwareInfoVO firmwareInfoVO) {
        String fileId = firmwareInfoVO.getMd5();
        if (file == null && fileId == null) {
            a.warn("No fileId and file content when upload upgrade firmware in {}", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        if (file == null) {
            Optional upgradeFileInfo = this.b.getUpgradeFileInfo(fileId);
            if (!upgradeFileInfo.isPresent()) return new OperationResponse(com.tplink.smb.omada.common.g.b.a);
            if (!this.a(omadacId, ((UpgradeFileInfo)upgradeFileInfo.get()).getFileSize())) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.tw);
            }
            Firmware firmware = Firmware.builder().b(fileId).a(omadacId).e(firmwareInfoVO.getDescription()).b(System.currentTimeMillis()).a(new ModelTypeInfo(firmwareInfoVO.getModelTypeInfo().getShowModel(), firmwareInfoVO.getModelTypeInfo().getCompoundModel())).a(((UpgradeFileInfo)upgradeFileInfo.get()).getFileSize()).a(firmwareInfoVO.getTargetEnable()).a(this.a(omadacId, firmwareInfoVO.getTargetSites())).d(com.tplink.smb.omada.manager.device.application.upgrade.firmware.c.a(firmwareInfoVO.getFileName())).c(firmwareInfoVO.getFileName()).a();
            OperationResponse checkRes = this.b(firmware, omadacId);
            if (!checkRes.success()) {
                return checkRes;
            }
            String id = this.e.a(firmware);
            firmware.setId(id);
            this.b(omadacId, firmware);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)firmware);
        }
        if (!this.a(omadacId, file.getSize())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.tw);
        }
        try (InputStream inputStream = file.getInputStream();){
            OperationResponse<UploadUpgradeFileResVO> uploadRes = this.c.b(omadacId, inputStream, fileId, file.getName(), file.getSize(), false);
            if (!uploadRes.success()) return new OperationResponse(com.tplink.smb.omada.common.g.b.Ab);
            Firmware firmware = Firmware.builder().b(((UploadUpgradeFileResVO)uploadRes.getResult()).getFileId()).a(omadacId).e(firmwareInfoVO.getDescription()).a(file.getSize()).c(file.getOriginalFilename()).b(System.currentTimeMillis()).a(new ModelTypeInfo(firmwareInfoVO.getModelTypeInfo().getShowModel(), firmwareInfoVO.getModelTypeInfo().getCompoundModel())).a(firmwareInfoVO.getTargetEnable()).a(this.a(omadacId, firmwareInfoVO.getTargetSites())).d(com.tplink.smb.omada.manager.device.application.upgrade.firmware.c.a(firmwareInfoVO.getFileName())).a();
            OperationResponse checkRes = this.b(firmware, omadacId);
            if (!checkRes.success()) {
                OperationResponse operationResponse = checkRes;
                return operationResponse;
            }
            String id = this.e.a(firmware);
            firmware.setId(id);
            this.b(omadacId, firmware);
            OperationResponse operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)firmware);
            return operationResponse;
        }
        catch (IOException e2) {
            a.warn("Upload upgrade firmware failed with exception in {} .", (Object)omadacId, (Object)e2);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.eL);
        }
    }

    public OperationResponse<GridVO<FirmwareInfoVO>> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.common.gridquery.b queryData) {
        Boolean validSearchKey = this.l.a(queryData.e());
        if (!Boolean.TRUE.equals(validSearchKey)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        com.tplink.smb.omada.common.gridquery.a<Firmware> firmwareGrid = this.e.a(omadacId.a(), queryData);
        List results = firmwareGrid.getData();
        List firmwareInfoVOS = Optional.ofNullable(results).map(rs -> rs.stream().map(firmware -> this.a((Firmware)firmware, omadacId)).collect(Collectors.toList())).orElse(Collections.emptyList());
        GridVO res = new GridVO();
        res.setCurrentPage(queryData.b());
        res.setCurrentSize(queryData.c());
        res.setData(firmwareInfoVOS);
        res.setTotalRows((long)((int)firmwareGrid.getTotalRows()));
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)res);
    }

    public OperationResponse<String> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, String firmwareId) {
        Firmware firmware = this.e.a(omadacId.a(), firmwareId).orElse(null);
        this.e.e(omadacId.a(), firmwareId);
        this.d.a(omadacId, firmwareId);
        if (firmware != null) {
            boolean existOtherFirmware;
            this.k.a(omadacId.a(), firmware.getTargetSites(), firmware.getModelTypeInfo().getCompoundModel());
            if (!OmadacType.s() && !(existOtherFirmware = this.a(omadacId, firmware))) {
                this.b.deleteUpgradeFile(firmware.getFileId());
                this.b(firmware.getFileId());
            }
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)x.a((Object)firmware));
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)firmwareId);
    }

    private boolean a(com.tplink.smb.omada.manager.j.a.a.c omadacId, Firmware firmware) {
        Optional<com.tplink.smb.omada.manager.configuration.domain.model.omadac.o> omadacOpt = this.m.b(omadacId);
        if (!omadacOpt.isPresent()) {
            a.warn("checkExistOtherFirmware found invalid omada, omadacId:{}", (Object)omadacId);
            return false;
        }
        com.tplink.smb.omada.manager.configuration.domain.model.omadac.o omadac = omadacOpt.get();
        ArrayList<String> omadacIds = new ArrayList<String>();
        if (omadac instanceof n) {
            Set<com.tplink.smb.omada.manager.j.a.a.c> customerIds = ((n)omadac).b();
            if (!CollectionUtils.isEmpty(customerIds)) {
                omadacIds.addAll(customerIds.stream().map(com.tplink.smb.omada.manager.j.a.a.c::a).collect(Collectors.toSet()));
            }
        } else if (omadac instanceof com.tplink.smb.omada.manager.configuration.domain.model.omadac.c) {
            com.tplink.smb.omada.manager.j.a.a.b mspId = ((com.tplink.smb.omada.manager.configuration.domain.model.omadac.c)omadac).b();
            if (mspId != null) {
                Optional<n> mspOpt = this.m.f(mspId);
                mspOpt.ifPresent(msp -> {
                    if (!CollectionUtils.isEmpty(msp.b())) {
                        omadacIds.addAll(msp.b().stream().map(com.tplink.smb.omada.manager.j.a.a.c::a).collect(Collectors.toSet()));
                    }
                });
            }
        } else {
            omadacIds.add(omadac.j().a());
        }
        if (CollectionUtils.isEmpty(omadacIds)) {
            return false;
        }
        for (String checkOmadacId : omadacIds) {
            boolean existOtherFirmware = this.e.f(checkOmadacId, firmware.getFileId());
            if (!existOtherFirmware) continue;
            a.debug("Existed other firmware is using same fileId, do not delete this file. omadacId:{}", (Object)checkOmadacId);
            return true;
        }
        return false;
    }

    private void b(String fileId) {
        if (!com.tplink.smb.omada.common.util.system.a.b()) {
            return;
        }
        a.info("do notifyOtherNodeDeleteUpgradeFirmware");
        OmadaClusterUniversalRequestDTO requestDTO = new OmadaClusterUniversalRequestDTO(a.class, (TypeReference)new b(this), Boolean.valueOf(false), "deleteUpgradeFirmwareForCluster", new Class[]{String.class}, new Object[]{fileId});
        for (String nodeId : com.tplink.smb.omada.common.util.system.c.a().keySet()) {
            if (Objects.equals(nodeId, com.tplink.smb.omada.common.util.system.a.h())) continue;
            this.n.resolveSpringBeanCall(nodeId, requestDTO);
        }
    }

    @KeepMethod
    public void deleteUpgradeFirmwareForCluster(String fileId) {
        a.info("deleteUpgradeFirmwareForCluster invoked by other node.");
        this.b.deleteUpgradeFile(fileId);
    }

    public OperationResponse<CreateUpgradePlanResVO> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, String firmwareId, PlanUpgradeCreateVO planUpgradeCreateVO, String operator) {
        Firmware firmware = this.e.a(omadacId.a(), firmwareId).orElse(null);
        if (firmware == null) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.zV);
        }
        if (!Boolean.TRUE.equals(firmware.getTargetEnable()) && this.a(omadacId, Collections.singletonList(firmware.getModelTypeInfo().getCompoundModel()), planUpgradeCreateVO.getSites())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.td);
        }
        planUpgradeCreateVO.setModelList(this.a(firmware));
        return this.d.a(omadacId, planUpgradeCreateVO, com.tplink.smb.omada.manager.device.application.upgrade.manage.e.g, firmwareId, operator);
    }

    public OperationResponse a(com.tplink.smb.omada.manager.j.a.a.c omadacId, String firmwareId, UpgradeFirmwareInfoVO upgradeFirmwareInfoVO) {
        Firmware firmware = this.e.a(omadacId.a(), firmwareId).orElse(null);
        if (firmware == null) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.zV);
        }
        AuditLogReturnDTO auditLogReturnDTO = AuditLogReturnDTO.builder().omadacId(omadacId.a()).build();
        auditLogReturnDTO.setOldValue(x.a((Object)this.a(firmware, omadacId)));
        Boolean oldTargetEnalbe = firmware.getTargetEnable();
        List<String> oldTargetSites = firmware.getTargetSites();
        firmware.setTargetEnable(upgradeFirmwareInfoVO.getTargetEnable());
        firmware.setTargetSites(this.a(omadacId, upgradeFirmwareInfoVO.getTargetSites()));
        if (CollectionUtil.isEmpty(firmware.getTargetSites())) {
            firmware.setTargetEnable(false);
        }
        firmware.setDescription(upgradeFirmwareInfoVO.getDescription());
        firmware.setFirmwareVersion(com.tplink.smb.omada.manager.device.application.upgrade.firmware.c.a(firmware.getName()));
        OperationResponse checkRes = this.b(firmware, omadacId);
        if (!checkRes.success()) {
            return checkRes;
        }
        this.e.a(firmware);
        this.a(omadacId, firmware, oldTargetEnalbe, oldTargetSites);
        OperationResponse response = new OperationResponse(com.tplink.smb.omada.common.g.b.a);
        auditLogReturnDTO.setNewValue(x.a((Object)this.a(firmware, omadacId)));
        response.setAuditLogReturn(auditLogReturnDTO);
        return response;
    }

    public OperationResponse<AllSitesVO> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, String firmwareId) {
        Firmware firmware = this.e.a(omadacId.a(), firmwareId).orElse(null);
        if (firmware == null) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.zV);
        }
        AllSitesVO res = new AllSitesVO();
        if (!CollectionUtils.isEmpty(firmware.getTargetSites())) {
            Map<String, String> siteIdName = this.i.c(omadacId, new HashSet<String>(firmware.getTargetSites()), com.tplink.smb.omada.manager.c.x.a);
            List siteBasicVOS = firmware.getTargetSites().stream().map(siteId -> new SiteBasicVO(siteId, (String)siteIdName.get(siteId))).collect(Collectors.toList());
            res.setTargetSites(siteBasicVOS);
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)res);
    }

    public boolean a(com.tplink.smb.omada.manager.j.a.a.c omadacId, List<String> modelList, List<String> sites) {
        for (String model : modelList) {
            Set<String> siteIds = this.e.c(omadacId.a(), model);
            if (CollectionUtils.isEmpty(siteIds) || !CollectionUtils.containsAny(siteIds, sites)) continue;
            return true;
        }
        return false;
    }

    public Set<String> c(com.tplink.smb.omada.manager.j.a.a.c omadacId, String siteId) {
        List<Firmware> targetFirmwareList = this.e.d(omadacId.a(), siteId);
        return targetFirmwareList.stream().map(firmware -> firmware.getModelTypeInfo().getCompoundModel()).collect(Collectors.toSet());
    }

    public AuditLogReturnDTO a(String omadacId) {
        return AuditLogReturnDTO.builder().omadacId(omadacId).oldValue(null).newValue(null).build();
    }

    private List<PlanUpgradeSelectedModelVO> a(Firmware firmware) {
        ModelTypeInfo model = firmware.getModelTypeInfo();
        ArrayList<PlanUpgradeSelectedModelVO> res = new ArrayList<PlanUpgradeSelectedModelVO>();
        PlanUpgradeSelectedModelVO selectedModel = new PlanUpgradeSelectedModelVO();
        selectedModel.setModelTypeInfo(new ModelTypeInfoVO(model.getShowModel(), model.getCompoundModel()));
        selectedModel.setTargetVersion(firmware.getName());
        res.add(selectedModel);
        return res;
    }

    private boolean a(com.tplink.smb.omada.manager.j.a.a.c omadacId, long fileSize) {
        List<Firmware> existedFirmwares = this.e.d(omadacId.a());
        long existSize = 0L;
        if (!CollectionUtils.isEmpty(existedFirmwares)) {
            existSize = existedFirmwares.stream().mapToLong(Firmware::getFileSize).sum();
        }
        if (existSize + fileSize < 0x8000000L) {
            return true;
        }
        List<DeviceFirmwareTypeInfoDTO> models = this.h.h(omadacId);
        if (CollectionUtils.isEmpty(models)) {
            return false;
        }
        long allowFileSizeTotal = 0L;
        for (DeviceFirmwareTypeInfoDTO model : models) {
            if (DeviceTypeEnum.a.c(model.getType())) {
                allowFileSizeTotal += 0x2000000L;
                continue;
            }
            if (DeviceTypeEnum.c.c(model.getType())) {
                allowFileSizeTotal += 0x4000000L;
                continue;
            }
            if (DeviceTypeEnum.b.c(model.getType()) && model.getCompoundModel().contains("-4G")) {
                allowFileSizeTotal += 0x10000000L;
                continue;
            }
            if (DeviceTypeEnum.b.c(model.getType())) {
                allowFileSizeTotal += 0x4000000L;
                continue;
            }
            allowFileSizeTotal += 0x2000000L;
        }
        a.info("Total file size in omadacId {} is {}, new file size is {}, allowSize {} ", new Object[]{omadacId, existSize, fileSize, allowFileSizeTotal});
        return existSize + fileSize < allowFileSizeTotal;
    }

    private FirmwareInfoVO a(Firmware firmware, com.tplink.smb.omada.manager.j.a.a.c omadacId) {
        if (firmware == null) {
            return null;
        }
        List<Object> siteBasicVOS = new ArrayList();
        if (!CollectionUtils.isEmpty(firmware.getTargetSites())) {
            Map<String, String> siteIdName = this.i.c(omadacId, new HashSet<String>(firmware.getTargetSites()), com.tplink.smb.omada.manager.c.x.a);
            siteBasicVOS = firmware.getTargetSites().stream().map(siteId -> new SiteBasicVO(siteId, (String)siteIdName.get(siteId))).collect(Collectors.toList());
            siteBasicVOS.sort(Comparator.comparing(SiteBasicVO::getName));
            siteBasicVOS = siteBasicVOS.stream().limit(2L).collect(Collectors.toList());
        }
        FirmwareInfoVO firmwareInfoVO = new FirmwareInfoVO();
        firmwareInfoVO.setId(firmware.getId());
        firmwareInfoVO.setName(firmware.getName());
        firmwareInfoVO.setModelTypeInfo(new ModelTypeInfoVO(firmware.getModelTypeInfo().getShowModel(), firmware.getModelTypeInfo().getCompoundModel()));
        firmwareInfoVO.setDescription(firmware.getDescription());
        firmwareInfoVO.setUploadTime(firmware.getUploadTime());
        firmwareInfoVO.setTargetEnable(firmware.getTargetEnable());
        firmwareInfoVO.setTargetSitesNum(firmware.getTargetSitesNum());
        firmwareInfoVO.setTargetSites(siteBasicVOS);
        return firmwareInfoVO;
    }

    private OperationResponse b(Firmware firmware, com.tplink.smb.omada.manager.j.a.a.c omadacId) {
        List<com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.u> list;
        List<com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.c> autoCheckUpgrades;
        if (!Boolean.TRUE.equals(firmware.getTargetEnable())) {
            return OperationResponse.SUCCESS;
        }
        if (firmware.getFirmwareVersion() == null) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.tc);
        }
        List<Firmware> firmwares = this.e.b(omadacId.a(), firmware.getModelTypeInfo().getCompoundModel());
        if (!CollectionUtils.isEmpty(firmwares)) {
            for (Firmware firmware2 : firmwares) {
                if (firmware2.getId().equals(firmware.getId()) || !CollectionUtils.containsAny(firmware.getTargetSites(), firmware2.getTargetSites())) continue;
                return new OperationResponse(com.tplink.smb.omada.common.g.b.td);
            }
        }
        if (!CollectionUtils.isEmpty(autoCheckUpgrades = this.f.d(omadacId.a(), firmware.getModelTypeInfo().getCompoundModel()))) {
            for (com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.c autoCheckUpgrade : autoCheckUpgrades) {
                if (!CollectionUtils.containsAny(firmware.getTargetSites(), autoCheckUpgrade.e())) continue;
                return new OperationResponse(com.tplink.smb.omada.common.g.b.tf);
            }
        }
        if (!CollectionUtils.isEmpty(list = this.g.e(omadacId.a(), firmware.getModelTypeInfo().getCompoundModel()))) {
            for (com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.u planUpgrade : list) {
                if (!CollectionUtils.containsAny(firmware.getTargetSites(), planUpgrade.e())) continue;
                return new OperationResponse(com.tplink.smb.omada.common.g.b.te);
            }
        }
        return OperationResponse.SUCCESS;
    }

    private void b(com.tplink.smb.omada.manager.j.a.a.c omadacId, Firmware firmware) {
        if (!Boolean.TRUE.equals(firmware.getTargetEnable()) || CollectionUtils.isEmpty(firmware.getTargetSites())) {
            return;
        }
        ArrayList<com.tplink.smb.omada.manager.device.domain.model.upgrade.firmware.b> targetFirmwares = new ArrayList<com.tplink.smb.omada.manager.device.domain.model.upgrade.firmware.b>();
        for (String site : firmware.getTargetSites()) {
            targetFirmwares.add(com.tplink.smb.omada.manager.device.domain.model.upgrade.firmware.b.a().a(omadacId).a(new com.tplink.smb.omada.manager.j.a.a.d(site)).e(firmware.getFirmwareVersion()).d(firmware.getModelTypeInfo().getCompoundModel()).b(firmware.getId()).c(firmware.getName()).a());
        }
        this.k.a(targetFirmwares);
    }

    private void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, Firmware newFirmware, boolean oldTargetEnable, List<String> oldTargetSites) {
        if (!Boolean.TRUE.equals(newFirmware.getTargetEnable()) || CollectionUtils.isEmpty(newFirmware.getTargetSites())) {
            this.k.a(omadacId.a(), oldTargetSites, newFirmware.getModelTypeInfo().getCompoundModel());
            return;
        }
        HashSet<String> increaseSites = new HashSet<String>(newFirmware.getTargetSites());
        if (!CollectionUtils.isEmpty(oldTargetSites)) {
            increaseSites.removeIf(oldTargetSites::contains);
        }
        if (!CollectionUtils.isEmpty(increaseSites)) {
            ArrayList<com.tplink.smb.omada.manager.device.domain.model.upgrade.firmware.b> increasedTargetFirmwares = new ArrayList<com.tplink.smb.omada.manager.device.domain.model.upgrade.firmware.b>();
            for (String site2 : increaseSites) {
                increasedTargetFirmwares.add(com.tplink.smb.omada.manager.device.domain.model.upgrade.firmware.b.a().a(omadacId).a(new com.tplink.smb.omada.manager.j.a.a.d(site2)).e(newFirmware.getFirmwareVersion()).d(newFirmware.getModelTypeInfo().getCompoundModel()).b(newFirmware.getId()).c(newFirmware.getName()).a());
            }
            this.k.a(increasedTargetFirmwares);
        }
        if (CollectionUtils.isEmpty(oldTargetSites)) {
            return;
        }
        HashSet<String> reduceSites = new HashSet<String>(oldTargetSites);
        reduceSites.removeIf(site -> newFirmware.getTargetSites().contains(site));
        if (!CollectionUtils.isEmpty(reduceSites)) {
            this.k.a(omadacId.a(), reduceSites, newFirmware.getModelTypeInfo().getCompoundModel());
        }
    }

    private List<String> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, List<String> siteIds) {
        return this.i.a(omadacId, siteIds);
    }

    public OperationResponse a(String omadacId, long uploadSize) {
        if (this.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), uploadSize)) {
            return OperationResponse.SUCCESS;
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.tw);
    }
}

