/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.application.upgrade;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.TaskKey;
import com.tplink.smb.component.upgradefilecache.api.UpgradeFileCacheCommonService;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.obfuscate.KeepClassNameAndSetter;
import com.tplink.smb.omada.common.obfuscate.KeepMethod;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.g;
import com.tplink.smb.omada.common.util.system.c;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalMethodResolveClient;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalRequestDTO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.CheckDeviceFirmwareVO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.StackUpgradeReqDTO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.UpgradeProcessVO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.UpgradeResultVO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.UpgradeStackResultVO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.UploadUpgradeFileResVO;
import com.tplink.smb.omada.manager.device.application.upgrade.PreConnectInfoDTO;
import com.tplink.smb.omada.manager.device.application.upgrade.UpgradeResponseDTO;
import com.tplink.smb.omada.manager.device.application.upgrade.d;
import com.tplink.smb.omada.manager.device.application.upgrade.f;
import com.tplink.smb.omada.manager.device.application.upgrade.firmware.a;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.device.O;
import com.tplink.smb.omada.manager.device.domain.model.device.o;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.l;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.UpgradeRequestDTO;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.j;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.n;
import com.tplink.smb.omada.manager.stack.api.internal.dto.OswStackInfoDTO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@KeepClassNameAndSetter
public class UpgradeDeviceApplicationService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(UpgradeDeviceApplicationService.class);
    @Autowired
    private j b;
    @Autowired
    private l c;
    @Autowired
    private UpgradeFileCacheCommonService d;
    @Autowired
    private com.tplink.smb.omada.manager.stack.api.internal.service.c e;
    @Autowired
    private ScheduleCenter f;
    @Autowired
    private OmadaClusterUniversalMethodResolveClient g;
    @Autowired
    @Lazy
    private a h;
    @Autowired
    private O i;

    public OperationResponse<UpgradeResultVO> a(UpgradeRequestDTO upgradeRequestDTO) {
        List upgradeMacList;
        com.tplink.smb.omada.manager.j.a.a.d site;
        com.tplink.smb.omada.manager.j.a.a.c omadacId = upgradeRequestDTO.getOmadacId();
        List<o> deviceList = this.i.b(omadacId, site = upgradeRequestDTO.getSite(), new HashSet<String>(upgradeMacList = upgradeRequestDTO.getUpgradeMacList().stream().map(G::a).collect(Collectors.toList())));
        if (CollectionUtils.isEmpty(deviceList)) {
            a.warn("omadacId:{},siteId:{}, checkAndUpgrade when manual upgrade no device can upgrade.", (Object)omadacId.a(), (Object)site.a());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.zU);
        }
        Set<String> targetFirmwareModel = this.h.c(omadacId, site.a());
        List<G> macList = deviceList.stream().filter(device -> !targetFirmwareModel.contains(device.O().getCompoundModel())).map(o::c_).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(macList)) {
            a.warn("omadacId:{},siteId:{}, when manual upgrade has device configured with a target firmware version.", (Object)omadacId.a(), (Object)site.a());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.tn);
        }
        upgradeRequestDTO.setUpgradeMacList(macList);
        return this.b(upgradeRequestDTO);
    }

    public OperationResponse<UpgradeResultVO> b(UpgradeRequestDTO upgradeRequestDTO) {
        String upgradeId = T.e();
        upgradeRequestDTO.setUpgradeId(upgradeId);
        com.tplink.smb.omada.manager.j.a.a.c omadacId = upgradeRequestDTO.getOmadacId();
        a.info("manual trigger START-DEVICE-UPGRADE omadacId:{},siteId:{},upgradeId:{}, devices {}", new Object[]{omadacId.a(), upgradeId, upgradeRequestDTO.getSite(), upgradeRequestDTO.getUpgradeMacList()});
        b resErrorCode = DeviceTypeEnum.d.equals((Object)upgradeRequestDTO.getDeviceTypeEnum()) ? this.b.b(upgradeRequestDTO) : this.b.a(upgradeRequestDTO);
        UpgradeResultVO upgradeResultVO = new UpgradeResultVO(omadacId.a(), upgradeId, com.tplink.smb.omada.manager.device.application.upgrade.d.d(upgradeRequestDTO.getUpgradeMacList()));
        return new OperationResponse(resErrorCode, (Object)upgradeResultVO);
    }

    public OperationResponse<UpgradeStackResultVO> a(UpgradeRequestDTO upgradeRequestDTO, StackUpgradeReqDTO upgradeReqDTO) {
        UpgradeStackResultVO resultVO = new UpgradeStackResultVO();
        com.tplink.smb.omada.manager.j.a.a.c omadacId = upgradeRequestDTO.getOmadacId();
        com.tplink.smb.omada.manager.j.a.a.d siteId = upgradeRequestDTO.getSite();
        resultVO.setOmadacId(omadacId.a());
        resultVO.setStackIds(upgradeReqDTO.getStackIds());
        OperationResponse response = new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)resultVO);
        if (CollectionUtils.isEmpty((Collection)upgradeReqDTO.getStackIds())) {
            return response;
        }
        List stackInfos = this.e.a(omadacId.a(), siteId.a(), (Collection)upgradeReqDTO.getStackIds());
        if (stackInfos.size() != upgradeReqDTO.getStackIds().size()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.HC);
        }
        List<String> deviceMacs = stackInfos.stream().map(OswStackInfoDTO::getMasterMac).collect(Collectors.toList());
        List<com.tplink.smb.omada.manager.device.domain.model.deviceimage.d> imageList = this.c.c(omadacId, deviceMacs);
        ArrayList<String> masterMacs = new ArrayList<String>();
        for (int i2 = 0; i2 < imageList.size(); ++i2) {
            if (!imageList.get(i2).aX().x().equals(upgradeReqDTO.getCompoundModel())) continue;
            masterMacs.add(imageList.get(i2).al().a());
        }
        if (CollectionUtils.isEmpty(masterMacs)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.zU);
        }
        upgradeRequestDTO.setUpgradeMacList(com.tplink.smb.omada.manager.device.application.upgrade.d.a(masterMacs));
        OperationResponse<UpgradeResultVO> upgradeResp = this.b(upgradeRequestDTO);
        resultVO.setUpgradeId(((UpgradeResultVO)upgradeResp.getResult()).getUpgradeId());
        resultVO.setMacs(masterMacs);
        return response;
    }

    public OperationResponse a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d site, G deviceMac) {
        UpgradeProcessVO upgradeProcessVO = this.b.a(omadacId, site, deviceMac);
        if (upgradeProcessVO == null) {
            a.debug("omadacId:{},siteId:{},deviceMac:{}, getSingleUpgradeProcess result is null, device is not on upgrading", new Object[]{omadacId.a(), site.a(), deviceMac});
            return OperationResponse.SUCCESS;
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)upgradeProcessVO);
    }

    public OperationResponse b(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d site, G deviceMac) {
        UpgradeProcessVO upgradeProcessVO = this.b.b(omadacId, site, deviceMac);
        if (upgradeProcessVO == null) {
            a.debug("omadacId:{},siteId:{},deviceMac:{}, getOltSingleUpgradeProcess result is null, device is not on upgrading", new Object[]{omadacId.a(), site.a(), deviceMac});
            return OperationResponse.SUCCESS;
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)upgradeProcessVO);
    }

    public OperationResponse<UploadUpgradeFileResVO> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, InputStream in, String checkMd5, String fileName, long size, boolean allowAutoDelete) {
        try {
            CountingInputStream countingIn = new CountingInputStream(in);
            g md5DigestInputstream = new g((InputStream)countingIn);
            b resErrorCode = this.b.a(omadacId, checkMd5, (InputStream)md5DigestInputstream, size, allowAutoDelete);
            UploadUpgradeFileResVO res = new UploadUpgradeFileResVO(checkMd5);
            if (!resErrorCode.a()) {
                a.warn("omadacId:{}, fileName [{}] save failed", (Object)omadacId.a(), (Object)fileName);
                return new OperationResponse(resErrorCode, (Object)res);
            }
            String fileId = md5DigestInputstream.b();
            if (fileId == null || !Objects.equals(checkMd5, fileId)) {
                return new OperationResponse(resErrorCode, (Object)res);
            }
            if (checkMd5 != null && !Objects.equals(checkMd5, fileId)) {
                this.d.deleteUpgradeFile(checkMd5);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.eL);
            }
            return new OperationResponse(resErrorCode, (Object)res);
        }
        catch (Exception e2) {
            a.warn("omadacId:{}, fileName [{}] getBytes Exception", (Object)omadacId.a(), (Object)fileName);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.eL);
        }
    }

    public OperationResponse<UploadUpgradeFileResVO> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, InputStream in, String checkMd5, String fileName, long size, boolean allowAutoDelete) {
        try {
            byte[] fileBytes = IOUtils.toByteArray((InputStream)in);
            CountingInputStream countingIn = new CountingInputStream((InputStream)new ByteArrayInputStream(fileBytes));
            g md5DigestInputstream = new g((InputStream)countingIn);
            b resErrorCode = this.b.a(omadacId, checkMd5, (InputStream)md5DigestInputstream, size, allowAutoDelete);
            UploadUpgradeFileResVO res = new UploadUpgradeFileResVO(checkMd5);
            if (!resErrorCode.a()) {
                a.warn("omadacId:{}, fileName [{}] uploadUpgradeFileForGlobalFirmware failed", (Object)omadacId.a(), (Object)fileName);
                return new OperationResponse(resErrorCode, (Object)res);
            }
            String fileId = md5DigestInputstream.b();
            if (fileId == null || !Objects.equals(checkMd5, fileId)) {
                return new OperationResponse(resErrorCode, (Object)res);
            }
            if (checkMd5 != null && !Objects.equals(checkMd5, fileId)) {
                this.d.deleteUpgradeFile(checkMd5);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.eL);
            }
            this.a(omadacId.a(), checkMd5, fileBytes, size, allowAutoDelete);
            return new OperationResponse(resErrorCode, (Object)res);
        }
        catch (Exception e2) {
            a.warn("omadacId:{}, fileName [{}] uploadUpgradeFileForGlobalFirmware getBytes Exception", (Object)omadacId.a(), (Object)fileName);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.eL);
        }
    }

    private void a(String omadacId, String checkMd5, byte[] fileBytes, Long size, Boolean allowAutoDelete) {
        if (!com.tplink.smb.omada.common.util.system.a.b()) {
            return;
        }
        a.info("omadacId:{}, do notifyOtherNodeSaveUpgradeFile", (Object)omadacId);
        OmadaClusterUniversalRequestDTO requestDTO = new OmadaClusterUniversalRequestDTO(UpgradeDeviceApplicationService.class, (TypeReference)new f(this), Boolean.valueOf(false), "saveUpgradeFileForCluster", new Class[]{String.class, String.class, byte[].class, Long.class, Boolean.class}, new Object[]{omadacId, checkMd5, fileBytes, size, allowAutoDelete});
        for (String nodeId : com.tplink.smb.omada.common.util.system.c.a().keySet()) {
            if (Objects.equals(nodeId, com.tplink.smb.omada.common.util.system.a.h())) continue;
            this.g.resolveSpringBeanCall(nodeId, requestDTO, 120L, TimeUnit.SECONDS);
        }
    }

    @KeepMethod
    public void saveUpgradeFileForCluster(String omadacId, String checkMd5, byte[] fileBytes, Long size, Boolean allowAutoDelete) {
        a.info("saveUpgradeFileForCluster invoked by other node.");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileBytes);
        b resErrorCode = this.b.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), checkMd5, byteArrayInputStream, size, allowAutoDelete);
        if (!resErrorCode.a()) {
            a.warn("saveUpgradeFileForCluster failed, the error code is {}, error message is {}.", (Object)resErrorCode.b(), (Object)resErrorCode.c());
        }
    }

    public OperationResponse a(com.tplink.smb.omada.manager.j.a.a.c omadacId, String fileId) {
        b removeRes = this.b.b(omadacId, fileId);
        if (removeRes.a()) {
            return OperationResponse.SUCCESS;
        }
        a.warn("{} fileId [{}] delete failed", (Object)omadacId, (Object)fileId);
        return OperationResponse.GENERAL_ERROR;
    }

    public OperationResponse a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d site, CheckDeviceFirmwareVO checkDeviceFirmwareVO) {
        if (CollectionUtils.isEmpty((Collection)checkDeviceFirmwareVO.getMac())) {
            a.warn("omadacId:{},siteId:{} checkTargetFirmware param is null.", (Object)omadacId.a(), (Object)site.a());
            return OperationResponse.SUCCESS;
        }
        List<o> deviceList = this.i.b(omadacId, site, new HashSet<String>(checkDeviceFirmwareVO.getMac()));
        Set<String> targetFirmwareModel = this.h.c(omadacId, site.a());
        if (CollectionUtils.isEmpty(targetFirmwareModel)) {
            return OperationResponse.SUCCESS;
        }
        for (o device : deviceList) {
            if (null == device.O() || !targetFirmwareModel.contains(device.O().getCompoundModel())) continue;
            a.warn("omadacId:{},siteId:{} checkTargetFirmware has device configured with a target firmware version.", (Object)omadacId.a(), (Object)site.a());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.tn);
        }
        return OperationResponse.SUCCESS;
    }

    public OperationResponse<UploadUpgradeFileResVO> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, String fileId) {
        boolean res = this.b.a(omadacId, fileId);
        return res ? new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)new UploadUpgradeFileResVO(fileId)) : new OperationResponse(com.tplink.smb.omada.common.g.b.a);
    }

    public OperationResponse<UpgradeProcessVO> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d site, String upgradeId) {
        UpgradeProcessVO upgradeProcessVO = this.b.a(omadacId, site, upgradeId);
        if (upgradeProcessVO == null) {
            a.warn("omadacId:{},siteId:{},upgradeId:{} getUpgradeProcess result is null", new Object[]{omadacId.a(), site.a(), upgradeId});
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)upgradeProcessVO);
    }

    public OperationResponse<UpgradeProcessVO> b(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d site, String upgradeId) {
        UpgradeProcessVO upgradeProcessVO = this.b.b(omadacId, site, upgradeId);
        if (upgradeProcessVO == null) {
            a.warn("omadacId:{},siteId:{},upgradeId:{} getOltUpgradeProcess result is null", new Object[]{omadacId.a(), site.a(), upgradeId});
        } else if (n.c.a() == upgradeProcessVO.getProgressStatus().intValue()) {
            this.f.deleteTask(TaskKey.of((String)"monitor_upgrade", (String)upgradeId));
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)upgradeProcessVO);
    }

    public OperationResponse a(com.tplink.smb.omada.manager.j.a.a.c omadacId, com.tplink.smb.omada.manager.j.a.a.d site, String fileId, DeviceTypeEnum deviceTypeEnum, String model, String role, String operator, String ip, int resource) {
        if (this.h.a(omadacId, Collections.singletonList(model), Collections.singletonList(site.a()))) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.tn);
        }
        ArrayList<G> deviceMacs = new ArrayList<G>();
        List<com.tplink.smb.omada.manager.device.domain.model.deviceimage.d> imageList = this.c.a(omadacId, site);
        for (int i2 = 0; i2 < imageList.size(); ++i2) {
            if (!imageList.get(i2).aX().x().equals(model)) continue;
            deviceMacs.add(imageList.get(i2).al());
        }
        if (CollectionUtils.isEmpty(deviceMacs)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.zU);
        }
        UpgradeRequestDTO upgradeRequestDTO = new UpgradeRequestDTO(omadacId, "", deviceMacs, fileId, site, deviceTypeEnum, deviceMacs.size() == 1, false, role, operator, ip, resource, null, null, null);
        return this.b(upgradeRequestDTO);
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, G deviceMac) {
        b resErrorCode = this.b.a(omadacId, deviceMac);
        if (resErrorCode.a()) {
            return;
        }
    }

    public void a(UpgradeResponseDTO upgradeResponseDTO) {
        b resErrorCode = this.b.a(upgradeResponseDTO);
        if (resErrorCode.a()) {
            a.debug("handle success upgradeResponse in {}", (Object)upgradeResponseDTO.getDeviceMac());
            return;
        }
    }

    public void b(com.tplink.smb.omada.manager.j.a.a.c omadacId, G deviceMac) {
        b resErrorCode = this.b.b(omadacId, deviceMac);
        if (resErrorCode.a()) {
            a.debug("handle success SendUpgradeFileFailed in {}", (Object)deviceMac.a());
            return;
        }
    }

    public void a(PreConnectInfoDTO preConnectInfo) {
        b resErrorCode = this.b.a(preConnectInfo);
        if (resErrorCode.a()) {
            a.debug("handle success PreConnectInfo in {}", (Object)preConnectInfo.getDeviceMac());
        } else {
            this.b(preConnectInfo.getOmadacId(), preConnectInfo.getDeviceMac());
        }
    }

    public void a(long time) {
        this.d.deleteFileByExpireTime(time);
    }
}

