/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.application.deviceInfo;

import com.tplink.smb.ecsp.common.TransResult;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageBody;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.PreConnectInfo;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.PreConnectInfoResponse;
import com.tplink.smb.ecsp.protocol.packet.header.MessageHeader;
import com.tplink.smb.ecsp.proxy.EcspV2DeviceServerProxy;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.spring.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.EcspFirstVersionEnum;
import com.tplink.smb.omada.device.manage.message.MessageType;
import com.tplink.smb.omada.manager.device.application.deviceInfo.TransferPreConnectDTO;
import com.tplink.smb.omada.manager.device.application.deviceInfo.a.a;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import jakarta.annotation.PostConstruct;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@b
public class c {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);
    private static final PreConnectInfoResponse b = PreConnectInfoResponse.builder().errCode(Integer.valueOf(0)).build();
    private static final PreConnectInfoResponse c = PreConnectInfoResponse.builder().errCode(Integer.valueOf(-25001)).build();
    @Autowired
    @Lazy
    private EcspV2DeviceServerProxy d;
    @Autowired
    private a e;
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.omadac.c f;
    @Autowired
    private com.tplink.smb.omada.manager.dpi.api.internal.service.b g;

    @PostConstruct
    public void a() {
        this.d.observeTransferPreConnectRequest().subscribe(this::a, throwable -> a.warn("observe v2 transfer pre connect: {},", (Object)throwable.getMessage(), throwable));
    }

    private void a(TransResult<EcspMessage> transResult) {
        com.tplink.smb.omada.common.concurrent.thread.b.a(() -> {
            try {
                a.info("start handle transfer pre-connected info.");
                if (Objects.isNull(transResult)) {
                    a.info("empty transfer pre-connected info.");
                    return;
                }
                EcspMessage message = (EcspMessage)transResult.getResult();
                String mac = message.getMac();
                TransferPreConnectDTO transferPreConnect = this.a((EcspMessage)transResult.getResult());
                if (Objects.isNull(transferPreConnect) || Objects.isNull(transferPreConnect.getToken())) {
                    a.info("error pre-connected info for device: {}", (Object)mac);
                    return;
                }
                a.debug("accept device transfer pre connect info is {}", (Object)transferPreConnect);
                if (this.a(mac, transferPreConnect.getToken())) {
                    a.info("send transfer channel pre-connected info response to dev: {}", (Object)mac);
                    this.d.sendTransferPreConnectResponse(mac, transferPreConnect.getEcspVersion(), (MessageBody)b, transferPreConnect.getSequenceId(), 30000L);
                } else {
                    a.warn("illegal device: {} try to connect to controller", (Object)mac);
                    this.d.sendTransferPreConnectResponse(mac, transferPreConnect.getEcspVersion(), (MessageBody)c, transferPreConnect.getSequenceId(), 30000L);
                }
            }
            catch (Exception e2) {
                a.warn("handle transfer pre connect message: {} failed.", (Object)T.b((Object)transResult), (Object)e2);
            }
        });
    }

    private TransferPreConnectDTO a(EcspMessage message) {
        MessageHeader header = message.getHeader();
        if (header == null) {
            a.warn("get pre connect info but header is null");
            return null;
        }
        String mac = header.getMac();
        DeviceTypeEnum deviceType = DeviceTypeEnum.a((String)header.getDevice());
        if (deviceType == null) {
            a.warn("get pre connect info from {} but deviceType is null", (Object)mac);
            return null;
        }
        MessageType messageType = null;
        if (header.getType() != null) {
            messageType = MessageType.resolve((int)header.getType());
        }
        if (messageType == null) {
            a.warn("get pre connect info from {} but messageType[{}] error", (Object)mac, (Object)header.getType());
            return null;
        }
        Integer sequenceId = header.getSeq();
        String ecspVersion = com.tplink.smb.omada.manager.device.port.common.b.b.a(deviceType, EcspFirstVersionEnum.V2);
        PreConnectInfo preConnectInfo = (PreConnectInfo)x.a((String)x.a((Object)message.getBody()), PreConnectInfo.class);
        TransferPreConnectDTO preConnectDTO = new TransferPreConnectDTO();
        preConnectDTO.setDeviceMac(mac);
        preConnectDTO.setDeviceType(deviceType);
        preConnectDTO.setEcspVersion(ecspVersion);
        preConnectDTO.setSequenceId(sequenceId);
        preConnectDTO.setToken(preConnectInfo.getToken());
        return preConnectDTO;
    }

    private boolean a(String deviceMac, String deviceToken) {
        if (T.c((String)deviceToken)) {
            a.warn("device token of : {} is blank", (Object)deviceMac);
            return false;
        }
        boolean valid = false;
        com.tplink.smb.omada.manager.j.a.a.c omadacId = this.f.a(new G(deviceMac));
        if (Objects.nonNull(omadacId) && Objects.nonNull(omadacId.a())) {
            String dpiToken = this.g.a(omadacId.a(), deviceMac);
            valid = T.a((String)dpiToken, (String)deviceToken);
        } else {
            a.info("cannot get omadacId of deviceMac : {}", (Object)deviceMac);
        }
        if (valid) {
            return true;
        }
        String transferToken = this.e.a(deviceMac);
        return T.a((String)transferToken, (String)deviceToken);
    }
}

