/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.application.device.osg.dto;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.manager.device.api.app.osg.dto.OsgConfigAppVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgConfigVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgMspConfigVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgPortConfigVO;
import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgPortPoeVO;
import com.tplink.smb.omada.manager.device.application.device.osg.dto.OsgIptvDTO;
import com.tplink.smb.omada.manager.device.application.device.osg.dto.OsgSnmpDTO;
import com.tplink.smb.omada.manager.device.domain.model.device.E;
import com.tplink.smb.omada.manager.device.domain.model.device.osg.y;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class OsgConfigDTO {
    private String name;
    private String description;
    private Integer ledSetting;
    private OsgSnmpDTO snmp;
    private OsgIptvDTO iptv;
    private Boolean hwOffloadEnable;
    private List<y> poe;
    @Deprecated
    private Boolean lldpEnable;
    private Integer lldpSetting;
    private String echoServer;
    private List<OsgPortConfigVO> portConfigs;
    private E locationDetail;
    private Boolean remember;
    private Integer rememberDevice;
    private List<String> tagIds;
    private Integer jumboSize;

    public static OsgConfigDTO fromWebVO(OsgConfigVO vo) {
        OsgConfigDTO dto = new OsgConfigDTO();
        dto.setName(vo.getName());
        dto.setDescription(vo.getDescription());
        dto.setLedSetting(vo.getLedSetting());
        dto.setSnmp(Optional.ofNullable(vo.getSnmp()).map(OsgSnmpDTO::fromWebVO).orElse(null));
        dto.setIptv(Optional.ofNullable(vo.getIptv()).map(OsgIptvDTO::fromWebVO).orElse(null));
        dto.setHwOffloadEnable(vo.getHwOffloadEnable());
        dto.setPoe(OsgConfigDTO.fromWebVO(vo.getPoeSettings()));
        dto.setLldpEnable(vo.getLldpEnable());
        dto.setLldpSetting(vo.getLldpSetting());
        dto.setEchoServer(vo.getEchoServer());
        dto.setPortConfigs(vo.getPortConfigs());
        dto.setLocationDetail(E.a(vo.getLocation()));
        dto.setRemember(vo.getRemember());
        dto.setRememberDevice(vo.getRememberDevice());
        dto.setTagIds(vo.getTagIds());
        dto.setJumboSize(vo.getJumboSize());
        return dto;
    }

    public static OsgConfigDTO fromWebVOForMsp(OsgMspConfigVO vo) {
        OsgConfigDTO dto = new OsgConfigDTO();
        dto.setName(vo.getName());
        return dto;
    }

    public static OsgConfigDTO fromAppVO(OsgConfigAppVO vo) {
        OsgConfigDTO dto = new OsgConfigDTO();
        dto.setName(vo.getName());
        dto.setLedSetting(vo.getLedSetting());
        dto.setSnmp(Optional.ofNullable(vo.getSnmp()).map(OsgSnmpDTO::fromAppVO).orElse(null));
        dto.setIptv(Optional.ofNullable(vo.getIptv()).map(OsgIptvDTO::fromAppVO).orElse(null));
        dto.setHwOffloadEnable(vo.getHwOffloadEnable());
        dto.setLldpEnable(vo.getLldpEnable());
        dto.setLldpSetting(vo.getLldpSetting());
        dto.setEchoServer(vo.getEchoServer());
        return dto;
    }

    public OperationResponse validate() {
        if (CollectionUtils.isEmpty(this.getPortConfigs())) {
            return OperationResponse.SUCCESS;
        }
        for (OsgPortConfigVO portConfigVO : this.getPortConfigs()) {
            if (!Boolean.TRUE.equals(portConfigVO.getMirrorEnable()) || !CollectionUtils.isEmpty((Collection)portConfigVO.getMirroredPorts()) && portConfigVO.getMirrorMode() != null) continue;
            return new OperationResponse(b.Dz);
        }
        return OperationResponse.SUCCESS;
    }

    public static List<y> fromWebVO(List<OsgPortPoeVO> poeSettings) {
        if (CollectionUtils.isEmpty(poeSettings)) {
            return null;
        }
        ArrayList<y> res = new ArrayList<y>();
        for (OsgPortPoeVO osgPortPoeVO : poeSettings) {
            res.add(new y(osgPortPoeVO.getPortId(), Boolean.TRUE.equals(osgPortPoeVO.getEnable()) ? 1 : 0));
        }
        return res;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Integer getLedSetting() {
        return this.ledSetting;
    }

    @Generated
    public OsgSnmpDTO getSnmp() {
        return this.snmp;
    }

    @Generated
    public OsgIptvDTO getIptv() {
        return this.iptv;
    }

    @Generated
    public Boolean getHwOffloadEnable() {
        return this.hwOffloadEnable;
    }

    @Generated
    public List<y> getPoe() {
        return this.poe;
    }

    @Deprecated
    @Generated
    public Boolean getLldpEnable() {
        return this.lldpEnable;
    }

    @Generated
    public Integer getLldpSetting() {
        return this.lldpSetting;
    }

    @Generated
    public String getEchoServer() {
        return this.echoServer;
    }

    @Generated
    public List<OsgPortConfigVO> getPortConfigs() {
        return this.portConfigs;
    }

    @Generated
    public E getLocationDetail() {
        return this.locationDetail;
    }

    @Generated
    public Boolean getRemember() {
        return this.remember;
    }

    @Generated
    public Integer getRememberDevice() {
        return this.rememberDevice;
    }

    @Generated
    public List<String> getTagIds() {
        return this.tagIds;
    }

    @Generated
    public Integer getJumboSize() {
        return this.jumboSize;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setLedSetting(Integer ledSetting) {
        this.ledSetting = ledSetting;
    }

    @Generated
    public void setSnmp(OsgSnmpDTO snmp) {
        this.snmp = snmp;
    }

    @Generated
    public void setIptv(OsgIptvDTO iptv) {
        this.iptv = iptv;
    }

    @Generated
    public void setHwOffloadEnable(Boolean hwOffloadEnable) {
        this.hwOffloadEnable = hwOffloadEnable;
    }

    @Generated
    public void setPoe(List<y> poe) {
        this.poe = poe;
    }

    @Deprecated
    @Generated
    public void setLldpEnable(Boolean lldpEnable) {
        this.lldpEnable = lldpEnable;
    }

    @Generated
    public void setLldpSetting(Integer lldpSetting) {
        this.lldpSetting = lldpSetting;
    }

    @Generated
    public void setEchoServer(String echoServer) {
        this.echoServer = echoServer;
    }

    @Generated
    public void setPortConfigs(List<OsgPortConfigVO> portConfigs) {
        this.portConfigs = portConfigs;
    }

    @Generated
    public void setLocationDetail(E locationDetail) {
        this.locationDetail = locationDetail;
    }

    @Generated
    public void setRemember(Boolean remember) {
        this.remember = remember;
    }

    @Generated
    public void setRememberDevice(Integer rememberDevice) {
        this.rememberDevice = rememberDevice;
    }

    @Generated
    public void setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
    }

    @Generated
    public void setJumboSize(Integer jumboSize) {
        this.jumboSize = jumboSize;
    }

    @Generated
    public String toString() {
        return "OsgConfigDTO(name=" + this.getName() + ", description=" + this.getDescription() + ", ledSetting=" + this.getLedSetting() + ", snmp=" + this.getSnmp() + ", iptv=" + this.getIptv() + ", hwOffloadEnable=" + this.getHwOffloadEnable() + ", poe=" + this.getPoe() + ", lldpEnable=" + this.getLldpEnable() + ", lldpSetting=" + this.getLldpSetting() + ", echoServer=" + this.getEchoServer() + ", portConfigs=" + this.getPortConfigs() + ", locationDetail=" + this.getLocationDetail() + ", remember=" + this.getRemember() + ", rememberDevice=" + this.getRememberDevice() + ", tagIds=" + this.getTagIds() + ", jumboSize=" + this.getJumboSize() + ")";
    }
}

