/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.shared;

import com.tplink.smb.omada.common.util.v;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.util.CollectionUtils;

public class Ipv4CheckDTO {
    long ipStart;
    long ipEnd;
    String ipAddress;
    List<String> ipList;
    long minIp;
    long maxIp;
    IpRangeTypeEnum type;

    private Ipv4CheckDTO() {
    }

    public long getIpStart() {
        switch (this.type) {
            case RANGE: {
                return this.ipStart;
            }
            case SINGLE: {
                return v.b((String)this.ipAddress);
            }
            case LIST: {
                return this.minIp;
            }
        }
        return 0L;
    }

    public long getIpEnd() {
        switch (this.type) {
            case RANGE: {
                return this.ipEnd;
            }
            case SINGLE: {
                return v.b((String)this.ipAddress);
            }
            case LIST: {
                return this.maxIp;
            }
        }
        return 0L;
    }

    public boolean duplicateWithIpRange(String cidr) {
        long start = v.f((String)cidr);
        long end = v.g((String)cidr);
        return this.duplicateWithIpRange(start, end);
    }

    public boolean duplicateWithIpRange(String start, String end) {
        return this.duplicateWithIpRange(v.b((String)start), v.b((String)end));
    }

    private boolean duplicateWithIpRange(long start, long end) {
        switch (this.type) {
            case RANGE: {
                return this.ipStart <= end && this.ipEnd >= start;
            }
            case LIST: {
                if (this.minIp > end || this.maxIp < start) {
                    return false;
                }
                for (String ipAddr : this.ipList) {
                    long ip = v.b((String)ipAddr);
                    if (ip < start || ip > end) continue;
                    return true;
                }
                return false;
            }
            case SINGLE: {
                long ip = v.b((String)this.ipAddress);
                return ip >= start && ip <= end;
            }
        }
        return false;
    }

    public boolean duplicateWithIpList(List<String> ipList) {
        for (String ip : ipList) {
            if (!this.duplicateWithSingleIp(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean duplicateWithSingleIp(String ipAddr) {
        switch (this.type) {
            case RANGE: {
                return v.a((String)ipAddr, (long)this.ipStart, (long)this.ipEnd);
            }
            case LIST: {
                return this.ipList.contains(ipAddr);
            }
            case SINGLE: {
                return this.ipAddress.equals(ipAddr);
            }
        }
        return false;
    }

    public static Ipv4CheckDTO buildFromIpv4AndMask(String ipv4, String mask) {
        if (!Pattern.matches("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", ipv4) || !Pattern.matches("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", mask)) {
            return null;
        }
        Ipv4CheckDTO ipRangeDTO = new Ipv4CheckDTO();
        ipRangeDTO.ipStart = v.e((String)ipv4, (String)mask);
        ipRangeDTO.ipEnd = v.h((String)ipv4, (String)mask);
        ipRangeDTO.type = IpRangeTypeEnum.RANGE;
        return ipRangeDTO;
    }

    public static Ipv4CheckDTO buildFromCIDR(String cidr) {
        if (!Pattern.matches("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])/(\\d|((1|2)\\d)|(30|31|32))\\b", cidr)) {
            return null;
        }
        Ipv4CheckDTO ipRangeDTO = new Ipv4CheckDTO();
        ipRangeDTO.ipStart = v.f((String)cidr);
        ipRangeDTO.ipEnd = v.g((String)cidr);
        ipRangeDTO.type = IpRangeTypeEnum.RANGE;
        return ipRangeDTO;
    }

    public static Ipv4CheckDTO buildFromSingleAddress(String addr) {
        if (!Pattern.matches("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", addr)) {
            return null;
        }
        Ipv4CheckDTO ipRangeDTO = new Ipv4CheckDTO();
        ipRangeDTO.ipAddress = addr;
        ipRangeDTO.type = IpRangeTypeEnum.SINGLE;
        return ipRangeDTO;
    }

    public static Ipv4CheckDTO buildFromList(List<String> addrList) {
        if (CollectionUtils.isEmpty(addrList)) {
            return null;
        }
        Ipv4CheckDTO ipRangeDTO = new Ipv4CheckDTO();
        ipRangeDTO.ipList = new ArrayList<String>();
        ipRangeDTO.ipList.addAll(addrList);
        ipRangeDTO.minIp = addrList.stream().map(v::b).min(Long::compare).orElse(0L);
        ipRangeDTO.maxIp = addrList.stream().map(v::b).max(Long::compare).orElse(ipRangeDTO.minIp);
        ipRangeDTO.type = IpRangeTypeEnum.LIST;
        return ipRangeDTO;
    }

    private static enum IpRangeTypeEnum {
        SINGLE,
        RANGE,
        LIST;

    }
}

