/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.speedtest;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.body.NotifyRequestBody;
import com.tplink.smb.omada.device.manage.message.config.osg.OsgSetKeyEnum;
import com.tplink.smb.omada.device.manage.message.notify.req.SpeedTestNotifyReq;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.K;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.d.v;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.speedtest.SpeedTestResult;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class SpeedTestResultBO {
    private String id;
    private Integer status;
    private Long timeStamp;
    private List<SpeedTestResult> resultInfos;
    private Map<Integer, String> portNameMap;

    public static SpeedTestResultBO buildDefault() {
        return new SpeedTestResultBO().setId(T.e()).setStatus(2).setTimeStamp(System.currentTimeMillis() / 1000L);
    }

    public SpeedTestResultBO buildByNotifyRequestBody(@Nullable NotifyRequestBody notifyRequestBody, Map<K, v> portIdPortUuidMap) {
        this.setStatus(3);
        if (Objects.isNull(notifyRequestBody)) {
            return this;
        }
        List speedTestResps = x.b((String)x.a(notifyRequestBody.getContent().get(OsgSetKeyEnum.SPEED_TEST.key())), SpeedTestNotifyReq.class);
        if (!CollectionUtils.isEmpty((Collection)speedTestResps)) {
            for (SpeedTestNotifyReq req : speedTestResps) {
                if (!Objects.equals(req.getStatus(), 1)) continue;
                this.setStatus(1);
            }
            this.setResultInfos(speedTestResps.stream().map(speedTestNotifyReq -> SpeedTestResult.fromNotifyReq(speedTestNotifyReq, portIdPortUuidMap)).collect(Collectors.toList()));
        } else {
            this.setResultInfos(new ArrayList<SpeedTestResult>(2));
        }
        this.setTimeStamp(System.currentTimeMillis() / 1000L);
        return this;
    }

    public boolean isTesting() {
        return Objects.equals(this.status, 2);
    }

    public boolean isFailed() {
        return Objects.equals(3, this.status);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Long getTimeStamp() {
        return this.timeStamp;
    }

    @Generated
    public List<SpeedTestResult> getResultInfos() {
        return this.resultInfos;
    }

    @Generated
    public Map<Integer, String> getPortNameMap() {
        return this.portNameMap;
    }

    @Generated
    public SpeedTestResultBO setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public SpeedTestResultBO setStatus(Integer status) {
        this.status = status;
        return this;
    }

    @Generated
    public SpeedTestResultBO setTimeStamp(Long timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    @Generated
    public SpeedTestResultBO setResultInfos(List<SpeedTestResult> resultInfos) {
        this.resultInfos = resultInfos;
        return this;
    }

    @Generated
    public SpeedTestResultBO setPortNameMap(Map<Integer, String> portNameMap) {
        this.portNameMap = portNameMap;
        return this;
    }

    @Generated
    public String toString() {
        return "SpeedTestResultBO(id=" + this.getId() + ", status=" + this.getStatus() + ", timeStamp=" + this.getTimeStamp() + ", resultInfos=" + this.getResultInfos() + ", portNameMap=" + this.getPortNameMap() + ")";
    }
}

