/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan;

import com.tplink.smb.omada.common.constant.o;
import com.tplink.smb.omada.common.e.l;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.config.WeightConfig;
import com.tplink.smb.omada.device.manage.message.config.osg.WanLoadBalanceConfig;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.VirtualWanWeightVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.WanLoadBalanceVO;
import com.tplink.smb.omada.manager.configuration.domain.model.site.component.g;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.virtualwan.a;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.K;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.VirtualWanWeight;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.d.v;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

@KeepClass
public class WanLoadBalance
implements l<WanLoadBalance> {
    private String weight;
    private Boolean appOptRouting;
    private Boolean linkBackup;
    private String backupWan;
    private List<String> primaryWan;
    private String method;
    private Integer mode;
    private List<VirtualWanWeight> virtualWanWeights;
    private static final String WEIGHT_FOR_NORMAL_WAN = "10";
    private static final String WEIGHT_FOR_USB_LTE_WAN = "1";
    private static final String WEIGHT_FOR_ALL_NORMAL = "1";

    public static WanLoadBalance fromVO(@Nonnull WanLoadBalanceVO wanLoadBalanceVO, List<v> wanPortUnis, String oldWeight, Map<String, Integer> osgPortTypeMap, List<a> virtualWans, WanLoadBalanceConfig defaultLoadBalanceConfig) {
        if (wanLoadBalanceVO == null) {
            return WanLoadBalance.createDefaultWanLoadBalance(wanPortUnis, osgPortTypeMap, virtualWans, defaultLoadBalanceConfig);
        }
        WanLoadBalance wanLoadBalance = new WanLoadBalance();
        wanLoadBalance.setWeight(wanLoadBalanceVO.getWeight()).setAppOptRouting(wanLoadBalanceVO.getAppOptRouting()).setLinkBackup(wanLoadBalanceVO.getLinkBackup()).setBackupWan(wanLoadBalanceVO.getBackupWan()).setPrimaryWan(wanLoadBalanceVO.getPrimaryWan()).setMethod(wanLoadBalanceVO.getMethod()).setMode(wanLoadBalanceVO.getMode());
        if (wanLoadBalanceVO.getVirtualWanWeights() != null) {
            wanLoadBalance.setVirtualWanWeights(wanLoadBalanceVO.getVirtualWanWeights().stream().map(virtualWanWeightVO -> {
                VirtualWanWeight virtualWanWeight = new VirtualWanWeight();
                virtualWanWeight.setVirtualWanId(virtualWanWeightVO.getVirtualWanId()).setWeight(virtualWanWeightVO.getWeight());
                return virtualWanWeight;
            }).collect(Collectors.toList()));
        }
        if (T.a((String)wanLoadBalance.getWeight())) {
            wanLoadBalance.setWeight(oldWeight);
        }
        return wanLoadBalance;
    }

    public static WanLoadBalanceVO toVO(WanLoadBalance wanLoadBalance) {
        if (wanLoadBalance == null) {
            return null;
        }
        WanLoadBalanceVO wanLoadBalanceVO = new WanLoadBalanceVO();
        wanLoadBalanceVO.setWeight(wanLoadBalance.getWeight()).setAppOptRouting(wanLoadBalance.getAppOptRouting()).setLinkBackup(wanLoadBalance.getLinkBackup()).setBackupWan(wanLoadBalance.getBackupWan()).setPrimaryWan(wanLoadBalance.getPrimaryWan()).setMethod(wanLoadBalance.getMethod()).setMode(wanLoadBalance.getMode());
        if (wanLoadBalance.getVirtualWanWeights() != null) {
            wanLoadBalanceVO.setVirtualWanWeights(wanLoadBalance.getVirtualWanWeights().stream().map(virtualWanWeight -> {
                VirtualWanWeightVO virtualWanWeightVO = new VirtualWanWeightVO();
                virtualWanWeightVO.setVirtualWanId(virtualWanWeight.getVirtualWanId()).setWeight(virtualWanWeight.getWeight());
                return virtualWanWeightVO;
            }).collect(Collectors.toList()));
        }
        return wanLoadBalanceVO;
    }

    public static WanLoadBalance createDefaultWanLoadBalance(List<v> wanPortUnis, Map<String, Integer> osgPortTypeMap, List<a> virtualWans, WanLoadBalanceConfig defaultLoadBalanceConfig) {
        int virtualWansNum;
        int n2 = virtualWansNum = virtualWans == null ? 0 : virtualWans.size();
        if (virtualWansNum + wanPortUnis.size() < 2) {
            return null;
        }
        WanLoadBalance wanLoadBalance = new WanLoadBalance();
        wanLoadBalance.setWeight(WanLoadBalance.createDefaultWeight(wanPortUnis, osgPortTypeMap, Optional.ofNullable(defaultLoadBalanceConfig).map(WanLoadBalanceConfig::getWeight).orElse(null)));
        wanLoadBalance.setAppOptRouting(true);
        wanLoadBalance.setLinkBackup(false);
        WanLoadBalance.a(wanLoadBalance, wanPortUnis, osgPortTypeMap, virtualWans);
        return wanLoadBalance;
    }

    public static WanLoadBalance modifyWanLoadBalance(WanLoadBalance oldWanLoadBalance, List<v> newWanPortUnis, Map<String, Integer> osgPortTypeMap, List<a> virtualWans, WanLoadBalanceConfig defaultLoadBalanceConfig) {
        boolean backUpWanNotExist;
        int virtualWansNum;
        int n2 = virtualWansNum = virtualWans == null ? 0 : virtualWans.size();
        if (virtualWansNum + newWanPortUnis.size() < 2) {
            return null;
        }
        if (oldWanLoadBalance == null) {
            return WanLoadBalance.createDefaultWanLoadBalance(newWanPortUnis, osgPortTypeMap, virtualWans, defaultLoadBalanceConfig);
        }
        WanLoadBalance wanLoadBalance = new WanLoadBalance();
        wanLoadBalance.setWeight(WanLoadBalance.createDefaultWeight(newWanPortUnis, osgPortTypeMap, Optional.ofNullable(defaultLoadBalanceConfig).map(WanLoadBalanceConfig::getWeight).orElse(null)));
        wanLoadBalance.setAppOptRouting(oldWanLoadBalance.getAppOptRouting());
        wanLoadBalance.setLinkBackup(oldWanLoadBalance.getLinkBackup());
        WanLoadBalance.a(wanLoadBalance, newWanPortUnis, osgPortTypeMap, virtualWans);
        List<String> newWanPorts = newWanPortUnis.stream().map(v::b).collect(Collectors.toList());
        List<String> primaryWans = WanLoadBalance.a(oldWanLoadBalance.getPrimaryWan(), newWanPorts);
        boolean bl2 = backUpWanNotExist = !newWanPorts.contains(oldWanLoadBalance.getBackupWan());
        if (Boolean.FALSE.equals(oldWanLoadBalance.getLinkBackup()) || CollectionUtils.isEmpty(primaryWans) || backUpWanNotExist) {
            wanLoadBalance.setLinkBackup(false);
            return wanLoadBalance;
        }
        wanLoadBalance.setMethod(oldWanLoadBalance.getMethod());
        wanLoadBalance.setMode(oldWanLoadBalance.getMode());
        wanLoadBalance.setBackupWan(oldWanLoadBalance.getBackupWan());
        wanLoadBalance.setPrimaryWan(primaryWans);
        return wanLoadBalance;
    }

    public static WanLoadBalance modifyWanLoadBalanceByVirutalWan(WanLoadBalance oldWanLoadBalance, List<v> newWanPortUnis, Map<String, Integer> osgPortTypeMap, List<a> virtualWans, WanLoadBalanceConfig defaultLoadBalanceConfig) {
        int virtualWansNum;
        int n2 = virtualWansNum = virtualWans == null ? 0 : virtualWans.size();
        if (virtualWansNum + newWanPortUnis.size() < 2) {
            return null;
        }
        if (oldWanLoadBalance == null) {
            return WanLoadBalance.createDefaultWanLoadBalance(newWanPortUnis, osgPortTypeMap, virtualWans, defaultLoadBalanceConfig);
        }
        WanLoadBalance.a(oldWanLoadBalance, newWanPortUnis, osgPortTypeMap, virtualWans);
        return oldWanLoadBalance;
    }

    private static void a(WanLoadBalance wanLoadBalance, List<v> wanPortUnis, Map<String, Integer> osgPortTypeMap, List<a> virtualWans) {
        if (!CollectionUtils.isEmpty(virtualWans)) {
            String[] weight = wanLoadBalance.getWeight().split(",");
            if (weight.length != wanPortUnis.size()) {
                throw new IllegalArgumentException("inconsistent size of weight and port num");
            }
            Map<v, Integer> weightMap = IntStream.range(0, wanPortUnis.size()).boxed().collect(Collectors.toMap(i2 -> (v)wanPortUnis.get((int)i2), i2 -> Integer.parseInt(weight[i2])));
            wanLoadBalance.setVirtualWanWeights(virtualWans.stream().map(virtualWan -> {
                VirtualWanWeight virtualWanWeight = new VirtualWanWeight();
                virtualWanWeight.setVirtualWanId(((g)virtualWan.getId()).b());
                if (wanLoadBalance.getVirtualWanWeights() == null) {
                    virtualWanWeight.setWeight((Integer)weightMap.get(new v(virtualWan.getPhysicalWanId())));
                } else {
                    Optional<VirtualWanWeight> existingWeight = wanLoadBalance.getVirtualWanWeights().stream().filter(oldVirtualWanWeight -> oldVirtualWanWeight.getVirtualWanId().equals(((g)virtualWan.getId()).b())).findFirst();
                    virtualWanWeight.setWeight(existingWeight.isPresent() ? existingWeight.get().getWeight() : (Integer)weightMap.get(new v(virtualWan.getPhysicalWanId())));
                }
                return virtualWanWeight;
            }).collect(Collectors.toList()));
        } else {
            wanLoadBalance.setVirtualWanWeights(null);
        }
    }

    public static String createDefaultWeight(List<v> wanPortUnis, @NotNull Map<String, Integer> osgPortTypeMap, List<WeightConfig> defaultWeightConfig) {
        StringBuilder weight = new StringBuilder();
        if (CollectionUtils.isEmpty(defaultWeightConfig)) {
            boolean hasUsbWan = false;
            for (int i2 = 0; i2 < wanPortUnis.size(); ++i2) {
                if (o.h.equals(osgPortTypeMap.get(wanPortUnis.get(i2).b()))) {
                    weight.append("1");
                    hasUsbWan = true;
                } else {
                    weight.append(WEIGHT_FOR_NORMAL_WAN);
                }
                if (i2 == wanPortUnis.size() - 1) continue;
                weight.append(",");
            }
            if (!hasUsbWan) {
                return weight.toString().replaceAll(WEIGHT_FOR_NORMAL_WAN, "1");
            }
            return weight.toString();
        }
        for (int i3 = 0; i3 < wanPortUnis.size(); ++i3) {
            for (WeightConfig weightConfig : defaultWeightConfig) {
                if (!Objects.equals(wanPortUnis.get(i3).a(), weightConfig.getPortId())) continue;
                weight.append(weightConfig.getWeight());
            }
            if (i3 == wanPortUnis.size() - 1) continue;
            weight.append(",");
        }
        return weight.toString();
    }

    public static WanLoadBalance fromConfig(WanLoadBalanceConfig wanLoadBalanceConfig, List<v> wanPortUuids, @Nonnull Map<K, v> portUuidMap, Map<String, Integer> osgPortTypeMap, WanLoadBalanceConfig defaultLoadBalanceConfig) {
        if (wanLoadBalanceConfig == null) {
            return WanLoadBalance.createDefaultWanLoadBalance(wanPortUuids, osgPortTypeMap, null, defaultLoadBalanceConfig);
        }
        WanLoadBalance wanLoadBalance = new WanLoadBalance();
        String backupWan = null;
        if (!Objects.isNull(wanLoadBalanceConfig.getBackupWan())) {
            backupWan = portUuidMap.containsKey(new K(wanLoadBalanceConfig.getBackupWan())) ? portUuidMap.get(new K(wanLoadBalanceConfig.getBackupWan())).b() : null;
        }
        List<String> primaryWans = new ArrayList<String>(2);
        if (!CollectionUtils.isEmpty((Collection)wanLoadBalanceConfig.getPrimaryWan())) {
            primaryWans = wanLoadBalanceConfig.getPrimaryWan().stream().filter(primaryWan -> portUuidMap.containsKey(new K((Integer)primaryWan))).map(primaryWan -> ((v)portUuidMap.get(new K((Integer)primaryWan))).b()).collect(Collectors.toList());
        }
        wanLoadBalance.setBackupWan(backupWan).setPrimaryWan(primaryWans).setMethod(wanLoadBalanceConfig.getMethod()).setMode(wanLoadBalanceConfig.getMode());
        if (wanLoadBalanceConfig.getAppOptRouting() == null) {
            wanLoadBalance.setAppOptRouting(true);
        } else {
            wanLoadBalance.setAppOptRouting(Objects.equals(1, wanLoadBalanceConfig.getAppOptRouting()));
        }
        wanLoadBalance.setLinkBackup(Objects.equals(1, wanLoadBalanceConfig.getLinkBackup()));
        StringBuilder weight = new StringBuilder();
        for (int i2 = 0; i2 < wanLoadBalanceConfig.getWeight().size(); ++i2) {
            weight.append(((WeightConfig)wanLoadBalanceConfig.getWeight().get(i2)).getWeight());
            if (i2 == wanLoadBalanceConfig.getWeight().size() - 1) continue;
            weight.append(",");
        }
        wanLoadBalance.setWeight(weight.toString());
        return wanLoadBalance;
    }

    public static Optional<WanLoadBalanceConfig> toConfig(@Nonnull WanLoadBalance wanLoadBalance, @Nonnull Map<v, K> uuidPortIdMap, List<v> portUuids, Map<String, Integer> virtualWanEntryIdMap) {
        return Optional.ofNullable(wanLoadBalance).flatMap(wanLoadBalanceTmp -> {
            WanLoadBalanceConfig wanLoadBalanceConfig = new WanLoadBalanceConfig();
            BeanUtils.copyProperties((Object)wanLoadBalanceTmp, (Object)wanLoadBalanceConfig);
            if (!T.a((String)wanLoadBalanceTmp.getBackupWan())) {
                Integer backupWan = uuidPortIdMap.containsKey(new v(wanLoadBalanceTmp.getBackupWan())) ? ((K)uuidPortIdMap.get(new v(wanLoadBalanceTmp.getBackupWan()))).a() : null;
                wanLoadBalanceConfig.setBackupWan(backupWan);
            }
            if (!CollectionUtils.isEmpty(wanLoadBalanceTmp.getPrimaryWan())) {
                List primaryWans = wanLoadBalanceTmp.getPrimaryWan().stream().filter(primaryWan -> uuidPortIdMap.containsKey(new v((String)primaryWan))).map(primaryWan -> ((K)uuidPortIdMap.get(new v((String)primaryWan))).a()).collect(Collectors.toList());
                wanLoadBalanceConfig.setPrimaryWan(primaryWans);
            }
            wanLoadBalanceConfig.setAppOptRouting(Integer.valueOf(Boolean.TRUE.equals(wanLoadBalanceTmp.getAppOptRouting()) ? 1 : 0));
            wanLoadBalanceConfig.setLinkBackup(Integer.valueOf(Boolean.TRUE.equals(wanLoadBalanceTmp.getLinkBackup()) ? 1 : 0));
            if (!T.c((String)wanLoadBalanceTmp.getWeight())) {
                List<Integer> weightList = Arrays.stream(T.a((String)wanLoadBalanceTmp.getWeight(), (char)',')).map(Integer::parseInt).collect(Collectors.toList());
                WanLoadBalance.a(weightList, wanLoadBalanceConfig, portUuids);
            }
            if (!CollectionUtils.isEmpty(wanLoadBalance.getVirtualWanWeights()) && !CollectionUtils.isEmpty((Map)virtualWanEntryIdMap)) {
                wanLoadBalanceConfig.getWeight().addAll(wanLoadBalance.getVirtualWanWeights().stream().filter(virtualWanWeight -> virtualWanEntryIdMap.containsKey(virtualWanWeight.getVirtualWanId())).map(virtualWanWeight -> {
                    WeightConfig weightConfig = new WeightConfig();
                    weightConfig.setVirtualWanId((Integer)virtualWanEntryIdMap.get(virtualWanWeight.getVirtualWanId()));
                    weightConfig.setWeight(virtualWanWeight.getWeight());
                    return weightConfig;
                }).collect(Collectors.toList()));
            }
            return Optional.ofNullable(wanLoadBalanceConfig);
        });
    }

    private static void a(List<Integer> weightList, WanLoadBalanceConfig wanLoadBalanceConfig, List<v> portUuids) {
        if (!CollectionUtils.isEmpty(weightList)) {
            ArrayList<WeightConfig> weightConfigs = new ArrayList<WeightConfig>();
            for (int i2 = 0; i2 < weightList.size(); ++i2) {
                WeightConfig weightConfig = new WeightConfig();
                weightConfig.setPortId(portUuids.get(i2).a());
                weightConfig.setWeight(weightList.get(i2));
                weightConfigs.add(weightConfig);
            }
            weightConfigs.sort(Comparator.comparing(WeightConfig::getPortId));
            wanLoadBalanceConfig.setWeight(weightConfigs);
        }
    }

    private static List<String> a(List<String> oldPrimaryWan, List<String> newWanPorts) {
        return oldPrimaryWan == null ? new ArrayList<String>() : oldPrimaryWan.stream().filter(newWanPorts::contains).collect(Collectors.toList());
    }

    public boolean sameValueAs(WanLoadBalance other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    @Generated
    public String getWeight() {
        return this.weight;
    }

    @Generated
    public Boolean getAppOptRouting() {
        return this.appOptRouting;
    }

    @Generated
    public Boolean getLinkBackup() {
        return this.linkBackup;
    }

    @Generated
    public String getBackupWan() {
        return this.backupWan;
    }

    @Generated
    public List<String> getPrimaryWan() {
        return this.primaryWan;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public List<VirtualWanWeight> getVirtualWanWeights() {
        return this.virtualWanWeights;
    }

    @Generated
    public WanLoadBalance setWeight(String weight) {
        this.weight = weight;
        return this;
    }

    @Generated
    public WanLoadBalance setAppOptRouting(Boolean appOptRouting) {
        this.appOptRouting = appOptRouting;
        return this;
    }

    @Generated
    public WanLoadBalance setLinkBackup(Boolean linkBackup) {
        this.linkBackup = linkBackup;
        return this;
    }

    @Generated
    public WanLoadBalance setBackupWan(String backupWan) {
        this.backupWan = backupWan;
        return this;
    }

    @Generated
    public WanLoadBalance setPrimaryWan(List<String> primaryWan) {
        this.primaryWan = primaryWan;
        return this;
    }

    @Generated
    public WanLoadBalance setMethod(String method) {
        this.method = method;
        return this;
    }

    @Generated
    public WanLoadBalance setMode(Integer mode) {
        this.mode = mode;
        return this;
    }

    @Generated
    public WanLoadBalance setVirtualWanWeights(List<VirtualWanWeight> virtualWanWeights) {
        this.virtualWanWeights = virtualWanWeights;
        return this;
    }
}

