/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.device.manage.message.config.osg.Ipv4UsbSettingConfig;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.UsbLteSettingVO;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.AutoConfig;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.DnsConfig;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.K;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.ManuallyConfig;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.S;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.WanDhcpOption;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.d.v;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.springframework.util.CollectionUtils;

@KeepClass
public class UsbLteSetting {
    private v portUuid;
    private String portDesc;
    private String usbModem;
    private Integer reduceUsbRfi;
    private Integer configType;
    private AutoConfig autoConfig;
    private ManuallyConfig manuallyConfig;
    private Integer connectionMode;
    private String pin;
    private Integer authType;
    private Integer mtuSize;
    private Integer dnsEnable;
    private DnsConfig dnsConfig;
    private List<WanDhcpOption> dhcpOptions;

    public Optional<UsbLteSetting> fromVO(UsbLteSettingVO usbLteSettingVO) {
        Optional<AutoConfig> autoConfigOptional = usbLteSettingVO.getAutoConfig() == null ? Optional.empty() : AutoConfig.fromVO(usbLteSettingVO.getAutoConfig());
        Optional<DnsConfig> dnsConfigOptional = usbLteSettingVO.getDnsConfig() == null ? Optional.empty() : DnsConfig.fromVO(usbLteSettingVO.getDnsConfig());
        Optional<ManuallyConfig> manuallyConfigOptional = usbLteSettingVO.getManuallyConfig() == null ? Optional.empty() : ManuallyConfig.fromVO(usbLteSettingVO.getManuallyConfig());
        List<WanDhcpOption> dhcpOptionList = usbLteSettingVO.getDhcpOptions() == null ? Collections.emptyList() : usbLteSettingVO.getDhcpOptions().stream().map(dhcpOptionVO -> {
            WanDhcpOption dhcpOption = new WanDhcpOption();
            dhcpOption.setCode(dhcpOptionVO.getCode());
            dhcpOption.setType(dhcpOptionVO.getType());
            dhcpOption.setValue(dhcpOptionVO.getValue());
            return dhcpOption;
        }).collect(Collectors.toList());
        return Optional.of(UsbLteSetting.builder().d(usbLteSettingVO.getAuthType()).a(new v(usbLteSettingVO.getPortUuid())).a(usbLteSettingVO.getPortDesc()).b(usbLteSettingVO.getConfigType()).a(Boolean.FALSE.equals(usbLteSettingVO.getReduceUsbRfi()) ? 0 : 1).c(usbLteSettingVO.getPin()).c(usbLteSettingVO.getConnectionMode()).e(usbLteSettingVO.getMtuSize()).f(Boolean.TRUE.equals(usbLteSettingVO.getDnsEnable()) ? 1 : 0).a(autoConfigOptional.orElse(usbLteSettingVO.getConfigType() == 0 ? this.autoConfig : null)).a(dnsConfigOptional.orElse(Boolean.TRUE.equals(usbLteSettingVO.getDnsEnable()) ? this.dnsConfig : null)).a(manuallyConfigOptional.orElse(usbLteSettingVO.getConfigType() == 1 ? this.manuallyConfig : null)).a(dhcpOptionList).a());
    }

    public UsbLteSettingVO toVO(Boolean supportReduceUsbRfi) {
        UsbLteSettingVO usbLteSettingVO = new UsbLteSettingVO();
        usbLteSettingVO.setAuthType(this.authType);
        usbLteSettingVO.setPortUuid(this.portUuid.b());
        usbLteSettingVO.setPortDesc(this.portDesc);
        usbLteSettingVO.setUsbModem(this.usbModem);
        usbLteSettingVO.setConfigType(this.configType);
        if (Boolean.TRUE.equals(supportReduceUsbRfi)) {
            usbLteSettingVO.setReduceUsbRfi(Boolean.valueOf(!Objects.equals(this.reduceUsbRfi, 0)));
        }
        usbLteSettingVO.setPin(this.pin);
        usbLteSettingVO.setConnectionMode(this.connectionMode);
        usbLteSettingVO.setMtuSize(this.mtuSize);
        usbLteSettingVO.setDnsEnable(Boolean.valueOf(Objects.equals(this.dnsEnable, 1)));
        usbLteSettingVO.setAutoConfig(this.autoConfig == null ? null : this.autoConfig.toVO());
        usbLteSettingVO.setDnsConfig(this.dnsConfig == null ? null : this.dnsConfig.toVO());
        usbLteSettingVO.setManuallyConfig(this.manuallyConfig == null ? null : this.manuallyConfig.toVO());
        if (!CollectionUtils.isEmpty(this.dhcpOptions)) {
            usbLteSettingVO.setDhcpOptions(this.dhcpOptions.stream().map(WanDhcpOption::toVO).collect(Collectors.toList()));
        }
        return usbLteSettingVO;
    }

    public static Optional<UsbLteSetting> fromConfig(v portUuid, Ipv4UsbSettingConfig ipv4UsbSettingConfig) {
        if (ipv4UsbSettingConfig == null) {
            return Optional.empty();
        }
        return Optional.of(UsbLteSetting.builder().d(ipv4UsbSettingConfig.getAuthType()).c(ipv4UsbSettingConfig.getPin()).a(portUuid).b(ipv4UsbSettingConfig.getConfigType()).a(ipv4UsbSettingConfig.getReduceUsbRfi() == null ? 1 : ipv4UsbSettingConfig.getReduceUsbRfi()).c(ipv4UsbSettingConfig.getConnectionMode()).e(ipv4UsbSettingConfig.getMtuSize()).f(ipv4UsbSettingConfig.getDnsEnable()).a((AutoConfig)AutoConfig.fromConfig(ipv4UsbSettingConfig.getAutoConfig()).orElse(null)).a((DnsConfig)DnsConfig.fromConfig(ipv4UsbSettingConfig.getDnsConfig()).orElse(null)).a((ManuallyConfig)ManuallyConfig.fromConfig(ipv4UsbSettingConfig.getManuallyConfig()).orElse(null)).a(CollectionUtils.isEmpty((Collection)ipv4UsbSettingConfig.getDhcpOptions()) ? Collections.emptyList() : ipv4UsbSettingConfig.getDhcpOptions().stream().map(dhcpOptionConfig -> {
            Integer code = dhcpOptionConfig.getCode();
            if (Objects.equals(55, code)) {
                return null;
            }
            WanDhcpOption dhcpOption = new WanDhcpOption();
            dhcpOption.setCode(code);
            dhcpOption.setType(dhcpOptionConfig.getType());
            dhcpOption.setValue(dhcpOptionConfig.getValue());
            return dhcpOption;
        }).filter(Objects::nonNull).collect(Collectors.toList())).a());
    }

    public static Ipv4UsbSettingConfig toConfig(UsbLteSetting usbLteSetting, K portId, Boolean supportReduceUsbRfi, String portName) {
        if (usbLteSetting == null) {
            return null;
        }
        Ipv4UsbSettingConfig ipv4UsbSettingConfig = new Ipv4UsbSettingConfig();
        ipv4UsbSettingConfig.setAuthType(usbLteSetting.getAuthType());
        ipv4UsbSettingConfig.setPin(usbLteSetting.getPin());
        ipv4UsbSettingConfig.setPort(portId.a());
        ipv4UsbSettingConfig.setPortName(portName);
        ipv4UsbSettingConfig.setConfigType(usbLteSetting.getConfigType());
        ipv4UsbSettingConfig.setReduceUsbRfi(Boolean.TRUE.equals(supportReduceUsbRfi) ? Optional.ofNullable(usbLteSetting.getReduceUsbRfi()).orElse(1) : null);
        ipv4UsbSettingConfig.setConnectionMode(usbLteSetting.getConnectionMode());
        ipv4UsbSettingConfig.setMtuSize(usbLteSetting.getMtuSize());
        ipv4UsbSettingConfig.setDnsEnable(usbLteSetting.getDnsEnable());
        ipv4UsbSettingConfig.setAutoConfig(AutoConfig.toConfig(usbLteSetting.getAutoConfig()));
        ipv4UsbSettingConfig.setDnsConfig(DnsConfig.toConfig(usbLteSetting.getDnsConfig()));
        ipv4UsbSettingConfig.setManuallyConfig(ManuallyConfig.toConfig(usbLteSetting.getManuallyConfig()));
        if (ipv4UsbSettingConfig.getManuallyConfig() == null) {
            ipv4UsbSettingConfig.setManuallyConfig(S.a(usbLteSetting.getAutoConfig().getLocation(), usbLteSetting.getAutoConfig().getMobileISP()));
        }
        ipv4UsbSettingConfig.setDhcpOptions(CollectionUtils.isEmpty(usbLteSetting.getDhcpOptions()) ? Collections.emptyList() : usbLteSetting.getDhcpOptions().stream().map(WanDhcpOption::toConfig).collect(Collectors.toList()));
        return ipv4UsbSettingConfig;
    }

    public static UsbLteSetting createDefaultUsbLteSetting(v portUuid) {
        UsbLteSetting usbLteSetting = new UsbLteSetting();
        usbLteSetting.setAuthType(0);
        usbLteSetting.setPortUuid(portUuid);
        usbLteSetting.setConfigType(0);
        usbLteSetting.setReduceUsbRfi(1);
        usbLteSetting.setConnectionMode(1);
        usbLteSetting.setMtuSize(1480);
        usbLteSetting.setDnsEnable(0);
        usbLteSetting.setAutoConfig(AutoConfig.createAutoConfig());
        usbLteSetting.setPin(null);
        usbLteSetting.setDnsConfig(null);
        usbLteSetting.setManuallyConfig(null);
        usbLteSetting.setDhcpOptions(Collections.emptyList());
        return usbLteSetting;
    }

    public boolean sameValueAs(UsbLteSetting other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    @Generated
    public static a builder() {
        return new a();
    }

    @Generated
    public v getPortUuid() {
        return this.portUuid;
    }

    @Generated
    public String getPortDesc() {
        return this.portDesc;
    }

    @Generated
    public String getUsbModem() {
        return this.usbModem;
    }

    @Generated
    public Integer getReduceUsbRfi() {
        return this.reduceUsbRfi;
    }

    @Generated
    public Integer getConfigType() {
        return this.configType;
    }

    @Generated
    public AutoConfig getAutoConfig() {
        return this.autoConfig;
    }

    @Generated
    public ManuallyConfig getManuallyConfig() {
        return this.manuallyConfig;
    }

    @Generated
    public Integer getConnectionMode() {
        return this.connectionMode;
    }

    @Generated
    public String getPin() {
        return this.pin;
    }

    @Generated
    public Integer getAuthType() {
        return this.authType;
    }

    @Generated
    public Integer getMtuSize() {
        return this.mtuSize;
    }

    @Generated
    public Integer getDnsEnable() {
        return this.dnsEnable;
    }

    @Generated
    public DnsConfig getDnsConfig() {
        return this.dnsConfig;
    }

    @Generated
    public List<WanDhcpOption> getDhcpOptions() {
        return this.dhcpOptions;
    }

    @Generated
    public void setPortUuid(v portUuid) {
        this.portUuid = portUuid;
    }

    @Generated
    public void setPortDesc(String portDesc) {
        this.portDesc = portDesc;
    }

    @Generated
    public void setUsbModem(String usbModem) {
        this.usbModem = usbModem;
    }

    @Generated
    public void setReduceUsbRfi(Integer reduceUsbRfi) {
        this.reduceUsbRfi = reduceUsbRfi;
    }

    @Generated
    public void setConfigType(Integer configType) {
        this.configType = configType;
    }

    @Generated
    public void setAutoConfig(AutoConfig autoConfig) {
        this.autoConfig = autoConfig;
    }

    @Generated
    public void setManuallyConfig(ManuallyConfig manuallyConfig) {
        this.manuallyConfig = manuallyConfig;
    }

    @Generated
    public void setConnectionMode(Integer connectionMode) {
        this.connectionMode = connectionMode;
    }

    @Generated
    public void setPin(String pin) {
        this.pin = pin;
    }

    @Generated
    public void setAuthType(Integer authType) {
        this.authType = authType;
    }

    @Generated
    public void setMtuSize(Integer mtuSize) {
        this.mtuSize = mtuSize;
    }

    @Generated
    public void setDnsEnable(Integer dnsEnable) {
        this.dnsEnable = dnsEnable;
    }

    @Generated
    public void setDnsConfig(DnsConfig dnsConfig) {
        this.dnsConfig = dnsConfig;
    }

    @Generated
    public void setDhcpOptions(List<WanDhcpOption> dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
    }

    @Generated
    public UsbLteSetting() {
    }

    @Generated
    public UsbLteSetting(v portUuid, String portDesc, String usbModem, Integer reduceUsbRfi, Integer configType, AutoConfig autoConfig, ManuallyConfig manuallyConfig, Integer connectionMode, String pin, Integer authType, Integer mtuSize, Integer dnsEnable, DnsConfig dnsConfig, List<WanDhcpOption> dhcpOptions) {
        this.portUuid = portUuid;
        this.portDesc = portDesc;
        this.usbModem = usbModem;
        this.reduceUsbRfi = reduceUsbRfi;
        this.configType = configType;
        this.autoConfig = autoConfig;
        this.manuallyConfig = manuallyConfig;
        this.connectionMode = connectionMode;
        this.pin = pin;
        this.authType = authType;
        this.mtuSize = mtuSize;
        this.dnsEnable = dnsEnable;
        this.dnsConfig = dnsConfig;
        this.dhcpOptions = dhcpOptions;
    }

    @Generated
    public static class a {
        @Generated
        private v a;
        @Generated
        private String b;
        @Generated
        private String c;
        @Generated
        private Integer d;
        @Generated
        private Integer e;
        @Generated
        private AutoConfig f;
        @Generated
        private ManuallyConfig g;
        @Generated
        private Integer h;
        @Generated
        private String i;
        @Generated
        private Integer j;
        @Generated
        private Integer k;
        @Generated
        private Integer l;
        @Generated
        private DnsConfig m;
        @Generated
        private List<WanDhcpOption> n;

        @Generated
        a() {
        }

        @Generated
        public a a(v portUuid) {
            this.a = portUuid;
            return this;
        }

        @Generated
        public a a(String portDesc) {
            this.b = portDesc;
            return this;
        }

        @Generated
        public a b(String usbModem) {
            this.c = usbModem;
            return this;
        }

        @Generated
        public a a(Integer reduceUsbRfi) {
            this.d = reduceUsbRfi;
            return this;
        }

        @Generated
        public a b(Integer configType) {
            this.e = configType;
            return this;
        }

        @Generated
        public a a(AutoConfig autoConfig) {
            this.f = autoConfig;
            return this;
        }

        @Generated
        public a a(ManuallyConfig manuallyConfig) {
            this.g = manuallyConfig;
            return this;
        }

        @Generated
        public a c(Integer connectionMode) {
            this.h = connectionMode;
            return this;
        }

        @Generated
        public a c(String pin) {
            this.i = pin;
            return this;
        }

        @Generated
        public a d(Integer authType) {
            this.j = authType;
            return this;
        }

        @Generated
        public a e(Integer mtuSize) {
            this.k = mtuSize;
            return this;
        }

        @Generated
        public a f(Integer dnsEnable) {
            this.l = dnsEnable;
            return this;
        }

        @Generated
        public a a(DnsConfig dnsConfig) {
            this.m = dnsConfig;
            return this;
        }

        @Generated
        public a a(List<WanDhcpOption> dhcpOptions) {
            this.n = dhcpOptions;
            return this;
        }

        @Generated
        public UsbLteSetting a() {
            return new UsbLteSetting(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l, this.m, this.n);
        }

        @Generated
        public String toString() {
            return "UsbLteSetting.UsbLteSettingBuilder(portUuid=" + this.a + ", portDesc=" + this.b + ", usbModem=" + this.c + ", reduceUsbRfi=" + this.d + ", configType=" + this.e + ", autoConfig=" + this.f + ", manuallyConfig=" + this.g + ", connectionMode=" + this.h + ", pin=" + this.i + ", authType=" + this.j + ", mtuSize=" + this.k + ", dnsEnable=" + this.l + ", dnsConfig=" + this.m + ", dhcpOptions=" + this.n + ")";
        }
    }
}

