/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.device.manage.message.config.osg.LteWanConfig;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.DialupSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.LteWanSettingVO;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.DialupSetting;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.K;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.d.v;
import com.tplink.smb.omada.manager.device.domain.model.device.osg.m;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

@KeepClass
public class LteWanSetting {
    private v portUuid;
    private String portDesc;
    private Boolean mobileData;
    private Integer simPriority;
    private List<DialupSetting> dialUpSettings;
    private Integer supportDualSim;
    private Integer simCardUsed;

    public static LteWanConfig toConfig(LteWanSetting lteWanSetting, K portId, Map<Integer, Integer> entryIds, m osg) {
        LteWanConfig config = new LteWanConfig();
        config.setName(osg.dD().getPortNameMap().get(portId.a()));
        config.setPort(portId.a());
        config.setMobileData(Integer.valueOf(lteWanSetting.getMobileData() != false ? 1 : 0));
        DialupSetting sim1Setting = lteWanSetting.getSingleDialUpSetting(1).orElse(null);
        if (sim1Setting == null) {
            return config;
        }
        config.setDataRoaming(Integer.valueOf(Boolean.TRUE.equals(sim1Setting.getDataRoaming()) ? 1 : 0));
        config.setNetworkMode(sim1Setting.getNetworkMode());
        config.setBandMode(sim1Setting.getBandMode());
        config.setNetSearchMode(sim1Setting.getNetSearchMode());
        if (Objects.equals(sim1Setting.getBandMode(), 1)) {
            config.setBands(sim1Setting.getBands());
            config.setBands5g(sim1Setting.getBands5g());
        }
        config.setNetworkMode(sim1Setting.getNetworkMode());
        if (Objects.equals(1, config.getNetSearchMode())) {
            config.setIsp(sim1Setting.getIsp());
            config.setIspNum(sim1Setting.getIspNum());
        }
        config.setApnMode(sim1Setting.getApnMode());
        if (Objects.equals(1, config.getApnMode()) && entryIds != null && entryIds.get(1) != null) {
            config.setApn(entryIds.get(1));
        }
        if (!Objects.equals(1, osg.cg())) {
            return config;
        }
        DialupSetting sim2Setting = lteWanSetting.getSingleDialUpSetting(2).orElse(null);
        if (sim2Setting == null) {
            return config;
        }
        config.setSim2DataRoaming(Integer.valueOf(Boolean.TRUE.equals(sim2Setting.getDataRoaming()) ? 1 : 0));
        config.setSim2NetworkMode(sim2Setting.getNetworkMode());
        config.setSim2BandMode(sim2Setting.getBandMode());
        config.setSim2NetSearchMode(sim2Setting.getNetSearchMode());
        if (Objects.equals(sim2Setting.getBandMode(), 1)) {
            config.setSim2Bands(sim2Setting.getBands());
            if (sim2Setting.getBands5g() != null) {
                config.setSim2Bands5g(sim2Setting.getBands5g());
            }
        }
        config.setSim2NetworkMode(sim2Setting.getNetworkMode());
        if (Objects.equals(1, config.getSim2NetSearchMode())) {
            config.setSim2Isp(sim2Setting.getIsp());
            config.setSim2IspNum(sim2Setting.getIspNum());
        }
        config.setSim2ApnMode(sim2Setting.getApnMode());
        if (Objects.equals(1, config.getSim2ApnMode()) && entryIds != null && entryIds.get(2) != null) {
            config.setSim2Apn(entryIds.get(2));
        }
        config.setSimPriority(Optional.ofNullable(lteWanSetting.getSimPriority()).orElse(1));
        config.setTimeout(Optional.ofNullable(sim1Setting.getFailoverTimeout()).orElse(100));
        config.setSim2Timeout(Optional.ofNullable(sim2Setting.getFailoverTimeout()).orElse(100));
        return config;
    }

    public static Optional<LteWanSetting> fromConfig(v portUuid, LteWanConfig lteWanConfig) {
        if (lteWanConfig == null) {
            return Optional.empty();
        }
        return Optional.of(LteWanSetting.builder().a(portUuid).a(lteWanConfig.getMobileData() == 1).a(lteWanConfig.getSimPriority()).c(lteWanConfig.getSimCardUsed()).a(DialupSetting.fromConfig(lteWanConfig)).a());
    }

    public static LteWanSetting createDefaultLteWanPortSetting(v portUuid, Integer supportDualSimCard, List<Integer> supportNetworkMode) {
        return LteWanSetting.builder().a(portUuid).a(true).b(supportDualSimCard).a(DialupSetting.createDefaultSetting(supportDualSimCard, supportNetworkMode)).a(!Objects.equals(1, supportDualSimCard) ? null : Integer.valueOf(1)).a();
    }

    public Optional<LteWanSetting> fromVO(LteWanSettingVO lteWanSettingVO) {
        return Optional.of(LteWanSetting.builder().a(new v(lteWanSettingVO.getPortUuid())).a(lteWanSettingVO.getPortDesc()).a(lteWanSettingVO.getMobileData()).a(lteWanSettingVO.getSimPriority()).a(DialupSetting.fromVO(lteWanSettingVO, this.getSingleDialUpSetting(2).orElse(null))).a());
    }

    public LteWanSettingVO toVO(Integer simCardUsed, Integer supportDualSimCard) {
        LteWanSettingVO vo = new LteWanSettingVO();
        vo.setPortUuid(this.portUuid.b());
        vo.setPortDesc(this.portDesc);
        vo.setMobileData(this.mobileData);
        vo.setSupportDualSim(Optional.ofNullable(supportDualSimCard).orElse(0));
        DialupSetting sim1DialUpSetting = this.getSingleDialUpSetting(1).orElse(null);
        if (sim1DialUpSetting == null) {
            return vo;
        }
        vo.setDataRoaming(sim1DialUpSetting.getDataRoaming());
        vo.setNetworkMode(sim1DialUpSetting.getNetworkMode());
        vo.setBandMode(sim1DialUpSetting.getBandMode());
        vo.setBands(sim1DialUpSetting.getBands());
        vo.setDialupSetting(sim1DialUpSetting.toVO());
        if (!Objects.equals(1, supportDualSimCard)) {
            vo.setDialUpSettings(Collections.singletonList(sim1DialUpSetting.toVO()));
            return vo;
        }
        vo.setSimPriority(Integer.valueOf(this.simPriority == null ? 1 : this.simPriority));
        vo.setSimCardUsed(simCardUsed);
        vo.setDialUpSettings(this.a(this.dialUpSettings));
        return vo;
    }

    private List<DialupSettingVO> a(List<DialupSetting> dualDialUpSetting) {
        if (CollectionUtils.isEmpty(dualDialUpSetting)) {
            return Collections.emptyList();
        }
        return dualDialUpSetting.stream().map(DialupSetting::toVO).collect(Collectors.toList());
    }

    public static LteWanSetting handleLteSimChange(LteWanSetting lteWanSetting, int oldSupportDualSim, int targetSupportDualSim, List<Integer> supportNetworkMode) {
        if (Objects.equals(oldSupportDualSim, targetSupportDualSim)) {
            return lteWanSetting;
        }
        lteWanSetting.setSupportDualSim(targetSupportDualSim);
        if (Objects.equals(1, targetSupportDualSim)) {
            lteWanSetting.setSimPriority(1);
            ArrayList<DialupSetting> dialupSettings = new ArrayList<DialupSetting>(2);
            if (!org.springframework.util.CollectionUtils.isEmpty(lteWanSetting.getDialUpSettings())) {
                DialupSetting setting = lteWanSetting.getSingleDialUpSetting(1).orElse(null);
                if (setting == null) {
                    dialupSettings.add(DialupSetting.createDefaultSimDialupSetting(supportNetworkMode));
                } else {
                    setting.setFailoverTimeout(100);
                    dialupSettings.add(setting);
                }
                dialupSettings.add(DialupSetting.createDefaultSimDialupSetting(supportNetworkMode));
                lteWanSetting.setDialUpSettings(dialupSettings);
                return lteWanSetting;
            }
            lteWanSetting.setDialUpSettings(DialupSetting.createDefaultSetting(targetSupportDualSim, supportNetworkMode));
            return lteWanSetting;
        }
        lteWanSetting.setSimPriority(null);
        if (!org.springframework.util.CollectionUtils.isEmpty(lteWanSetting.getDialUpSettings())) {
            DialupSetting setting = lteWanSetting.getSingleDialUpSetting(1).orElse(null);
            if (setting == null) {
                lteWanSetting.setDialUpSettings(Collections.singletonList(DialupSetting.createDefaultSimDialupSetting(supportNetworkMode)));
                return lteWanSetting;
            }
            setting.setFailoverTimeout(null);
            lteWanSetting.setDialUpSettings(Collections.singletonList(setting));
            return lteWanSetting;
        }
        lteWanSetting.setDialUpSettings(DialupSetting.createDefaultSetting(targetSupportDualSim, supportNetworkMode));
        return lteWanSetting;
    }

    public Optional<DialupSetting> getSingleDialUpSetting(Integer simCard) {
        if (simCard == null || CollectionUtils.isEmpty(this.getDialUpSettings()) || this.getDialUpSettings().size() < simCard) {
            return Optional.empty();
        }
        return Optional.of(this.getDialUpSettings().get(simCard - 1));
    }

    public boolean sameValueAs(LteWanSetting other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    @Generated
    public static a builder() {
        return new a();
    }

    @Generated
    public v getPortUuid() {
        return this.portUuid;
    }

    @Generated
    public String getPortDesc() {
        return this.portDesc;
    }

    @Generated
    public Boolean getMobileData() {
        return this.mobileData;
    }

    @Generated
    public Integer getSimPriority() {
        return this.simPriority;
    }

    @Generated
    public List<DialupSetting> getDialUpSettings() {
        return this.dialUpSettings;
    }

    @Generated
    public Integer getSupportDualSim() {
        return this.supportDualSim;
    }

    @Generated
    public Integer getSimCardUsed() {
        return this.simCardUsed;
    }

    @Generated
    public void setPortUuid(v portUuid) {
        this.portUuid = portUuid;
    }

    @Generated
    public void setPortDesc(String portDesc) {
        this.portDesc = portDesc;
    }

    @Generated
    public void setMobileData(Boolean mobileData) {
        this.mobileData = mobileData;
    }

    @Generated
    public void setSimPriority(Integer simPriority) {
        this.simPriority = simPriority;
    }

    @Generated
    public void setDialUpSettings(List<DialupSetting> dialUpSettings) {
        this.dialUpSettings = dialUpSettings;
    }

    @Generated
    public void setSupportDualSim(Integer supportDualSim) {
        this.supportDualSim = supportDualSim;
    }

    @Generated
    public void setSimCardUsed(Integer simCardUsed) {
        this.simCardUsed = simCardUsed;
    }

    @Generated
    public LteWanSetting() {
    }

    @Generated
    public LteWanSetting(v portUuid, String portDesc, Boolean mobileData, Integer simPriority, List<DialupSetting> dialUpSettings, Integer supportDualSim, Integer simCardUsed) {
        this.portUuid = portUuid;
        this.portDesc = portDesc;
        this.mobileData = mobileData;
        this.simPriority = simPriority;
        this.dialUpSettings = dialUpSettings;
        this.supportDualSim = supportDualSim;
        this.simCardUsed = simCardUsed;
    }

    @Generated
    public static class a {
        @Generated
        private v a;
        @Generated
        private String b;
        @Generated
        private Boolean c;
        @Generated
        private Integer d;
        @Generated
        private List<DialupSetting> e;
        @Generated
        private Integer f;
        @Generated
        private Integer g;

        @Generated
        a() {
        }

        @Generated
        public a a(v portUuid) {
            this.a = portUuid;
            return this;
        }

        @Generated
        public a a(String portDesc) {
            this.b = portDesc;
            return this;
        }

        @Generated
        public a a(Boolean mobileData) {
            this.c = mobileData;
            return this;
        }

        @Generated
        public a a(Integer simPriority) {
            this.d = simPriority;
            return this;
        }

        @Generated
        public a a(List<DialupSetting> dialUpSettings) {
            this.e = dialUpSettings;
            return this;
        }

        @Generated
        public a b(Integer supportDualSim) {
            this.f = supportDualSim;
            return this;
        }

        @Generated
        public a c(Integer simCardUsed) {
            this.g = simCardUsed;
            return this;
        }

        @Generated
        public LteWanSetting a() {
            return new LteWanSetting(this.a, this.b, this.c, this.d, this.e, this.f, this.g);
        }

        @Generated
        public String toString() {
            return "LteWanSetting.LteWanSettingBuilder(portUuid=" + this.a + ", portDesc=" + this.b + ", mobileData=" + this.c + ", simPriority=" + this.d + ", dialUpSettings=" + this.e + ", supportDualSim=" + this.f + ", simCardUsed=" + this.g + ")";
        }
    }
}

