/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.device.manage.message.config.osg.Ipv4SettingConfig;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.Ipv4PptpVO;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.Ipv4Connection2;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.Ipv4ProtoType;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.u;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.v;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.springframework.beans.BeanUtils;

@KeepClass
public class Ipv4Pptp
extends Ipv4ProtoType<Ipv4Pptp> {
    private String ipaddr;
    private String userName;
    private String password;
    private String ipFromIsp;
    private String gateway;
    private String linkType;
    private Integer redialInterval;
    private String startTime;
    private String endTime;
    private String service;
    private String netmask;
    private Integer mtu;
    private String dns1;
    private String dns2;
    private Ipv4Connection2 ipv4Connection2;
    private Integer mssClampingType;
    private Integer mssClampingValue;

    public Ipv4Pptp(v vlanId, Boolean qosTagEnable, Integer vlanPriority) {
        super(u.e, vlanId, qosTagEnable, vlanPriority);
    }

    public static Optional<Ipv4Pptp> fromVO(@NotNull Integer vlanId, Boolean qosTagEnable, Integer vlanPriority, @NotNull Ipv4PptpVO ipv4PptpVO) {
        Ipv4Pptp ipv4Pptp = new Ipv4Pptp(v.c().a(vlanId).a(), qosTagEnable, vlanPriority);
        BeanUtils.copyProperties((Object)ipv4PptpVO, (Object)ipv4Pptp);
        ipv4Pptp.setIpv4Connection2(Ipv4Connection2.fromVO(ipv4PptpVO.getIpv4Connection2()).orElse(null));
        return Optional.of(ipv4Pptp);
    }

    public static Optional<Ipv4Pptp> fromConfig(@NotNull Integer vlanId, @NotNull Integer qosTag, @NotNull Ipv4SettingConfig ipv4SettingConfig) {
        Ipv4Pptp ipv4Pptp = new Ipv4Pptp(v.c().a(vlanId).a(), qosTag != QOS_DISABLE, qosTag);
        BeanUtils.copyProperties((Object)ipv4SettingConfig, (Object)ipv4Pptp);
        ipv4Pptp.setIpv4Connection2(Ipv4Connection2.fromConfig(ipv4SettingConfig.getConnection2Config()).orElse(null));
        if ("".equals(ipv4Pptp.getDns1())) {
            ipv4Pptp.setDns1(null);
        }
        if ("".equals(ipv4Pptp.getDns2())) {
            ipv4Pptp.setDns2(null);
        }
        return Optional.of(ipv4Pptp);
    }

    @Override
    public OperationResponse checkIpDuplicated(Long beginIpLong, Long endIpLong) {
        Long wanIpLong;
        if ("off".equals(this.ipFromIsp) && (wanIpLong = Long.valueOf(com.tplink.smb.omada.common.util.v.b((String)this.ipaddr))) > beginIpLong && wanIpLong < endIpLong) {
            return new OperationResponse(b.hn);
        }
        Ipv4Connection2 pptpIpv4Connection2 = this.getIpv4Connection2();
        if (pptpIpv4Connection2 != null) {
            return pptpIpv4Connection2.checkIpDuplicated(beginIpLong, endIpLong);
        }
        return OperationResponse.SUCCESS;
    }

    @Override
    public boolean dnsDuplicated() {
        if (StringUtils.isNotBlank((CharSequence)this.dns1) && Objects.equals(this.dns1, this.dns2)) {
            return true;
        }
        if (this.ipv4Connection2 != null) {
            return this.ipv4Connection2.dnsDuplicated();
        }
        return false;
    }

    @Override
    public boolean dnsInRange(long beginIp, long endIp) {
        if (com.tplink.smb.omada.common.util.v.a((String)this.dns1, (long)beginIp, (long)endIp) || com.tplink.smb.omada.common.util.v.a((String)this.dns2, (long)beginIp, (long)endIp)) {
            return true;
        }
        if (this.ipv4Connection2 != null) {
            return this.ipv4Connection2.dnsInRange(beginIp, endIp);
        }
        return false;
    }

    public boolean sameValueAs(Ipv4Pptp other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Ipv4Pptp other = (Ipv4Pptp)o2;
        return this.sameValueAs(other);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Generated
    public String getIpaddr() {
        return this.ipaddr;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getIpFromIsp() {
        return this.ipFromIsp;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public String getLinkType() {
        return this.linkType;
    }

    @Generated
    public Integer getRedialInterval() {
        return this.redialInterval;
    }

    @Generated
    public String getStartTime() {
        return this.startTime;
    }

    @Generated
    public String getEndTime() {
        return this.endTime;
    }

    @Generated
    public String getService() {
        return this.service;
    }

    @Generated
    public String getNetmask() {
        return this.netmask;
    }

    @Generated
    public Integer getMtu() {
        return this.mtu;
    }

    @Generated
    public String getDns1() {
        return this.dns1;
    }

    @Generated
    public String getDns2() {
        return this.dns2;
    }

    @Generated
    public Ipv4Connection2 getIpv4Connection2() {
        return this.ipv4Connection2;
    }

    @Generated
    public Integer getMssClampingType() {
        return this.mssClampingType;
    }

    @Generated
    public Integer getMssClampingValue() {
        return this.mssClampingValue;
    }

    @Generated
    public Ipv4Pptp setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
        return this;
    }

    @Generated
    public Ipv4Pptp setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @Generated
    public Ipv4Pptp setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public Ipv4Pptp setIpFromIsp(String ipFromIsp) {
        this.ipFromIsp = ipFromIsp;
        return this;
    }

    @Generated
    public Ipv4Pptp setGateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @Generated
    public Ipv4Pptp setLinkType(String linkType) {
        this.linkType = linkType;
        return this;
    }

    @Generated
    public Ipv4Pptp setRedialInterval(Integer redialInterval) {
        this.redialInterval = redialInterval;
        return this;
    }

    @Generated
    public Ipv4Pptp setStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @Generated
    public Ipv4Pptp setEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @Generated
    public Ipv4Pptp setService(String service) {
        this.service = service;
        return this;
    }

    @Generated
    public Ipv4Pptp setNetmask(String netmask) {
        this.netmask = netmask;
        return this;
    }

    @Generated
    public Ipv4Pptp setMtu(Integer mtu) {
        this.mtu = mtu;
        return this;
    }

    @Generated
    public Ipv4Pptp setDns1(String dns1) {
        this.dns1 = dns1;
        return this;
    }

    @Generated
    public Ipv4Pptp setDns2(String dns2) {
        this.dns2 = dns2;
        return this;
    }

    @Generated
    public Ipv4Pptp setIpv4Connection2(Ipv4Connection2 ipv4Connection2) {
        this.ipv4Connection2 = ipv4Connection2;
        return this;
    }

    @Generated
    public Ipv4Pptp setMssClampingType(Integer mssClampingType) {
        this.mssClampingType = mssClampingType;
        return this;
    }

    @Generated
    public Ipv4Pptp setMssClampingValue(Integer mssClampingValue) {
        this.mssClampingValue = mssClampingValue;
        return this;
    }
}

