/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.device.manage.message.config.osg.Ipv4SettingConfig;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.Ipv4IpoaVO;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.Ipv4ProtoType;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.Y;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.u;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.v;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.springframework.beans.BeanUtils;

@KeepClass
public class Ipv4Ipoa
extends Ipv4ProtoType<Ipv4Ipoa> {
    private String ipaddr;
    private String netmask;
    private String gateway;
    private Integer mtu;
    private String dns1;
    private String dns2;
    private List<Y> wanMultipleIps;

    public Ipv4Ipoa(v vlanId, Boolean qosTagEnable, Integer vlanPriority) {
        super(u.g, vlanId, qosTagEnable, vlanPriority);
    }

    public static Optional<Ipv4Ipoa> fromVO(@NotNull Integer vlanId, Boolean qosTagEnable, Integer vlanPriority, @NotNull Ipv4IpoaVO ipv4IpoaVO) {
        Ipv4Ipoa ipv4Ipoa = new Ipv4Ipoa(v.c().a(vlanId).a(), qosTagEnable, vlanPriority);
        BeanUtils.copyProperties((Object)ipv4IpoaVO, (Object)ipv4Ipoa);
        if (CollectionUtils.isNotEmpty((Collection)ipv4IpoaVO.getWanMultipleIps())) {
            ipv4Ipoa.setWanMultipleIps(ipv4IpoaVO.getWanMultipleIps().stream().map(Y::a).collect(Collectors.toList()));
        }
        return Optional.of(ipv4Ipoa);
    }

    public static Optional<Ipv4Ipoa> fromConfig(@NotNull Integer vlanId, Integer qosTag, @NotNull Ipv4SettingConfig ipv4SettingConfig) {
        Ipv4Ipoa ipv4Ipoa = new Ipv4Ipoa(v.c().a(vlanId).a(), qosTag != QOS_DISABLE, qosTag);
        BeanUtils.copyProperties((Object)ipv4SettingConfig, (Object)ipv4Ipoa);
        if ("".equals(ipv4Ipoa.getDns1())) {
            ipv4Ipoa.setDns1(null);
        }
        if ("".equals(ipv4Ipoa.getDns2())) {
            ipv4Ipoa.setDns2(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)ipv4SettingConfig.getWanMultipleIps())) {
            ipv4Ipoa.setWanMultipleIps(ipv4SettingConfig.getWanMultipleIps().stream().map(wanMultipleIpEntry -> {
                Y wanMultipleIp = new Y();
                wanMultipleIp.a(wanMultipleIpEntry.getIpaddr());
                wanMultipleIp.a(true);
                return wanMultipleIp;
            }).collect(Collectors.toList()));
        }
        return Optional.of(ipv4Ipoa);
    }

    @Override
    public OperationResponse checkIpDuplicated(Long beginIpLong, Long endIpLong) {
        Long staticWanIpLong = com.tplink.smb.omada.common.util.v.b((String)this.ipaddr);
        if (staticWanIpLong > beginIpLong && staticWanIpLong < endIpLong) {
            return new OperationResponse(b.hn);
        }
        if (CollectionUtils.isNotEmpty(this.wanMultipleIps)) {
            for (Y wanMultipleIp : this.wanMultipleIps) {
                long ipLong = com.tplink.smb.omada.common.util.v.b((String)wanMultipleIp.c());
                if (ipLong <= beginIpLong || ipLong >= endIpLong) continue;
                return new OperationResponse(b.hn);
            }
        }
        return OperationResponse.SUCCESS;
    }

    @Override
    public boolean dnsDuplicated() {
        return StringUtils.isNotBlank((CharSequence)this.dns1) && Objects.equals(this.dns1, this.dns2);
    }

    @Override
    public boolean dnsInRange(long beginIp, long endIp) {
        return com.tplink.smb.omada.common.util.v.a((String)this.dns1, (long)beginIp, (long)endIp) || com.tplink.smb.omada.common.util.v.a((String)this.dns2, (long)beginIp, (long)endIp);
    }

    public boolean sameValueAs(Ipv4Ipoa other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Ipv4Ipoa other = (Ipv4Ipoa)o2;
        return this.sameValueAs(other);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Generated
    public String getIpaddr() {
        return this.ipaddr;
    }

    @Generated
    public String getNetmask() {
        return this.netmask;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public Integer getMtu() {
        return this.mtu;
    }

    @Generated
    public String getDns1() {
        return this.dns1;
    }

    @Generated
    public String getDns2() {
        return this.dns2;
    }

    @Generated
    public List<Y> getWanMultipleIps() {
        return this.wanMultipleIps;
    }

    @Generated
    public Ipv4Ipoa setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
        return this;
    }

    @Generated
    public Ipv4Ipoa setNetmask(String netmask) {
        this.netmask = netmask;
        return this;
    }

    @Generated
    public Ipv4Ipoa setGateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @Generated
    public Ipv4Ipoa setMtu(Integer mtu) {
        this.mtu = mtu;
        return this;
    }

    @Generated
    public Ipv4Ipoa setDns1(String dns1) {
        this.dns1 = dns1;
        return this;
    }

    @Generated
    public Ipv4Ipoa setDns2(String dns2) {
        this.dns2 = dns2;
        return this;
    }

    @Generated
    public Ipv4Ipoa setWanMultipleIps(List<Y> wanMultipleIps) {
        this.wanMultipleIps = wanMultipleIps;
        return this;
    }
}

