/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.device.manage.message.config.osg.Ipv4SettingConfig;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.Ipv4DhcpVO;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.Ipv4ProtoType;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.WanDhcpOption;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.Y;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.u;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.v;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.springframework.beans.BeanUtils;

@KeepClass
public class Ipv4Dhcp
extends Ipv4ProtoType<Ipv4Dhcp> {
    private String unicast;
    private String dns1;
    private String dns2;
    private String hostname;
    private Integer mtu;
    private List<WanDhcpOption> dhcpOptions;
    private List<Y> wanMultipleIps;

    public Ipv4Dhcp(v vlanId, Boolean qosTagEnable, Integer vlanPriority) {
        super(u.b, vlanId, qosTagEnable, vlanPriority);
    }

    public static Optional<Ipv4Dhcp> fromVO(@NotNull Integer vlanId, Boolean qosTagEnable, Integer vlanPriority, @NotNull Ipv4DhcpVO ipv4DhcpVO) {
        Ipv4Dhcp ipv4Dhcp = new Ipv4Dhcp(v.c().a(vlanId).a(), qosTagEnable, vlanPriority);
        BeanUtils.copyProperties((Object)ipv4DhcpVO, (Object)ipv4Dhcp);
        if (CollectionUtils.isNotEmpty((Collection)ipv4DhcpVO.getWanMultipleIps())) {
            ipv4Dhcp.setWanMultipleIps(ipv4DhcpVO.getWanMultipleIps().stream().map(Y::a).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)ipv4DhcpVO.getDhcpOptions())) {
            ipv4Dhcp.setDhcpOptions(ipv4DhcpVO.getDhcpOptions().stream().map(dhcpOptionVO -> {
                WanDhcpOption dhcpOption = new WanDhcpOption();
                dhcpOption.setCode(dhcpOptionVO.getCode());
                dhcpOption.setType(dhcpOptionVO.getType());
                dhcpOption.setValue(dhcpOptionVO.getValue());
                return dhcpOption;
            }).collect(Collectors.toList()));
        }
        return Optional.of(ipv4Dhcp);
    }

    public static Optional<Ipv4Dhcp> fromConfig(@NotNull Integer vlanId, @NotNull Integer qosTag, @NotNull Ipv4SettingConfig ipv4SettingConfig) {
        Ipv4Dhcp ipv4Dhcp = new Ipv4Dhcp(v.c().a(vlanId).a(), qosTag != QOS_DISABLE, qosTag);
        BeanUtils.copyProperties((Object)ipv4SettingConfig, (Object)ipv4Dhcp);
        if ("".equals(ipv4Dhcp.getDns1())) {
            ipv4Dhcp.setDns1(null);
        }
        if ("".equals(ipv4Dhcp.getDns2())) {
            ipv4Dhcp.setDns2(null);
        }
        if ("".equals(ipv4Dhcp.getHostname())) {
            ipv4Dhcp.setHostname(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)ipv4SettingConfig.getWanMultipleIps())) {
            ipv4Dhcp.setWanMultipleIps(ipv4SettingConfig.getWanMultipleIps().stream().map(wanMultipleIpEntry -> {
                Y wanMultipleIp = new Y();
                wanMultipleIp.a(wanMultipleIpEntry.getIpaddr());
                wanMultipleIp.a(true);
                return wanMultipleIp;
            }).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)ipv4SettingConfig.getDhcpOptions())) {
            ipv4Dhcp.setDhcpOptions(ipv4SettingConfig.getDhcpOptions().stream().map(dhcpOptionConfig -> {
                Integer code = dhcpOptionConfig.getCode();
                if (Objects.equals(55, code)) {
                    return null;
                }
                WanDhcpOption dhcpOption = new WanDhcpOption();
                dhcpOption.setCode(code);
                dhcpOption.setType(dhcpOptionConfig.getType());
                dhcpOption.setValue(dhcpOptionConfig.getValue());
                return dhcpOption;
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return Optional.of(ipv4Dhcp);
    }

    @Override
    public OperationResponse checkIpDuplicated(Long beginIpLong, Long endIpLong) {
        if (CollectionUtils.isNotEmpty(this.wanMultipleIps)) {
            for (Y wanMultipleIp : this.wanMultipleIps) {
                long ipLong = com.tplink.smb.omada.common.util.v.b((String)wanMultipleIp.c());
                if (ipLong <= beginIpLong || ipLong >= endIpLong) continue;
                return new OperationResponse(b.hn);
            }
        }
        return OperationResponse.SUCCESS;
    }

    @Override
    public boolean dnsDuplicated() {
        return StringUtils.isNotBlank((CharSequence)this.dns1) && Objects.equals(this.dns1, this.dns2);
    }

    @Override
    public boolean dnsInRange(long beginIp, long endIp) {
        return com.tplink.smb.omada.common.util.v.a((String)this.dns1, (long)beginIp, (long)endIp) || com.tplink.smb.omada.common.util.v.a((String)this.dns2, (long)beginIp, (long)endIp);
    }

    public boolean sameValueAs(Ipv4Dhcp other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Ipv4Dhcp ipv4Dhcp = (Ipv4Dhcp)o2;
        return this.sameValueAs(ipv4Dhcp);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Generated
    public String getUnicast() {
        return this.unicast;
    }

    @Generated
    public String getDns1() {
        return this.dns1;
    }

    @Generated
    public String getDns2() {
        return this.dns2;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public Integer getMtu() {
        return this.mtu;
    }

    @Generated
    public List<WanDhcpOption> getDhcpOptions() {
        return this.dhcpOptions;
    }

    @Generated
    public List<Y> getWanMultipleIps() {
        return this.wanMultipleIps;
    }

    @Generated
    public Ipv4Dhcp setUnicast(String unicast) {
        this.unicast = unicast;
        return this;
    }

    @Generated
    public Ipv4Dhcp setDns1(String dns1) {
        this.dns1 = dns1;
        return this;
    }

    @Generated
    public Ipv4Dhcp setDns2(String dns2) {
        this.dns2 = dns2;
        return this;
    }

    @Generated
    public Ipv4Dhcp setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Generated
    public Ipv4Dhcp setMtu(Integer mtu) {
        this.mtu = mtu;
        return this;
    }

    @Generated
    public Ipv4Dhcp setDhcpOptions(List<WanDhcpOption> dhcpOptions) {
        this.dhcpOptions = dhcpOptions;
        return this;
    }

    @Generated
    public Ipv4Dhcp setWanMultipleIps(List<Y> wanMultipleIps) {
        this.wanMultipleIps = wanMultipleIps;
        return this;
    }
}

