/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.e.l;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.f.c;
import com.tplink.smb.omada.common.util.v;
import com.tplink.smb.omada.device.manage.message.config.osg.Connection2Config;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.Ipv4Connection2VO;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@KeepClass
public class Ipv4Connection2
implements l<Ipv4Connection2> {
    private String mainProto;
    private String proto;
    private String server;
    private String ipaddr;
    private String netmask;
    private String gateway;
    private String dns1;
    private String dns2;

    public static boolean validate(String vpnServer) {
        if (T.a((String)vpnServer)) {
            return true;
        }
        Matcher matcher = c.bf.matcher(vpnServer);
        if (!matcher.matches()) {
            return true;
        }
        long vpnLongIp = v.b((String)vpnServer);
        return vpnLongIp < v.b((String)"224.0.0.0") || vpnLongIp > v.b((String)"239.255.255.255");
    }

    public static Optional<Ipv4Connection2> fromVO(Ipv4Connection2VO ipv4Connection2VO) {
        if (ipv4Connection2VO == null || !Ipv4Connection2.validate(ipv4Connection2VO.getServer())) {
            return Optional.empty();
        }
        Ipv4Connection2 ipv4Connection2 = new Ipv4Connection2().setMainProto(ipv4Connection2VO.getMainProto()).setProto(ipv4Connection2VO.getProto()).setServer(ipv4Connection2VO.getServer()).setIpaddr(ipv4Connection2VO.getIpaddr()).setNetmask(ipv4Connection2VO.getNetmask()).setGateway(ipv4Connection2VO.getGateway()).setDns1(ipv4Connection2VO.getDns1()).setDns2(ipv4Connection2VO.getDns2());
        return Optional.of(ipv4Connection2);
    }

    public static Optional<Ipv4Connection2> fromConfig(Connection2Config connection2Config) {
        if (connection2Config == null) {
            return Optional.empty();
        }
        Ipv4Connection2 ipv4Connection2 = new Ipv4Connection2().setMainProto(connection2Config.getMainProto()).setProto(connection2Config.getProto()).setServer(connection2Config.getServer()).setIpaddr(connection2Config.getIpaddr()).setNetmask(connection2Config.getNetmask()).setGateway(connection2Config.getGateway()).setDns1(connection2Config.getDns1()).setDns2(connection2Config.getDns2());
        return Optional.of(ipv4Connection2);
    }

    public OperationResponse checkIpDuplicated(Long beginIpLong, Long endIpLong) {
        Long wan2IpLong;
        if ("static".equals(this.proto) && (wan2IpLong = Long.valueOf(v.b((String)this.ipaddr))) > beginIpLong && wan2IpLong < endIpLong) {
            return new OperationResponse(b.hn);
        }
        return OperationResponse.SUCCESS;
    }

    public boolean dnsDuplicated() {
        return !T.c((String)this.dns1) && Objects.equals(this.dns1, this.dns2);
    }

    public boolean dnsInRange(long beginIp, long endIp) {
        return v.a((String)this.dns1, (long)beginIp, (long)endIp) || v.a((String)this.dns2, (long)beginIp, (long)endIp);
    }

    public boolean sameValueAs(Ipv4Connection2 other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Ipv4Connection2 other = (Ipv4Connection2)o2;
        return this.sameValueAs(other);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Generated
    public String getMainProto() {
        return this.mainProto;
    }

    @Generated
    public String getProto() {
        return this.proto;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public String getIpaddr() {
        return this.ipaddr;
    }

    @Generated
    public String getNetmask() {
        return this.netmask;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public String getDns1() {
        return this.dns1;
    }

    @Generated
    public String getDns2() {
        return this.dns2;
    }

    @Generated
    public Ipv4Connection2 setMainProto(String mainProto) {
        this.mainProto = mainProto;
        return this;
    }

    @Generated
    public Ipv4Connection2 setProto(String proto) {
        this.proto = proto;
        return this;
    }

    @Generated
    public Ipv4Connection2 setServer(String server) {
        this.server = server;
        return this;
    }

    @Generated
    public Ipv4Connection2 setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
        return this;
    }

    @Generated
    public Ipv4Connection2 setNetmask(String netmask) {
        this.netmask = netmask;
        return this;
    }

    @Generated
    public Ipv4Connection2 setGateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @Generated
    public Ipv4Connection2 setDns1(String dns1) {
        this.dns1 = dns1;
        return this;
    }

    @Generated
    public Ipv4Connection2 setDns2(String dns2) {
        this.dns2 = dns2;
        return this;
    }
}

