/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.region.b;
import com.tplink.smb.omada.device.manage.message.config.osg.DslWanConfig;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.DslWanSettingVO;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.K;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.d.v;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.l;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.m;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;

@KeepClass
public class DslWanSetting {
    private Integer port;
    private v portUuid;
    private String portDesc;
    private String location;
    @JsonProperty(value="isp")
    private Integer isp;
    private Integer modulation;
    private Integer vpi;
    private Integer vci;
    private Integer encapMode;
    private Boolean merEnable;
    private String merUsername;
    private String merPassword;

    public static DslWanConfig toConfig(DslWanSetting dslWanSetting, K portId, com.tplink.smb.omada.manager.device.domain.model.device.osg.m osg) {
        DslWanConfig dslWanConfig = new DslWanConfig();
        dslWanConfig.setPort(portId.a());
        dslWanConfig.setPortName(dslWanSetting.getPortDesc());
        dslWanConfig.setLocation(dslWanSetting.getLocation());
        dslWanConfig.setLocation(dslWanSetting.getLocation());
        dslWanConfig.setIsp(dslWanSetting.getIsp());
        dslWanConfig.setModulation(dslWanSetting.getModulation());
        dslWanConfig.setVpi(dslWanSetting.getVpi());
        dslWanConfig.setVci(dslWanSetting.getVci());
        dslWanConfig.setEncapMode(dslWanSetting.getEncapMode());
        dslWanConfig.setEnableMer(Integer.valueOf(Boolean.TRUE.equals(dslWanSetting.getMerEnable()) ? 1 : 0));
        dslWanConfig.setMerUsername(dslWanSetting.getMerUsername());
        dslWanConfig.setMerPassword(dslWanSetting.getMerPassword());
        return dslWanConfig;
    }

    public Optional<DslWanSetting> fromVO(DslWanSettingVO vo) {
        if (Objects.isNull(vo)) {
            return Optional.empty();
        }
        return Optional.of(DslWanSetting.builder().a(new v(vo.getPortUuid())).a(vo.getPortDesc()).b(vo.getLocation()).b(vo.getIsp()).c(vo.getModulation()).d(vo.getVpi()).e(vo.getVci()).f(vo.getEncapMode()).a(vo.getMerEnable()).c(vo.getMerUsername()).d(vo.getMerPassword()).a());
    }

    public static Optional<DslWanSetting> fromConfig(v portUuid, DslWanConfig dslWanConfig) {
        if (Objects.isNull(dslWanConfig)) {
            return Optional.empty();
        }
        return Optional.of(DslWanSetting.builder().a(portUuid).b(dslWanConfig.getLocation()).b(dslWanConfig.getIsp()).c(dslWanConfig.getModulation()).d(dslWanConfig.getVpi()).e(dslWanConfig.getVci()).f(dslWanConfig.getEncapMode()).a(DslWanSetting.convertMerEnable(dslWanConfig.getEnableMer())).c(dslWanConfig.getMerUsername()).d(dslWanConfig.getMerPassword()).a());
    }

    public static DslWanSetting createDefaultDslWanSetting(v portUuid) {
        return DslWanSetting.builder().a(portUuid).b(b.dv.a()).b(l.a.a()).c(m.a.a()).a(Boolean.FALSE).a();
    }

    public DslWanSettingVO toVO() {
        DslWanSettingVO dslWanSettingVO = new DslWanSettingVO();
        dslWanSettingVO.setPortUuid(this.portUuid.b());
        dslWanSettingVO.setPortDesc(this.portDesc);
        dslWanSettingVO.setLocation(this.location);
        dslWanSettingVO.setIsp(this.isp);
        dslWanSettingVO.setModulation(this.modulation);
        dslWanSettingVO.setVpi(this.vpi);
        dslWanSettingVO.setVci(this.vci);
        dslWanSettingVO.setEncapMode(this.encapMode);
        dslWanSettingVO.setMerEnable(this.merEnable);
        dslWanSettingVO.setMerUsername(this.merUsername);
        dslWanSettingVO.setMerPassword(this.merPassword);
        return dslWanSettingVO;
    }

    public Integer getIsp() {
        return this.isp;
    }

    public void setIsp(Integer isp) {
        this.isp = isp;
    }

    public boolean sameValueAs(DslWanSetting other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public static Boolean convertMerEnable(Integer merEnable) {
        if (null == merEnable) {
            return Boolean.FALSE;
        }
        return merEnable == 1;
    }

    @Generated
    public static a builder() {
        return new a();
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public v getPortUuid() {
        return this.portUuid;
    }

    @Generated
    public String getPortDesc() {
        return this.portDesc;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public Integer getModulation() {
        return this.modulation;
    }

    @Generated
    public Integer getVpi() {
        return this.vpi;
    }

    @Generated
    public Integer getVci() {
        return this.vci;
    }

    @Generated
    public Integer getEncapMode() {
        return this.encapMode;
    }

    @Generated
    public Boolean getMerEnable() {
        return this.merEnable;
    }

    @Generated
    public String getMerUsername() {
        return this.merUsername;
    }

    @Generated
    public String getMerPassword() {
        return this.merPassword;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setPortUuid(v portUuid) {
        this.portUuid = portUuid;
    }

    @Generated
    public void setPortDesc(String portDesc) {
        this.portDesc = portDesc;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setModulation(Integer modulation) {
        this.modulation = modulation;
    }

    @Generated
    public void setVpi(Integer vpi) {
        this.vpi = vpi;
    }

    @Generated
    public void setVci(Integer vci) {
        this.vci = vci;
    }

    @Generated
    public void setEncapMode(Integer encapMode) {
        this.encapMode = encapMode;
    }

    @Generated
    public void setMerEnable(Boolean merEnable) {
        this.merEnable = merEnable;
    }

    @Generated
    public void setMerUsername(String merUsername) {
        this.merUsername = merUsername;
    }

    @Generated
    public void setMerPassword(String merPassword) {
        this.merPassword = merPassword;
    }

    @Generated
    public DslWanSetting() {
    }

    @Generated
    public DslWanSetting(Integer port, v portUuid, String portDesc, String location, Integer isp, Integer modulation, Integer vpi, Integer vci, Integer encapMode, Boolean merEnable, String merUsername, String merPassword) {
        this.port = port;
        this.portUuid = portUuid;
        this.portDesc = portDesc;
        this.location = location;
        this.isp = isp;
        this.modulation = modulation;
        this.vpi = vpi;
        this.vci = vci;
        this.encapMode = encapMode;
        this.merEnable = merEnable;
        this.merUsername = merUsername;
        this.merPassword = merPassword;
    }

    @Generated
    public static class a {
        @Generated
        private Integer a;
        @Generated
        private v b;
        @Generated
        private String c;
        @Generated
        private String d;
        @Generated
        private Integer e;
        @Generated
        private Integer f;
        @Generated
        private Integer g;
        @Generated
        private Integer h;
        @Generated
        private Integer i;
        @Generated
        private Boolean j;
        @Generated
        private String k;
        @Generated
        private String l;

        @Generated
        a() {
        }

        @Generated
        public a a(Integer port) {
            this.a = port;
            return this;
        }

        @Generated
        public a a(v portUuid) {
            this.b = portUuid;
            return this;
        }

        @Generated
        public a a(String portDesc) {
            this.c = portDesc;
            return this;
        }

        @Generated
        public a b(String location) {
            this.d = location;
            return this;
        }

        @JsonProperty(value="isp")
        @Generated
        public a b(Integer isp) {
            this.e = isp;
            return this;
        }

        @Generated
        public a c(Integer modulation) {
            this.f = modulation;
            return this;
        }

        @Generated
        public a d(Integer vpi) {
            this.g = vpi;
            return this;
        }

        @Generated
        public a e(Integer vci) {
            this.h = vci;
            return this;
        }

        @Generated
        public a f(Integer encapMode) {
            this.i = encapMode;
            return this;
        }

        @Generated
        public a a(Boolean merEnable) {
            this.j = merEnable;
            return this;
        }

        @Generated
        public a c(String merUsername) {
            this.k = merUsername;
            return this;
        }

        @Generated
        public a d(String merPassword) {
            this.l = merPassword;
            return this;
        }

        @Generated
        public DslWanSetting a() {
            return new DslWanSetting(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l);
        }

        @Generated
        public String toString() {
            return "DslWanSetting.DslWanSettingBuilder(port=" + this.a + ", portUuid=" + this.b + ", portDesc=" + this.c + ", location=" + this.d + ", isp=" + this.e + ", modulation=" + this.f + ", vpi=" + this.g + ", vci=" + this.h + ", encapMode=" + this.i + ", merEnable=" + this.j + ", merUsername=" + this.k + ", merPassword=" + this.l + ")";
        }
    }
}

