/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan;

import com.tplink.smb.omada.common.constant.T;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.device.manage.message.config.osg.LteWanConfig;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.DialupSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.LteWanSettingVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@KeepClass
public class DialupSetting {
    private Integer netSearchMode;
    private String isp;
    private Integer ispNum;
    private Integer apnMode;
    private String apn;
    private Integer failoverTimeout;
    private Boolean dataRoaming;
    private Integer networkMode;
    private Integer bandMode;
    private List<String> bands;
    private List<String> bands5g;

    public static List<DialupSetting> fromVO(LteWanSettingVO lteWanSettingVO, DialupSetting sim2DialupSetting) {
        ArrayList<DialupSetting> dialupSettings = new ArrayList<DialupSetting>(2);
        if (CollectionUtils.isEmpty((Collection)lteWanSettingVO.getDialUpSettings())) {
            if (lteWanSettingVO.getDialupSetting() == null) {
                return dialupSettings;
            }
            DialupSettingVO dialupSettingVO = lteWanSettingVO.getDialupSetting();
            dialupSettings.add(DialupSetting.builder().a(dialupSettingVO.getNetworkSearch()).a(dialupSettingVO.getNetworkSearch() == 0 ? null : dialupSettingVO.getIsp()).b(dialupSettingVO.getIspNum()).c(dialupSettingVO.getApnMode()).b(dialupSettingVO.getApnMode() == 0 ? null : dialupSettingVO.getApn()).a(lteWanSettingVO.getDataRoaming()).e(lteWanSettingVO.getNetworkMode()).f(lteWanSettingVO.getBandMode()).a(lteWanSettingVO.getBands()).b(lteWanSettingVO.getBands5g()).d(100).a());
            if (sim2DialupSetting != null) {
                dialupSettings.add(DialupSetting.builder().a(sim2DialupSetting.getNetSearchMode()).a(sim2DialupSetting.getIsp()).b(sim2DialupSetting.getIspNum()).c(sim2DialupSetting.getApnMode()).b(sim2DialupSetting.getApn()).a(sim2DialupSetting.getDataRoaming()).e(sim2DialupSetting.getNetworkMode()).f(sim2DialupSetting.getBandMode()).a(sim2DialupSetting.getBands()).b(sim2DialupSetting.getBands5g()).d(100).a());
            }
            return dialupSettings;
        }
        for (DialupSettingVO dialupSettingVO : lteWanSettingVO.getDialUpSettings()) {
            dialupSettings.add(DialupSetting.builder().a(dialupSettingVO.getNetworkSearch()).a(dialupSettingVO.getNetworkSearch() == 0 ? null : dialupSettingVO.getIsp()).b(dialupSettingVO.getIspNum()).c(dialupSettingVO.getApnMode()).b(dialupSettingVO.getApnMode() == 0 ? null : dialupSettingVO.getApn()).d(Optional.ofNullable(dialupSettingVO.getFailoverTimeout()).orElse(100)).a(dialupSettingVO.getDataRoaming()).e(dialupSettingVO.getNetworkMode()).f(dialupSettingVO.getBandMode()).a(dialupSettingVO.getBands()).b(dialupSettingVO.getBands5g()).a());
        }
        return dialupSettings;
    }

    public static List<DialupSetting> fromConfig(LteWanConfig lteWanConfig) {
        ArrayList<DialupSetting> dialupSettings = new ArrayList<DialupSetting>(2);
        dialupSettings.add(DialupSetting.builder().a(lteWanConfig.getNetSearchMode()).a(lteWanConfig.getNetSearchMode() == 0 ? null : lteWanConfig.getIsp()).b(lteWanConfig.getIspNum()).c(lteWanConfig.getApnMode()).d(lteWanConfig.getTimeout()).a(lteWanConfig.getDataRoaming() == 1).e(lteWanConfig.getNetworkMode()).f(lteWanConfig.getBandMode()).a(Objects.equals(lteWanConfig.getBandMode(), 0) ? null : lteWanConfig.getBands()).b(Objects.equals(lteWanConfig.getBandMode(), 0) ? null : lteWanConfig.getBands5g()).a());
        if (Objects.isNull(lteWanConfig.getSimPriority())) {
            return dialupSettings;
        }
        dialupSettings.add(DialupSetting.builder().a(lteWanConfig.getSim2NetSearchMode()).a(lteWanConfig.getSim2NetSearchMode() == 0 ? null : lteWanConfig.getSim2Isp()).b(lteWanConfig.getSim2IspNum()).c(lteWanConfig.getSim2ApnMode()).d(lteWanConfig.getSim2Timeout()).a(lteWanConfig.getSim2DataRoaming() == 1).e(lteWanConfig.getSim2NetworkMode()).f(lteWanConfig.getSim2BandMode()).a(Objects.equals(lteWanConfig.getSim2BandMode(), 0) ? null : lteWanConfig.getSim2Bands()).b(Objects.equals(lteWanConfig.getSim2BandMode(), 0) ? null : lteWanConfig.getSim2Bands5g()).a());
        return dialupSettings;
    }

    public static List<DialupSetting> createDefaultSetting(Integer supportDualSim, List<Integer> supportNetworkMode) {
        ArrayList<DialupSetting> dialupSettings = new ArrayList<DialupSetting>(2);
        dialupSettings.add(DialupSetting.createDefaultSimDialupSetting(supportNetworkMode));
        if (!Objects.equals(1, supportDualSim)) {
            return dialupSettings;
        }
        dialupSettings.add(DialupSetting.createDefaultSimDialupSetting(supportNetworkMode));
        return dialupSettings;
    }

    public DialupSettingVO toVO() {
        DialupSettingVO vo = new DialupSettingVO();
        vo.setNetworkSearch(this.netSearchMode);
        vo.setIsp(this.isp);
        vo.setIspNum(this.ispNum);
        vo.setApnMode(this.apnMode);
        vo.setApn(this.apn);
        vo.setFailoverTimeout(this.failoverTimeout);
        vo.setDataRoaming(this.dataRoaming);
        vo.setNetworkMode(this.networkMode);
        vo.setBandMode(this.bandMode);
        vo.setBands(this.bands);
        vo.setBands5g(this.bands5g);
        return vo;
    }

    public static DialupSetting createDefaultSimDialupSetting(List<Integer> supportNetworkMode) {
        return DialupSetting.builder().a(0).c(0).a(false).e(supportNetworkMode.contains(6) ? 6 : 2).f(0).d(T.aU).a();
    }

    @Generated
    public static a builder() {
        return new a();
    }

    @Generated
    public Integer getNetSearchMode() {
        return this.netSearchMode;
    }

    @Generated
    public String getIsp() {
        return this.isp;
    }

    @Generated
    public Integer getIspNum() {
        return this.ispNum;
    }

    @Generated
    public Integer getApnMode() {
        return this.apnMode;
    }

    @Generated
    public String getApn() {
        return this.apn;
    }

    @Generated
    public Integer getFailoverTimeout() {
        return this.failoverTimeout;
    }

    @Generated
    public Boolean getDataRoaming() {
        return this.dataRoaming;
    }

    @Generated
    public Integer getNetworkMode() {
        return this.networkMode;
    }

    @Generated
    public Integer getBandMode() {
        return this.bandMode;
    }

    @Generated
    public List<String> getBands() {
        return this.bands;
    }

    @Generated
    public List<String> getBands5g() {
        return this.bands5g;
    }

    @Generated
    public void setNetSearchMode(Integer netSearchMode) {
        this.netSearchMode = netSearchMode;
    }

    @Generated
    public void setIsp(String isp) {
        this.isp = isp;
    }

    @Generated
    public void setIspNum(Integer ispNum) {
        this.ispNum = ispNum;
    }

    @Generated
    public void setApnMode(Integer apnMode) {
        this.apnMode = apnMode;
    }

    @Generated
    public void setApn(String apn) {
        this.apn = apn;
    }

    @Generated
    public void setFailoverTimeout(Integer failoverTimeout) {
        this.failoverTimeout = failoverTimeout;
    }

    @Generated
    public void setDataRoaming(Boolean dataRoaming) {
        this.dataRoaming = dataRoaming;
    }

    @Generated
    public void setNetworkMode(Integer networkMode) {
        this.networkMode = networkMode;
    }

    @Generated
    public void setBandMode(Integer bandMode) {
        this.bandMode = bandMode;
    }

    @Generated
    public void setBands(List<String> bands) {
        this.bands = bands;
    }

    @Generated
    public void setBands5g(List<String> bands5g) {
        this.bands5g = bands5g;
    }

    @Generated
    public DialupSetting() {
    }

    @Generated
    public DialupSetting(Integer netSearchMode, String isp, Integer ispNum, Integer apnMode, String apn, Integer failoverTimeout, Boolean dataRoaming, Integer networkMode, Integer bandMode, List<String> bands, List<String> bands5g) {
        this.netSearchMode = netSearchMode;
        this.isp = isp;
        this.ispNum = ispNum;
        this.apnMode = apnMode;
        this.apn = apn;
        this.failoverTimeout = failoverTimeout;
        this.dataRoaming = dataRoaming;
        this.networkMode = networkMode;
        this.bandMode = bandMode;
        this.bands = bands;
        this.bands5g = bands5g;
    }

    @Generated
    public static class a {
        @Generated
        private Integer a;
        @Generated
        private String b;
        @Generated
        private Integer c;
        @Generated
        private Integer d;
        @Generated
        private String e;
        @Generated
        private Integer f;
        @Generated
        private Boolean g;
        @Generated
        private Integer h;
        @Generated
        private Integer i;
        @Generated
        private List<String> j;
        @Generated
        private List<String> k;

        @Generated
        a() {
        }

        @Generated
        public a a(Integer netSearchMode) {
            this.a = netSearchMode;
            return this;
        }

        @Generated
        public a a(String isp) {
            this.b = isp;
            return this;
        }

        @Generated
        public a b(Integer ispNum) {
            this.c = ispNum;
            return this;
        }

        @Generated
        public a c(Integer apnMode) {
            this.d = apnMode;
            return this;
        }

        @Generated
        public a b(String apn) {
            this.e = apn;
            return this;
        }

        @Generated
        public a d(Integer failoverTimeout) {
            this.f = failoverTimeout;
            return this;
        }

        @Generated
        public a a(Boolean dataRoaming) {
            this.g = dataRoaming;
            return this;
        }

        @Generated
        public a e(Integer networkMode) {
            this.h = networkMode;
            return this;
        }

        @Generated
        public a f(Integer bandMode) {
            this.i = bandMode;
            return this;
        }

        @Generated
        public a a(List<String> bands) {
            this.j = bands;
            return this;
        }

        @Generated
        public a b(List<String> bands5g) {
            this.k = bands5g;
            return this;
        }

        @Generated
        public DialupSetting a() {
            return new DialupSetting(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k);
        }

        @Generated
        public String toString() {
            return "DialupSetting.DialupSettingBuilder(netSearchMode=" + this.a + ", isp=" + this.b + ", ispNum=" + this.c + ", apnMode=" + this.d + ", apn=" + this.e + ", failoverTimeout=" + this.f + ", dataRoaming=" + this.g + ", networkMode=" + this.h + ", bandMode=" + this.i + ", bands=" + this.j + ", bands5g=" + this.k + ")";
        }
    }
}

