/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan;

import com.google.common.collect.Sets;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.o;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.config.osg.WanLoadBalanceConfig;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.DslWanSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.InternetVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.LteWanSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.UsbLteSettingVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.wan.WanPortSettingVO;
import com.tplink.smb.omada.manager.configuration.application.site.s.f.a.b;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.B;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.DslWanSetting;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.Ipv6Static;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.K;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.LteWanSetting;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.UsbLteSetting;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.WanBandwidthSetting;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.WanLoadBalance;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.WanPortIpv4Setting;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.WanPortIpv6Setting;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.WanPortMacSetting;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.WanPortSetting;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.d.v;
import com.tplink.smb.omada.manager.dashboard.api.web.network.WanPortBandwidthVO;
import com.tplink.smb.omada.manager.j.a.a.c;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@KeepClass
public abstract class BaseInternet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseInternet.class);
    private final c omadacId;
    private Boolean enable;
    private List<v> wanPortUuids;
    private List<WanBandwidthSetting> wanBandWidthSettings;
    private List<WanPortSetting> wanPortSettings;
    private List<UsbLteSetting> usbLteSettings;
    private List<LteWanSetting> lteWanSettings;
    private List<DslWanSetting> dslWanSettings;
    private WanLoadBalance wanLoadBalance;
    private Integer interval;
    private B unit;

    public abstract String getIdStr();

    public List<String> getWanPortUuidsStr() {
        if (CollectionUtils.isEmpty(this.wanPortUuids)) {
            return Collections.emptyList();
        }
        return this.wanPortUuids.stream().map(v::b).collect(Collectors.toList());
    }

    public List<K> getWanPortIds(Map<v, K> uuidToPortIdMap) {
        if (CollectionUtils.isEmpty(this.wanPortUuids)) {
            return Collections.emptyList();
        }
        return this.wanPortUuids.stream().filter(uuidToPortIdMap::containsKey).map(uuidToPortIdMap::get).collect(Collectors.toList());
    }

    public List<Integer> getWanPortIdsByInt(Map<v, K> uuidToPortIdMap) {
        if (CollectionUtils.isEmpty(this.wanPortUuids)) {
            return Collections.emptyList();
        }
        return this.wanPortUuids.stream().filter(uuidToPortIdMap::containsKey).map(portUuid -> ((K)uuidToPortIdMap.get(portUuid)).a()).sorted(Comparator.comparing(portId -> portId)).collect(Collectors.toList());
    }

    public List<WanPortIpv4Setting> getWanPortIpv4Settings() {
        if (CollectionUtils.isEmpty(this.wanPortSettings)) {
            return Collections.emptyList();
        }
        return this.wanPortSettings.stream().map(WanPortSetting::getIpv4Setting).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<WanPortIpv6Setting> getWanPortIpv6Settings() {
        if (CollectionUtils.isEmpty(this.wanPortSettings)) {
            return Collections.emptyList();
        }
        return this.wanPortSettings.stream().map(WanPortSetting::getIpv6Setting).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<WanPortMacSetting> getWanPortMacSettings() {
        if (CollectionUtils.isEmpty(this.wanPortSettings)) {
            return Collections.emptyList();
        }
        return this.wanPortSettings.stream().map(WanPortSetting::getMacSetting).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public int getAllWanPortSize() {
        return Optional.ofNullable(this.getWanPortSettings()).map(List::size).orElse(0) + Optional.ofNullable(this.getUsbLteSettings()).map(List::size).orElse(0) + Optional.ofNullable(this.getLteWanSettings()).map(List::size).orElse(0);
    }

    public WanBandwidthSetting getWanBandwidthSettingByPortId(Integer portId) {
        if (CollectionUtils.isEmpty(this.getWanBandWidthSettings())) {
            return null;
        }
        for (WanBandwidthSetting wanBandwidthSetting : this.getWanBandWidthSettings()) {
            if (!Objects.equals(portId, wanBandwidthSetting.getPortUuid().a())) continue;
            return wanBandwidthSetting;
        }
        return null;
    }

    public void updateByWanPortBandwidthVO(WanPortBandwidthVO wanPortBandwidthVO) {
        if (wanPortBandwidthVO == null || CollectionUtils.isEmpty((Collection)wanPortBandwidthVO.getBandwidths())) {
            this.wanBandWidthSettings = null;
            return;
        }
        this.wanBandWidthSettings = wanPortBandwidthVO.getBandwidths().stream().map(WanBandwidthSetting::fromVO).collect(Collectors.toList());
    }

    public boolean isEnable() {
        return Boolean.TRUE.equals(this.enable);
    }

    public abstract OperationResponse<BaseInternet> modifyWanPort(b var1, Map<v, String> var2, Map<String, Integer> var3, List<com.tplink.smb.omada.manager.configuration.domain.model.site.wired.virtualwan.a> var4, int var5, int var6, WanLoadBalanceConfig var7, List<Integer> var8);

    protected com.tplink.smb.omada.manager.configuration.application.site.s.f.a.a getBuildInternetCommand(b modifyWanPortsCommand, Map<v, String> wanDefaultMacMap, Map<String, Integer> osgPortTypeMap, List<com.tplink.smb.omada.manager.configuration.domain.model.site.wired.virtualwan.a> virtualWans, int oldSupportDualSim, int targetSupportDualSim, WanLoadBalanceConfig defaultLoadBalanceConfig, List<Integer> supportNetworkMode) {
        List<v> portUuids = modifyWanPortsCommand.i();
        Set newNormalWanPorts = portUuids.stream().map(v::b).filter(portId -> !Objects.equals(osgPortTypeMap.get(portId), o.h)).filter(portId -> !Objects.equals(osgPortTypeMap.get(portId), o.i)).filter(portId -> !Objects.equals(osgPortTypeMap.get(portId), o.j)).collect(Collectors.toSet());
        Set newUsbWanPorts = portUuids.stream().map(v::b).filter(portId -> Objects.equals(osgPortTypeMap.get(portId), o.h)).collect(Collectors.toSet());
        Set newLteWanPorts = portUuids.stream().map(v::b).filter(portId -> Objects.equals(osgPortTypeMap.get(portId), o.i)).collect(Collectors.toSet());
        Set newDslWanPorts = portUuids.stream().map(v::b).filter(portId -> Objects.equals(osgPortTypeMap.get(portId), o.j)).collect(Collectors.toSet());
        HashSet oldDslWanPorts = CollectionUtils.isEmpty(this.getDslWanSettings()) ? new HashSet() : this.getDslWanSettings().stream().map(dslWanSetting -> dslWanSetting.getPortUuid().b()).collect(Collectors.toSet());
        HashSet oldNormalWanPorts = CollectionUtils.isEmpty(this.getWanPortSettings()) ? new HashSet() : this.getWanPortSettings().stream().map(WanPortSetting::getPortUuid).map(v::b).filter(portUuid -> !oldDslWanPorts.contains(portUuid)).collect(Collectors.toSet());
        HashSet oldUsbWanPorts = CollectionUtils.isEmpty(this.getUsbLteSettings()) ? new HashSet() : this.getUsbLteSettings().stream().map(UsbLteSetting::getPortUuid).map(v::b).collect(Collectors.toSet());
        HashSet oldLteWanPorts = CollectionUtils.isEmpty(this.getLteWanSettings()) ? new HashSet() : this.getLteWanSettings().stream().map(LteWanSetting::getPortUuid).map(v::b).collect(Collectors.toSet());
        Sets.SetView disabledNormalPorts = Sets.difference(oldNormalWanPorts, newNormalWanPorts);
        Sets.SetView disabledUsbPorts = Sets.difference(oldUsbWanPorts, newUsbWanPorts);
        Sets.SetView disabledLtePorts = Sets.difference(oldLteWanPorts, newLteWanPorts);
        Sets.SetView disabledDslPorts = Sets.difference(oldDslWanPorts, newDslWanPorts);
        HashSet disabledPorts = new HashSet(disabledNormalPorts.immutableCopy());
        disabledPorts.addAll(disabledUsbPorts);
        disabledPorts.addAll(disabledLtePorts);
        disabledPorts.addAll(disabledDslPorts);
        if (!CollectionUtils.isEmpty(this.getWanBandWidthSettings())) {
            this.getWanBandWidthSettings().removeIf(wanBandwidthSetting -> disabledPorts.contains(wanBandwidthSetting.getPortUuid().b()));
        }
        List<WanPortSetting> retainWanPortSettings = this.getWanPortSettings().stream().filter(wanPortSetting -> !disabledPorts.contains(wanPortSetting.getPortUuid().b())).collect(Collectors.toList());
        WanLoadBalance retainWanLoadBalance = this.getWanLoadBalance();
        ArrayList<UsbLteSetting> retainUsbLteSettings = this.getUsbLteSettings() == null ? new ArrayList<UsbLteSetting>() : this.getUsbLteSettings().stream().filter(usbLteSetting -> !disabledPorts.contains(usbLteSetting.getPortUuid().b())).collect(Collectors.toList());
        List existUsb = retainUsbLteSettings.stream().map(UsbLteSetting::getPortUuid).map(v::b).collect(Collectors.toList());
        ArrayList<LteWanSetting> retainLteWanSettings = this.getLteWanSettings() == null ? new ArrayList<LteWanSetting>() : this.getLteWanSettings().stream().filter(lteWanSetting -> !disabledPorts.contains(lteWanSetting.getPortUuid().b())).map(lteWanSetting -> LteWanSetting.handleLteSimChange(lteWanSetting, oldSupportDualSim, targetSupportDualSim, supportNetworkMode)).collect(Collectors.toList());
        List existLte = retainLteWanSettings.stream().map(LteWanSetting::getPortUuid).map(v::b).collect(Collectors.toList());
        ArrayList<DslWanSetting> retainDslWanSettings = this.getDslWanSettings() == null ? new ArrayList<DslWanSetting>() : this.getDslWanSettings().stream().filter(dslWanSetting -> !disabledPorts.contains(dslWanSetting.getPortUuid().b())).collect(Collectors.toList());
        List existDsl = retainDslWanSettings.stream().map(dslWanSetting -> dslWanSetting.getPortUuid().b()).collect(Collectors.toList());
        Sets.SetView newNormalPorts = Sets.difference(newNormalWanPorts, oldNormalWanPorts);
        Sets.SetView newUsbPorts = Sets.difference(newUsbWanPorts, oldUsbWanPorts);
        Sets.SetView newLtePorts = Sets.difference(newLteWanPorts, oldLteWanPorts);
        Sets.SetView newDslPorts = Sets.difference(newDslWanPorts, oldDslWanPorts);
        HashSet newPorts = new HashSet(newNormalPorts);
        newPorts.addAll(newUsbPorts);
        newPorts.addAll(newLtePorts);
        newPorts.addAll(newDslPorts);
        for (String portUuid2 : newPorts) {
            Integer portType = osgPortTypeMap.get(portUuid2);
            if (portType == null) continue;
            if (portType.equals(o.h) && !existUsb.contains(portUuid2)) {
                retainUsbLteSettings.add(UsbLteSetting.createDefaultUsbLteSetting(new v(portUuid2)));
                continue;
            }
            if (portType.equals(o.i) && !existLte.contains(portUuid2)) {
                retainLteWanSettings.add(LteWanSetting.createDefaultLteWanPortSetting(new v(portUuid2), targetSupportDualSim, supportNetworkMode));
                continue;
            }
            if (portType.equals(o.j) && !existDsl.contains(portUuid2)) {
                retainDslWanSettings.add(DslWanSetting.createDefaultDslWanSetting(new v(portUuid2)));
                retainWanPortSettings.add(WanPortSetting.createDefaultWanPortSetting(new v(portUuid2), wanDefaultMacMap.get(new v(portUuid2))));
                continue;
            }
            if (portType.equals(o.d) || portType.equals(o.g) || portType.equals(o.e)) {
                retainWanPortSettings.add(WanPortSetting.createDefaultWanPortSetting(new v(portUuid2), wanDefaultMacMap.get(new v(portUuid2))));
                continue;
            }
            log.warn("new portId{} unknown wan type {}", (Object)portUuid2, (Object)osgPortTypeMap.get(portUuid2));
        }
        if (!newNormalWanPorts.equals(oldNormalWanPorts) || newUsbWanPorts.size() != oldUsbWanPorts.size() || !Objects.equals(newLteWanPorts.size(), oldLteWanPorts.size()) || newDslWanPorts.size() != oldDslWanPorts.size()) {
            retainWanLoadBalance = WanLoadBalance.modifyWanLoadBalance(this.getWanLoadBalance(), portUuids, osgPortTypeMap, virtualWans, defaultLoadBalanceConfig);
        }
        retainWanPortSettings = retainWanPortSettings.stream().sorted(Comparator.comparing(wanPortSetting -> wanPortSetting.getPortUuid().a())).collect(Collectors.toList());
        return com.tplink.smb.omada.manager.configuration.application.site.s.f.a.a.a().a(modifyWanPortsCommand.c()).b(modifyWanPortsCommand.f()).a(modifyWanPortsCommand.j()).a(portUuids).c(retainUsbLteSettings).d(retainLteWanSettings).e(retainDslWanSettings).b(retainWanPortSettings).f(this.getWanBandWidthSettings()).a(retainWanLoadBalance).a(modifyWanPortsCommand.l()).a();
    }

    public static OperationResponse validate(@Nullable Integer interval, @Nonnull List<v> wanPortUuids, @Nonnull List<WanPortSetting> wanPortSettings, @Nullable List<UsbLteSetting> usbLteSettings, @Nullable List<LteWanSetting> lteWanSettings, @Nullable List<DslWanSetting> dslWanSettings, @Nullable WanLoadBalance wanLoadBalance) {
        if (interval == null) {
            return OperationResponse.PARAM_ERROR;
        }
        Set wanPortSettingPorts = wanPortSettings.stream().map(WanPortSetting::getPortUuid).collect(Collectors.toSet());
        HashSet usbPortSettingPorts = usbLteSettings == null ? new HashSet(1) : usbLteSettings.stream().map(UsbLteSetting::getPortUuid).collect(Collectors.toSet());
        HashSet ltePortSettingPorts = lteWanSettings == null ? new HashSet(1) : lteWanSettings.stream().map(LteWanSetting::getPortUuid).collect(Collectors.toSet());
        HashSet dslPortSettingPorts = dslWanSettings == null ? new HashSet(1) : dslWanSettings.stream().map(DslWanSetting::getPortUuid).collect(Collectors.toSet());
        wanPortSettingPorts.addAll(usbPortSettingPorts);
        wanPortSettingPorts.addAll(ltePortSettingPorts);
        wanPortSettingPorts.addAll(dslPortSettingPorts);
        HashSet<v> wanPortSet = new HashSet<v>(wanPortUuids);
        if (wanPortSet.size() != wanPortUuids.size()) {
            return OperationResponse.PARAM_ERROR;
        }
        List<WanPortIpv4Setting> wanPortIpv4Settings = wanPortSettings.stream().map(wanPortSetting -> wanPortSetting.getIpv4Setting()).filter(wanPortIpv4Setting -> wanPortIpv4Setting != null).collect(Collectors.toList());
        if (!BaseInternet.checkIp4Addr(wanPortIpv4Settings)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.hq);
        }
        List<WanPortIpv6Setting> wanPortIpv6Settings = wanPortSettings.stream().map(WanPortSetting::getIpv6Setting).filter(Objects::nonNull).collect(Collectors.toList());
        if (!BaseInternet.checkIpv6Addr(wanPortIpv6Settings)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.hq);
        }
        List wanPortMacSettings = wanPortSettings.stream().map(WanPortSetting::getMacSetting).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(wanPortMacSettings) && !CollectionUtils.isEmpty(wanPortSettings)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (wanPortUuids.size() > 1 && wanLoadBalance == null) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    public static boolean checkIp4Addr(@Nonnull List<WanPortIpv4Setting> wanPortIpv4Settings) {
        HashSet<String> ipSet = new HashSet<String>(wanPortIpv4Settings.size());
        for (WanPortIpv4Setting wanPortIpv4Setting : wanPortIpv4Settings) {
            if (wanPortIpv4Setting.checkIpv4AddrDuplicate(ipSet)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkIpv6Addr(@Nonnull List<WanPortIpv6Setting> wanPortIpv6Settings) {
        HashSet<String> ipSet = new HashSet<String>(wanPortIpv6Settings.size());
        block4: for (WanPortIpv6Setting wanPortIpv6Setting : wanPortIpv6Settings) {
            if (!Objects.equals(1, wanPortIpv6Setting.getEnable())) {
                return true;
            }
            switch (wanPortIpv6Setting.getIpv6ProtoType().getProto()) {
                case a: {
                    Ipv6Static ipv6Static = (Ipv6Static)wanPortIpv6Setting.getIpv6ProtoType();
                    String ipv6Addr = ipv6Static.getAddr();
                    Integer mask = ipv6Static.getPfLen();
                    if (T.a((String)ipv6Addr) || mask == null || ipSet.add(com.tplink.smb.omada.manager.configuration.domain.shared.B.b(ipv6Addr, mask))) continue block4;
                    return false;
                }
                case c: 
                case b: 
                case e: 
                case d: {
                    continue block4;
                }
            }
            return false;
        }
        return true;
    }

    protected com.tplink.smb.omada.manager.configuration.application.site.s.f.a.a getBuildInternetCommandByVO(@Nonnull InternetVO internetVO, List<com.tplink.smb.omada.manager.configuration.domain.model.site.wired.virtualwan.a> virtualWans, WanLoadBalanceConfig defaultLoadBalanceConfig) {
        List<v> wanPortUnis = internetVO.getPortUuids().stream().map(v::new).collect(Collectors.toList());
        Map<v, WanPortSettingVO> wanPortSettingVOMap = internetVO.getWanPortSettings().stream().collect(Collectors.toMap(wanPortSettingVO -> new v(wanPortSettingVO.getPortUuid()), wanPortSettingVO -> wanPortSettingVO));
        HashMap usbLteWanPortSettingVOMap = internetVO.getUsbLteSettings() == null ? new HashMap(1) : internetVO.getUsbLteSettings().stream().collect(Collectors.toMap(usbLteSettingVO -> new v(usbLteSettingVO.getPortUuid()), usbLteSettingVO -> usbLteSettingVO));
        HashMap lteWanPortSettingVOMap = internetVO.getLteWanSettings() == null ? new HashMap(1) : internetVO.getLteWanSettings().stream().collect(Collectors.toMap(lteWanSettingVO -> new v(lteWanSettingVO.getPortUuid()), lteWanSettingVO -> lteWanSettingVO));
        List dslWanPortSettingList = internetVO.getWanPortSettings().stream().filter(wanPortSettings -> Objects.nonNull(wanPortSettings.getDslSetting())).collect(Collectors.toList());
        HashMap dslWanPortSettingVOMap = CollectionUtils.isEmpty(dslWanPortSettingList) ? new HashMap(1) : dslWanPortSettingList.stream().collect(Collectors.toMap(dslWanPortSetting -> new v(dslWanPortSetting.getPortUuid()), WanPortSettingVO::getDslSetting));
        Map<v, WanPortSetting> oldWanPortSettingMap = this.getWanPortSettings().stream().collect(Collectors.toMap(WanPortSetting::getPortUuid, wanPortSetting -> wanPortSetting));
        HashMap oldUsbLteSettingWanPortSettingMap = this.getUsbLteSettings() == null ? new HashMap(1) : this.getUsbLteSettings().stream().collect(Collectors.toMap(UsbLteSetting::getPortUuid, usbLteSetting -> usbLteSetting));
        HashMap oldLteSettingWanPortSettingMap = this.getLteWanSettings() == null ? new HashMap(1) : this.getLteWanSettings().stream().collect(Collectors.toMap(LteWanSetting::getPortUuid, Function.identity()));
        HashMap oldDslSettingWanPortSettingMap = this.getDslWanSettings() == null ? new HashMap() : this.getDslWanSettings().stream().collect(Collectors.toMap(DslWanSetting::getPortUuid, Function.identity()));
        List<WanPortSetting> newWanPortSettings = wanPortUnis.stream().filter(oldWanPortSettingMap::containsKey).map(portUuid -> ((WanPortSetting)oldWanPortSettingMap.get(portUuid)).fromVO((WanPortSettingVO)wanPortSettingVOMap.get(portUuid)).orElse((WanPortSetting)oldWanPortSettingMap.get(portUuid))).collect(Collectors.toList());
        List<UsbLteSetting> newUsbLteWanPortSettings = wanPortUnis.stream().filter(oldUsbLteSettingWanPortSettingMap::containsKey).map(portUuid -> ((UsbLteSetting)oldUsbLteSettingWanPortSettingMap.get(portUuid)).fromVO((UsbLteSettingVO)usbLteWanPortSettingVOMap.get(portUuid)).orElse((UsbLteSetting)oldUsbLteSettingWanPortSettingMap.get(portUuid))).collect(Collectors.toList());
        List<LteWanSetting> newLteWanPortSettings = wanPortUnis.stream().filter(oldLteSettingWanPortSettingMap::containsKey).map(portUuid -> ((LteWanSetting)oldLteSettingWanPortSettingMap.get(portUuid)).fromVO((LteWanSettingVO)lteWanPortSettingVOMap.get(portUuid)).orElse((LteWanSetting)oldLteSettingWanPortSettingMap.get(portUuid))).collect(Collectors.toList());
        List<DslWanSetting> newDslWanPortSettings = wanPortUnis.stream().filter(oldDslSettingWanPortSettingMap::containsKey).map(portUuid -> ((DslWanSetting)oldDslSettingWanPortSettingMap.get(portUuid)).fromVO((DslWanSettingVO)dslWanPortSettingVOMap.get(portUuid)).orElse((DslWanSetting)oldDslSettingWanPortSettingMap.get(portUuid))).collect(Collectors.toList());
        HashMap<String, Integer> osgPortTypeMap = new HashMap<String, Integer>();
        if (!CollectionUtils.isEmpty(newWanPortSettings)) {
            for (WanPortSetting wanPortSetting2 : newWanPortSettings) {
                osgPortTypeMap.put(wanPortSetting2.getPortUuid().b(), o.d);
            }
        }
        if (!CollectionUtils.isEmpty(newUsbLteWanPortSettings)) {
            for (UsbLteSetting usbLteSetting2 : newUsbLteWanPortSettings) {
                osgPortTypeMap.put(usbLteSetting2.getPortUuid().b(), o.h);
            }
        }
        if (!CollectionUtils.isEmpty(newLteWanPortSettings)) {
            for (LteWanSetting lteWanSetting : newLteWanPortSettings) {
                osgPortTypeMap.put(lteWanSetting.getPortUuid().b(), o.i);
            }
        }
        return com.tplink.smb.omada.manager.configuration.application.site.s.f.a.a.a().a(new c(internetVO.getOmadacId())).b(internetVO.getEnable()).a(Optional.ofNullable(internetVO.getInterval()).orElse(2)).a(Optional.ofNullable(internetVO.getUnit()).map(B::a).orElse(B.a)).a(wanPortUnis).b(newWanPortSettings).c(newUsbLteWanPortSettings).d(newLteWanPortSettings).e(newDslWanPortSettings).f(this.getWanBandWidthSettings()).a(WanLoadBalance.fromVO(internetVO.getWanLoadBalance(), wanPortUnis, Optional.ofNullable(this.getWanLoadBalance()).map(WanLoadBalance::getWeight).orElse(null), osgPortTypeMap, virtualWans, defaultLoadBalanceConfig)).a();
    }

    @Generated
    protected BaseInternet(a<?, ?> b2) {
        this.omadacId = b2.a;
        this.enable = b2.b;
        this.wanPortUuids = b2.c;
        this.wanBandWidthSettings = b2.d;
        this.wanPortSettings = b2.e;
        this.usbLteSettings = b2.f;
        this.lteWanSettings = b2.g;
        this.dslWanSettings = b2.h;
        this.wanLoadBalance = b2.i;
        this.interval = b2.j;
        this.unit = b2.k;
    }

    @Generated
    public c getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public List<v> getWanPortUuids() {
        return this.wanPortUuids;
    }

    @Generated
    public List<WanBandwidthSetting> getWanBandWidthSettings() {
        return this.wanBandWidthSettings;
    }

    @Generated
    public List<WanPortSetting> getWanPortSettings() {
        return this.wanPortSettings;
    }

    @Generated
    public List<UsbLteSetting> getUsbLteSettings() {
        return this.usbLteSettings;
    }

    @Generated
    public List<LteWanSetting> getLteWanSettings() {
        return this.lteWanSettings;
    }

    @Generated
    public List<DslWanSetting> getDslWanSettings() {
        return this.dslWanSettings;
    }

    @Generated
    public WanLoadBalance getWanLoadBalance() {
        return this.wanLoadBalance;
    }

    @Generated
    public Integer getInterval() {
        return this.interval;
    }

    @Generated
    public B getUnit() {
        return this.unit;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setWanPortUuids(List<v> wanPortUuids) {
        this.wanPortUuids = wanPortUuids;
    }

    @Generated
    public void setWanBandWidthSettings(List<WanBandwidthSetting> wanBandWidthSettings) {
        this.wanBandWidthSettings = wanBandWidthSettings;
    }

    @Generated
    public void setWanPortSettings(List<WanPortSetting> wanPortSettings) {
        this.wanPortSettings = wanPortSettings;
    }

    @Generated
    public void setUsbLteSettings(List<UsbLteSetting> usbLteSettings) {
        this.usbLteSettings = usbLteSettings;
    }

    @Generated
    public void setLteWanSettings(List<LteWanSetting> lteWanSettings) {
        this.lteWanSettings = lteWanSettings;
    }

    @Generated
    public void setDslWanSettings(List<DslWanSetting> dslWanSettings) {
        this.dslWanSettings = dslWanSettings;
    }

    @Generated
    public void setWanLoadBalance(WanLoadBalance wanLoadBalance) {
        this.wanLoadBalance = wanLoadBalance;
    }

    @Generated
    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    @Generated
    public void setUnit(B unit) {
        this.unit = unit;
    }

    @Generated
    public static abstract class a<C extends BaseInternet, B extends a<C, B>> {
        @Generated
        private c a;
        @Generated
        private Boolean b;
        @Generated
        private List<v> c;
        @Generated
        private List<WanBandwidthSetting> d;
        @Generated
        private List<WanPortSetting> e;
        @Generated
        private List<UsbLteSetting> f;
        @Generated
        private List<LteWanSetting> g;
        @Generated
        private List<DslWanSetting> h;
        @Generated
        private WanLoadBalance i;
        @Generated
        private Integer j;
        @Generated
        private B k;

        @Generated
        public B a(c omadacId) {
            this.a = omadacId;
            return this.a();
        }

        @Generated
        public B a(Boolean enable) {
            this.b = enable;
            return this.a();
        }

        @Generated
        public B a(List<v> wanPortUuids) {
            this.c = wanPortUuids;
            return this.a();
        }

        @Generated
        public B b(List<WanBandwidthSetting> wanBandWidthSettings) {
            this.d = wanBandWidthSettings;
            return this.a();
        }

        @Generated
        public B c(List<WanPortSetting> wanPortSettings) {
            this.e = wanPortSettings;
            return this.a();
        }

        @Generated
        public B d(List<UsbLteSetting> usbLteSettings) {
            this.f = usbLteSettings;
            return this.a();
        }

        @Generated
        public B e(List<LteWanSetting> lteWanSettings) {
            this.g = lteWanSettings;
            return this.a();
        }

        @Generated
        public B f(List<DslWanSetting> dslWanSettings) {
            this.h = dslWanSettings;
            return this.a();
        }

        @Generated
        public B a(WanLoadBalance wanLoadBalance) {
            this.i = wanLoadBalance;
            return this.a();
        }

        @Generated
        public B a(Integer interval) {
            this.j = interval;
            return this.a();
        }

        @Generated
        public B a(B unit) {
            this.k = unit;
            return this.a();
        }

        @Generated
        protected abstract B a();

        @Generated
        public abstract C b();

        @Generated
        public String toString() {
            return "BaseInternet.BaseInternetBuilder(omadacId=" + this.a + ", enable=" + this.b + ", wanPortUuids=" + this.c + ", wanBandWidthSettings=" + this.d + ", wanPortSettings=" + this.e + ", usbLteSettings=" + this.f + ", lteWanSettings=" + this.g + ", dslWanSettings=" + this.h + ", wanLoadBalance=" + this.i + ", interval=" + this.j + ", unit=" + this.k + ")";
        }
    }
}

