/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lanprofile;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.e.l;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lanprofile.LanProfileVO;
import com.tplink.smb.omada.manager.configuration.domain.model.site.component.g;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.BaseLanNetwork;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.F;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@KeepClass
public class NetworkAssociated
implements l<NetworkAssociated> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetworkAssociated.class);
    private F nativeNetworkId;
    private Integer nativeBridgeVlan;
    private List<F> tagNetworkIds;
    private Map<String, Set<Integer>> tagBridgeVlanMap;
    private List<F> esEnableTagNetworkIds;
    private Map<String, Set<Integer>> esEnableTagBridgeVlanMap;
    private List<F> untagNetworkIds;
    private Map<String, Set<Integer>> untagBridgeVlanMap;
    private F voiceNetworkId;
    private Integer voiceBridgeVlan;

    public static OperationResponse<NetworkAssociated> build(LanProfileVO lanProfileVO) {
        ArrayList<String> esEnableTaggedNetworkIds = new ArrayList<String>();
        HashMap<String, Set<Integer>> esEnableTaggedNetworkMap = new HashMap<String, Set<Integer>>();
        NetworkAssociated.a(lanProfileVO, esEnableTaggedNetworkIds, esEnableTaggedNetworkMap);
        return NetworkAssociated.build(lanProfileVO.getNativeNetworkId(), lanProfileVO.getTagNetworkIds(), lanProfileVO.getUntagNetworkIds(), esEnableTaggedNetworkIds, lanProfileVO.getVoiceNetworkId(), lanProfileVO.getNativeBridgeVlan(), lanProfileVO.getTagBridgeVlanMap(), lanProfileVO.getUntagBridgeVlanMap(), esEnableTaggedNetworkMap, lanProfileVO.getVoiceBridgeVlan());
    }

    public static OperationResponse<NetworkAssociated> buildDefault(BaseLanNetwork primaryLanNetwork) {
        if (Objects.isNull(primaryLanNetwork) || Objects.isNull(primaryLanNetwork.getId())) {
            return OperationResponse.success(null);
        }
        return NetworkAssociated.build(((g)primaryLanNetwork.getId()).b(), new ArrayList<String>(), new ArrayList<String>(), null, null, null, null, null, null, null);
    }

    private static void a(LanProfileVO lanProfileVO, List<String> esEnableTaggedNetworkIds, Map<String, Set<Integer>> esEnableTaggedNetworkMap) {
        if (lanProfileVO.getEsEnableTaggedNetworkIds() == null) {
            return;
        }
        lanProfileVO.getEsEnableTaggedNetworkIds().forEach(id -> {
            if (!id.contains("_")) {
                esEnableTaggedNetworkIds.add((String)id);
                return;
            }
            String idPrefix = id.split("_")[0];
            String vlan = id.split("_")[1];
            if (!esEnableTaggedNetworkIds.contains(idPrefix)) {
                esEnableTaggedNetworkIds.add(idPrefix);
            }
            if (esEnableTaggedNetworkMap.containsKey(idPrefix)) {
                ((Set)esEnableTaggedNetworkMap.get(idPrefix)).add(Integer.parseInt(vlan));
            } else {
                HashSet<Integer> bridgeVlanList = new HashSet<Integer>();
                bridgeVlanList.add(Integer.parseInt(vlan));
                esEnableTaggedNetworkMap.put(idPrefix, bridgeVlanList);
            }
        });
    }

    public static OperationResponse<NetworkAssociated> build(String nativeNetworkId, List<String> tagNetworkIds, List<String> untagNetworkIds, List<String> esEnableTagNetworkIds, String voiceNetworkId, Integer nativeBridgeVlan, Map<String, Set<Integer>> tagBridgeVlanMap, Map<String, Set<Integer>> untagBridgeVlanMap, Map<String, Set<Integer>> esEnableTagBridgeVlanMap, Integer voiceBridgeVlan) {
        F nativeNetwork = T.a((String)nativeNetworkId) ? null : new F(nativeNetworkId);
        ArrayList<F> tagNetworkIdList = new ArrayList<F>(4);
        if (tagNetworkIds != null && !tagNetworkIds.isEmpty()) {
            tagNetworkIdList.addAll(tagNetworkIds.stream().filter(tagNetworkId -> !T.a((String)tagNetworkId)).map(F::new).collect(Collectors.toList()));
        }
        ArrayList<F> untagNetworkIdList = new ArrayList<F>(4);
        if (untagNetworkIds != null && !untagNetworkIds.isEmpty()) {
            untagNetworkIdList.addAll(untagNetworkIds.stream().filter(untagNetworkId -> !T.a((String)untagNetworkId)).map(F::new).collect(Collectors.toList()));
        }
        ArrayList<F> esEnableTagNetworkIdList = new ArrayList<F>();
        if (!CollectionUtils.isEmpty(esEnableTagNetworkIds)) {
            esEnableTagNetworkIdList.addAll(esEnableTagNetworkIds.stream().filter(Objects::nonNull).map(F::new).collect(Collectors.toList()));
        }
        F voiceNetwork = T.a((String)voiceNetworkId) ? null : new F(voiceNetworkId);
        return new OperationResponse(b.a, (Object)NetworkAssociated.builder().a(nativeNetwork).a(nativeBridgeVlan).a(tagNetworkIdList).a(tagBridgeVlanMap).c(untagNetworkIdList).c(untagBridgeVlanMap).b(esEnableTagNetworkIdList).b(esEnableTagBridgeVlanMap).b(voiceNetwork).b(voiceBridgeVlan).a());
    }

    public static OperationResponse validate(String nativeNetworkId, List<String> tagNetworkIds, List<String> untagNetworkIds, String voiceNetworkId) {
        if (nativeNetworkId != null) {
            boolean isContain;
            boolean bl2 = isContain = tagNetworkIds != null && tagNetworkIds.contains(nativeNetworkId) || untagNetworkIds != null && untagNetworkIds.contains(nativeNetworkId);
            if (isContain) {
                log.warn("Native Network can not be included in Tagged Networks or Untagged Networks.");
                return new OperationResponse(b.iG);
            }
        }
        if (tagNetworkIds != null && untagNetworkIds != null && !Collections.disjoint(tagNetworkIds, untagNetworkIds)) {
            log.warn("Untagged Network can not be included in Tagged Networks.");
            return new OperationResponse(b.iH);
        }
        if (!(voiceNetworkId == null || tagNetworkIds != null && tagNetworkIds.contains(voiceNetworkId))) {
            log.warn("Voice Network must be included in Tagged Networks.");
            return new OperationResponse(b.iI);
        }
        return OperationResponse.SUCCESS;
    }

    public static NetworkAssociated createDefaultNetworkAssociated(F nativeNetworkId) {
        return NetworkAssociated.builder().a(nativeNetworkId).a(new ArrayList<F>(3)).c(new ArrayList<F>(3)).a();
    }

    public boolean sameValueAs(NetworkAssociated other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    @Generated
    NetworkAssociated(F nativeNetworkId, Integer nativeBridgeVlan, List<F> tagNetworkIds, Map<String, Set<Integer>> tagBridgeVlanMap, List<F> esEnableTagNetworkIds, Map<String, Set<Integer>> esEnableTagBridgeVlanMap, List<F> untagNetworkIds, Map<String, Set<Integer>> untagBridgeVlanMap, F voiceNetworkId, Integer voiceBridgeVlan) {
        this.nativeNetworkId = nativeNetworkId;
        this.nativeBridgeVlan = nativeBridgeVlan;
        this.tagNetworkIds = tagNetworkIds;
        this.tagBridgeVlanMap = tagBridgeVlanMap;
        this.esEnableTagNetworkIds = esEnableTagNetworkIds;
        this.esEnableTagBridgeVlanMap = esEnableTagBridgeVlanMap;
        this.untagNetworkIds = untagNetworkIds;
        this.untagBridgeVlanMap = untagBridgeVlanMap;
        this.voiceNetworkId = voiceNetworkId;
        this.voiceBridgeVlan = voiceBridgeVlan;
    }

    @Generated
    public static a builder() {
        return new a();
    }

    @Generated
    public F getNativeNetworkId() {
        return this.nativeNetworkId;
    }

    @Generated
    public Integer getNativeBridgeVlan() {
        return this.nativeBridgeVlan;
    }

    @Generated
    public List<F> getTagNetworkIds() {
        return this.tagNetworkIds;
    }

    @Generated
    public Map<String, Set<Integer>> getTagBridgeVlanMap() {
        return this.tagBridgeVlanMap;
    }

    @Generated
    public List<F> getEsEnableTagNetworkIds() {
        return this.esEnableTagNetworkIds;
    }

    @Generated
    public Map<String, Set<Integer>> getEsEnableTagBridgeVlanMap() {
        return this.esEnableTagBridgeVlanMap;
    }

    @Generated
    public List<F> getUntagNetworkIds() {
        return this.untagNetworkIds;
    }

    @Generated
    public Map<String, Set<Integer>> getUntagBridgeVlanMap() {
        return this.untagBridgeVlanMap;
    }

    @Generated
    public F getVoiceNetworkId() {
        return this.voiceNetworkId;
    }

    @Generated
    public Integer getVoiceBridgeVlan() {
        return this.voiceBridgeVlan;
    }

    @Generated
    public NetworkAssociated setNativeNetworkId(F nativeNetworkId) {
        this.nativeNetworkId = nativeNetworkId;
        return this;
    }

    @Generated
    public NetworkAssociated setNativeBridgeVlan(Integer nativeBridgeVlan) {
        this.nativeBridgeVlan = nativeBridgeVlan;
        return this;
    }

    @Generated
    public NetworkAssociated setTagNetworkIds(List<F> tagNetworkIds) {
        this.tagNetworkIds = tagNetworkIds;
        return this;
    }

    @Generated
    public NetworkAssociated setTagBridgeVlanMap(Map<String, Set<Integer>> tagBridgeVlanMap) {
        this.tagBridgeVlanMap = tagBridgeVlanMap;
        return this;
    }

    @Generated
    public NetworkAssociated setEsEnableTagNetworkIds(List<F> esEnableTagNetworkIds) {
        this.esEnableTagNetworkIds = esEnableTagNetworkIds;
        return this;
    }

    @Generated
    public NetworkAssociated setEsEnableTagBridgeVlanMap(Map<String, Set<Integer>> esEnableTagBridgeVlanMap) {
        this.esEnableTagBridgeVlanMap = esEnableTagBridgeVlanMap;
        return this;
    }

    @Generated
    public NetworkAssociated setUntagNetworkIds(List<F> untagNetworkIds) {
        this.untagNetworkIds = untagNetworkIds;
        return this;
    }

    @Generated
    public NetworkAssociated setUntagBridgeVlanMap(Map<String, Set<Integer>> untagBridgeVlanMap) {
        this.untagBridgeVlanMap = untagBridgeVlanMap;
        return this;
    }

    @Generated
    public NetworkAssociated setVoiceNetworkId(F voiceNetworkId) {
        this.voiceNetworkId = voiceNetworkId;
        return this;
    }

    @Generated
    public NetworkAssociated setVoiceBridgeVlan(Integer voiceBridgeVlan) {
        this.voiceBridgeVlan = voiceBridgeVlan;
        return this;
    }

    @Generated
    public String toString() {
        return "NetworkAssociated(nativeNetworkId=" + this.getNativeNetworkId() + ", nativeBridgeVlan=" + this.getNativeBridgeVlan() + ", tagNetworkIds=" + this.getTagNetworkIds() + ", tagBridgeVlanMap=" + this.getTagBridgeVlanMap() + ", esEnableTagNetworkIds=" + this.getEsEnableTagNetworkIds() + ", esEnableTagBridgeVlanMap=" + this.getEsEnableTagBridgeVlanMap() + ", untagNetworkIds=" + this.getUntagNetworkIds() + ", untagBridgeVlanMap=" + this.getUntagBridgeVlanMap() + ", voiceNetworkId=" + this.getVoiceNetworkId() + ", voiceBridgeVlan=" + this.getVoiceBridgeVlan() + ")";
    }

    @Generated
    public static class a {
        @Generated
        private F a;
        @Generated
        private Integer b;
        @Generated
        private List<F> c;
        @Generated
        private Map<String, Set<Integer>> d;
        @Generated
        private List<F> e;
        @Generated
        private Map<String, Set<Integer>> f;
        @Generated
        private List<F> g;
        @Generated
        private Map<String, Set<Integer>> h;
        @Generated
        private F i;
        @Generated
        private Integer j;

        @Generated
        a() {
        }

        @Generated
        public a a(F nativeNetworkId) {
            this.a = nativeNetworkId;
            return this;
        }

        @Generated
        public a a(Integer nativeBridgeVlan) {
            this.b = nativeBridgeVlan;
            return this;
        }

        @Generated
        public a a(List<F> tagNetworkIds) {
            this.c = tagNetworkIds;
            return this;
        }

        @Generated
        public a a(Map<String, Set<Integer>> tagBridgeVlanMap) {
            this.d = tagBridgeVlanMap;
            return this;
        }

        @Generated
        public a b(List<F> esEnableTagNetworkIds) {
            this.e = esEnableTagNetworkIds;
            return this;
        }

        @Generated
        public a b(Map<String, Set<Integer>> esEnableTagBridgeVlanMap) {
            this.f = esEnableTagBridgeVlanMap;
            return this;
        }

        @Generated
        public a c(List<F> untagNetworkIds) {
            this.g = untagNetworkIds;
            return this;
        }

        @Generated
        public a c(Map<String, Set<Integer>> untagBridgeVlanMap) {
            this.h = untagBridgeVlanMap;
            return this;
        }

        @Generated
        public a b(F voiceNetworkId) {
            this.i = voiceNetworkId;
            return this;
        }

        @Generated
        public a b(Integer voiceBridgeVlan) {
            this.j = voiceBridgeVlan;
            return this;
        }

        @Generated
        public NetworkAssociated a() {
            return new NetworkAssociated(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j);
        }

        @Generated
        public String toString() {
            return "NetworkAssociated.NetworkAssociatedBuilder(nativeNetworkId=" + this.a + ", nativeBridgeVlan=" + this.b + ", tagNetworkIds=" + this.c + ", tagBridgeVlanMap=" + this.d + ", esEnableTagNetworkIds=" + this.e + ", esEnableTagBridgeVlanMap=" + this.f + ", untagNetworkIds=" + this.g + ", untagBridgeVlanMap=" + this.h + ", voiceNetworkId=" + this.i + ", voiceBridgeVlan=" + this.j + ")";
        }
    }
}

