/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork;

import com.tplink.smb.omada.common.e.l;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.config.osg.OsgLanNetworkIpv6Config;
import com.tplink.smb.omada.device.manage.message.config.osg.RouteAdvertisementConfig;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.LanNetworkIpv6ConfigVO;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.H;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.LanNetworkIpv6Dhcpv6;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.LanNetworkIpv6Passthrough;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.LanNetworkIpv6ProtoType;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.LanNetworkIpv6Rdnss;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.LanNetworkIpv6Slaac;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.ab;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.K;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.wan.d.v;
import com.tplink.smb.omada.manager.configuration.domain.shared.B;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.springframework.beans.BeanUtils;

@KeepClass
public class LanNetworkIpv6Config
implements l<LanNetworkIpv6Config> {
    private Integer enable;
    private LanNetworkIpv6ProtoType ipv6ProtoType;

    public boolean isDhcpv6() {
        return this.ipv6ProtoType != null && Objects.equals((Object)H.a, (Object)this.ipv6ProtoType.getIpv6Proto());
    }

    public boolean isPassthrough() {
        return this.ipv6ProtoType != null && Objects.equals((Object)H.d, (Object)this.ipv6ProtoType.getIpv6Proto());
    }

    public boolean isEnable() {
        return Objects.equals(1, this.getEnable());
    }

    public boolean existsBySiteAndPrefix(@Nonnull String prefix) {
        switch (this.getIpv6ProtoType().getIpv6Proto()) {
            case b: {
                LanNetworkIpv6Slaac lanNetworkIpv6Slaac = (LanNetworkIpv6Slaac)this.getIpv6ProtoType();
                if (!B.a(prefix, lanNetworkIpv6Slaac.getPrefix())) break;
                return true;
            }
            case c: {
                LanNetworkIpv6Rdnss lanNetworkIpv6Rdnss = (LanNetworkIpv6Rdnss)this.getIpv6ProtoType();
                if (!B.a(prefix, lanNetworkIpv6Rdnss.getPrefix())) break;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static LanNetworkIpv6Config createDefaultLanNetworkIpv6Setting() {
        return LanNetworkIpv6Config.builder().a(0).a();
    }

    public static Optional<OsgLanNetworkIpv6Config> toConfig(@Nonnull LanNetworkIpv6Config lanNetworkIpv6Config, @Nonnull Map<v, K> uuidPortIdMap) {
        return Optional.ofNullable(lanNetworkIpv6Config).map(ipv6Config -> {
            OsgLanNetworkIpv6Config osgLanNetworkIpv6Config = new OsgLanNetworkIpv6Config();
            osgLanNetworkIpv6Config.setEnable(ipv6Config.getEnable());
            if (!ipv6Config.isEnable() || ipv6Config.getIpv6ProtoType() == null) {
                return osgLanNetworkIpv6Config;
            }
            osgLanNetworkIpv6Config.setProto(ipv6Config.getIpv6ProtoType().getIpv6Proto().a());
            switch (ipv6Config.getIpv6ProtoType().getIpv6Proto()) {
                case a: {
                    LanNetworkIpv6Dhcpv6 lanNetworkIpv6Dhcpv6 = (LanNetworkIpv6Dhcpv6)ipv6Config.getIpv6ProtoType();
                    BeanUtils.copyProperties((Object)lanNetworkIpv6Dhcpv6, (Object)osgLanNetworkIpv6Config);
                    osgLanNetworkIpv6Config.setRa(LanNetworkIpv6Config.a(lanNetworkIpv6Dhcpv6.getRa()));
                    break;
                }
                case b: {
                    LanNetworkIpv6Slaac lanNetworkIpv6Slaac = (LanNetworkIpv6Slaac)ipv6Config.getIpv6ProtoType();
                    BeanUtils.copyProperties((Object)lanNetworkIpv6Slaac, (Object)osgLanNetworkIpv6Config);
                    if (!T.a((String)lanNetworkIpv6Slaac.getPortUuid())) {
                        K portIdOfSlaac = (K)uuidPortIdMap.get(new v(lanNetworkIpv6Slaac.getPortUuid()));
                        osgLanNetworkIpv6Config.setPortId((Integer)Optional.ofNullable(portIdOfSlaac).map(K::a).orElse(null));
                    }
                    osgLanNetworkIpv6Config.setRa(LanNetworkIpv6Config.a(lanNetworkIpv6Slaac.getRa()));
                    if (!Objects.equals(1, osgLanNetworkIpv6Config.getPreType())) break;
                    osgLanNetworkIpv6Config.setPrefix(null);
                    break;
                }
                case c: {
                    LanNetworkIpv6Rdnss lanNetworkIpv6Rdnss = (LanNetworkIpv6Rdnss)ipv6Config.getIpv6ProtoType();
                    BeanUtils.copyProperties((Object)lanNetworkIpv6Rdnss, (Object)osgLanNetworkIpv6Config);
                    if (!T.a((String)lanNetworkIpv6Rdnss.getPortUuid())) {
                        K portIdOfRdnss = (K)uuidPortIdMap.get(new v(lanNetworkIpv6Rdnss.getPortUuid()));
                        osgLanNetworkIpv6Config.setPortId((Integer)Optional.ofNullable(portIdOfRdnss).map(K::a).orElse(null));
                    }
                    osgLanNetworkIpv6Config.setRa(LanNetworkIpv6Config.a(lanNetworkIpv6Rdnss.getRa()));
                    if (!Objects.equals(1, osgLanNetworkIpv6Config.getPreType())) break;
                    osgLanNetworkIpv6Config.setPrefix(null);
                    break;
                }
                case d: {
                    LanNetworkIpv6Passthrough lanNetworkIpv6Passthrough = (LanNetworkIpv6Passthrough)ipv6Config.getIpv6ProtoType();
                    BeanUtils.copyProperties((Object)lanNetworkIpv6Passthrough, (Object)osgLanNetworkIpv6Config);
                    if (T.a((String)lanNetworkIpv6Passthrough.getPortUuid())) break;
                    K portIdOfPassthrough = (K)uuidPortIdMap.get(new v(lanNetworkIpv6Passthrough.getPortUuid()));
                    osgLanNetworkIpv6Config.setPortId((Integer)Optional.ofNullable(portIdOfPassthrough).map(K::a).orElse(null));
                    break;
                }
            }
            return osgLanNetworkIpv6Config;
        });
    }

    private static RouteAdvertisementConfig a(ab ra) {
        if (ra == null) {
            RouteAdvertisementConfig raConfig = new RouteAdvertisementConfig();
            raConfig.setEnable(Integer.valueOf(0));
            return raConfig;
        }
        RouteAdvertisementConfig raConfig = new RouteAdvertisementConfig();
        raConfig.setEnable(Integer.valueOf(1));
        raConfig.setPreference(ra.b());
        raConfig.setValidLifetime(ra.c());
        raConfig.setPreferredLifetime(ra.d());
        return raConfig;
    }

    public static Optional<LanNetworkIpv6Config> fromVO(@Nonnull LanNetworkIpv6ConfigVO lanNetworkIpv6ConfigVO) {
        if (Objects.equals(0, lanNetworkIpv6ConfigVO.getEnable())) {
            return Optional.ofNullable(LanNetworkIpv6Config.builder().a(lanNetworkIpv6ConfigVO.getEnable()).a());
        }
        H ipv6Proto = H.a(lanNetworkIpv6ConfigVO.getProto());
        if (ipv6Proto == null) {
            return Optional.ofNullable(LanNetworkIpv6Config.builder().a(lanNetworkIpv6ConfigVO.getEnable()).a());
        }
        return Optional.ofNullable(LanNetworkIpv6Config.builder().a(lanNetworkIpv6ConfigVO.getEnable()).a((LanNetworkIpv6ProtoType)LanNetworkIpv6Config.toIpv6ProtoType(lanNetworkIpv6ConfigVO).orElse(null)).a());
    }

    public static Optional<LanNetworkIpv6ProtoType> toIpv6ProtoType(@Nonnull LanNetworkIpv6ConfigVO lanNetworkIpv6Config) {
        if (Objects.equals(0, lanNetworkIpv6Config.getEnable())) {
            return Optional.empty();
        }
        H ipv6Proto = H.a(lanNetworkIpv6Config.getProto());
        if (ipv6Proto == null) {
            return Optional.empty();
        }
        switch (ipv6Proto) {
            case a: {
                Optional<LanNetworkIpv6Dhcpv6> ipv6Dhcpv6Opt = LanNetworkIpv6Dhcpv6.fromDTO(lanNetworkIpv6Config.getDhcpv6());
                ipv6Dhcpv6Opt.ifPresent(ipv6Dhcpv6 -> ipv6Dhcpv6.setRa(ab.a(lanNetworkIpv6Config.getRa())));
                return Optional.ofNullable(ipv6Dhcpv6Opt.orElse(null));
            }
            case c: {
                Optional<LanNetworkIpv6Rdnss> ipv6RdnssOpt = LanNetworkIpv6Rdnss.fromDTO(lanNetworkIpv6Config.getRdnss());
                ipv6RdnssOpt.ifPresent(ipv6Rdnss -> ipv6Rdnss.setRa(ab.a(lanNetworkIpv6Config.getRa())));
                return Optional.ofNullable(ipv6RdnssOpt.orElse(null));
            }
            case b: {
                Optional<LanNetworkIpv6Slaac> ipv6SlaacOpt = LanNetworkIpv6Slaac.fromDTO(lanNetworkIpv6Config.getSlaac());
                ipv6SlaacOpt.ifPresent(ipv6Slaac -> ipv6Slaac.setRa(ab.a(lanNetworkIpv6Config.getRa())));
                return Optional.ofNullable(ipv6SlaacOpt.orElse(null));
            }
            case d: {
                return Optional.ofNullable(LanNetworkIpv6Passthrough.fromDTO(lanNetworkIpv6Config.getPassthrough()).orElse(null));
            }
        }
        return Optional.empty();
    }

    public Optional<Integer> getPreIdByProto() {
        if (this.getIpv6ProtoType() == null || this.getIpv6ProtoType().getIpv6Proto() == null) {
            return Optional.empty();
        }
        switch (this.getIpv6ProtoType().getIpv6Proto()) {
            case b: {
                LanNetworkIpv6Slaac lanNetworkIpv6Slaac = (LanNetworkIpv6Slaac)this.getIpv6ProtoType();
                return Optional.ofNullable(lanNetworkIpv6Slaac.getPreId());
            }
            case c: {
                LanNetworkIpv6Rdnss lanNetworkIpv6Rdnss = (LanNetworkIpv6Rdnss)this.getIpv6ProtoType();
                return Optional.ofNullable(lanNetworkIpv6Rdnss.getPreId());
            }
        }
        return Optional.empty();
    }

    public Optional<String> getPortUuidByProto() {
        if (this.getIpv6ProtoType() == null || this.getIpv6ProtoType().getIpv6Proto() == null) {
            return Optional.empty();
        }
        switch (this.getIpv6ProtoType().getIpv6Proto()) {
            case b: {
                LanNetworkIpv6Slaac lanNetworkIpv6Slaac = (LanNetworkIpv6Slaac)this.getIpv6ProtoType();
                return Optional.ofNullable(lanNetworkIpv6Slaac.getPortUuid());
            }
            case c: {
                LanNetworkIpv6Rdnss lanNetworkIpv6Rdnss = (LanNetworkIpv6Rdnss)this.getIpv6ProtoType();
                return Optional.ofNullable(lanNetworkIpv6Rdnss.getPortUuid());
            }
            case d: {
                LanNetworkIpv6Passthrough lanNetworkIpv6Passthrough = (LanNetworkIpv6Passthrough)this.getIpv6ProtoType();
                return Optional.ofNullable(lanNetworkIpv6Passthrough.getPortUuid());
            }
        }
        return Optional.empty();
    }

    public boolean isPDMode() {
        if (this.getIpv6ProtoType() == null || this.getIpv6ProtoType().getIpv6Proto() == null) {
            return false;
        }
        switch (this.getIpv6ProtoType().getIpv6Proto()) {
            case b: {
                LanNetworkIpv6Slaac lanNetworkIpv6Slaac = (LanNetworkIpv6Slaac)this.getIpv6ProtoType();
                return Objects.equals(1, lanNetworkIpv6Slaac.getPreType());
            }
            case c: {
                LanNetworkIpv6Rdnss lanNetworkIpv6Rdnss = (LanNetworkIpv6Rdnss)this.getIpv6ProtoType();
                return Objects.equals(1, lanNetworkIpv6Rdnss.getPreType());
            }
        }
        return false;
    }

    public String getIpv6SubnetByProto() {
        if (this.getIpv6ProtoType() == null || this.getIpv6ProtoType().getIpv6Proto() == null) {
            return null;
        }
        switch (this.getIpv6ProtoType().getIpv6Proto()) {
            case a: {
                LanNetworkIpv6Dhcpv6 lanNetworkIpv6Dhcpv6 = (LanNetworkIpv6Dhcpv6)this.getIpv6ProtoType();
                return lanNetworkIpv6Dhcpv6.getGateway() + "/" + lanNetworkIpv6Dhcpv6.getSubnet();
            }
            case b: {
                LanNetworkIpv6Slaac lanNetworkIpv6Slaac = (LanNetworkIpv6Slaac)this.getIpv6ProtoType();
                if (T.a((String)lanNetworkIpv6Slaac.getPrefix())) {
                    return null;
                }
                if (this.isPDMode()) {
                    return B.a(lanNetworkIpv6Slaac.getPrefix(), (int)lanNetworkIpv6Slaac.getPreId());
                }
                return lanNetworkIpv6Slaac.getPrefix() + "/64";
            }
            case c: {
                LanNetworkIpv6Rdnss lanNetworkIpv6Rdnss = (LanNetworkIpv6Rdnss)this.getIpv6ProtoType();
                if (T.a((String)lanNetworkIpv6Rdnss.getPrefix())) {
                    return null;
                }
                if (this.isPDMode()) {
                    return B.a(lanNetworkIpv6Rdnss.getPrefix(), (int)lanNetworkIpv6Rdnss.getPreId());
                }
                return lanNetworkIpv6Rdnss.getPrefix() + "/64";
            }
        }
        return null;
    }

    public Optional<String> getPrefixByProto() {
        if (this.getIpv6ProtoType() == null || this.getIpv6ProtoType().getIpv6Proto() == null) {
            return Optional.empty();
        }
        switch (this.getIpv6ProtoType().getIpv6Proto()) {
            case b: {
                LanNetworkIpv6Slaac lanNetworkIpv6Slaac = (LanNetworkIpv6Slaac)this.getIpv6ProtoType();
                return Optional.ofNullable(lanNetworkIpv6Slaac.getPrefix());
            }
            case c: {
                LanNetworkIpv6Rdnss lanNetworkIpv6Rdnss = (LanNetworkIpv6Rdnss)this.getIpv6ProtoType();
                return Optional.ofNullable(lanNetworkIpv6Rdnss.getPrefix());
            }
        }
        return Optional.empty();
    }

    public void setPrefixByProto(String prefix) {
        if (this.getIpv6ProtoType() == null || this.getIpv6ProtoType().getIpv6Proto() == null) {
            return;
        }
        switch (this.getIpv6ProtoType().getIpv6Proto()) {
            case b: {
                LanNetworkIpv6Slaac lanNetworkIpv6Slaac = (LanNetworkIpv6Slaac)this.getIpv6ProtoType();
                lanNetworkIpv6Slaac.setPrefix(prefix);
                return;
            }
            case c: {
                LanNetworkIpv6Rdnss lanNetworkIpv6Rdnss = (LanNetworkIpv6Rdnss)this.getIpv6ProtoType();
                lanNetworkIpv6Rdnss.setPrefix(prefix);
                return;
            }
        }
    }

    public void setPortUuidByProto(String portId) {
        if (this.getIpv6ProtoType() == null || this.getIpv6ProtoType().getIpv6Proto() == null) {
            return;
        }
        switch (this.getIpv6ProtoType().getIpv6Proto()) {
            case b: {
                LanNetworkIpv6Slaac lanNetworkIpv6Slaac = (LanNetworkIpv6Slaac)this.getIpv6ProtoType();
                lanNetworkIpv6Slaac.setPortUuid(portId);
                return;
            }
            case c: {
                LanNetworkIpv6Rdnss lanNetworkIpv6Rdnss = (LanNetworkIpv6Rdnss)this.getIpv6ProtoType();
                lanNetworkIpv6Rdnss.setPortUuid(portId);
                return;
            }
            case d: {
                LanNetworkIpv6Passthrough lanNetworkIpv6Passthrough = (LanNetworkIpv6Passthrough)this.getIpv6ProtoType();
                lanNetworkIpv6Passthrough.setPortUuid(portId);
                return;
            }
        }
    }

    public boolean sameValueAs(LanNetworkIpv6Config other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    @Generated
    LanNetworkIpv6Config(Integer enable, LanNetworkIpv6ProtoType ipv6ProtoType) {
        this.enable = enable;
        this.ipv6ProtoType = ipv6ProtoType;
    }

    @Generated
    public static a builder() {
        return new a();
    }

    @Generated
    public Integer getEnable() {
        return this.enable;
    }

    @Generated
    public LanNetworkIpv6ProtoType getIpv6ProtoType() {
        return this.ipv6ProtoType;
    }

    @Generated
    public LanNetworkIpv6Config setEnable(Integer enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public LanNetworkIpv6Config setIpv6ProtoType(LanNetworkIpv6ProtoType ipv6ProtoType) {
        this.ipv6ProtoType = ipv6ProtoType;
        return this;
    }

    @Generated
    public static class a {
        @Generated
        private Integer a;
        @Generated
        private LanNetworkIpv6ProtoType b;

        @Generated
        a() {
        }

        @Generated
        public a a(Integer enable) {
            this.a = enable;
            return this;
        }

        @Generated
        public a a(LanNetworkIpv6ProtoType ipv6ProtoType) {
            this.b = ipv6ProtoType;
            return this;
        }

        @Generated
        public LanNetworkIpv6Config a() {
            return new LanNetworkIpv6Config(this.a, this.b);
        }

        @Generated
        public String toString() {
            return "LanNetworkIpv6Config.LanNetworkIpv6ConfigBuilder(enable=" + this.a + ", ipv6ProtoType=" + this.b + ")";
        }
    }
}

