/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork;

import com.tplink.smb.omada.common.e.l;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.v;
import com.tplink.smb.omada.device.manage.message.config.osg.DhcpRangeConfig;
import com.tplink.smb.omada.device.manage.message.config.osg.DhcpSettingsConfig;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.DhcpOption;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.o;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.springframework.util.CollectionUtils;

@KeepClass
public class DhcpSetting
implements l<DhcpSetting> {
    private Boolean enable;
    @Deprecated
    private String ipaddrStart;
    @Deprecated
    private String ipaddrEnd;
    private List<o> ipRangePool;
    private Long ipRangeStart;
    private Long ipRangeEnd;
    private String dhcpns;
    private String priDns;
    private String sndDns;
    private Integer leasetime;
    private String gateway;
    private String hostIP;
    private String option60;
    private String option66;
    private String option138;
    private String dhcpNextServer;
    private List<DhcpOption> options;
    private Boolean supportDhcpRangePool;

    public static DhcpSettingsConfig toConfig(DhcpSetting dhcpSetting) {
        DhcpSettingsConfig dhcpSettingsConfig = new DhcpSettingsConfig();
        if (dhcpSetting == null) {
            dhcpSettingsConfig.setEnable(Integer.valueOf(0));
            return dhcpSettingsConfig;
        }
        List<DhcpOption> options = dhcpSetting.getOptions();
        dhcpSettingsConfig.setEnable(Integer.valueOf(Boolean.TRUE.equals(dhcpSetting.getEnable()) ? 1 : 0)).setDhcpns(dhcpSetting.getDhcpns()).setPriDns(dhcpSetting.getPriDns()).setSndDns(dhcpSetting.getSndDns()).setLeasetime(dhcpSetting.getLeasetime()).setGateway(dhcpSetting.getGateway() == null ? "" : dhcpSetting.getGateway()).setHostIP(dhcpSetting.getHostIP());
        if (Boolean.TRUE.equals(dhcpSetting.getSupportDhcpRangePool())) {
            if (!CollectionUtils.isEmpty(dhcpSetting.getIpRangePool())) {
                dhcpRangeConfigs = dhcpSetting.getIpRangePool().stream().map(ipRange -> new DhcpRangeConfig().setStart(ipRange.a()).setEnd(ipRange.b())).collect(Collectors.toList());
                dhcpSettingsConfig.setIpRangePool(dhcpRangeConfigs);
            }
        } else if (!CollectionUtils.isEmpty(dhcpSetting.getIpRangePool())) {
            dhcpRangeConfigs = dhcpSetting.getIpRangePool().stream().map(ipRange -> new DhcpRangeConfig().setStart(ipRange.a()).setEnd(ipRange.b())).collect(Collectors.toList());
            dhcpSettingsConfig.setIpRangePool(dhcpRangeConfigs);
        } else {
            dhcpSettingsConfig.setIpaddrStart(dhcpSetting.getIpaddrStart());
            dhcpSettingsConfig.setIpaddrEnd(dhcpSetting.getIpaddrEnd());
        }
        if (!CollectionUtils.isEmpty(options)) {
            String option60 = null;
            String option66 = null;
            String option138 = null;
            for (DhcpOption option : options) {
                if (Objects.equals(option.getCode(), 60)) {
                    option60 = option.getValue();
                }
                if (Objects.equals(option.getCode(), 66)) {
                    option66 = option.getValue();
                }
                if (!Objects.equals(option.getCode(), 138)) continue;
                option138 = option.getValue();
            }
            dhcpSettingsConfig.setOption60(option60).setOption66(option66).setOption138(option138).setOptions(dhcpSetting.getOptions().stream().map(DhcpOption::toConfig).collect(Collectors.toList()));
        }
        dhcpSettingsConfig.setDhcpNextServer(dhcpSetting.getDhcpNextServer());
        return dhcpSettingsConfig;
    }

    public static DhcpSetting fromConfig(DhcpSettingsConfig dhcpSettingsConfig, String gatewaySubnet) {
        DhcpSetting dhcpSetting = new DhcpSetting();
        dhcpSetting.setEnable(1 == dhcpSettingsConfig.getEnable()).setDhcpns(dhcpSettingsConfig.getDhcpns()).setPriDns(dhcpSettingsConfig.getPriDns()).setSndDns(dhcpSettingsConfig.getSndDns()).setLeasetime(dhcpSettingsConfig.getLeasetime()).setGateway(dhcpSettingsConfig.getGateway()).setHostIP(dhcpSettingsConfig.getHostIP()).setIpRangePool(new ArrayList<o>());
        List dhcpRangeConfigs = dhcpSettingsConfig.getIpRangePool();
        dhcpSetting.setIpRangeStart(v.f((String)gatewaySubnet));
        dhcpSetting.setIpRangeEnd(v.g((String)gatewaySubnet));
        if (dhcpRangeConfigs == null || dhcpRangeConfigs.isEmpty()) {
            dhcpSetting.setIpaddrStart(dhcpSettingsConfig.getIpaddrStart());
            dhcpSetting.setIpaddrEnd(dhcpSettingsConfig.getIpaddrEnd());
        } else {
            List<o> ipRangePool = dhcpRangeConfigs.stream().map(dhcpRangeConfig -> new o().a(dhcpRangeConfig.getStart()).b(dhcpRangeConfig.getEnd()).a(v.b((String)dhcpRangeConfig.getStart())).b(v.b((String)dhcpRangeConfig.getEnd()))).collect(Collectors.toList());
            dhcpSetting.setIpRangePool(ipRangePool);
        }
        dhcpSetting.setDhcpNextServer(dhcpSettingsConfig.getDhcpNextServer());
        List dhcpOptionConfigs = dhcpSettingsConfig.getOptions();
        if (CollectionUtils.isEmpty((Collection)dhcpOptionConfigs)) {
            return dhcpSetting;
        }
        dhcpSetting.setOptions(dhcpOptionConfigs.stream().map(DhcpOption::fromConfig).collect(Collectors.toList()));
        return dhcpSetting;
    }

    public boolean containsCustomDhcpOption() {
        if (!CollectionUtils.isEmpty(this.options)) {
            for (DhcpOption option : this.options) {
                if (Objects.equals(option.getCode(), 60) || Objects.equals(option.getCode(), 66) || Objects.equals(option.getCode(), 138)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean sameValueAs(DhcpSetting other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Deprecated
    @Generated
    public String getIpaddrStart() {
        return this.ipaddrStart;
    }

    @Deprecated
    @Generated
    public String getIpaddrEnd() {
        return this.ipaddrEnd;
    }

    @Generated
    public List<o> getIpRangePool() {
        return this.ipRangePool;
    }

    @Generated
    public Long getIpRangeStart() {
        return this.ipRangeStart;
    }

    @Generated
    public Long getIpRangeEnd() {
        return this.ipRangeEnd;
    }

    @Generated
    public String getDhcpns() {
        return this.dhcpns;
    }

    @Generated
    public String getPriDns() {
        return this.priDns;
    }

    @Generated
    public String getSndDns() {
        return this.sndDns;
    }

    @Generated
    public Integer getLeasetime() {
        return this.leasetime;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public String getHostIP() {
        return this.hostIP;
    }

    @Generated
    public String getOption60() {
        return this.option60;
    }

    @Generated
    public String getOption66() {
        return this.option66;
    }

    @Generated
    public String getOption138() {
        return this.option138;
    }

    @Generated
    public String getDhcpNextServer() {
        return this.dhcpNextServer;
    }

    @Generated
    public List<DhcpOption> getOptions() {
        return this.options;
    }

    @Generated
    public Boolean getSupportDhcpRangePool() {
        return this.supportDhcpRangePool;
    }

    @Generated
    public DhcpSetting setEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    @Deprecated
    @Generated
    public DhcpSetting setIpaddrStart(String ipaddrStart) {
        this.ipaddrStart = ipaddrStart;
        return this;
    }

    @Deprecated
    @Generated
    public DhcpSetting setIpaddrEnd(String ipaddrEnd) {
        this.ipaddrEnd = ipaddrEnd;
        return this;
    }

    @Generated
    public DhcpSetting setIpRangePool(List<o> ipRangePool) {
        this.ipRangePool = ipRangePool;
        return this;
    }

    @Generated
    public DhcpSetting setIpRangeStart(Long ipRangeStart) {
        this.ipRangeStart = ipRangeStart;
        return this;
    }

    @Generated
    public DhcpSetting setIpRangeEnd(Long ipRangeEnd) {
        this.ipRangeEnd = ipRangeEnd;
        return this;
    }

    @Generated
    public DhcpSetting setDhcpns(String dhcpns) {
        this.dhcpns = dhcpns;
        return this;
    }

    @Generated
    public DhcpSetting setPriDns(String priDns) {
        this.priDns = priDns;
        return this;
    }

    @Generated
    public DhcpSetting setSndDns(String sndDns) {
        this.sndDns = sndDns;
        return this;
    }

    @Generated
    public DhcpSetting setLeasetime(Integer leasetime) {
        this.leasetime = leasetime;
        return this;
    }

    @Generated
    public DhcpSetting setGateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @Generated
    public DhcpSetting setHostIP(String hostIP) {
        this.hostIP = hostIP;
        return this;
    }

    @Generated
    public DhcpSetting setOption60(String option60) {
        this.option60 = option60;
        return this;
    }

    @Generated
    public DhcpSetting setOption66(String option66) {
        this.option66 = option66;
        return this;
    }

    @Generated
    public DhcpSetting setOption138(String option138) {
        this.option138 = option138;
        return this;
    }

    @Generated
    public DhcpSetting setDhcpNextServer(String dhcpNextServer) {
        this.dhcpNextServer = dhcpNextServer;
        return this;
    }

    @Generated
    public DhcpSetting setOptions(List<DhcpOption> options) {
        this.options = options;
        return this;
    }

    @Generated
    public DhcpSetting setSupportDhcpRangePool(Boolean supportDhcpRangePool) {
        this.supportDhcpRangePool = supportDhcpRangePool;
        return this;
    }

    @Generated
    public DhcpSetting() {
    }

    @Generated
    public DhcpSetting(Boolean enable, String ipaddrStart, String ipaddrEnd, List<o> ipRangePool, Long ipRangeStart, Long ipRangeEnd, String dhcpns, String priDns, String sndDns, Integer leasetime, String gateway, String hostIP, String option60, String option66, String option138, String dhcpNextServer, List<DhcpOption> options, Boolean supportDhcpRangePool) {
        this.enable = enable;
        this.ipaddrStart = ipaddrStart;
        this.ipaddrEnd = ipaddrEnd;
        this.ipRangePool = ipRangePool;
        this.ipRangeStart = ipRangeStart;
        this.ipRangeEnd = ipRangeEnd;
        this.dhcpns = dhcpns;
        this.priDns = priDns;
        this.sndDns = sndDns;
        this.leasetime = leasetime;
        this.gateway = gateway;
        this.hostIP = hostIP;
        this.option60 = option60;
        this.option66 = option66;
        this.option138 = option138;
        this.dhcpNextServer = dhcpNextServer;
        this.options = options;
        this.supportDhcpRangePool = supportDhcpRangePool;
    }

    @Generated
    public String toString() {
        return "DhcpSetting(enable=" + this.getEnable() + ", ipaddrStart=" + this.getIpaddrStart() + ", ipaddrEnd=" + this.getIpaddrEnd() + ", ipRangePool=" + this.getIpRangePool() + ", ipRangeStart=" + this.getIpRangeStart() + ", ipRangeEnd=" + this.getIpRangeEnd() + ", dhcpns=" + this.getDhcpns() + ", priDns=" + this.getPriDns() + ", sndDns=" + this.getSndDns() + ", leasetime=" + this.getLeasetime() + ", gateway=" + this.getGateway() + ", hostIP=" + this.getHostIP() + ", option60=" + this.getOption60() + ", option66=" + this.getOption66() + ", option138=" + this.getOption138() + ", dhcpNextServer=" + this.getDhcpNextServer() + ", options=" + this.getOptions() + ", supportDhcpRangePool=" + this.getSupportDhcpRangePool() + ")";
    }
}

