/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.servicesetting.dhcpreservation;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.DhcpReservationVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.DhcpOptionVO;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;

public class DhcpReservationExportDTO {
    @Pattern(regexp="^$|^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters")
    private @Pattern(regexp="^$|^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters") String description;
    @NotNull
    @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] should be a valid MAC address.")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private @NotNull @Pattern(regexp="[A-Fa-f0-9]{1}[02468aceACE]{1}([-:][A-Fa-f0-9]{2}){5}", message="Parameter [mac] should be a valid MAC address.") String mac;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="IP Setting parameter [ip] should be a valid IP address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="IP Setting parameter [ip] should be a valid IP address.") String ip;
    @NotNull
    private Boolean status;
    private String netName;
    private Boolean exportToIpMacBinding;
    @Nullable
    @PII(strategy=PIIMaskStrategy.HASH)
    private String name;
    private List<DhcpOptionVO> options;
    private String serverType;
    @a
    private String serverMac;
    private String serverStackName;

    public static DhcpReservationExportDTO buildByDhcpReservationVO(DhcpReservationVO vo, String serverStackName) {
        DhcpReservationExportDTO exportDTO = new DhcpReservationExportDTO();
        exportDTO.setDescription(vo.getDescription());
        exportDTO.setMac(vo.getMac());
        exportDTO.setIp(vo.getIp());
        exportDTO.setStatus(vo.getStatus());
        exportDTO.setNetName(vo.getNetName());
        exportDTO.setExportToIpMacBinding(vo.getExportToIpMacBinding());
        exportDTO.setName(vo.getName());
        exportDTO.setOptions(vo.getOptions());
        exportDTO.setServerType(vo.getServerType());
        exportDTO.setServerMac(vo.getServerMac());
        exportDTO.setServerStackName(serverStackName);
        return exportDTO;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public String getNetName() {
        return this.netName;
    }

    @Generated
    public Boolean getExportToIpMacBinding() {
        return this.exportToIpMacBinding;
    }

    @Nullable
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<DhcpOptionVO> getOptions() {
        return this.options;
    }

    @Generated
    public String getServerType() {
        return this.serverType;
    }

    @Generated
    public String getServerMac() {
        return this.serverMac;
    }

    @Generated
    public String getServerStackName() {
        return this.serverStackName;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setNetName(String netName) {
        this.netName = netName;
    }

    @Generated
    public void setExportToIpMacBinding(Boolean exportToIpMacBinding) {
        this.exportToIpMacBinding = exportToIpMacBinding;
    }

    @Generated
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @Generated
    public void setOptions(List<DhcpOptionVO> options) {
        this.options = options;
    }

    @Generated
    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    @Generated
    public void setServerMac(String serverMac) {
        this.serverMac = serverMac;
    }

    @Generated
    public void setServerStackName(String serverStackName) {
        this.serverStackName = serverStackName;
    }

    @Generated
    public DhcpReservationExportDTO() {
    }
}

