/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.encoder;

import com.tplink.smb.omada.common.util.b.h;
import com.tplink.smb.omada.device.manage.message.config.ap.mesh.ConfigChildAP;
import com.tplink.smb.omada.device.manage.message.config.ap.mesh.ConfigChildAPList;
import com.tplink.smb.omada.device.manage.message.config.ap.mesh.ConfigMesh;
import com.tplink.smb.omada.device.manage.message.config.ap.mesh.ConfigTargetIP;
import com.tplink.smb.omada.device.manage.message.config.ap.mesh.Mesh;
import com.tplink.smb.omada.manager.device.domain.model.device.ap.A;
import com.tplink.smb.omada.manager.device.domain.model.device.b;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class MeshBO {
    @Nonnull
    private Boolean enable;
    private Boolean autoFailoverEnable;
    private Boolean defGatewayEnable;
    private String gateway;
    private Boolean fullSector;
    @Nonnull
    private Integer operation;

    @Nonnull
    public Mesh packageSiteMeshSetting(A meshSetting, b adoptInfo, boolean wirelessLinked, boolean supportP2P) {
        Mesh mesh = new Mesh();
        mesh.setIsNewConfig(0);
        ConfigMesh configMesh = new ConfigMesh();
        if (wirelessLinked || supportP2P) {
            configMesh.setEnable(1);
        } else {
            configMesh.setEnable(this.getEnable() != false ? 1 : 0);
        }
        mesh.setConfigMesh(configMesh);
        ConfigTargetIP configTargetIP = new ConfigTargetIP();
        configTargetIP.setEnable(Boolean.TRUE.equals(this.getDefGatewayEnable()) ? 0 : 1);
        configTargetIP.setTargetIP(this.getGateway());
        mesh.setConfigTargetIP(configTargetIP);
        mesh.setFullSector(Boolean.valueOf(supportP2P ? true : this.getFullSector()));
        if (this.getOperation() == 1) {
            mesh.setIsNewConfig(1);
            ConfigChildAPList configChildAPList = MeshBO.createConfigChildAPList(meshSetting, adoptInfo);
            mesh.setConfigChildAPList(configChildAPList);
        }
        return mesh;
    }

    @Nonnull
    private static ConfigChildAPList createConfigChildAPList(@Nullable A meshSetting, b adoptInfo) {
        ConfigChildAPList configChildAPList = new ConfigChildAPList();
        if (meshSetting == null) {
            return configChildAPList;
        }
        Set<String> childApMacs = meshSetting.f();
        if (CollectionUtils.isEmpty(childApMacs)) {
            return configChildAPList;
        }
        for (String childMac : childApMacs) {
            ConfigChildAP configChildAP = new ConfigChildAP();
            configChildAP.setMac(childMac);
            configChildAP.setRadioId(Optional.ofNullable(meshSetting.g().get(childMac)).orElse(1));
            configChildAP.setAction(Integer.valueOf(1));
            if (adoptInfo != null) {
                configChildAP.setUsername(adoptInfo.a());
                configChildAP.setPassword(h.a((String)adoptInfo.b()));
            }
            configChildAPList.add((Object)configChildAP);
        }
        return configChildAPList;
    }

    @Nonnull
    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Boolean getAutoFailoverEnable() {
        return this.autoFailoverEnable;
    }

    @Generated
    public Boolean getDefGatewayEnable() {
        return this.defGatewayEnable;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public Boolean getFullSector() {
        return this.fullSector;
    }

    @Nonnull
    @Generated
    public Integer getOperation() {
        return this.operation;
    }

    @Generated
    public void setEnable(@Nonnull Boolean enable) {
        if (enable == null) {
            throw new NullPointerException("enable is marked non-null but is null");
        }
        this.enable = enable;
    }

    @Generated
    public void setAutoFailoverEnable(Boolean autoFailoverEnable) {
        this.autoFailoverEnable = autoFailoverEnable;
    }

    @Generated
    public void setDefGatewayEnable(Boolean defGatewayEnable) {
        this.defGatewayEnable = defGatewayEnable;
    }

    @Generated
    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    @Generated
    public void setFullSector(Boolean fullSector) {
        this.fullSector = fullSector;
    }

    @Generated
    public void setOperation(@Nonnull Integer operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        this.operation = operation;
    }

    @Generated
    public String toString() {
        return "MeshBO(enable=" + this.getEnable() + ", autoFailoverEnable=" + this.getAutoFailoverEnable() + ", defGatewayEnable=" + this.getDefGatewayEnable() + ", gateway=" + this.getGateway() + ", fullSector=" + this.getFullSector() + ", operation=" + this.getOperation() + ")";
    }

    @Generated
    public MeshBO() {
    }

    @Generated
    public MeshBO(@Nonnull Boolean enable, Boolean autoFailoverEnable, Boolean defGatewayEnable, String gateway, Boolean fullSector, @Nonnull Integer operation) {
        if (enable == null) {
            throw new NullPointerException("enable is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        this.enable = enable;
        this.autoFailoverEnable = autoFailoverEnable;
        this.defGatewayEnable = defGatewayEnable;
        this.gateway = gateway;
        this.fullSector = fullSector;
        this.operation = operation;
    }
}

