/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.dst;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.global.common.dto.DstDTO;
import com.tplink.smb.omada.manager.configuration.api.web.site.dst.DstEnableAndModeDTO;
import com.tplink.smb.omada.manager.configuration.api.web.site.dst.a;
import com.tplink.smb.omada.manager.configuration.domain.model.site.dst.Dst;
import com.tplink.smb.omada.manager.configuration.domain.model.site.dst.DstTime;
import com.tplink.smb.omada.manager.configuration.domain.shared.y;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder
@KeepClass
public class DstInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DstInfo.class);
    private Boolean status;
    private Boolean enable;
    private Integer mode;
    private Long startTime;
    private Long endTime;
    private Long offset;
    private Long nextExcute;
    private Long nextStart;
    private Long nextEnd;
    private Long lastStart;
    private Long lastEnd;

    public boolean needDstOffset(long currentTime) {
        return (Boolean.TRUE.equals(this.enable) || a.b.a().equals(this.mode) || a.c.a().equals(this.mode)) && (currentTime > this.startTime && currentTime < this.endTime || currentTime > this.lastStart && currentTime < this.lastEnd || currentTime > this.nextStart && currentTime < this.nextEnd);
    }

    public static DstInfo defaultDstInfo() {
        return new DstInfo(false, false, 0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    public static DstInfo defaultAutoOffDstInfo() {
        return new DstInfo(false, false, 1, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    public static DstInfo fromDst(Dst dst, String timeZoneId) {
        long nextExcute;
        if (Objects.isNull(dst)) {
            return DstInfo.defaultDstInfo();
        }
        Boolean enable = dst.getEnable();
        Integer mode = dst.getMode();
        DstEnableAndModeDTO dstEnableAndModeDTO = a.a((Boolean)enable, (Integer)mode, (Boolean)dst.nullDataResolve());
        enable = dstEnableAndModeDTO.getEnable();
        mode = dstEnableAndModeDTO.getMode();
        if (a.a.a().equals(mode)) {
            return DstInfo.defaultDstInfo();
        }
        if (!Boolean.TRUE.equals(enable) && a.b.a().equals(mode)) {
            return DstInfo.defaultAutoOffDstInfo();
        }
        log.debug("AUTO DST dst {} , timeZoneId {}", (Object)x.a((Object)dst), (Object)timeZoneId);
        long nowTime = System.currentTimeMillis();
        long startTime = y.a(dst.getStart(), timeZoneId);
        long endTime = y.a(dst.getEnd(), timeZoneId) - dst.getOffset();
        long nextYearStart = nextExcute = y.a(dst.getStart(), timeZoneId, 1);
        long nextYearEnd = y.a(dst.getEnd(), timeZoneId, 1) - dst.getOffset();
        long lastStart = y.a(dst.getStart(), timeZoneId, -1);
        long lastEnd = y.a(dst.getEnd(), timeZoneId, -1) - dst.getOffset();
        if (endTime <= startTime) {
            if (nowTime >= startTime) {
                endTime = y.a(dst.getEnd(), timeZoneId, 1) - dst.getOffset();
                nextYearEnd = y.a(dst.getEnd(), timeZoneId, 2) - dst.getOffset();
                lastEnd = y.a(dst.getEnd(), timeZoneId) - dst.getOffset();
            } else {
                nextExcute = startTime;
                startTime = y.a(dst.getStart(), timeZoneId, -1);
                nextYearStart = nextExcute;
                lastStart = y.a(dst.getStart(), timeZoneId, -2);
            }
        } else if (nowTime < startTime) {
            nextExcute = startTime;
            nextYearStart = startTime;
            nextYearEnd = endTime;
            startTime = y.a(dst.getStart(), timeZoneId, -1);
            endTime = y.a(dst.getEnd(), timeZoneId, -1) - dst.getOffset();
            lastStart = y.a(dst.getStart(), timeZoneId, -2);
            lastEnd = y.a(dst.getEnd(), timeZoneId, -2) - dst.getOffset();
        }
        boolean dstStatus = nowTime >= startTime && nowTime <= endTime;
        return new DstInfo(dstStatus, true, mode, startTime, endTime, dst.getOffset(), nextExcute, nextYearStart, nextYearEnd, lastStart, lastEnd);
    }

    public static DstInfo fromDstDTO(DstDTO dstDTO, String timeZoneId) {
        boolean defaultDstInfo;
        boolean bl2 = defaultDstInfo = Objects.isNull(dstDTO) || (Objects.isNull(dstDTO.getStart()) || Objects.isNull(dstDTO.getEnd())) && a.a.a().equals(dstDTO.getMode());
        if (defaultDstInfo) {
            return DstInfo.defaultDstInfo();
        }
        if ((Objects.isNull(dstDTO.getStart()) || Objects.isNull(dstDTO.getEnd())) && a.b.a().equals(dstDTO.getMode())) {
            return DstInfo.defaultAutoOffDstInfo();
        }
        Object dst = ((Dst.a)((Dst.a)((Dst.a)((Dst.a)((Dst.a)Dst.builder().a(dstDTO.getEnable())).a(dstDTO.getMode())).a(dstDTO.getOffset())).a(DstTime.builder().a(dstDTO.getStart().getMonth()).b(dstDTO.getStart().getSerial()).c(dstDTO.getStart().getDay()).d(dstDTO.getStart().getHour()).e(dstDTO.getStart().getMinute()).a())).b(DstTime.builder().a(dstDTO.getEnd().getMonth()).b(dstDTO.getEnd().getSerial()).c(dstDTO.getEnd().getDay()).d(dstDTO.getEnd().getHour()).e(dstDTO.getEnd().getMinute()).a())).b();
        return DstInfo.fromDst(dst, timeZoneId);
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setOffset(Long offset) {
        this.offset = offset;
    }

    @Generated
    public void setNextExcute(Long nextExcute) {
        this.nextExcute = nextExcute;
    }

    @Generated
    public void setNextStart(Long nextStart) {
        this.nextStart = nextStart;
    }

    @Generated
    public void setNextEnd(Long nextEnd) {
        this.nextEnd = nextEnd;
    }

    @Generated
    public void setLastStart(Long lastStart) {
        this.lastStart = lastStart;
    }

    @Generated
    public void setLastEnd(Long lastEnd) {
        this.lastEnd = lastEnd;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public Long getStartTime() {
        return this.startTime;
    }

    @Generated
    public Long getEndTime() {
        return this.endTime;
    }

    @Generated
    public Long getOffset() {
        return this.offset;
    }

    @Generated
    public Long getNextExcute() {
        return this.nextExcute;
    }

    @Generated
    public Long getNextStart() {
        return this.nextStart;
    }

    @Generated
    public Long getNextEnd() {
        return this.nextEnd;
    }

    @Generated
    public Long getLastStart() {
        return this.lastStart;
    }

    @Generated
    public Long getLastEnd() {
        return this.lastEnd;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof DstInfo)) {
            return false;
        }
        DstInfo other = (DstInfo)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$status = this.getStatus();
        Boolean other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        Integer this$mode = this.getMode();
        Integer other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)this$mode).equals(other$mode)) {
            return false;
        }
        Long this$startTime = this.getStartTime();
        Long other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Long this$endTime = this.getEndTime();
        Long other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Long this$offset = this.getOffset();
        Long other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Long this$nextExcute = this.getNextExcute();
        Long other$nextExcute = other.getNextExcute();
        if (this$nextExcute == null ? other$nextExcute != null : !((Object)this$nextExcute).equals(other$nextExcute)) {
            return false;
        }
        Long this$nextStart = this.getNextStart();
        Long other$nextStart = other.getNextStart();
        if (this$nextStart == null ? other$nextStart != null : !((Object)this$nextStart).equals(other$nextStart)) {
            return false;
        }
        Long this$nextEnd = this.getNextEnd();
        Long other$nextEnd = other.getNextEnd();
        if (this$nextEnd == null ? other$nextEnd != null : !((Object)this$nextEnd).equals(other$nextEnd)) {
            return false;
        }
        Long this$lastStart = this.getLastStart();
        Long other$lastStart = other.getLastStart();
        if (this$lastStart == null ? other$lastStart != null : !((Object)this$lastStart).equals(other$lastStart)) {
            return false;
        }
        Long this$lastEnd = this.getLastEnd();
        Long other$lastEnd = other.getLastEnd();
        return !(this$lastEnd == null ? other$lastEnd != null : !((Object)this$lastEnd).equals(other$lastEnd));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DstInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        Integer $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)$mode).hashCode());
        Long $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Long $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Long $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Long $nextExcute = this.getNextExcute();
        result = result * 59 + ($nextExcute == null ? 43 : ((Object)$nextExcute).hashCode());
        Long $nextStart = this.getNextStart();
        result = result * 59 + ($nextStart == null ? 43 : ((Object)$nextStart).hashCode());
        Long $nextEnd = this.getNextEnd();
        result = result * 59 + ($nextEnd == null ? 43 : ((Object)$nextEnd).hashCode());
        Long $lastStart = this.getLastStart();
        result = result * 59 + ($lastStart == null ? 43 : ((Object)$lastStart).hashCode());
        Long $lastEnd = this.getLastEnd();
        result = result * 59 + ($lastEnd == null ? 43 : ((Object)$lastEnd).hashCode());
        return result;
    }

    @Generated
    public DstInfo() {
    }

    @Generated
    public DstInfo(Boolean status, Boolean enable, Integer mode, Long startTime, Long endTime, Long offset, Long nextExcute, Long nextStart, Long nextEnd, Long lastStart, Long lastEnd) {
        this.status = status;
        this.enable = enable;
        this.mode = mode;
        this.startTime = startTime;
        this.endTime = endTime;
        this.offset = offset;
        this.nextExcute = nextExcute;
        this.nextStart = nextStart;
        this.nextEnd = nextEnd;
        this.lastStart = lastStart;
        this.lastEnd = lastEnd;
    }
}

