/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.ldap;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.ldap.LdapConnectionCacheQueryDTO;
import com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.ldap.t;
import com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.ldap.u;
import com.tplink.smb.omada.manager.j.a.a.c;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapEntryIdentificationContextMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.stereotype.Component;

@Component
public class s {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(s.class);
    private static final String b = "ldap://";
    private static final String c = "ldaps://";
    private static final Cache<LdapConnectionCacheQueryDTO, LdapTemplate> d = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofSeconds(180L)).removalListener(rl -> {
        try {
            a.info("[OmadacId:{},SiteId:{}] Disconnect LDAPConnection {}", new Object[]{((LdapConnectionCacheQueryDTO)rl.getKey()).getOmadacId(), ((LdapConnectionCacheQueryDTO)rl.getKey()).getSiteId(), rl.getValue()});
        }
        catch (Exception e2) {
            a.error(e2.getMessage(), (Throwable)e2);
        }
    }).build();

    public OperationResponse a(@Nonnull c omadacId, @Nonnull String server, @Nonnull Integer port, @Nonnull Boolean useSsl, @Nullable String baseDn, @Nullable String regularDn, @Nullable String regularPassword) {
        if (T.a((String)regularDn) && T.b((String)regularPassword) || T.b((String)regularDn) && T.a((String)regularPassword)) {
            return OperationResponse.PARAM_ERROR;
        }
        LdapTemplate ldapConnection = this.a(omadacId, server, port, useSsl, regularDn, regularPassword);
        if (ldapConnection == null) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Lo);
        }
        ArrayList<String> contentList = new ArrayList<String>();
        try {
            if (baseDn == null) {
                String baseNameSearchKey = "namingContexts";
                String rootDn = (String)ldapConnection.lookup("", new String[]{baseNameSearchKey}, (AttributesMapper)new t(this, baseNameSearchKey));
                if (rootDn == null) {
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.Lp);
                }
                contentList.add(rootDn);
            } else {
                int searchScope = 1;
                List entries = ldapConnection.search(baseDn, "objectClass=*", searchScope, null, (ContextMapper)new LdapEntryIdentificationContextMapper());
                contentList.addAll(entries.stream().filter(entry -> entry.getAbsoluteName() != null).map(entry -> entry.getAbsoluteName().toString()).collect(Collectors.toList()));
            }
        }
        catch (Exception e2) {
            a.error(e2.getMessage(), (Throwable)e2);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Lp);
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, contentList);
    }

    public LdapTemplate a(c omadacId, String server, Integer port, Boolean useSsl, String regularDn, String regularPassword) {
        d.cleanUp();
        try {
            LdapConnectionCacheQueryDTO ldapDTO = new LdapConnectionCacheQueryDTO();
            ldapDTO.setOmadacId(omadacId.a());
            ldapDTO.setServer(server);
            ldapDTO.setPort(port);
            ldapDTO.setUseSsl(useSsl);
            ldapDTO.setRegularDn(regularDn);
            ldapDTO.setRegularPassword(regularPassword);
            return (LdapTemplate)d.get((Object)ldapDTO, () -> {
                boolean isRegular = T.b((String)regularDn) && T.b((String)regularPassword);
                System.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", "true");
                LdapContextSource contextSource = new LdapContextSource();
                String header = b;
                if (Boolean.TRUE.equals(useSsl)) {
                    contextSource = new u();
                    header = c;
                }
                HashMap<String, String> config = new HashMap<String, String>();
                contextSource.setUrl(header + server + ":" + port);
                config.put("java.naming.ldap.attributes.binary", "objectGUID");
                if (isRegular) {
                    config.put("java.naming.security.principal", regularDn);
                    config.put("java.naming.security.credentials", regularPassword);
                }
                contextSource.setPooled(true);
                contextSource.setBaseEnvironmentProperties(config);
                if (!isRegular) {
                    contextSource.setAnonymousReadOnly(true);
                }
                contextSource.afterPropertiesSet();
                return new LdapTemplate((ContextSource)contextSource);
            });
        }
        catch (Exception e2) {
            a.error("[OmadacId:{}] Failed to connection to LDAP server {}:{}", new Object[]{omadacId.a(), server, port, e2});
            return null;
        }
    }
}

