/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.authentication.ldap.googleldap;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeepClass
public class CrtKeySslSocketFactory
extends SSLSocketFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CrtKeySslSocketFactory.class);
    private static final ThreadLocal<String> CRT_THREAD = new ThreadLocal();
    private static final ThreadLocal<String> KEY_THREAD = new ThreadLocal();
    private static final ThreadLocal<String> PWD_THREAD = new ThreadLocal();
    public static final int TIMEOUT = 10000;
    private final SSLSocketFactory sslSocketFactory;

    public static void setThread(String crtContent, String keyContent, String password) {
        CRT_THREAD.set(crtContent);
        KEY_THREAD.set(keyContent);
        PWD_THREAD.set(password);
        log.debug("SetThread in CrtKeySslSocketFactory, threads:{}, {}, {}", new Object[]{CRT_THREAD, KEY_THREAD, PWD_THREAD});
    }

    public static void removeThread() {
        log.debug("Prepare to remove threads after handling :{}, {}, {}", new Object[]{CRT_THREAD, KEY_THREAD, PWD_THREAD});
        CRT_THREAD.remove();
        KEY_THREAD.remove();
        PWD_THREAD.remove();
        log.debug("Removed threads after handling :{}, {}, {}", new Object[]{CRT_THREAD, KEY_THREAD, PWD_THREAD});
    }

    private CrtKeySslSocketFactory(String crtContent, String keyContent, String password) {
        this.sslSocketFactory = CrtKeySslSocketFactory.getSocketFactory(crtContent, keyContent, password);
    }

    public static SocketFactory getDefault() {
        return new CrtKeySslSocketFactory(CRT_THREAD.get(), KEY_THREAD.get(), PWD_THREAD.get());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static SSLSocketFactory getSocketFactory(String crtContent, String keyContent, String password) {
        try (ByteArrayInputStream crtInputStream = new ByteArrayInputStream(crtContent.getBytes(StandardCharsets.UTF_8));){
            SSLSocketFactory sSLSocketFactory;
            try (ByteArrayInputStream keyInputStream = new ByteArrayInputStream(keyContent.getBytes(StandardCharsets.UTF_8));){
                KeyPair key;
                Security.addProvider((Provider)new BouncyCastleProvider());
                CertificateFactory cf2 = CertificateFactory.getInstance("X.509");
                PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(keyInputStream));
                Object object = pemParser.readObject();
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
                if (object instanceof PEMEncryptedKeyPair) {
                    log.info("Encrypted key - we will use provided password");
                    key = converter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(decProv));
                } else if (object instanceof PrivateKeyInfo) {
                    key = converter.getKeyPair(CrtKeySslSocketFactory.a((PrivateKeyInfo)object));
                } else {
                    log.info("Unencrypted key - no password needed");
                    key = converter.getKeyPair((PEMKeyPair)object);
                }
                pemParser.close();
                X509Certificate cert = null;
                while (((InputStream)crtInputStream).available() > 0) {
                    cert = (X509Certificate)cf2.generateCertificate(crtInputStream);
                }
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null, null);
                ks.setCertificateEntry("certificate", cert);
                ks.setKeyEntry("private-key", key.getPrivate(), password.toCharArray(), new Certificate[]{cert});
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, password.toCharArray());
                SSLContext context = SSLContext.getInstance("TLSv1.2");
                context.init(kmf.getKeyManagers(), null, null);
                sSLSocketFactory = context.getSocketFactory();
            }
            return sSLSocketFactory;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e2) {
            log.error("Exception in getSocketFactory : ", (Throwable)e2);
            return null;
        }
    }

    private static PEMKeyPair a(PrivateKeyInfo privateKeyInfo) throws IOException {
        ASN1Encodable asn1PrivateKey = privateKeyInfo.parsePrivateKey();
        RSAPrivateKey keyStruct = RSAPrivateKey.getInstance((Object)asn1PrivateKey);
        RSAPublicKey pubSpec = new RSAPublicKey(keyStruct.getModulus(), keyStruct.getPublicExponent());
        AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
        return new PEMKeyPair(new SubjectPublicKeyInfo(algId, (ASN1Encodable)pubSpec), new PrivateKeyInfo(algId, (ASN1Encodable)keyStruct));
    }

    @Override
    public Socket createSocket(Socket s2, String host, int port, boolean autoClose) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(s2, host, port, autoClose);
        socket.setSoTimeout(10000);
        return socket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(host, port);
        socket.setSoTimeout(10000);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(host, port);
        socket.setSoTimeout(10000);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(localHost, port, localHost, localPort);
        socket.setSoTimeout(10000);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(address, port, localAddress, localPort);
        socket.setSoTimeout(10000);
        return socket;
    }
}

