/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.site.active;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.omada.common.util.K;
import com.tplink.smb.omada.manager.configuration.domain.model.site.active.ActiveSiteCacheProperties;
import com.tplink.smb.omada.manager.j.a.a.c;
import com.tplink.smb.omada.manager.j.a.a.d;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@com.tplink.smb.omada.common.spring.b
public abstract class AbstractActiveSiteCacheImpl
implements com.tplink.smb.omada.manager.configuration.domain.model.site.active.a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(AbstractActiveSiteCacheImpl.class);
    private static final String b = com.tplink.smb.omada.common.cache.a.a((String)"manager.config", (String)"active.sites.daily");
    private static final String c = com.tplink.smb.omada.common.cache.a.a((String)"manager.config", (String)"active.sites.weekly");
    @Autowired
    private ActiveSiteCacheProperties d;
    @Autowired
    private CacheService e;
    private static final Object f = new Object();
    private final Map<OmadacIdSiteIdPO, Object> g = new ConcurrentHashMap<OmadacIdSiteIdPO, Object>();

    protected abstract int a();

    protected static String a(@Nonnull String siteId, int totalPartitions, a timestamp) {
        int partition = siteId.hashCode() & totalPartitions - 1;
        return AbstractActiveSiteCacheImpl.a(partition, timestamp);
    }

    protected static String a(@Nonnull String siteId, int totalPartitions, b timestamp) {
        int partition = siteId.hashCode() & totalPartitions - 1;
        return AbstractActiveSiteCacheImpl.a(partition, timestamp);
    }

    protected static String a(int partitionIdx, a timestamp) {
        return new StringJoiner(":").add("partition").add(String.valueOf(partitionIdx)).add("date").add(K.b((long)timestamp.a())).toString();
    }

    protected static String a(int partitionIdx, b timestamp) {
        return new StringJoiner(":").add("partition").add(String.valueOf(partitionIdx)).add("week").add(K.a((long)timestamp.a())).toString();
    }

    @PostConstruct
    public void b() {
        if (this.d.getFlushInterval().equals(Duration.ZERO)) {
            a.info("ActiveSitesCache period flush buf is disabled.");
            return;
        }
        long millis = this.d.getFlushInterval().toMillis();
        a.info("Scheduled ActiveSitesCache period flush buf task at fixed rate of {} millis.", (Object)millis);
        com.tplink.smb.omada.common.concurrent.thread.b.b(() -> {
            a.trace("Starting to flush buffed active ids {}", this.g);
            try {
                this.c();
            }
            catch (Exception e2) {
                a.warn("Failed to execute ActiveSiteCache.flushBuf()", (Throwable)e2);
            }
        }, (long)millis, (long)millis, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public void a(c omadacId, d siteId) {
        if (this.d.getFlushInterval().equals(Duration.ZERO)) {
            a.trace("Saving OmadacId: {}, SiteId: {} into ActiveSitesCache buf directly", (Object)omadacId, (Object)siteId);
            int partitions = this.a();
            Set<OmadacIdSiteIdPO> set = Collections.singleton(new OmadacIdSiteIdPO(omadacId, siteId));
            String dailyCacheKey = AbstractActiveSiteCacheImpl.a(siteId.a(), partitions, new a());
            this.a(dailyCacheKey, set);
            String weeklyCacheKey = AbstractActiveSiteCacheImpl.a(siteId.a(), partitions, new b());
            this.b(weeklyCacheKey, set);
        } else {
            a.trace("Putting OmadacId: {}, SiteId: {} into ActiveSitesCache buf", (Object)omadacId, (Object)siteId);
            this.g.put(new OmadacIdSiteIdPO(omadacId, siteId), f);
        }
    }

    @Override
    public Map<String, Set<String>> a(int partition) {
        a.debug("Getting ActiveSites of Today by partition: {}", (Object)partition);
        long currentSec = System.currentTimeMillis() / 1000L;
        long yesterdayEndSec = AbstractActiveSiteCacheImpl.d();
        HashSet yesterdaySet = new HashSet();
        long delta = currentSec - yesterdayEndSec;
        if (delta > 0L && delta < this.d.getDailyWarmingUpWindow().getSeconds()) {
            a.debug("Getting ActiveSites of Today by partition: {}. Currently within warming up window: {} seconds, need fetch both yesterday and today", (Object)partition, (Object)this.d.getDailyWarmingUpWindow().getSeconds());
            yesterdaySet = new HashSet(this.e.getSet(b, AbstractActiveSiteCacheImpl.a(partition, new a(yesterdayEndSec * 1000L)), OmadacIdSiteIdPO.class));
            a.debug("Fetched Yesterday's set by partition: {}, result: {}", (Object)partition, yesterdaySet);
        }
        HashSet todaySet = new HashSet(this.e.getSet(b, AbstractActiveSiteCacheImpl.a(partition, new a()), OmadacIdSiteIdPO.class));
        a.debug("Fetched Today's set by partition: {}, result: {}", (Object)partition, todaySet);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        todaySet.forEach(po -> result.computeIfAbsent(po.getOmadacId(), k2 -> new HashSet()).add(po.getSiteId()));
        yesterdaySet.forEach(po -> result.computeIfAbsent(po.getOmadacId(), k2 -> new HashSet()).add(po.getSiteId()));
        a.debug("Fetched active sites of day by partition: {}, result: {}", (Object)partition, result);
        return result;
    }

    @Override
    public Map<String, Set<String>> b(int partition) {
        HashSet lastWeekSet = new HashSet(this.e.getSet(c, AbstractActiveSiteCacheImpl.a(partition, new b(AbstractActiveSiteCacheImpl.e() * 1000L)), OmadacIdSiteIdPO.class));
        a.debug("Fetched Last Week's set by partition: {}, result: {}", (Object)partition, lastWeekSet);
        HashSet thisWeekSet = new HashSet(this.e.getSet(c, AbstractActiveSiteCacheImpl.a(partition, new b()), OmadacIdSiteIdPO.class));
        a.debug("Fetched This Week's set by partition: {}, result: {}", (Object)partition, thisWeekSet);
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        thisWeekSet.forEach(po -> result.computeIfAbsent(po.getOmadacId(), k2 -> new HashSet()).add(po.getSiteId()));
        lastWeekSet.forEach(po -> result.computeIfAbsent(po.getOmadacId(), k2 -> new HashSet()).add(po.getSiteId()));
        a.debug("Fetched active sites of week by partition: {}, result: {}", (Object)partition, result);
        return result;
    }

    protected void c() {
        int partitions = this.a();
        HashMap<String, Set> dailyTargetMap = new HashMap<String, Set>();
        HashMap<String, Set> weeklyTargetMap = new HashMap<String, Set>();
        Iterator<Map.Entry<OmadacIdSiteIdPO, Object>> iterator = this.g.entrySet().iterator();
        while (iterator.hasNext()) {
            OmadacIdSiteIdPO omadacIdSiteIdPO = iterator.next().getKey();
            String omadacId = omadacIdSiteIdPO.getOmadacId();
            String siteId = omadacIdSiteIdPO.getSiteId();
            String dailyCacheKey = AbstractActiveSiteCacheImpl.a(siteId, partitions, new a());
            String weeklyCacheKey = AbstractActiveSiteCacheImpl.a(siteId, partitions, new b());
            dailyTargetMap.computeIfAbsent(dailyCacheKey, k2 -> new HashSet()).add(omadacIdSiteIdPO);
            weeklyTargetMap.computeIfAbsent(weeklyCacheKey, k2 -> new HashSet()).add(omadacIdSiteIdPO);
            iterator.remove();
            a.debug("Removed <OmadacId:{}, SiteId:{}> from buf, need write to cache", (Object)omadacId, (Object)siteId);
        }
        dailyTargetMap.forEach(this::a);
        weeklyTargetMap.forEach(this::b);
    }

    private void a(String dailyCacheKey, Set<OmadacIdSiteIdPO> set) {
        try {
            this.e.getSet(b, dailyCacheKey, OmadacIdSiteIdPO.class).addAll(set);
            if (a.isTraceEnabled()) {
                a.trace("Successfully updated cache {}:{} with values {}", new Object[]{b, dailyCacheKey, set});
            }
            this.e.expireKey(b, dailyCacheKey, this.d.getDailyKeepAlive().getSeconds(), TimeUnit.SECONDS);
            if (a.isTraceEnabled()) {
                a.trace("Successfully set expiration of {}:{} with {} seconds", new Object[]{b, dailyCacheKey, this.d.getDailyKeepAlive().getSeconds()});
            }
        }
        catch (Exception e2) {
            a.warn("Failed to flush {}, {} to {}", new Object[]{dailyCacheKey, set, b, e2});
        }
    }

    private void b(String cacheKey, Set<OmadacIdSiteIdPO> set) {
        try {
            this.e.getSet(c, cacheKey, OmadacIdSiteIdPO.class).addAll(set);
            if (a.isTraceEnabled()) {
                a.trace("Successfully updated cache {}:{} with values {}", new Object[]{c, cacheKey, set});
            }
            this.e.expireKey(c, cacheKey, this.d.getWeeklyKeepAlive().getSeconds(), TimeUnit.SECONDS);
            if (a.isTraceEnabled()) {
                a.trace("Successfully set expiration of {}:{} with {} seconds", new Object[]{c, cacheKey, this.d.getDailyKeepAlive().getSeconds()});
            }
        }
        catch (Exception e2) {
            a.warn("Failed to flush {}, {} to {}", new Object[]{cacheKey, set, c, e2});
        }
    }

    private static long d() {
        return LocalDate.now(ZoneOffset.UTC).atStartOfDay().toEpochSecond(ZoneOffset.UTC) - 1L;
    }

    private static long e() {
        return LocalDate.now(ZoneOffset.UTC).atStartOfDay().with(ChronoField.DAY_OF_WEEK, DayOfWeek.MONDAY.getValue()).toEpochSecond(ZoneOffset.UTC) - 1L;
    }

    private static class a {
        public static final int a = 999999999;
        private final long b;

        public a() {
            this.b = LocalDateTime.ofInstant(Instant.now(), ZoneOffset.UTC).withHour(23).withMinute(59).withSecond(59).withNano(999999999).toEpochSecond(ZoneOffset.UTC);
        }

        public a(long anyMillis) {
            this.b = LocalDateTime.ofEpochSecond(TimeUnit.MILLISECONDS.toSeconds(anyMillis), 999999999, ZoneOffset.UTC).withHour(23).withMinute(59).withSecond(59).toEpochSecond(ZoneOffset.UTC);
        }

        public long a() {
            return this.b;
        }
    }

    private static class b {
        public static final int a = 999999999;
        private final long b;

        public b() {
            this.b = LocalDateTime.ofInstant(Instant.now(), ZoneOffset.UTC).with(ChronoField.DAY_OF_WEEK, DayOfWeek.SUNDAY.getValue()).withHour(23).withMinute(59).withSecond(59).withNano(999999999).toEpochSecond(ZoneOffset.UTC);
        }

        public b(long anyMillis) {
            this.b = LocalDateTime.ofEpochSecond(TimeUnit.MILLISECONDS.toSeconds(anyMillis), 999999999, ZoneOffset.UTC).with(ChronoField.DAY_OF_WEEK, DayOfWeek.SUNDAY.getValue()).withHour(23).withMinute(59).withSecond(59).toEpochSecond(ZoneOffset.UTC);
        }

        public long a() {
            return this.b;
        }
    }

    @JsonPropertyOrder(value={"omadacId", "siteId"})
    private static class OmadacIdSiteIdPO {
        @JsonProperty(value="omadacId")
        private String omadacId;
        @JsonProperty(value="siteId")
        private String siteId;

        public OmadacIdSiteIdPO(c omadacId, d siteId) {
            this.omadacId = omadacId.a();
            this.siteId = siteId.a();
        }

        @Generated
        public String getOmadacId() {
            return this.omadacId;
        }

        @Generated
        public String getSiteId() {
            return this.siteId;
        }

        @JsonProperty(value="omadacId")
        @Generated
        public void setOmadacId(String omadacId) {
            this.omadacId = omadacId;
        }

        @JsonProperty(value="siteId")
        @Generated
        public void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Generated
        public String toString() {
            return "AbstractActiveSiteCacheImpl.OmadacIdSiteIdPO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ")";
        }

        @Generated
        public OmadacIdSiteIdPO() {
        }

        @Generated
        public OmadacIdSiteIdPO(String omadacId, String siteId) {
            this.omadacId = omadacId;
            this.siteId = siteId;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof OmadacIdSiteIdPO)) {
                return false;
            }
            OmadacIdSiteIdPO other = (OmadacIdSiteIdPO)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$omadacId = this.getOmadacId();
            String other$omadacId = other.getOmadacId();
            if (this$omadacId == null ? other$omadacId != null : !this$omadacId.equals(other$omadacId)) {
                return false;
            }
            String this$siteId = this.getSiteId();
            String other$siteId = other.getSiteId();
            return !(this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OmadacIdSiteIdPO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $omadacId = this.getOmadacId();
            result = result * 59 + ($omadacId == null ? 43 : $omadacId.hashCode());
            String $siteId = this.getSiteId();
            result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
            return result;
        }
    }
}

