/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.omadac.migrate.dto;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.nbu.common.pii.utils.PIIJacksonUtil;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.constant.DeviceStatusEnum;
import com.tplink.smb.omada.manager.configuration.api.web.omadac.global.migrate.MigrateVO;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.b.c;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.d;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MigrateDeviceDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrateDeviceDTO.class);
    private String type;
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String mac;
    @PII(strategy=PIIMaskStrategy.HASH)
    private String name;
    private String model;
    private String modelVersion;
    private String showModel;
    private String site;
    private String siteName;
    private boolean isMigrating;
    private boolean isConnected;
    private DeviceStatusEnum status;
    private Boolean stackMaster;
    private Boolean stackSlave;
    @Nullable
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private G stackMasterMac;
    @Nullable
    private String stackId;

    public static MigrateDeviceDTO fromDeviceImage(d deviceImage, Map<com.tplink.smb.omada.manager.j.a.a.d, String> siteNameMap) {
        c oswImage;
        MigrateDeviceDTO migrateDeviceDTO = new MigrateDeviceDTO();
        migrateDeviceDTO.setType(deviceImage.an().b());
        migrateDeviceDTO.setMac(deviceImage.al().a());
        migrateDeviceDTO.setName(deviceImage.aw());
        migrateDeviceDTO.setModel(deviceImage.aX().s());
        migrateDeviceDTO.setModelVersion(deviceImage.aX().t());
        migrateDeviceDTO.setShowModel(deviceImage.aX().A());
        migrateDeviceDTO.setSite(deviceImage.ap().a());
        migrateDeviceDTO.setSiteName(siteNameMap.get(deviceImage.ap()));
        migrateDeviceDTO.setMigrating(deviceImage.at().i());
        migrateDeviceDTO.setConnected(deviceImage.t());
        migrateDeviceDTO.setStatus(deviceImage.at());
        if (deviceImage instanceof c && (oswImage = (c)deviceImage).bF() != null) {
            migrateDeviceDTO.setStackMaster(Boolean.TRUE.equals(oswImage.bF().g()));
            migrateDeviceDTO.setStackSlave(Boolean.FALSE.equals(oswImage.bF().g()));
            migrateDeviceDTO.setStackMasterMac(oswImage.bq());
            migrateDeviceDTO.setStackId(oswImage.bF().c());
        }
        return migrateDeviceDTO;
    }

    public static MigrateVO toVO(MigrateDeviceDTO deviceDTO, boolean isSiteMigrate, boolean isDeviceForget) {
        MigrateVO migrateVO = new MigrateVO();
        if (isDeviceForget) {
            if (!deviceDTO.isMigrating()) {
                log.info("mac: {} is not migrate, status: {}", (Object)deviceDTO.getMac(), (Object)deviceDTO.getStatus());
                return null;
            }
        } else if (!deviceDTO.isConnected()) {
            log.info("mac: {} is not connected, status: {}", (Object)deviceDTO.getMac(), (Object)deviceDTO.getStatus());
            return null;
        }
        migrateVO.setType(deviceDTO.getType());
        migrateVO.setName(deviceDTO.getName());
        migrateVO.setMac(deviceDTO.getMac());
        if (!isSiteMigrate) {
            migrateVO.setSiteName(deviceDTO.getSiteName());
        }
        migrateVO.setStatusCategory(Integer.valueOf(deviceDTO.getStatus().l().b()));
        migrateVO.setStatus(Integer.valueOf(deviceDTO.getStatus().n()));
        migrateVO.setModel(deviceDTO.getModel());
        migrateVO.setModelVersion(deviceDTO.getModelVersion());
        migrateVO.setShowModel(deviceDTO.getShowModel());
        migrateVO.setSiteId(deviceDTO.getSite());
        return migrateVO;
    }

    public static List<MigrateVO> toVOs(List<MigrateDeviceDTO> devices, boolean isSiteMigrate, boolean isDeviceForget) {
        ArrayList<MigrateVO> migrateVOList = new ArrayList<MigrateVO>();
        if (CollectionUtils.isEmpty(devices)) {
            return migrateVOList;
        }
        for (MigrateDeviceDTO deviceDTO : devices) {
            MigrateVO migrateVO = MigrateDeviceDTO.toVO(deviceDTO, isSiteMigrate, isDeviceForget);
            if (migrateVO == null) continue;
            migrateVOList.add(migrateVO);
        }
        return migrateVOList;
    }

    public String toString() {
        return PIIJacksonUtil.parseToStr((Object)this);
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public String getShowModel() {
        return this.showModel;
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public String getSiteName() {
        return this.siteName;
    }

    @Generated
    public boolean isMigrating() {
        return this.isMigrating;
    }

    @Generated
    public boolean isConnected() {
        return this.isConnected;
    }

    @Generated
    public DeviceStatusEnum getStatus() {
        return this.status;
    }

    @Generated
    public Boolean getStackMaster() {
        return this.stackMaster;
    }

    @Generated
    public Boolean getStackSlave() {
        return this.stackSlave;
    }

    @Nullable
    @Generated
    public G getStackMasterMac() {
        return this.stackMasterMac;
    }

    @Nullable
    @Generated
    public String getStackId() {
        return this.stackId;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setShowModel(String showModel) {
        this.showModel = showModel;
    }

    @Generated
    public void setSite(String site) {
        this.site = site;
    }

    @Generated
    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    @Generated
    public void setMigrating(boolean isMigrating) {
        this.isMigrating = isMigrating;
    }

    @Generated
    public void setConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    @Generated
    public void setStatus(DeviceStatusEnum status) {
        this.status = status;
    }

    @Generated
    public void setStackMaster(Boolean stackMaster) {
        this.stackMaster = stackMaster;
    }

    @Generated
    public void setStackSlave(Boolean stackSlave) {
        this.stackSlave = stackSlave;
    }

    @Generated
    public void setStackMasterMac(@Nullable G stackMasterMac) {
        this.stackMasterMac = stackMasterMac;
    }

    @Generated
    public void setStackId(@Nullable String stackId) {
        this.stackId = stackId;
    }

    @Generated
    public MigrateDeviceDTO() {
    }
}

