/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.domain.model.network.lan.vlan;

import com.google.common.graph.Network;
import com.tplink.nbu.common.pii.utils.PIIMaskUtil;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.a.b;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.BaseOltEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.BaseOsgEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.BaseOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.MeshApEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.Port;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.TopologyDTO;
import com.tplink.smb.omada.manager.configuration.domain.shared.T;
import com.tplink.smb.omada.manager.olt.api.k;
import com.tplink.smb.omada.manager.olt.dto.AutoServicePortInternalDTO;
import com.tplink.smb.omada.manager.olt.dto.BaseRequestInternalDTO;
import com.tplink.smb.omada.manager.olt.dto.ServicePortInternalDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class r {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(r.class);
    @Autowired
    private k b;

    public Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> a(String osgMac, Set<Integer> osgPorts, TopologyDTO topologyDTO) {
        if (topologyDTO == null) {
            return new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        }
        HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> results = new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        Network topology = topologyDTO.getTopology();
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a osg = this.a((Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, a>)topology, osgMac);
        if (Objects.isNull(osg) || CollectionUtils.isEmpty((Collection)topology.successors((Object)osg))) {
            return new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        }
        Set successors = topology.successors((Object)osg);
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a successor : successors) {
            a edge;
            if (com.tplink.smb.omada.manager.configuration.api.internal.topology.a.b.E.contains(successor.getType()) || Objects.isNull(edge = (a)topology.edgeConnectingOrNull((Object)osg, (Object)successor))) continue;
            if (edge instanceof BaseOsgEdge) {
                BaseOsgEdge baseOsgEdge = (BaseOsgEdge)edge;
                Port upLink = baseOsgEdge.getUpLink();
                if (Objects.isNull(upLink) || !osgPorts.contains(upLink.getPortId())) continue;
                results.add(successor);
                this.a((Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, a>)topology, successor, results);
                continue;
            }
            if (!(edge instanceof MeshApEdge)) continue;
            results.add(successor);
            this.a((Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, a>)topology, successor, results);
        }
        return results;
    }

    public Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> b(String oswMac, Set<String> standardPortList, TopologyDTO topologyDTO) {
        if (topologyDTO == null) {
            return new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        }
        HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> results = new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        Network topology = topologyDTO.getTopology();
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a oswNode = this.a((Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, a>)topology, oswMac);
        if (Objects.isNull(oswNode) || CollectionUtils.isEmpty((Collection)topology.successors((Object)oswNode))) {
            return new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        }
        Set successors = topology.successors((Object)oswNode);
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a successor : successors) {
            BaseOswEdge baseOswEdge;
            Port upLink;
            a edge;
            if (com.tplink.smb.omada.manager.configuration.api.internal.topology.a.b.E.contains(successor.getType()) || Objects.isNull(edge = (a)topology.edgeConnectingOrNull((Object)oswNode, (Object)successor)) || !(edge instanceof BaseOswEdge) || Objects.isNull(upLink = (baseOswEdge = (BaseOswEdge)edge).getUpLink()) || !standardPortList.contains(upLink.getStandardOswPort())) continue;
            results.add(successor);
            this.a((Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, a>)topology, successor, results);
        }
        return results;
    }

    public Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> a(String omadacId, String siteId, String oltMac, TopologyDTO topologyDTO, Set<Integer> vlanSet) {
        if (topologyDTO == null) {
            return new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        }
        HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> results = new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        Network topology = topologyDTO.getTopology();
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a oltNode = this.a((Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, a>)topology, oltMac);
        if (Objects.isNull(oltNode) || CollectionUtils.isEmpty((Collection)topology.successors((Object)oltNode))) {
            return new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        }
        Set successors = topology.successors((Object)oltNode);
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a successor : successors) {
            BaseOltEdge baseOltEdge;
            Port upLink;
            a edge;
            if (com.tplink.smb.omada.manager.configuration.api.internal.topology.a.b.E.contains(successor.getType()) || Objects.isNull(edge = (a)topology.edgeConnectingOrNull((Object)oltNode, (Object)successor)) || !(edge instanceof BaseOltEdge) || Objects.isNull(upLink = (baseOltEdge = (BaseOltEdge)edge).getUpLink())) continue;
            if (!this.a(omadacId, siteId, vlanSet, oltNode, upLink)) {
                if (!a.isDebugEnabled()) continue;
                a.debug("osg {} port {} is not involved in vlan {}", new Object[]{PIIMaskUtil.encrypt((String)oltNode.getMac()), upLink, vlanSet});
                continue;
            }
            results.add(successor);
            this.a((Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, a>)topology, successor, results);
        }
        return results;
    }

    private boolean a(String omadacId, String siteId, Set<Integer> vlanSet, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a olt, Port upLink) {
        if (Objects.isNull(upLink.getStandardOswPort())) {
            return false;
        }
        String ponPort = upLink.getStandardOswPort();
        Integer portId = null;
        if (com.tplink.smb.omada.common.util.T.d((String)ponPort)) {
            portId = Integer.valueOf(ponPort);
        } else {
            try {
                String[] parts = ponPort.split("/");
                String lastPart = parts[parts.length - 1];
                if (com.tplink.smb.omada.common.util.T.d((String)lastPart)) {
                    portId = Integer.valueOf(lastPart);
                }
            }
            catch (Exception e2) {
                a.info("fail to get portId of olt:{} ponPort:{} when checkOltPortInvolvedVlan", (Object)PIIMaskUtil.encrypt((String)olt.getMac()), (Object)ponPort);
            }
        }
        if (a.isDebugEnabled()) {
            a.debug("checkOltPortInvolvedVlan: olt:{} port:{}", (Object)PIIMaskUtil.encrypt((String)olt.getMac()), (Object)portId);
        }
        if (Objects.isNull(portId)) {
            return false;
        }
        HashMap ponPortIdToVlanMap = new HashMap();
        BaseRequestInternalDTO baseRequestInternalDTO = new BaseRequestInternalDTO();
        baseRequestInternalDTO.setMac(olt.getMac());
        baseRequestInternalDTO.setOmadacId(omadacId);
        baseRequestInternalDTO.setSiteId(siteId);
        baseRequestInternalDTO.setTimeout(T.f);
        List autoServicePortList = this.b.b(baseRequestInternalDTO);
        if (a.isDebugEnabled()) {
            a.debug("OLT {} Pon Port vlan: {}", (Object)PIIMaskUtil.encrypt((String)olt.getMac()), (Object)autoServicePortList);
        }
        if (!CollectionUtils.isEmpty((Collection)autoServicePortList)) {
            for (AutoServicePortInternalDTO dto : autoServicePortList) {
                Integer ponPortId = dto.getPonPortId();
                if (Objects.isNull(ponPortId)) continue;
                ponPortIdToVlanMap.putIfAbsent(ponPortId, new HashSet());
                Integer portVlan = Objects.equals(dto.getUserVlan(), 0) ? dto.getSvlan() : dto.getUserVlan();
                ((Set)ponPortIdToVlanMap.get(ponPortId)).add(portVlan);
            }
        }
        BaseRequestInternalDTO portQueryDTO = new BaseRequestInternalDTO();
        portQueryDTO.setMac(olt.getMac());
        portQueryDTO.setOmadacId(omadacId);
        portQueryDTO.setSiteId(siteId);
        portQueryDTO.setTimeout(T.f);
        List manualPonPorts = this.b.a(portQueryDTO);
        if (!CollectionUtils.isEmpty((Collection)manualPonPorts)) {
            for (ServicePortInternalDTO dto : manualPonPorts) {
                Integer ponPortId = dto.getPonPortId();
                if (Objects.isNull(ponPortId)) continue;
                ponPortIdToVlanMap.putIfAbsent(ponPortId, new HashSet());
                Integer portVlan = Objects.equals(dto.getUserVlan(), 0) ? dto.getSvlan() : dto.getUserVlan();
                ((Set)ponPortIdToVlanMap.get(ponPortId)).add(portVlan);
            }
        }
        if (a.isDebugEnabled()) {
            a.debug("OLT {} Pon Port vlan: {}", (Object)PIIMaskUtil.encrypt((String)olt.getMac()), (Object)manualPonPorts);
        }
        if (!ponPortIdToVlanMap.containsKey(portId)) {
            return false;
        }
        Set vlans = (Set)ponPortIdToVlanMap.get(portId);
        return CollectionUtils.containsAny((Collection)vlans, vlanSet);
    }

    private void a(Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, a> topology, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a successor, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> results) {
        Set successors = topology.successors((Object)successor);
        if (CollectionUtils.isEmpty((Collection)successors)) {
            return;
        }
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : successors) {
            if (Objects.equals(node.getType(), "switch") || Objects.equals(node.getType(), "olt") || com.tplink.smb.omada.manager.configuration.api.internal.topology.a.b.E.contains(node.getType())) continue;
            results.add(node);
            this.a(topology, node, results);
        }
    }

    @Nullable
    private com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a a(@Nonnull Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, a> topology, String mac) {
        Set nodes = topology.nodes();
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            a.debug("no device in topology");
            return null;
        }
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : nodes) {
            if (!mac.equals(node.getMac())) continue;
            return node;
        }
        return null;
    }
}

