/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.common.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.manager.common.config.EventCenterProperties;
import com.tplink.smb.omada.manager.common.config.c;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={EventCenterProperties.class})
public class EventCenterWorkGroupConfig {
    @Lazy
    @Bean(name={"eventCenterWorkGroup"})
    @ConditionalOnMissingBean(name={"eventCenterWorkGroup"})
    public ExecutorService eventCenterWorkGroup(EventCenterProperties eventCenterProperties) {
        int coreSize = eventCenterProperties.getWorkGroupThreadPoolSize();
        int maxSize = eventCenterProperties.getWorkGroupThreadMaxPoolSize();
        return new ThreadPoolExecutor(coreSize, maxSize, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(eventCenterProperties.getWorkGroupThreadPoolQueueSize()), new ThreadFactoryBuilder().setNameFormat("eventCenter-work-group-%d").build(), new c(this));
    }
}

