/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.lock.api.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackTraceUtils {
    private static final Logger log = LoggerFactory.getLogger(StackTraceUtils.class);
    private static final Map<String, Boolean> ENABLE_LOG_MAP = new ConcurrentHashMap<String, Boolean>();

    public static void printStackTrace(String lockName, Object businessId) {
        String logKey = StackTraceUtils.buildLogKey(lockName, businessId);
        boolean enableLog = ENABLE_LOG_MAP.getOrDefault(logKey, false);
        if (enableLog) {
            String stackTraceString = StackTraceUtils.getStackTraceString();
            log.info("try to get lock: {}, businessId:{}, stackTrace: {}", new Object[]{lockName, businessId, stackTraceString});
        }
    }

    public static StackTraceElement[] getCurrentThreadStackTrace() {
        return Thread.currentThread().getStackTrace();
    }

    public static String getStackTraceString() {
        StackTraceElement[] currentThreadStackTrace = StackTraceUtils.getCurrentThreadStackTrace();
        StringBuilder stackTraceBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : currentThreadStackTrace) {
            stackTraceBuilder.append(stackTraceElement).append(System.lineSeparator());
        }
        return stackTraceBuilder.toString();
    }

    public static boolean setEnableLogStackTrace(String lockName, Object businessId, boolean enable) {
        String logKey = StackTraceUtils.buildLogKey(lockName, businessId);
        try {
            if (enable) {
                ENABLE_LOG_MAP.put(logKey, enable);
            } else {
                ENABLE_LOG_MAP.remove(logKey);
            }
            return true;
        }
        catch (Exception e) {
            log.warn("setEnableLogStackTrace lockName:{}, businessId:{}, exception: {}", new Object[]{lockName, businessId, e});
            return false;
        }
    }

    private static String buildLogKey(String lockName, Object businessId) {
        return lockName + "_" + businessId;
    }

    private StackTraceUtils() {
    }
}

