/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.lock.api;

import com.tplink.smb.component.lock.api.LockApi;
import com.tplink.smb.component.lock.api.ReadWriteLockService;
import com.tplink.smb.component.lock.api.utils.StackTraceUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public abstract class AbstractReadWriteLockService
implements ReadWriteLockService,
LockApi {
    private static final Logger log = LoggerFactory.getLogger(AbstractReadWriteLockService.class);

    @Override
    public <T> T doWithTryLockRead(String lockName, Object businessId, @NonNull Supplier<T> onSuccess, @NonNull Supplier<T> onFail) {
        return this.doWithTryLockRead(lockName, businessId, -1L, null, onSuccess, onFail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doWithTryLockRead(String lockName, Object businessId, long time, TimeUnit unit, @NonNull Supplier<T> onSuccess, @NonNull Supplier<T> onFail) {
        T t;
        boolean isLock;
        boolean enableMonitor = this.enableMonitorLock(lockName);
        long startTime = enableMonitor ? System.currentTimeMillis() : 0L;
        ReadWriteLock readWriteLock = this.getReadWriteLock(lockName, businessId);
        if (readWriteLock == null) {
            log.error("[readWriteLockService]businessId:{} get lock {} is null.", businessId, (Object)lockName);
            this.monitorLock(lockName, "get readLock null", startTime, enableMonitor);
            return onFail.get();
        }
        Lock readLock = readWriteLock.readLock();
        try {
            StackTraceUtils.printStackTrace(lockName, businessId);
            isLock = time <= 0L || unit == null ? readLock.tryLock() : readLock.tryLock(time, unit);
        }
        catch (InterruptedException e) {
            log.warn("[readWriteLockService]readLock :{},businessId:{} try get readLock {} interrupted, execute onFail.", new Object[]{readLock, businessId, lockName, e});
            Thread.currentThread().interrupt();
            this.monitorLock(lockName, "get readLock interrupted", startTime, enableMonitor);
            return onFail.get();
        }
        catch (Exception e) {
            log.warn("[lockService]readLock:{}, businessId:{} get readLock {} fail with exception, execute onFail.", new Object[]{readLock, businessId, lockName, e});
            this.monitorLock(lockName, "get readLock exception", startTime, enableMonitor);
            return onFail.get();
        }
        if (!isLock) {
            log.info("[readWriteLockService]readLock:{}, businessId:{} get readLock {} fail, execute onFail.", new Object[]{readLock, businessId, lockName});
            this.monitorLock(lockName, "get readLock fail", startTime, enableMonitor);
            return onFail.get();
        }
        try {
            log.debug("[readWriteLockService]readLock:{}, businessId:{} get readLock {} success.", new Object[]{readLock, businessId, lockName});
            t = onSuccess.get();
            readLock.unlock();
        }
        catch (Throwable throwable) {
            readLock.unlock();
            log.debug("[readWriteLockService]readLock:{}, businessId:{} unlock readLock {} success.", new Object[]{readLock, businessId, lockName});
            this.monitorLock(lockName, "get readLock success", startTime, enableMonitor);
            throw throwable;
        }
        log.debug("[readWriteLockService]readLock:{}, businessId:{} unlock readLock {} success.", new Object[]{readLock, businessId, lockName});
        this.monitorLock(lockName, "get readLock success", startTime, enableMonitor);
        return t;
    }

    @Override
    public <T> T doWithTryLockWrite(String lockName, Object businessId, @NonNull Supplier<T> onSuccess, @NonNull Supplier<T> onFail) {
        return this.doWithTryLockWrite(lockName, businessId, -1L, null, onSuccess, onFail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doWithTryLockWrite(String lockName, Object businessId, long time, TimeUnit unit, @NonNull Supplier<T> onSuccess, @NonNull Supplier<T> onFail) {
        T t;
        boolean isLock;
        boolean enableMonitor = this.enableMonitorLock(lockName);
        long startTime = enableMonitor ? System.currentTimeMillis() : 0L;
        ReadWriteLock readWriteLock = this.getReadWriteLock(lockName, businessId);
        if (readWriteLock == null) {
            log.error("[readWriteLockService]businessId:{} get lock {} is null.", businessId, (Object)lockName);
            this.monitorLock(lockName, "get writeLock null", startTime, enableMonitor);
            return onFail.get();
        }
        Lock writeLock = readWriteLock.writeLock();
        try {
            StackTraceUtils.printStackTrace(lockName, businessId);
            isLock = time <= 0L || unit == null ? writeLock.tryLock() : writeLock.tryLock(time, unit);
        }
        catch (InterruptedException e) {
            log.warn("[readWriteLockService]writeLock: {}, businessId:{} try get writeLock {} interrupted, execute onFail.", new Object[]{writeLock, businessId, lockName, e});
            Thread.currentThread().interrupt();
            this.monitorLock(lockName, "get writeLock interrupted", startTime, enableMonitor);
            return onFail.get();
        }
        catch (Exception e) {
            log.warn("[lockService]writeLock: {}, businessId:{} get writeLock {} fail with exception, execute onFail.", new Object[]{writeLock, businessId, lockName, e});
            this.monitorLock(lockName, "get writeLock exception", startTime, enableMonitor);
            return onFail.get();
        }
        if (!isLock) {
            log.info("[readWriteLockService]writeLock: {}, businessId:{} get writeLock {} fail, execute onFail.", new Object[]{writeLock, businessId, lockName});
            this.monitorLock(lockName, "get writeLock fail", startTime, enableMonitor);
            return onFail.get();
        }
        try {
            log.debug("[readWriteLockService]writeLock: {}, businessId:{} get writeLock {} success.", new Object[]{writeLock, businessId, lockName});
            t = onSuccess.get();
            writeLock.unlock();
        }
        catch (Throwable throwable) {
            writeLock.unlock();
            log.debug("[readWriteLockService]writeLock: {}, businessId:{} unlock writeLock {} success.", new Object[]{writeLock, businessId, lockName});
            this.monitorLock(lockName, "get writeLock success", startTime, enableMonitor);
            throw throwable;
        }
        log.debug("[readWriteLockService]writeLock: {}, businessId:{} unlock writeLock {} success.", new Object[]{writeLock, businessId, lockName});
        this.monitorLock(lockName, "get writeLock success", startTime, enableMonitor);
        return t;
    }
}

