/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.lock.api;

import com.tplink.smb.component.lock.api.LockApi;
import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.component.lock.api.utils.StackTraceUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public abstract class AbstractLockService
implements LockService,
LockApi {
    private static final Logger log = LoggerFactory.getLogger(AbstractLockService.class);

    @Override
    public <T> T doWithTryLock(String lockName, Object businessId, @NonNull Supplier<T> onSuccess, @NonNull Supplier<T> onFail) {
        return this.doWithTryLock(lockName, businessId, -1L, null, onSuccess, onFail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doWithTryLock(String lockName, Object businessId, long time, TimeUnit unit, @NonNull Supplier<T> onSuccess, @NonNull Supplier<T> onFail) {
        T t;
        boolean isLock;
        boolean enableMonitor = this.enableMonitorLock(lockName);
        long startTime = enableMonitor ? System.currentTimeMillis() : 0L;
        Lock lock = this.getLock(lockName, businessId);
        if (lock == null) {
            log.error("[lockService]businessId:{} get lock {} is null, execute onFail.", businessId, (Object)lockName);
            this.monitorLock(lockName, "get lock null", startTime, enableMonitor);
            return onFail.get();
        }
        try {
            StackTraceUtils.printStackTrace(lockName, businessId);
            isLock = time <= 0L || unit == null ? lock.tryLock() : lock.tryLock(time, unit);
        }
        catch (InterruptedException e) {
            log.warn("[lockService]lock: {}businessId:{} get lock {} interrupted, execute onFail.", new Object[]{lock, businessId, lockName, e});
            Thread.currentThread().interrupt();
            this.monitorLock(lockName, "get lock interrupted", startTime, enableMonitor);
            return onFail.get();
        }
        catch (Exception e) {
            log.warn("[lockService]lock: {}, businessId:{} get lock {} fail with exception, execute onFail.", new Object[]{lock, businessId, lockName, e});
            this.monitorLock(lockName, "get lock exception", startTime, enableMonitor);
            return onFail.get();
        }
        if (!isLock) {
            log.info("[lockService]lock: {}, businessId:{} get lock {} fail, execute onFail.", new Object[]{lock, businessId, lockName});
            this.monitorLock(lockName, "get lock fail", startTime, enableMonitor);
            return onFail.get();
        }
        try {
            log.debug("[lockService]lock: {}, businessId:{} get lock {} success.", new Object[]{lock, businessId, lockName});
            t = onSuccess.get();
            lock.unlock();
        }
        catch (Throwable throwable) {
            lock.unlock();
            log.debug("[lockService]lock: {}, businessId:{} unlock lock {} success.", new Object[]{lock, businessId, lockName});
            this.monitorLock(lockName, "get lock success", startTime, enableMonitor);
            throw throwable;
        }
        log.debug("[lockService]lock: {}, businessId:{} unlock lock {} success.", new Object[]{lock, businessId, lockName});
        this.monitorLock(lockName, "get lock success", startTime, enableMonitor);
        return t;
    }
}

