/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.log.component.server.port.adapter.eventcenter;

import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.eventcenter.api.EventHandler;
import com.tplink.smb.log.component.common.exception.LogComponentException;
import com.tplink.smb.log.component.common.utils.JsonUtils;
import com.tplink.smb.log.component.common.utils.StringUtils;
import com.tplink.smb.log.component.server.domain.LogCacheRepository;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class LogComponentServerSubscriber
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(LogComponentServerSubscriber.class);
    private final EventCenter eventCenter;
    private final LogCacheRepository logCacheRepository;
    private final ExecutorService logComponentEventCenterWorkGroup;
    private final String topic;
    private final String groupId;

    public LogComponentServerSubscriber(String topic, String groupId, EventCenter eventCenter, LogCacheRepository logCacheRepository, ExecutorService logComponentEventCenterWorkGroup) {
        this.eventCenter = eventCenter;
        this.logCacheRepository = logCacheRepository;
        this.logComponentEventCenterWorkGroup = logComponentEventCenterWorkGroup;
        if (StringUtils.isNull((String)topic) || StringUtils.isNull((String)groupId)) {
            throw new LogComponentException("topic and groupId should not be null.");
        }
        this.topic = topic;
        this.groupId = groupId;
    }

    @PostConstruct
    public void register() {
        this.eventCenter.registerUnicast(this.topic, this.groupId, (EventHandler)this, this.logComponentEventCenterWorkGroup);
    }

    public void handleEvent(Event event) {
        if (StringUtils.isNull((String)((String)event.getMessage()))) {
            LogComponentServerSubscriber.log.warn("Event message is null.");
            return;
        }
        List logs = JsonUtils.json2list((String)((String)event.getMessage()), String.class);
        if (CollectionUtils.isEmpty((Collection)logs)) {
            return;
        }
        logs.forEach(log -> this.logCacheRepository.save((String)log));
    }

    public void unregisterTopic() {
        this.eventCenter.unregister(this.topic, (EventHandler)this);
        log.debug("unregister topic:{} adopt elegant shutdown success.", (Object)this.topic);
    }
}

