/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.log.component.server.port.adapter.cache;

import com.google.common.collect.Queues;
import com.tplink.smb.log.component.server.domain.BusinessDealLogService;
import com.tplink.smb.log.component.server.domain.LogCacheRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCacheQueueRepositoryImpl
implements LogCacheRepository {
    private static final Logger log = LoggerFactory.getLogger(LogCacheQueueRepositoryImpl.class);
    private final BlockingQueue<String> logBlockingQueue;
    private final int consumeLogSize;
    private final int timeout;
    private BusinessDealLogService businessDealLogService;

    public LogCacheQueueRepositoryImpl(int cacheLogQueueSize, int consumeLogSize, int timeout, BusinessDealLogService businessDealLogService) {
        this.logBlockingQueue = new LinkedBlockingQueue<String>(cacheLogQueueSize);
        this.consumeLogSize = consumeLogSize;
        this.timeout = timeout;
        this.businessDealLogService = businessDealLogService;
    }

    @Override
    public List<String> getLogs() {
        ArrayList<String> logs = new ArrayList<String>(100);
        try {
            Queues.drain(this.logBlockingQueue, logs, (int)this.consumeLogSize, (long)this.timeout, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("interrupt exception.when get logs from Queue");
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return logs;
    }

    @Override
    public void save(String aLog) {
        for (int retryCount = 0; !this.logBlockingQueue.offer(aLog) && retryCount < 10; ++retryCount) {
            log.warn("log component add a Log with cache Queue is full, log:{}", (Object)aLog);
            Optional.ofNullable(this.logBlockingQueue.poll()).ifPresent(message -> this.businessDealLogService.businessDealLog(Collections.singletonList(message)));
        }
    }
}

