/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.log.component.server.port.adapter;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.log.component.server.application.LogComponentServerApplicationService;
import com.tplink.smb.log.component.server.domain.BusinessDealLogService;
import com.tplink.smb.log.component.server.domain.CacheLogConsumeHandler;
import com.tplink.smb.log.component.server.domain.LogCacheRepository;
import com.tplink.smb.log.component.server.port.adapter.cache.LogCacheQueueRepositoryImpl;
import com.tplink.smb.log.component.server.port.adapter.config.LogComponentServerProperties;
import com.tplink.smb.log.component.server.port.adapter.eventcenter.LogComponentServerSubscriber;
import com.tplink.smb.log.component.server.port.adapter.service.AdoptElegantShutDownServiceImpl;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={LogComponentServerProperties.class})
public class LogComponentAutoConfig {
    @Bean
    @ConditionalOnMissingBean
    public LogCacheQueueRepositoryImpl logMQRepository(LogComponentServerProperties logComponentServerProperties, BusinessDealLogService businessDealLogService) {
        return new LogCacheQueueRepositoryImpl(logComponentServerProperties.getCacheLogQueueSize(), logComponentServerProperties.getConsumeLogSize(), logComponentServerProperties.getTimeout(), businessDealLogService);
    }

    @Bean
    @ConditionalOnMissingBean
    public LogComponentServerSubscriber logMQSubscriber(EventCenter eventCenter, LogCacheRepository logCacheRepository, @Qualifier(value="logComponentEventCenterWorkGroup") ExecutorService logComponentEventCenterWorkGroup, LogComponentServerProperties logComponentServerProperties) {
        return new LogComponentServerSubscriber(logComponentServerProperties.getTopic(), logComponentServerProperties.getGroupId(), eventCenter, logCacheRepository, logComponentEventCenterWorkGroup);
    }

    @Bean(value={"logComponentEventCenterWorkGroup"})
    @ConditionalOnMissingBean(name={"logComponentEventCenterWorkGroup"})
    public ExecutorService logComponentEventCenterWorkGroup() {
        return new ThreadPoolExecutor(1, 3, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().setNameFormat("log-component-event-center-work-group-%s").build(), new ThreadPoolExecutor.DiscardOldestPolicy(){
            private final Logger log = LoggerFactory.getLogger(ThreadPoolExecutor.DiscardOldestPolicy.class);

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                this.log.warn("log component queue is full, discard oldest.");
                super.rejectedExecution(r, e);
            }
        });
    }

    @Bean
    @ConditionalOnMissingBean
    public LogComponentServerApplicationService logServerApplicationService() {
        return new LogComponentServerApplicationService();
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheLogConsumeHandler consumeLogService(LogComponentServerProperties logComponentServerProperties, LogCacheRepository logCacheRepository, BusinessDealLogService businessDealLogService) {
        return new CacheLogConsumeHandler(logComponentServerProperties.getCorePoolSize(), logComponentServerProperties.getMaximumPoolSize(), logCacheRepository, businessDealLogService);
    }

    @Bean
    @ConditionalOnMissingBean
    public AdoptElegantShutDownServiceImpl adoptElegantShutDownService() {
        return new AdoptElegantShutDownServiceImpl();
    }
}

