/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.log.component.server.domain;

import com.tplink.smb.log.component.server.domain.BusinessDealLogService;
import com.tplink.smb.log.component.server.domain.LogCacheRepository;
import com.tplink.smb.log.component.server.port.adapter.threadpool.LogComponentThreadFactory;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

public class CacheLogConsumeHandler {
    private static final Logger log = LoggerFactory.getLogger(CacheLogConsumeHandler.class);
    private final int corePoolSize;
    private final int maximumPoolSize;
    private Thread callerThread;
    private ExecutorService threadPool;
    private final LogCacheRepository logCacheRepository;
    private final BusinessDealLogService businessDealLogService;

    public CacheLogConsumeHandler(int corePoolSize, int maximumPoolSize, LogCacheRepository logCacheRepository, BusinessDealLogService businessDealLogService) {
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.logCacheRepository = logCacheRepository;
        this.businessDealLogService = businessDealLogService;
    }

    @PreDestroy
    public synchronized void destroy() {
        if (this.callerThread != null) {
            log.info("Interrupt log-read-caller-thread");
            this.callerThread.interrupt();
            this.callerThread = null;
        }
        if (this.threadPool != null) {
            log.info("Shutdown log-component-work-group");
            this.threadPool.shutdown();
            this.threadPool = null;
        }
    }

    public synchronized void start() {
        log.info("log mq consume task is start...");
        if (this.threadPool == null || this.threadPool.isShutdown()) {
            this.threadPool = LogComponentThreadFactory.newThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, 60L, new LinkedBlockingQueue<Runnable>(1000), "log-component-work-group", new ThreadPoolExecutor.CallerRunsPolicy(){
                private final Logger log = LoggerFactory.getLogger(ThreadPoolExecutor.CallerRunsPolicy.class);

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                    this.log.warn("log component queue is full, call current thread deal.");
                    super.rejectedExecution(r, e);
                }
            });
        }
        if (this.callerThread == null || !this.callerThread.isAlive()) {
            this.callerThread = new Thread(this::dealLogs);
            this.callerThread.setName("log-read-caller-thread");
            this.callerThread.setDaemon(true);
            this.callerThread.start();
        }
    }

    private void dealLogs() {
        while (!Thread.currentThread().isInterrupted()) {
            List<String> logs = this.logCacheRepository.getLogs();
            if (CollectionUtils.isEmpty(logs)) continue;
            log.debug("get logs from MQ size : {}", (Object)logs.size());
            this.threadPool.execute(() -> this.businessDealLog(logs));
        }
    }

    private void businessDealLog(@Nonnull List<String> logs) {
        StopWatch stopWatch = new StopWatch();
        try {
            stopWatch.start();
            this.businessDealLogService.businessDealLog(logs);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        stopWatch.stop();
        log.debug("Business System deal logs use time: {}ms.", (Object)stopWatch.getTotalTimeMillis());
    }
}

