/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.api.web.statistic.dto;

import com.tplink.smb.omada.common.util.I;
import com.tplink.smb.omada.monitor.api.web.statistic.dto.BaseDeviceStatDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class OswStatDTO
extends BaseDeviceStatDTO {
    private List<OswPortStatDTO> ports;
    private Integer poeUtil;
    private Integer poePower;

    public long sumRx() {
        if (CollectionUtils.isEmpty(this.ports)) {
            return 0L;
        }
        long rx = 0L;
        for (OswPortStatDTO oswPortStatDO : this.ports) {
            if (oswPortStatDO.getRx() == null) continue;
            rx += oswPortStatDO.getRx().longValue();
        }
        return rx;
    }

    public long sumTx() {
        if (CollectionUtils.isEmpty(this.ports)) {
            return 0L;
        }
        long tx = 0L;
        for (OswPortStatDTO oswPortStatDO : this.ports) {
            if (oswPortStatDO.getTx() == null) continue;
            tx += oswPortStatDO.getTx().longValue();
        }
        return tx;
    }

    @Generated
    protected OswStatDTO(OswStatDTOBuilder<?, ?> b2) {
        super(b2);
        this.ports = b2.ports;
        this.poeUtil = b2.poeUtil;
        this.poePower = b2.poePower;
    }

    @Generated
    public static OswStatDTOBuilder<?, ?> builder() {
        return new OswStatDTOBuilderImpl();
    }

    @Generated
    public List<OswPortStatDTO> getPorts() {
        return this.ports;
    }

    @Generated
    public Integer getPoeUtil() {
        return this.poeUtil;
    }

    @Generated
    public Integer getPoePower() {
        return this.poePower;
    }

    @Generated
    public void setPorts(List<OswPortStatDTO> ports) {
        this.ports = ports;
    }

    @Generated
    public void setPoeUtil(Integer poeUtil) {
        this.poeUtil = poeUtil;
    }

    @Generated
    public void setPoePower(Integer poePower) {
        this.poePower = poePower;
    }

    @Override
    @Generated
    public String toString() {
        return "OswStatDTO(super=" + super.toString() + ", ports=" + this.getPorts() + ", poeUtil=" + this.getPoeUtil() + ", poePower=" + this.getPoePower() + ")";
    }

    @Generated
    public OswStatDTO() {
    }

    @Generated
    public OswStatDTO(List<OswPortStatDTO> ports, Integer poeUtil, Integer poePower) {
        this.ports = ports;
        this.poeUtil = poeUtil;
        this.poePower = poePower;
    }

    public static class OswPortStatDTO {
        private Integer port;
        private String standardPort;
        private Long tx;
        private Long rx;
        private Long txRate;
        private Long rxRate;
        private Long txPkts;
        private Long rxPkts;
        private Long txBroadPkts;
        private Long rxBroadPkts;
        private Long txMultiPkts;
        private Long rxMultiPkts;
        private Long dropPkts;
        private Long txErrPkts;
        private Long rxErrPkts;
        private Integer linkDownCnt;

        public static List<OswPortStatDTO> merge(List<OswPortStatDTO> pre, List<OswPortStatDTO> next) {
            if (CollectionUtils.isEmpty(pre)) {
                return next;
            }
            if (CollectionUtils.isEmpty(next)) {
                return pre;
            }
            ArrayList<OswPortStatDTO> list = new ArrayList<OswPortStatDTO>(pre.size());
            for (OswPortStatDTO prePortStat : pre) {
                next.stream().filter(nextPortStat -> Objects.equals(prePortStat.getPort(), nextPortStat.getPort())).findFirst().ifPresent(prePortStat::merge);
                list.add(prePortStat);
            }
            if (pre.size() < next.size()) {
                List includedPorts = list.stream().map(OswPortStatDTO::getPort).collect(Collectors.toList());
                List unIncludedPortStats = next.stream().filter(item -> !includedPorts.contains(item.getPort())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(unIncludedPortStats)) {
                    list.addAll(unIncludedPortStats);
                }
            }
            return list;
        }

        public void merge(OswPortStatDTO portStat) {
            this.tx = I.b((Long)this.tx, (Long)portStat.getTx());
            this.rx = I.b((Long)this.rx, (Long)portStat.getRx());
            this.txRate = I.a((Long)this.txRate, (Long)portStat.getTxRate());
            this.rxRate = I.a((Long)this.rxRate, (Long)portStat.getRxRate());
            this.txPkts = I.b((Long)this.txPkts, (Long)portStat.getTxPkts());
            this.rxPkts = I.b((Long)this.rxPkts, (Long)portStat.getRxPkts());
            this.txBroadPkts = I.b((Long)this.txBroadPkts, (Long)portStat.getTxBroadPkts());
            this.rxBroadPkts = I.b((Long)this.rxBroadPkts, (Long)portStat.getRxBroadPkts());
            this.txMultiPkts = I.b((Long)this.txMultiPkts, (Long)portStat.getTxMultiPkts());
            this.rxMultiPkts = I.b((Long)this.rxMultiPkts, (Long)portStat.getRxMultiPkts());
            this.dropPkts = I.b((Long)this.dropPkts, (Long)portStat.getDropPkts());
            this.txErrPkts = I.b((Long)this.txErrPkts, (Long)portStat.getTxErrPkts());
            this.rxErrPkts = I.b((Long)this.rxErrPkts, (Long)portStat.getRxErrPkts());
            this.linkDownCnt = this.linkDownCnt + portStat.getLinkDownCnt();
        }

        @Generated
        public static OswPortStatDTOBuilder builder() {
            return new OswPortStatDTOBuilder();
        }

        @Generated
        public Integer getPort() {
            return this.port;
        }

        @Generated
        public String getStandardPort() {
            return this.standardPort;
        }

        @Generated
        public Long getTx() {
            return this.tx;
        }

        @Generated
        public Long getRx() {
            return this.rx;
        }

        @Generated
        public Long getTxRate() {
            return this.txRate;
        }

        @Generated
        public Long getRxRate() {
            return this.rxRate;
        }

        @Generated
        public Long getTxPkts() {
            return this.txPkts;
        }

        @Generated
        public Long getRxPkts() {
            return this.rxPkts;
        }

        @Generated
        public Long getTxBroadPkts() {
            return this.txBroadPkts;
        }

        @Generated
        public Long getRxBroadPkts() {
            return this.rxBroadPkts;
        }

        @Generated
        public Long getTxMultiPkts() {
            return this.txMultiPkts;
        }

        @Generated
        public Long getRxMultiPkts() {
            return this.rxMultiPkts;
        }

        @Generated
        public Long getDropPkts() {
            return this.dropPkts;
        }

        @Generated
        public Long getTxErrPkts() {
            return this.txErrPkts;
        }

        @Generated
        public Long getRxErrPkts() {
            return this.rxErrPkts;
        }

        @Generated
        public Integer getLinkDownCnt() {
            return this.linkDownCnt;
        }

        @Generated
        public void setPort(Integer port) {
            this.port = port;
        }

        @Generated
        public void setStandardPort(String standardPort) {
            this.standardPort = standardPort;
        }

        @Generated
        public void setTx(Long tx) {
            this.tx = tx;
        }

        @Generated
        public void setRx(Long rx) {
            this.rx = rx;
        }

        @Generated
        public void setTxRate(Long txRate) {
            this.txRate = txRate;
        }

        @Generated
        public void setRxRate(Long rxRate) {
            this.rxRate = rxRate;
        }

        @Generated
        public void setTxPkts(Long txPkts) {
            this.txPkts = txPkts;
        }

        @Generated
        public void setRxPkts(Long rxPkts) {
            this.rxPkts = rxPkts;
        }

        @Generated
        public void setTxBroadPkts(Long txBroadPkts) {
            this.txBroadPkts = txBroadPkts;
        }

        @Generated
        public void setRxBroadPkts(Long rxBroadPkts) {
            this.rxBroadPkts = rxBroadPkts;
        }

        @Generated
        public void setTxMultiPkts(Long txMultiPkts) {
            this.txMultiPkts = txMultiPkts;
        }

        @Generated
        public void setRxMultiPkts(Long rxMultiPkts) {
            this.rxMultiPkts = rxMultiPkts;
        }

        @Generated
        public void setDropPkts(Long dropPkts) {
            this.dropPkts = dropPkts;
        }

        @Generated
        public void setTxErrPkts(Long txErrPkts) {
            this.txErrPkts = txErrPkts;
        }

        @Generated
        public void setRxErrPkts(Long rxErrPkts) {
            this.rxErrPkts = rxErrPkts;
        }

        @Generated
        public void setLinkDownCnt(Integer linkDownCnt) {
            this.linkDownCnt = linkDownCnt;
        }

        @Generated
        public String toString() {
            return "OswStatDTO.OswPortStatDTO(port=" + this.getPort() + ", standardPort=" + this.getStandardPort() + ", tx=" + this.getTx() + ", rx=" + this.getRx() + ", txRate=" + this.getTxRate() + ", rxRate=" + this.getRxRate() + ", txPkts=" + this.getTxPkts() + ", rxPkts=" + this.getRxPkts() + ", txBroadPkts=" + this.getTxBroadPkts() + ", rxBroadPkts=" + this.getRxBroadPkts() + ", txMultiPkts=" + this.getTxMultiPkts() + ", rxMultiPkts=" + this.getRxMultiPkts() + ", dropPkts=" + this.getDropPkts() + ", txErrPkts=" + this.getTxErrPkts() + ", rxErrPkts=" + this.getRxErrPkts() + ", linkDownCnt=" + this.getLinkDownCnt() + ")";
        }

        @Generated
        public OswPortStatDTO() {
        }

        @Generated
        public OswPortStatDTO(Integer port, String standardPort, Long tx, Long rx, Long txRate, Long rxRate, Long txPkts, Long rxPkts, Long txBroadPkts, Long rxBroadPkts, Long txMultiPkts, Long rxMultiPkts, Long dropPkts, Long txErrPkts, Long rxErrPkts, Integer linkDownCnt) {
            this.port = port;
            this.standardPort = standardPort;
            this.tx = tx;
            this.rx = rx;
            this.txRate = txRate;
            this.rxRate = rxRate;
            this.txPkts = txPkts;
            this.rxPkts = rxPkts;
            this.txBroadPkts = txBroadPkts;
            this.rxBroadPkts = rxBroadPkts;
            this.txMultiPkts = txMultiPkts;
            this.rxMultiPkts = rxMultiPkts;
            this.dropPkts = dropPkts;
            this.txErrPkts = txErrPkts;
            this.rxErrPkts = rxErrPkts;
            this.linkDownCnt = linkDownCnt;
        }

        @Generated
        public static class OswPortStatDTOBuilder {
            @Generated
            private Integer port;
            @Generated
            private String standardPort;
            @Generated
            private Long tx;
            @Generated
            private Long rx;
            @Generated
            private Long txRate;
            @Generated
            private Long rxRate;
            @Generated
            private Long txPkts;
            @Generated
            private Long rxPkts;
            @Generated
            private Long txBroadPkts;
            @Generated
            private Long rxBroadPkts;
            @Generated
            private Long txMultiPkts;
            @Generated
            private Long rxMultiPkts;
            @Generated
            private Long dropPkts;
            @Generated
            private Long txErrPkts;
            @Generated
            private Long rxErrPkts;
            @Generated
            private Integer linkDownCnt;

            @Generated
            OswPortStatDTOBuilder() {
            }

            @Generated
            public OswPortStatDTOBuilder port(Integer port) {
                this.port = port;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder standardPort(String standardPort) {
                this.standardPort = standardPort;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder tx(Long tx) {
                this.tx = tx;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder rx(Long rx) {
                this.rx = rx;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder txRate(Long txRate) {
                this.txRate = txRate;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder rxRate(Long rxRate) {
                this.rxRate = rxRate;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder txPkts(Long txPkts) {
                this.txPkts = txPkts;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder rxPkts(Long rxPkts) {
                this.rxPkts = rxPkts;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder txBroadPkts(Long txBroadPkts) {
                this.txBroadPkts = txBroadPkts;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder rxBroadPkts(Long rxBroadPkts) {
                this.rxBroadPkts = rxBroadPkts;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder txMultiPkts(Long txMultiPkts) {
                this.txMultiPkts = txMultiPkts;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder rxMultiPkts(Long rxMultiPkts) {
                this.rxMultiPkts = rxMultiPkts;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder dropPkts(Long dropPkts) {
                this.dropPkts = dropPkts;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder txErrPkts(Long txErrPkts) {
                this.txErrPkts = txErrPkts;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder rxErrPkts(Long rxErrPkts) {
                this.rxErrPkts = rxErrPkts;
                return this;
            }

            @Generated
            public OswPortStatDTOBuilder linkDownCnt(Integer linkDownCnt) {
                this.linkDownCnt = linkDownCnt;
                return this;
            }

            @Generated
            public OswPortStatDTO build() {
                return new OswPortStatDTO(this.port, this.standardPort, this.tx, this.rx, this.txRate, this.rxRate, this.txPkts, this.rxPkts, this.txBroadPkts, this.rxBroadPkts, this.txMultiPkts, this.rxMultiPkts, this.dropPkts, this.txErrPkts, this.rxErrPkts, this.linkDownCnt);
            }

            @Generated
            public String toString() {
                return "OswStatDTO.OswPortStatDTO.OswPortStatDTOBuilder(port=" + this.port + ", standardPort=" + this.standardPort + ", tx=" + this.tx + ", rx=" + this.rx + ", txRate=" + this.txRate + ", rxRate=" + this.rxRate + ", txPkts=" + this.txPkts + ", rxPkts=" + this.rxPkts + ", txBroadPkts=" + this.txBroadPkts + ", rxBroadPkts=" + this.rxBroadPkts + ", txMultiPkts=" + this.txMultiPkts + ", rxMultiPkts=" + this.rxMultiPkts + ", dropPkts=" + this.dropPkts + ", txErrPkts=" + this.txErrPkts + ", rxErrPkts=" + this.rxErrPkts + ", linkDownCnt=" + this.linkDownCnt + ")";
            }
        }
    }

    @Generated
    public static abstract class OswStatDTOBuilder<C extends OswStatDTO, B extends OswStatDTOBuilder<C, B>>
    extends BaseDeviceStatDTO.BaseDeviceStatDTOBuilder<C, B> {
        @Generated
        private List<OswPortStatDTO> ports;
        @Generated
        private Integer poeUtil;
        @Generated
        private Integer poePower;

        @Generated
        public B ports(List<OswPortStatDTO> ports) {
            this.ports = ports;
            return (B)this.self();
        }

        @Generated
        public B poeUtil(Integer poeUtil) {
            this.poeUtil = poeUtil;
            return (B)this.self();
        }

        @Generated
        public B poePower(Integer poePower) {
            this.poePower = poePower;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "OswStatDTO.OswStatDTOBuilder(super=" + super.toString() + ", ports=" + this.ports + ", poeUtil=" + this.poeUtil + ", poePower=" + this.poePower + ")";
        }
    }

    @Generated
    private static final class OswStatDTOBuilderImpl
    extends OswStatDTOBuilder<OswStatDTO, OswStatDTOBuilderImpl> {
        @Generated
        private OswStatDTOBuilderImpl() {
        }

        @Override
        @Generated
        protected OswStatDTOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OswStatDTO build() {
            return new OswStatDTO(this);
        }
    }
}

