/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.api.web.report.vo;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.f.a;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@Schema(name="NetworkReportScheduleVO")
public class NetworkReportScheduleVO {
    @NotNull(message="enable should not be null.")
    @Valid
    private @NotNull(message="enable should not be null.") @Valid Boolean enable;
    private Integer tab;
    private List<String> tabIdList;
    private String reportName;
    private Integer reportType;
    @PII(strategy=PIIMaskStrategy.HASH)
    private List<String> emailList;
    private Long time;
    private String cards;
    @Range(min=1L, max=5L)
    private @Range(min=1L, max=5L) Integer timingType;
    @Range(min=0L, max=23L)
    private @Range(min=0L, max=23L) Integer hour;
    @Range(min=0L, max=59L, message="Minute is from 0 to 59.")
    private @Range(min=0L, max=59L, message="Minute is from 0 to 59.") Integer minute;
    @Range(min=0L, max=6L, message="DayOfWeek is from 0 to 6.")
    private @Range(min=0L, max=6L, message="DayOfWeek is from 0 to 6.") Integer dayOfWeek;
    @Range(min=1L, max=31L, message="DayOfMonth is from 1 to 31.")
    private @Range(min=1L, max=31L, message="DayOfMonth is from 1 to 31.") Integer dayOfMonth;
    @Range(min=1L, max=12L, message="MonthOfYear is from 1 to 12.")
    private @Range(min=1L, max=12L, message="MonthOfYear is from 1 to 12.") Integer monthOfYear;

    public OperationResponse areEmailAddressesValid() {
        if (this.enable.booleanValue()) {
            if (CollectionUtils.isEmpty(this.emailList)) {
                return OperationResponse.PARAM_ERROR;
            }
            for (String email : this.emailList) {
                if (a.a((String)email)) continue;
                return new OperationResponse(b.bW);
            }
            return OperationResponse.SUCCESS;
        }
        if (!CollectionUtils.isEmpty(this.emailList)) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public static NetworkReportScheduleVOBuilder builder() {
        return new NetworkReportScheduleVOBuilder();
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }

    @Generated
    public Integer getTab() {
        return this.tab;
    }

    @Generated
    public List<String> getTabIdList() {
        return this.tabIdList;
    }

    @Generated
    public String getReportName() {
        return this.reportName;
    }

    @Generated
    public Integer getReportType() {
        return this.reportType;
    }

    @Generated
    public List<String> getEmailList() {
        return this.emailList;
    }

    @Generated
    public Long getTime() {
        return this.time;
    }

    @Generated
    public String getCards() {
        return this.cards;
    }

    @Generated
    public Integer getTimingType() {
        return this.timingType;
    }

    @Generated
    public Integer getHour() {
        return this.hour;
    }

    @Generated
    public Integer getMinute() {
        return this.minute;
    }

    @Generated
    public Integer getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Generated
    public Integer getDayOfMonth() {
        return this.dayOfMonth;
    }

    @Generated
    public Integer getMonthOfYear() {
        return this.monthOfYear;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setTab(Integer tab) {
        this.tab = tab;
    }

    @Generated
    public void setTabIdList(List<String> tabIdList) {
        this.tabIdList = tabIdList;
    }

    @Generated
    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    @Generated
    public void setReportType(Integer reportType) {
        this.reportType = reportType;
    }

    @Generated
    public void setEmailList(List<String> emailList) {
        this.emailList = emailList;
    }

    @Generated
    public void setTime(Long time) {
        this.time = time;
    }

    @Generated
    public void setCards(String cards) {
        this.cards = cards;
    }

    @Generated
    public void setTimingType(Integer timingType) {
        this.timingType = timingType;
    }

    @Generated
    public void setHour(Integer hour) {
        this.hour = hour;
    }

    @Generated
    public void setMinute(Integer minute) {
        this.minute = minute;
    }

    @Generated
    public void setDayOfWeek(Integer dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    @Generated
    public void setDayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    @Generated
    public void setMonthOfYear(Integer monthOfYear) {
        this.monthOfYear = monthOfYear;
    }

    @Generated
    public String toString() {
        return "NetworkReportScheduleVO(enable=" + this.getEnable() + ", tab=" + this.getTab() + ", tabIdList=" + this.getTabIdList() + ", reportName=" + this.getReportName() + ", reportType=" + this.getReportType() + ", emailList=" + this.getEmailList() + ", time=" + this.getTime() + ", cards=" + this.getCards() + ", timingType=" + this.getTimingType() + ", hour=" + this.getHour() + ", minute=" + this.getMinute() + ", dayOfWeek=" + this.getDayOfWeek() + ", dayOfMonth=" + this.getDayOfMonth() + ", monthOfYear=" + this.getMonthOfYear() + ")";
    }

    @Generated
    public NetworkReportScheduleVO() {
    }

    @Generated
    public NetworkReportScheduleVO(Boolean enable, Integer tab, List<String> tabIdList, String reportName, Integer reportType, List<String> emailList, Long time, String cards, Integer timingType, Integer hour, Integer minute, Integer dayOfWeek, Integer dayOfMonth, Integer monthOfYear) {
        this.enable = enable;
        this.tab = tab;
        this.tabIdList = tabIdList;
        this.reportName = reportName;
        this.reportType = reportType;
        this.emailList = emailList;
        this.time = time;
        this.cards = cards;
        this.timingType = timingType;
        this.hour = hour;
        this.minute = minute;
        this.dayOfWeek = dayOfWeek;
        this.dayOfMonth = dayOfMonth;
        this.monthOfYear = monthOfYear;
    }

    @Generated
    public static class NetworkReportScheduleVOBuilder {
        @Generated
        private Boolean enable;
        @Generated
        private Integer tab;
        @Generated
        private List<String> tabIdList;
        @Generated
        private String reportName;
        @Generated
        private Integer reportType;
        @Generated
        private List<String> emailList;
        @Generated
        private Long time;
        @Generated
        private String cards;
        @Generated
        private Integer timingType;
        @Generated
        private Integer hour;
        @Generated
        private Integer minute;
        @Generated
        private Integer dayOfWeek;
        @Generated
        private Integer dayOfMonth;
        @Generated
        private Integer monthOfYear;

        @Generated
        NetworkReportScheduleVOBuilder() {
        }

        @Generated
        public NetworkReportScheduleVOBuilder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        @Generated
        public NetworkReportScheduleVOBuilder tab(Integer tab) {
            this.tab = tab;
            return this;
        }

        @Generated
        public NetworkReportScheduleVOBuilder tabIdList(List<String> tabIdList) {
            this.tabIdList = tabIdList;
            return this;
        }

        @Generated
        public NetworkReportScheduleVOBuilder reportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        @Generated
        public NetworkReportScheduleVOBuilder reportType(Integer reportType) {
            this.reportType = reportType;
            return this;
        }

        @Generated
        public NetworkReportScheduleVOBuilder emailList(List<String> emailList) {
            this.emailList = emailList;
            return this;
        }

        @Generated
        public NetworkReportScheduleVOBuilder time(Long time) {
            this.time = time;
            return this;
        }

        @Generated
        public NetworkReportScheduleVOBuilder cards(String cards) {
            this.cards = cards;
            return this;
        }

        @Generated
        public NetworkReportScheduleVOBuilder timingType(Integer timingType) {
            this.timingType = timingType;
            return this;
        }

        @Generated
        public NetworkReportScheduleVOBuilder hour(Integer hour) {
            this.hour = hour;
            return this;
        }

        @Generated
        public NetworkReportScheduleVOBuilder minute(Integer minute) {
            this.minute = minute;
            return this;
        }

        @Generated
        public NetworkReportScheduleVOBuilder dayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Generated
        public NetworkReportScheduleVOBuilder dayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        @Generated
        public NetworkReportScheduleVOBuilder monthOfYear(Integer monthOfYear) {
            this.monthOfYear = monthOfYear;
            return this;
        }

        @Generated
        public NetworkReportScheduleVO build() {
            return new NetworkReportScheduleVO(this.enable, this.tab, this.tabIdList, this.reportName, this.reportType, this.emailList, this.time, this.cards, this.timingType, this.hour, this.minute, this.dayOfWeek, this.dayOfMonth, this.monthOfYear);
        }

        @Generated
        public String toString() {
            return "NetworkReportScheduleVO.NetworkReportScheduleVOBuilder(enable=" + this.enable + ", tab=" + this.tab + ", tabIdList=" + this.tabIdList + ", reportName=" + this.reportName + ", reportType=" + this.reportType + ", emailList=" + this.emailList + ", time=" + this.time + ", cards=" + this.cards + ", timingType=" + this.timingType + ", hour=" + this.hour + ", minute=" + this.minute + ", dayOfWeek=" + this.dayOfWeek + ", dayOfMonth=" + this.dayOfMonth + ", monthOfYear=" + this.monthOfYear + ")";
        }
    }
}

