/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.insight.port.mongo.anomaly;

import com.tplink.smb.omada.anomaly.api.b.h;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.insight.api.web.anomaly.vo.AnomalyCountVO;
import com.tplink.smb.omada.insight.api.web.anomaly.vo.SiteIncidentCountVO;
import com.tplink.smb.omada.insight.port.mongo.c.a;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@KeepClass
public class SiteAnomalyLevelCount {
    private String site;
    private Integer level;
    private Integer count;

    public static Map<String, SiteIncidentCountVO> transformSiteIncidentCount(List<SiteAnomalyLevelCount> levelCountList) {
        if (CollectionUtils.isEmpty(levelCountList)) {
            return new HashMap<String, SiteIncidentCountVO>();
        }
        HashMap<String, SiteIncidentCountVO> siteIncidentCounts = new HashMap<String, SiteIncidentCountVO>();
        levelCountList.forEach(anomalyLevelCount -> {
            String siteId = anomalyLevelCount.getSite();
            Integer level = anomalyLevelCount.getLevel();
            if (Objects.isNull(siteId) || Objects.isNull(level)) {
                return;
            }
            SiteIncidentCountVO siteIncidentCountVO = siteIncidentCounts.computeIfAbsent(siteId, SiteIncidentCountVO::buildDefault);
            h anomalyLevel = h.a((int)anomalyLevelCount.getLevel());
            if (Objects.nonNull(anomalyLevel)) {
                SiteAnomalyLevelCount.a(siteIncidentCountVO, anomalyLevel, anomalyLevelCount.getCount());
            }
        });
        return siteIncidentCounts;
    }

    private static void a(@Nonnull SiteIncidentCountVO siteIncidentCountVO, h anomalyLevel, Integer count) {
        if (Objects.isNull(siteIncidentCountVO.getIncidentNum())) {
            siteIncidentCountVO.setIncidentNum(AnomalyCountVO.buildDefault());
        }
        switch (anomalyLevel) {
            case a: {
                siteIncidentCountVO.getIncidentNum().setCritical(Integer.valueOf(a.a(siteIncidentCountVO.getIncidentNum().getCritical(), count)));
                break;
            }
            case b: {
                siteIncidentCountVO.getIncidentNum().setError(Integer.valueOf(a.a(siteIncidentCountVO.getIncidentNum().getError(), count)));
                break;
            }
            case c: {
                siteIncidentCountVO.getIncidentNum().setWarn(Integer.valueOf(a.a(siteIncidentCountVO.getIncidentNum().getWarn(), count)));
                break;
            }
            case d: {
                siteIncidentCountVO.getIncidentNum().setInfo(Integer.valueOf(a.a(siteIncidentCountVO.getIncidentNum().getInfo(), count)));
                break;
            }
        }
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public Integer getLevel() {
        return this.level;
    }

    @Generated
    public Integer getCount() {
        return this.count;
    }

    @Generated
    public void setSite(String site) {
        this.site = site;
    }

    @Generated
    public void setLevel(Integer level) {
        this.level = level;
    }

    @Generated
    public void setCount(Integer count) {
        this.count = count;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SiteAnomalyLevelCount)) {
            return false;
        }
        SiteAnomalyLevelCount other = (SiteAnomalyLevelCount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$level = this.getLevel();
        Integer other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        String this$site = this.getSite();
        String other$site = other.getSite();
        return !(this$site == null ? other$site != null : !this$site.equals(other$site));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SiteAnomalyLevelCount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        String $site = this.getSite();
        result = result * 59 + ($site == null ? 43 : $site.hashCode());
        return result;
    }

    @Generated
    public SiteAnomalyLevelCount(String site, Integer level, Integer count) {
        this.site = site;
        this.level = level;
        this.count = count;
    }

    @Generated
    public SiteAnomalyLevelCount() {
    }

    @Generated
    public String toString() {
        return "SiteAnomalyLevelCount(site=" + this.getSite() + ", level=" + this.getLevel() + ", count=" + this.getCount() + ")";
    }
}

