/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.system.systeminfo;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.device.manage.message.body.olt.DeviceResponseBody;
import com.tplink.smb.omada.manager.c.b.aX;
import com.tplink.smb.omada.manager.c.b.ac;
import com.tplink.smb.omada.manager.c.b.cA;
import com.tplink.smb.omada.manager.c.b.cS;
import com.tplink.smb.omada.manager.c.b.cs;
import com.tplink.smb.omada.manager.c.b.ct;
import com.tplink.smb.omada.manager.c.b.cz;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import com.tplink.smb.omada.manager.device.olt.system.systeminfo.entity.SystemInfoDstPredefined;
import com.tplink.smb.omada.manager.util.d;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfoTimeConfigDTO
extends DpmsBaseDeviceDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemInfoTimeConfigDTO.class);
    @NotNull(message="currentTimeSource can not be null")
    private @NotNull(message="currentTimeSource can not be null") cA currentTimeSource;
    @Range(min=2000L, max=2037L, message="year should be a number between {min}-{max}")
    private @Range(min=2000L, max=2037L, message="year should be a number between {min}-{max}") Integer year;
    private aX month;
    private Integer day;
    @Range(min=0L, max=23L, message="hour should be a number between {min}-{max}")
    private @Range(min=0L, max=23L, message="hour should be a number between {min}-{max}") Integer hour;
    @Range(min=0L, max=59L, message="minute should be a number between {min}-{max}")
    private @Range(min=0L, max=59L, message="minute should be a number between {min}-{max}") Integer minute;
    @Range(min=0L, max=59L, message="second should be a number between {min}-{max}")
    private @Range(min=0L, max=59L, message="second should be a number between {min}-{max}") Integer second;
    @Pattern(regexp="^(\\+(0\\d|1[0-3])|\\-(0[1-9]|1[0-2])):00|(\\-0[3-4]|\\+0([3-6]|9)):30|\\+05:45$", message="invalid time zone format.")
    private @Pattern(regexp="^(\\+(0\\d|1[0-3])|\\-(0[1-9]|1[0-2])):00|(\\-0[3-4]|\\+0([3-6]|9)):30|\\+05:45$", message="invalid time zone format.") String timeZone;
    private String primaryNtpServer;
    private String secondaryNtpServer;
    @Range(min=1L, max=24L, message="updateRate should be in {min}-{max}")
    private @Range(min=1L, max=24L, message="updateRate should be in {min}-{max}") Integer updateRate;
    @NotNull(message="dstStatus can not be null")
    private @NotNull(message="dstStatus can not be null") ac dstStatus;
    private ct dstMode;
    private cz predefinedProfile;
    private List<SystemInfoDstPredefined> predefinedList;
    @Range(min=1L, max=1440L, message="offset should be in {min}-{max}")
    private @Range(min=1L, max=1440L, message="offset should be in {min}-{max}") Integer offset;
    private cs startWeekRecurring;
    private cS startDayRecurring;
    private aX startMonthRecurring;
    @Pattern(regexp="^([0-1][0-9]|[2][0-3]):[0-5][0-9]$")
    private @Pattern(regexp="^([0-1][0-9]|[2][0-3]):[0-5][0-9]$") String startTimeRecurring;
    private cs endWeekRecurring;
    private cS endDayRecurring;
    private aX endMonthRecurring;
    @Pattern(regexp="^([0-1][0-9]|[2][0-3]):[0-5][0-9]$")
    private @Pattern(regexp="^([0-1][0-9]|[2][0-3]):[0-5][0-9]$") String endTimeRecurring;

    public OperationResponse<DeviceResponseBody<Void>> check() {
        switch (this.currentTimeSource) {
            case c: 
            case a: {
                if (Objects.isNull(this.year) || Objects.isNull(this.month) || Objects.isNull(this.day) || Objects.isNull(this.hour) || Objects.isNull(this.minute) || Objects.isNull(this.second)) {
                    return new OperationResponse(b.d, "When currentTimeSource is MANUALLY/PC CLOCK, date information related can not be null", null);
                }
                if (!d.a((int)this.month.ordinal(), (int)this.day, (int)this.year)) break;
                return new OperationResponse(b.d, "illegal date", null);
            }
            case b: {
                if (Objects.isNull(this.timeZone) || Objects.isNull(this.primaryNtpServer) || Objects.isNull(this.secondaryNtpServer) || Objects.isNull(this.updateRate)) {
                    return new OperationResponse(b.d, "When currentTimeSource is NTP_SERVER, timeZone/primaryNtpServer/secondaryNtpServer/updateRate can not be null", null);
                }
                if (!(java.util.regex.Pattern.matches("^\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b$", this.primaryNtpServer) || java.util.regex.Pattern.matches("^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$", this.primaryNtpServer) || java.util.regex.Pattern.matches("(?=^.{3,64}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+", this.primaryNtpServer))) {
                    return new OperationResponse(b.d, "Invalid primaryNtpServer format", null);
                }
                if (java.util.regex.Pattern.matches("^\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b$", this.secondaryNtpServer) || java.util.regex.Pattern.matches("^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$", this.secondaryNtpServer) || java.util.regex.Pattern.matches("(?=^.{3,64}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+", this.secondaryNtpServer)) break;
                return new OperationResponse(b.d, "Invalid secondaryNtpServer format", null);
            }
            default: {
                return null;
            }
        }
        if (Objects.equals(this.dstStatus, ac.b)) {
            if (Objects.isNull(this.dstMode)) {
                return new OperationResponse(b.d, "When dstStatus is ENABLE, mode can not be null", null);
            }
            switch (this.dstMode) {
                case a: {
                    if (!Objects.isNull(this.predefinedProfile)) break;
                    return new OperationResponse(b.d, "When mode is PREDEFINED, predefinedProfile can not be null", null);
                }
                case b: {
                    boolean nullStatus;
                    boolean bl = nullStatus = Objects.isNull(this.startWeekRecurring) || Objects.isNull(this.startDayRecurring) || Objects.isNull(this.startMonthRecurring) || Objects.isNull(this.startTimeRecurring) || Objects.isNull(this.endWeekRecurring) || Objects.isNull(this.endDayRecurring) || Objects.isNull(this.endMonthRecurring) || Objects.isNull(this.endTimeRecurring);
                    if (!nullStatus) break;
                    return new OperationResponse(b.d, "When mode is RECURING, startTimeRecuring and endTimeRecuring can not be null", null);
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    @Generated
    public SystemInfoTimeConfigDTO() {
    }

    @Generated
    public cA getCurrentTimeSource() {
        return this.currentTimeSource;
    }

    @Generated
    public Integer getYear() {
        return this.year;
    }

    @Generated
    public aX getMonth() {
        return this.month;
    }

    @Generated
    public Integer getDay() {
        return this.day;
    }

    @Generated
    public Integer getHour() {
        return this.hour;
    }

    @Generated
    public Integer getMinute() {
        return this.minute;
    }

    @Generated
    public Integer getSecond() {
        return this.second;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public String getPrimaryNtpServer() {
        return this.primaryNtpServer;
    }

    @Generated
    public String getSecondaryNtpServer() {
        return this.secondaryNtpServer;
    }

    @Generated
    public Integer getUpdateRate() {
        return this.updateRate;
    }

    @Generated
    public ac getDstStatus() {
        return this.dstStatus;
    }

    @Generated
    public ct getDstMode() {
        return this.dstMode;
    }

    @Generated
    public cz getPredefinedProfile() {
        return this.predefinedProfile;
    }

    @Generated
    public List<SystemInfoDstPredefined> getPredefinedList() {
        return this.predefinedList;
    }

    @Generated
    public Integer getOffset() {
        return this.offset;
    }

    @Generated
    public cs getStartWeekRecurring() {
        return this.startWeekRecurring;
    }

    @Generated
    public cS getStartDayRecurring() {
        return this.startDayRecurring;
    }

    @Generated
    public aX getStartMonthRecurring() {
        return this.startMonthRecurring;
    }

    @Generated
    public String getStartTimeRecurring() {
        return this.startTimeRecurring;
    }

    @Generated
    public cs getEndWeekRecurring() {
        return this.endWeekRecurring;
    }

    @Generated
    public cS getEndDayRecurring() {
        return this.endDayRecurring;
    }

    @Generated
    public aX getEndMonthRecurring() {
        return this.endMonthRecurring;
    }

    @Generated
    public String getEndTimeRecurring() {
        return this.endTimeRecurring;
    }

    @Generated
    public SystemInfoTimeConfigDTO setCurrentTimeSource(cA currentTimeSource) {
        this.currentTimeSource = currentTimeSource;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setYear(Integer year) {
        this.year = year;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setMonth(aX month) {
        this.month = month;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setDay(Integer day) {
        this.day = day;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setHour(Integer hour) {
        this.hour = hour;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setMinute(Integer minute) {
        this.minute = minute;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setSecond(Integer second) {
        this.second = second;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setPrimaryNtpServer(String primaryNtpServer) {
        this.primaryNtpServer = primaryNtpServer;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setSecondaryNtpServer(String secondaryNtpServer) {
        this.secondaryNtpServer = secondaryNtpServer;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setUpdateRate(Integer updateRate) {
        this.updateRate = updateRate;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setDstStatus(ac dstStatus) {
        this.dstStatus = dstStatus;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setDstMode(ct dstMode) {
        this.dstMode = dstMode;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setPredefinedProfile(cz predefinedProfile) {
        this.predefinedProfile = predefinedProfile;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setPredefinedList(List<SystemInfoDstPredefined> predefinedList) {
        this.predefinedList = predefinedList;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setStartWeekRecurring(cs startWeekRecurring) {
        this.startWeekRecurring = startWeekRecurring;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setStartDayRecurring(cS startDayRecurring) {
        this.startDayRecurring = startDayRecurring;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setStartMonthRecurring(aX startMonthRecurring) {
        this.startMonthRecurring = startMonthRecurring;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setStartTimeRecurring(String startTimeRecurring) {
        this.startTimeRecurring = startTimeRecurring;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setEndWeekRecurring(cs endWeekRecurring) {
        this.endWeekRecurring = endWeekRecurring;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setEndDayRecurring(cS endDayRecurring) {
        this.endDayRecurring = endDayRecurring;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setEndMonthRecurring(aX endMonthRecurring) {
        this.endMonthRecurring = endMonthRecurring;
        return this;
    }

    @Generated
    public SystemInfoTimeConfigDTO setEndTimeRecurring(String endTimeRecurring) {
        this.endTimeRecurring = endTimeRecurring;
        return this;
    }

    @Generated
    public String toString() {
        return "SystemInfoTimeConfigDTO(currentTimeSource=" + this.getCurrentTimeSource() + ", year=" + this.getYear() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ", hour=" + this.getHour() + ", minute=" + this.getMinute() + ", second=" + this.getSecond() + ", timeZone=" + this.getTimeZone() + ", primaryNtpServer=" + this.getPrimaryNtpServer() + ", secondaryNtpServer=" + this.getSecondaryNtpServer() + ", updateRate=" + this.getUpdateRate() + ", dstStatus=" + this.getDstStatus() + ", dstMode=" + this.getDstMode() + ", predefinedProfile=" + this.getPredefinedProfile() + ", predefinedList=" + this.getPredefinedList() + ", offset=" + this.getOffset() + ", startWeekRecurring=" + this.getStartWeekRecurring() + ", startDayRecurring=" + this.getStartDayRecurring() + ", startMonthRecurring=" + this.getStartMonthRecurring() + ", startTimeRecurring=" + this.getStartTimeRecurring() + ", endWeekRecurring=" + this.getEndWeekRecurring() + ", endDayRecurring=" + this.getEndDayRecurring() + ", endMonthRecurring=" + this.getEndMonthRecurring() + ", endTimeRecurring=" + this.getEndTimeRecurring() + ")";
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof SystemInfoTimeConfigDTO)) {
            return false;
        }
        SystemInfoTimeConfigDTO other = (SystemInfoTimeConfigDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$year = this.getYear();
        Integer other$year = other.getYear();
        if (this$year == null ? other$year != null : !((Object)this$year).equals(other$year)) {
            return false;
        }
        Integer this$day = this.getDay();
        Integer other$day = other.getDay();
        if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
            return false;
        }
        Integer this$hour = this.getHour();
        Integer other$hour = other.getHour();
        if (this$hour == null ? other$hour != null : !((Object)this$hour).equals(other$hour)) {
            return false;
        }
        Integer this$minute = this.getMinute();
        Integer other$minute = other.getMinute();
        if (this$minute == null ? other$minute != null : !((Object)this$minute).equals(other$minute)) {
            return false;
        }
        Integer this$second = this.getSecond();
        Integer other$second = other.getSecond();
        if (this$second == null ? other$second != null : !((Object)this$second).equals(other$second)) {
            return false;
        }
        Integer this$updateRate = this.getUpdateRate();
        Integer other$updateRate = other.getUpdateRate();
        if (this$updateRate == null ? other$updateRate != null : !((Object)this$updateRate).equals(other$updateRate)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        cA this$currentTimeSource = this.getCurrentTimeSource();
        cA other$currentTimeSource = other.getCurrentTimeSource();
        if (this$currentTimeSource == null ? other$currentTimeSource != null : !this$currentTimeSource.equals(other$currentTimeSource)) {
            return false;
        }
        aX this$month = this.getMonth();
        aX other$month = other.getMonth();
        if (this$month == null ? other$month != null : !this$month.equals(other$month)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        String this$primaryNtpServer = this.getPrimaryNtpServer();
        String other$primaryNtpServer = other.getPrimaryNtpServer();
        if (this$primaryNtpServer == null ? other$primaryNtpServer != null : !this$primaryNtpServer.equals(other$primaryNtpServer)) {
            return false;
        }
        String this$secondaryNtpServer = this.getSecondaryNtpServer();
        String other$secondaryNtpServer = other.getSecondaryNtpServer();
        if (this$secondaryNtpServer == null ? other$secondaryNtpServer != null : !this$secondaryNtpServer.equals(other$secondaryNtpServer)) {
            return false;
        }
        ac this$dstStatus = this.getDstStatus();
        ac other$dstStatus = other.getDstStatus();
        if (this$dstStatus == null ? other$dstStatus != null : !this$dstStatus.equals(other$dstStatus)) {
            return false;
        }
        ct this$dstMode = this.getDstMode();
        ct other$dstMode = other.getDstMode();
        if (this$dstMode == null ? other$dstMode != null : !this$dstMode.equals(other$dstMode)) {
            return false;
        }
        cz this$predefinedProfile = this.getPredefinedProfile();
        cz other$predefinedProfile = other.getPredefinedProfile();
        if (this$predefinedProfile == null ? other$predefinedProfile != null : !this$predefinedProfile.equals(other$predefinedProfile)) {
            return false;
        }
        List<SystemInfoDstPredefined> this$predefinedList = this.getPredefinedList();
        List<SystemInfoDstPredefined> other$predefinedList = other.getPredefinedList();
        if (this$predefinedList == null ? other$predefinedList != null : !((Object)this$predefinedList).equals(other$predefinedList)) {
            return false;
        }
        cs this$startWeekRecurring = this.getStartWeekRecurring();
        cs other$startWeekRecurring = other.getStartWeekRecurring();
        if (this$startWeekRecurring == null ? other$startWeekRecurring != null : !this$startWeekRecurring.equals(other$startWeekRecurring)) {
            return false;
        }
        cS this$startDayRecurring = this.getStartDayRecurring();
        cS other$startDayRecurring = other.getStartDayRecurring();
        if (this$startDayRecurring == null ? other$startDayRecurring != null : !this$startDayRecurring.equals(other$startDayRecurring)) {
            return false;
        }
        aX this$startMonthRecurring = this.getStartMonthRecurring();
        aX other$startMonthRecurring = other.getStartMonthRecurring();
        if (this$startMonthRecurring == null ? other$startMonthRecurring != null : !this$startMonthRecurring.equals(other$startMonthRecurring)) {
            return false;
        }
        String this$startTimeRecurring = this.getStartTimeRecurring();
        String other$startTimeRecurring = other.getStartTimeRecurring();
        if (this$startTimeRecurring == null ? other$startTimeRecurring != null : !this$startTimeRecurring.equals(other$startTimeRecurring)) {
            return false;
        }
        cs this$endWeekRecurring = this.getEndWeekRecurring();
        cs other$endWeekRecurring = other.getEndWeekRecurring();
        if (this$endWeekRecurring == null ? other$endWeekRecurring != null : !this$endWeekRecurring.equals(other$endWeekRecurring)) {
            return false;
        }
        cS this$endDayRecurring = this.getEndDayRecurring();
        cS other$endDayRecurring = other.getEndDayRecurring();
        if (this$endDayRecurring == null ? other$endDayRecurring != null : !this$endDayRecurring.equals(other$endDayRecurring)) {
            return false;
        }
        aX this$endMonthRecurring = this.getEndMonthRecurring();
        aX other$endMonthRecurring = other.getEndMonthRecurring();
        if (this$endMonthRecurring == null ? other$endMonthRecurring != null : !this$endMonthRecurring.equals(other$endMonthRecurring)) {
            return false;
        }
        String this$endTimeRecurring = this.getEndTimeRecurring();
        String other$endTimeRecurring = other.getEndTimeRecurring();
        return !(this$endTimeRecurring == null ? other$endTimeRecurring != null : !this$endTimeRecurring.equals(other$endTimeRecurring));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SystemInfoTimeConfigDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $year = this.getYear();
        result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
        Integer $day = this.getDay();
        result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
        Integer $hour = this.getHour();
        result = result * 59 + ($hour == null ? 43 : ((Object)$hour).hashCode());
        Integer $minute = this.getMinute();
        result = result * 59 + ($minute == null ? 43 : ((Object)$minute).hashCode());
        Integer $second = this.getSecond();
        result = result * 59 + ($second == null ? 43 : ((Object)$second).hashCode());
        Integer $updateRate = this.getUpdateRate();
        result = result * 59 + ($updateRate == null ? 43 : ((Object)$updateRate).hashCode());
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        cA $currentTimeSource = this.getCurrentTimeSource();
        result = result * 59 + ($currentTimeSource == null ? 43 : $currentTimeSource.hashCode());
        aX $month = this.getMonth();
        result = result * 59 + ($month == null ? 43 : $month.hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        String $primaryNtpServer = this.getPrimaryNtpServer();
        result = result * 59 + ($primaryNtpServer == null ? 43 : $primaryNtpServer.hashCode());
        String $secondaryNtpServer = this.getSecondaryNtpServer();
        result = result * 59 + ($secondaryNtpServer == null ? 43 : $secondaryNtpServer.hashCode());
        ac $dstStatus = this.getDstStatus();
        result = result * 59 + ($dstStatus == null ? 43 : $dstStatus.hashCode());
        ct $dstMode = this.getDstMode();
        result = result * 59 + ($dstMode == null ? 43 : $dstMode.hashCode());
        cz $predefinedProfile = this.getPredefinedProfile();
        result = result * 59 + ($predefinedProfile == null ? 43 : $predefinedProfile.hashCode());
        List<SystemInfoDstPredefined> $predefinedList = this.getPredefinedList();
        result = result * 59 + ($predefinedList == null ? 43 : ((Object)$predefinedList).hashCode());
        cs $startWeekRecurring = this.getStartWeekRecurring();
        result = result * 59 + ($startWeekRecurring == null ? 43 : $startWeekRecurring.hashCode());
        cS $startDayRecurring = this.getStartDayRecurring();
        result = result * 59 + ($startDayRecurring == null ? 43 : $startDayRecurring.hashCode());
        aX $startMonthRecurring = this.getStartMonthRecurring();
        result = result * 59 + ($startMonthRecurring == null ? 43 : $startMonthRecurring.hashCode());
        String $startTimeRecurring = this.getStartTimeRecurring();
        result = result * 59 + ($startTimeRecurring == null ? 43 : $startTimeRecurring.hashCode());
        cs $endWeekRecurring = this.getEndWeekRecurring();
        result = result * 59 + ($endWeekRecurring == null ? 43 : $endWeekRecurring.hashCode());
        cS $endDayRecurring = this.getEndDayRecurring();
        result = result * 59 + ($endDayRecurring == null ? 43 : $endDayRecurring.hashCode());
        aX $endMonthRecurring = this.getEndMonthRecurring();
        result = result * 59 + ($endMonthRecurring == null ? 43 : $endMonthRecurring.hashCode());
        String $endTimeRecurring = this.getEndTimeRecurring();
        result = result * 59 + ($endTimeRecurring == null ? 43 : $endTimeRecurring.hashCode());
        return result;
    }
}

