/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.security.acl;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.device.manage.message.body.olt.DeviceResponseBody;
import com.tplink.smb.omada.manager.c.b.ac;
import com.tplink.smb.omada.manager.c.b.ay;
import com.tplink.smb.omada.manager.c.b.h;
import com.tplink.smb.omada.manager.device.api.web.validation.olt.SortedField;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import com.tplink.smb.omada.manager.device.olt.security.acl.entity.IpProtocolAggregationEntity;
import com.tplink.smb.omada.manager.device.olt.security.acl.entity.IpV6MaskEntity;
import com.tplink.smb.omada.manager.device.olt.security.acl.entity.PolicyAggregationEntity;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class AclRuleConfigIpv6DTO
extends DpmsBaseDeviceDTO {
    @NotNull(message="aclId should not be null")
    @Range(min=0L, max=1999L, message="aclId should be between in {min} and {max}")
    private @NotNull(message="aclId should not be null") @Range(min=0L, max=1999L, message="aclId should be between in {min} and {max}") Integer aclId;
    @Range(min=1L, max=0x7FFFFFFFL, message="ruleId should be a number between {min}-{max}")
    @SortedField
    private @Range(min=1L, max=0x7FFFFFFFL, message="ruleId should be a number between {min}-{max}") Integer ruleId;
    @NotNull(message="ruleIdAutoAssign should not be null")
    private @NotNull(message="ruleIdAutoAssign should not be null") ac ruleIdAutoAssign;
    @NotNull(message="The operation should not be null")
    private @NotNull(message="The operation should not be null") h operation;
    @Range(min=0L, max=63L, message="ipv6Class should be between {min} and {max}")
    private @Range(min=0L, max=63L, message="ipv6Class should be between {min} and {max}") Integer ipv6Class;
    @Pattern(regexp="^[A-Fa-f0-9]{5}$")
    private @Pattern(regexp="^[A-Fa-f0-9]{5}$") String flowLabel;
    @Valid
    private IpV6MaskEntity sourceIpv6Mask;
    @Valid
    private IpV6MaskEntity destinationIpv6Mask;
    @NotNull(message="The ipProtocolType should not be null")
    private @NotNull(message="The ipProtocolType should not be null") ay ipProtocolType;
    @Valid
    private IpProtocolAggregationEntity ipProtocolBody;
    private String timeRange;
    @NotNull(message="logging should not be null")
    private @NotNull(message="logging should not be null") ac logging;
    private PolicyAggregationEntity policy;
    @Null(message="totalMatchedCounter should be null")
    private @Null(message="totalMatchedCounter should be null") Long totalMatchedCounter;
    private Integer supportPrefixLen;

    public OperationResponse<DeviceResponseBody<Void>> check() {
        if (Objects.nonNull(this.policy)) {
            OperationResponse<Void> policyResponse = this.policy.check();
            if (Objects.nonNull(policyResponse)) {
                return new OperationResponse(policyResponse.getErrorCode(), policyResponse.getMsg(), null);
            }
            return null;
        }
        return null;
    }

    @Generated
    public AclRuleConfigIpv6DTO() {
    }

    @Generated
    public Integer getAclId() {
        return this.aclId;
    }

    @Generated
    public Integer getRuleId() {
        return this.ruleId;
    }

    @Generated
    public ac getRuleIdAutoAssign() {
        return this.ruleIdAutoAssign;
    }

    @Generated
    public h getOperation() {
        return this.operation;
    }

    @Generated
    public Integer getIpv6Class() {
        return this.ipv6Class;
    }

    @Generated
    public String getFlowLabel() {
        return this.flowLabel;
    }

    @Generated
    public IpV6MaskEntity getSourceIpv6Mask() {
        return this.sourceIpv6Mask;
    }

    @Generated
    public IpV6MaskEntity getDestinationIpv6Mask() {
        return this.destinationIpv6Mask;
    }

    @Generated
    public ay getIpProtocolType() {
        return this.ipProtocolType;
    }

    @Generated
    public IpProtocolAggregationEntity getIpProtocolBody() {
        return this.ipProtocolBody;
    }

    @Generated
    public String getTimeRange() {
        return this.timeRange;
    }

    @Generated
    public ac getLogging() {
        return this.logging;
    }

    @Generated
    public PolicyAggregationEntity getPolicy() {
        return this.policy;
    }

    @Generated
    public Long getTotalMatchedCounter() {
        return this.totalMatchedCounter;
    }

    @Generated
    public Integer getSupportPrefixLen() {
        return this.supportPrefixLen;
    }

    @Generated
    public AclRuleConfigIpv6DTO setAclId(Integer aclId) {
        this.aclId = aclId;
        return this;
    }

    @Generated
    public AclRuleConfigIpv6DTO setRuleId(Integer ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    @Generated
    public AclRuleConfigIpv6DTO setRuleIdAutoAssign(ac ruleIdAutoAssign) {
        this.ruleIdAutoAssign = ruleIdAutoAssign;
        return this;
    }

    @Generated
    public AclRuleConfigIpv6DTO setOperation(h operation) {
        this.operation = operation;
        return this;
    }

    @Generated
    public AclRuleConfigIpv6DTO setIpv6Class(Integer ipv6Class) {
        this.ipv6Class = ipv6Class;
        return this;
    }

    @Generated
    public AclRuleConfigIpv6DTO setFlowLabel(String flowLabel) {
        this.flowLabel = flowLabel;
        return this;
    }

    @Generated
    public AclRuleConfigIpv6DTO setSourceIpv6Mask(IpV6MaskEntity sourceIpv6Mask) {
        this.sourceIpv6Mask = sourceIpv6Mask;
        return this;
    }

    @Generated
    public AclRuleConfigIpv6DTO setDestinationIpv6Mask(IpV6MaskEntity destinationIpv6Mask) {
        this.destinationIpv6Mask = destinationIpv6Mask;
        return this;
    }

    @Generated
    public AclRuleConfigIpv6DTO setIpProtocolType(ay ipProtocolType) {
        this.ipProtocolType = ipProtocolType;
        return this;
    }

    @Generated
    public AclRuleConfigIpv6DTO setIpProtocolBody(IpProtocolAggregationEntity ipProtocolBody) {
        this.ipProtocolBody = ipProtocolBody;
        return this;
    }

    @Generated
    public AclRuleConfigIpv6DTO setTimeRange(String timeRange) {
        this.timeRange = timeRange;
        return this;
    }

    @Generated
    public AclRuleConfigIpv6DTO setLogging(ac logging) {
        this.logging = logging;
        return this;
    }

    @Generated
    public AclRuleConfigIpv6DTO setPolicy(PolicyAggregationEntity policy) {
        this.policy = policy;
        return this;
    }

    @Generated
    public AclRuleConfigIpv6DTO setTotalMatchedCounter(Long totalMatchedCounter) {
        this.totalMatchedCounter = totalMatchedCounter;
        return this;
    }

    @Generated
    public AclRuleConfigIpv6DTO setSupportPrefixLen(Integer supportPrefixLen) {
        this.supportPrefixLen = supportPrefixLen;
        return this;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof AclRuleConfigIpv6DTO)) {
            return false;
        }
        AclRuleConfigIpv6DTO other = (AclRuleConfigIpv6DTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$aclId = this.getAclId();
        Integer other$aclId = other.getAclId();
        if (this$aclId == null ? other$aclId != null : !((Object)this$aclId).equals(other$aclId)) {
            return false;
        }
        Integer this$ruleId = this.getRuleId();
        Integer other$ruleId = other.getRuleId();
        if (this$ruleId == null ? other$ruleId != null : !((Object)this$ruleId).equals(other$ruleId)) {
            return false;
        }
        Integer this$ipv6Class = this.getIpv6Class();
        Integer other$ipv6Class = other.getIpv6Class();
        if (this$ipv6Class == null ? other$ipv6Class != null : !((Object)this$ipv6Class).equals(other$ipv6Class)) {
            return false;
        }
        Long this$totalMatchedCounter = this.getTotalMatchedCounter();
        Long other$totalMatchedCounter = other.getTotalMatchedCounter();
        if (this$totalMatchedCounter == null ? other$totalMatchedCounter != null : !((Object)this$totalMatchedCounter).equals(other$totalMatchedCounter)) {
            return false;
        }
        Integer this$supportPrefixLen = this.getSupportPrefixLen();
        Integer other$supportPrefixLen = other.getSupportPrefixLen();
        if (this$supportPrefixLen == null ? other$supportPrefixLen != null : !((Object)this$supportPrefixLen).equals(other$supportPrefixLen)) {
            return false;
        }
        ac this$ruleIdAutoAssign = this.getRuleIdAutoAssign();
        ac other$ruleIdAutoAssign = other.getRuleIdAutoAssign();
        if (this$ruleIdAutoAssign == null ? other$ruleIdAutoAssign != null : !this$ruleIdAutoAssign.equals(other$ruleIdAutoAssign)) {
            return false;
        }
        h this$operation = this.getOperation();
        h other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
            return false;
        }
        String this$flowLabel = this.getFlowLabel();
        String other$flowLabel = other.getFlowLabel();
        if (this$flowLabel == null ? other$flowLabel != null : !this$flowLabel.equals(other$flowLabel)) {
            return false;
        }
        IpV6MaskEntity this$sourceIpv6Mask = this.getSourceIpv6Mask();
        IpV6MaskEntity other$sourceIpv6Mask = other.getSourceIpv6Mask();
        if (this$sourceIpv6Mask == null ? other$sourceIpv6Mask != null : !((Object)this$sourceIpv6Mask).equals(other$sourceIpv6Mask)) {
            return false;
        }
        IpV6MaskEntity this$destinationIpv6Mask = this.getDestinationIpv6Mask();
        IpV6MaskEntity other$destinationIpv6Mask = other.getDestinationIpv6Mask();
        if (this$destinationIpv6Mask == null ? other$destinationIpv6Mask != null : !((Object)this$destinationIpv6Mask).equals(other$destinationIpv6Mask)) {
            return false;
        }
        ay this$ipProtocolType = this.getIpProtocolType();
        ay other$ipProtocolType = other.getIpProtocolType();
        if (this$ipProtocolType == null ? other$ipProtocolType != null : !this$ipProtocolType.equals(other$ipProtocolType)) {
            return false;
        }
        IpProtocolAggregationEntity this$ipProtocolBody = this.getIpProtocolBody();
        IpProtocolAggregationEntity other$ipProtocolBody = other.getIpProtocolBody();
        if (this$ipProtocolBody == null ? other$ipProtocolBody != null : !((Object)this$ipProtocolBody).equals(other$ipProtocolBody)) {
            return false;
        }
        String this$timeRange = this.getTimeRange();
        String other$timeRange = other.getTimeRange();
        if (this$timeRange == null ? other$timeRange != null : !this$timeRange.equals(other$timeRange)) {
            return false;
        }
        ac this$logging = this.getLogging();
        ac other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !this$logging.equals(other$logging)) {
            return false;
        }
        PolicyAggregationEntity this$policy = this.getPolicy();
        PolicyAggregationEntity other$policy = other.getPolicy();
        return !(this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AclRuleConfigIpv6DTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $aclId = this.getAclId();
        result = result * 59 + ($aclId == null ? 43 : ((Object)$aclId).hashCode());
        Integer $ruleId = this.getRuleId();
        result = result * 59 + ($ruleId == null ? 43 : ((Object)$ruleId).hashCode());
        Integer $ipv6Class = this.getIpv6Class();
        result = result * 59 + ($ipv6Class == null ? 43 : ((Object)$ipv6Class).hashCode());
        Long $totalMatchedCounter = this.getTotalMatchedCounter();
        result = result * 59 + ($totalMatchedCounter == null ? 43 : ((Object)$totalMatchedCounter).hashCode());
        Integer $supportPrefixLen = this.getSupportPrefixLen();
        result = result * 59 + ($supportPrefixLen == null ? 43 : ((Object)$supportPrefixLen).hashCode());
        ac $ruleIdAutoAssign = this.getRuleIdAutoAssign();
        result = result * 59 + ($ruleIdAutoAssign == null ? 43 : $ruleIdAutoAssign.hashCode());
        h $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
        String $flowLabel = this.getFlowLabel();
        result = result * 59 + ($flowLabel == null ? 43 : $flowLabel.hashCode());
        IpV6MaskEntity $sourceIpv6Mask = this.getSourceIpv6Mask();
        result = result * 59 + ($sourceIpv6Mask == null ? 43 : ((Object)$sourceIpv6Mask).hashCode());
        IpV6MaskEntity $destinationIpv6Mask = this.getDestinationIpv6Mask();
        result = result * 59 + ($destinationIpv6Mask == null ? 43 : ((Object)$destinationIpv6Mask).hashCode());
        ay $ipProtocolType = this.getIpProtocolType();
        result = result * 59 + ($ipProtocolType == null ? 43 : $ipProtocolType.hashCode());
        IpProtocolAggregationEntity $ipProtocolBody = this.getIpProtocolBody();
        result = result * 59 + ($ipProtocolBody == null ? 43 : ((Object)$ipProtocolBody).hashCode());
        String $timeRange = this.getTimeRange();
        result = result * 59 + ($timeRange == null ? 43 : $timeRange.hashCode());
        ac $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : $logging.hashCode());
        PolicyAggregationEntity $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AclRuleConfigIpv6DTO(super=" + super.toString() + ", aclId=" + this.getAclId() + ", ruleId=" + this.getRuleId() + ", ruleIdAutoAssign=" + this.getRuleIdAutoAssign() + ", operation=" + this.getOperation() + ", ipv6Class=" + this.getIpv6Class() + ", flowLabel=" + this.getFlowLabel() + ", sourceIpv6Mask=" + this.getSourceIpv6Mask() + ", destinationIpv6Mask=" + this.getDestinationIpv6Mask() + ", ipProtocolType=" + this.getIpProtocolType() + ", ipProtocolBody=" + this.getIpProtocolBody() + ", timeRange=" + this.getTimeRange() + ", logging=" + this.getLogging() + ", policy=" + this.getPolicy() + ", totalMatchedCounter=" + this.getTotalMatchedCounter() + ", supportPrefixLen=" + this.getSupportPrefixLen() + ")";
    }
}

