/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.security.acl;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.device.manage.message.body.olt.DeviceResponseBody;
import com.tplink.smb.omada.manager.c.b.ac;
import com.tplink.smb.omada.manager.c.b.ay;
import com.tplink.smb.omada.manager.c.b.h;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import com.tplink.smb.omada.manager.device.olt.security.acl.entity.IpProtocolAggregationEntity;
import com.tplink.smb.omada.manager.device.olt.security.acl.entity.IpV4MaskEntity;
import com.tplink.smb.omada.manager.device.olt.security.acl.entity.MacMaskEntity;
import com.tplink.smb.omada.manager.device.olt.security.acl.entity.PolicyAggregationEntity;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class AclRuleConfigCombinedEditDTO
extends DpmsBaseDeviceDTO {
    @NotNull(message="aclId should not be null")
    @Range(min=0L, max=1999L, message="aclId should be between in {min} and {max}")
    private @NotNull(message="aclId should not be null") @Range(min=0L, max=1999L, message="aclId should be between in {min} and {max}") Integer aclId;
    @Range(min=1L, max=0x7FFFFFFFL, message="ruleId should be a number between {min}-{max}")
    @NotNull(message="ruleId should not be null")
    private @Range(min=1L, max=0x7FFFFFFFL, message="ruleId should be a number between {min}-{max}") @NotNull(message="ruleId should not be null") Integer ruleId;
    private h operation;
    @Valid
    private MacMaskEntity sourceMacMask;
    @Valid
    private MacMaskEntity destinationMacMask;
    @Range(min=1L, max=4095L, message="vlanId should be a number between {min}-{max}")
    private @Range(min=1L, max=4095L, message="vlanId should be a number between {min}-{max}") Integer vlanId;
    private String etherType;
    @Valid
    private IpV4MaskEntity sourceIpMask;
    @Valid
    private IpV4MaskEntity destinationIpMask;
    private ay ipProtocolType;
    private IpProtocolAggregationEntity ipProtocolBody;
    @Range(min=-1L, max=63L, message="dscp should between {min} and {max} !")
    private @Range(min=-1L, max=63L, message="dscp should between {min} and {max} !") Integer dscp;
    private Integer ipTos;
    private Integer ipPre;
    private String timeRange;
    @Range(min=-1L, max=7L, message="userPriority should be between {min} and {max}")
    private @Range(min=-1L, max=7L, message="userPriority should be between {min} and {max}") Integer userPriority;
    private ac logging;
    @Valid
    private PolicyAggregationEntity policy;

    public OperationResponse<DeviceResponseBody<Void>> check() {
        if (Objects.nonNull(this.policy)) {
            OperationResponse<Void> policyResponse = this.policy.check();
            if (Objects.nonNull(policyResponse)) {
                return new OperationResponse(policyResponse.getErrorCode(), policyResponse.getMsg(), null);
            }
            return null;
        }
        return null;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO() {
    }

    @Generated
    public Integer getAclId() {
        return this.aclId;
    }

    @Generated
    public Integer getRuleId() {
        return this.ruleId;
    }

    @Generated
    public h getOperation() {
        return this.operation;
    }

    @Generated
    public MacMaskEntity getSourceMacMask() {
        return this.sourceMacMask;
    }

    @Generated
    public MacMaskEntity getDestinationMacMask() {
        return this.destinationMacMask;
    }

    @Generated
    public Integer getVlanId() {
        return this.vlanId;
    }

    @Generated
    public String getEtherType() {
        return this.etherType;
    }

    @Generated
    public IpV4MaskEntity getSourceIpMask() {
        return this.sourceIpMask;
    }

    @Generated
    public IpV4MaskEntity getDestinationIpMask() {
        return this.destinationIpMask;
    }

    @Generated
    public ay getIpProtocolType() {
        return this.ipProtocolType;
    }

    @Generated
    public IpProtocolAggregationEntity getIpProtocolBody() {
        return this.ipProtocolBody;
    }

    @Generated
    public Integer getDscp() {
        return this.dscp;
    }

    @Generated
    public Integer getIpTos() {
        return this.ipTos;
    }

    @Generated
    public Integer getIpPre() {
        return this.ipPre;
    }

    @Generated
    public String getTimeRange() {
        return this.timeRange;
    }

    @Generated
    public Integer getUserPriority() {
        return this.userPriority;
    }

    @Generated
    public ac getLogging() {
        return this.logging;
    }

    @Generated
    public PolicyAggregationEntity getPolicy() {
        return this.policy;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setAclId(Integer aclId) {
        this.aclId = aclId;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setRuleId(Integer ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setOperation(h operation) {
        this.operation = operation;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setSourceMacMask(MacMaskEntity sourceMacMask) {
        this.sourceMacMask = sourceMacMask;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setDestinationMacMask(MacMaskEntity destinationMacMask) {
        this.destinationMacMask = destinationMacMask;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setEtherType(String etherType) {
        this.etherType = etherType;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setSourceIpMask(IpV4MaskEntity sourceIpMask) {
        this.sourceIpMask = sourceIpMask;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setDestinationIpMask(IpV4MaskEntity destinationIpMask) {
        this.destinationIpMask = destinationIpMask;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setIpProtocolType(ay ipProtocolType) {
        this.ipProtocolType = ipProtocolType;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setIpProtocolBody(IpProtocolAggregationEntity ipProtocolBody) {
        this.ipProtocolBody = ipProtocolBody;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setDscp(Integer dscp) {
        this.dscp = dscp;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setIpTos(Integer ipTos) {
        this.ipTos = ipTos;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setIpPre(Integer ipPre) {
        this.ipPre = ipPre;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setTimeRange(String timeRange) {
        this.timeRange = timeRange;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setUserPriority(Integer userPriority) {
        this.userPriority = userPriority;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setLogging(ac logging) {
        this.logging = logging;
        return this;
    }

    @Generated
    public AclRuleConfigCombinedEditDTO setPolicy(PolicyAggregationEntity policy) {
        this.policy = policy;
        return this;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof AclRuleConfigCombinedEditDTO)) {
            return false;
        }
        AclRuleConfigCombinedEditDTO other = (AclRuleConfigCombinedEditDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$aclId = this.getAclId();
        Integer other$aclId = other.getAclId();
        if (this$aclId == null ? other$aclId != null : !((Object)this$aclId).equals(other$aclId)) {
            return false;
        }
        Integer this$ruleId = this.getRuleId();
        Integer other$ruleId = other.getRuleId();
        if (this$ruleId == null ? other$ruleId != null : !((Object)this$ruleId).equals(other$ruleId)) {
            return false;
        }
        Integer this$vlanId = this.getVlanId();
        Integer other$vlanId = other.getVlanId();
        if (this$vlanId == null ? other$vlanId != null : !((Object)this$vlanId).equals(other$vlanId)) {
            return false;
        }
        Integer this$dscp = this.getDscp();
        Integer other$dscp = other.getDscp();
        if (this$dscp == null ? other$dscp != null : !((Object)this$dscp).equals(other$dscp)) {
            return false;
        }
        Integer this$ipTos = this.getIpTos();
        Integer other$ipTos = other.getIpTos();
        if (this$ipTos == null ? other$ipTos != null : !((Object)this$ipTos).equals(other$ipTos)) {
            return false;
        }
        Integer this$ipPre = this.getIpPre();
        Integer other$ipPre = other.getIpPre();
        if (this$ipPre == null ? other$ipPre != null : !((Object)this$ipPre).equals(other$ipPre)) {
            return false;
        }
        Integer this$userPriority = this.getUserPriority();
        Integer other$userPriority = other.getUserPriority();
        if (this$userPriority == null ? other$userPriority != null : !((Object)this$userPriority).equals(other$userPriority)) {
            return false;
        }
        h this$operation = this.getOperation();
        h other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
            return false;
        }
        MacMaskEntity this$sourceMacMask = this.getSourceMacMask();
        MacMaskEntity other$sourceMacMask = other.getSourceMacMask();
        if (this$sourceMacMask == null ? other$sourceMacMask != null : !((Object)this$sourceMacMask).equals(other$sourceMacMask)) {
            return false;
        }
        MacMaskEntity this$destinationMacMask = this.getDestinationMacMask();
        MacMaskEntity other$destinationMacMask = other.getDestinationMacMask();
        if (this$destinationMacMask == null ? other$destinationMacMask != null : !((Object)this$destinationMacMask).equals(other$destinationMacMask)) {
            return false;
        }
        String this$etherType = this.getEtherType();
        String other$etherType = other.getEtherType();
        if (this$etherType == null ? other$etherType != null : !this$etherType.equals(other$etherType)) {
            return false;
        }
        IpV4MaskEntity this$sourceIpMask = this.getSourceIpMask();
        IpV4MaskEntity other$sourceIpMask = other.getSourceIpMask();
        if (this$sourceIpMask == null ? other$sourceIpMask != null : !((Object)this$sourceIpMask).equals(other$sourceIpMask)) {
            return false;
        }
        IpV4MaskEntity this$destinationIpMask = this.getDestinationIpMask();
        IpV4MaskEntity other$destinationIpMask = other.getDestinationIpMask();
        if (this$destinationIpMask == null ? other$destinationIpMask != null : !((Object)this$destinationIpMask).equals(other$destinationIpMask)) {
            return false;
        }
        ay this$ipProtocolType = this.getIpProtocolType();
        ay other$ipProtocolType = other.getIpProtocolType();
        if (this$ipProtocolType == null ? other$ipProtocolType != null : !this$ipProtocolType.equals(other$ipProtocolType)) {
            return false;
        }
        IpProtocolAggregationEntity this$ipProtocolBody = this.getIpProtocolBody();
        IpProtocolAggregationEntity other$ipProtocolBody = other.getIpProtocolBody();
        if (this$ipProtocolBody == null ? other$ipProtocolBody != null : !((Object)this$ipProtocolBody).equals(other$ipProtocolBody)) {
            return false;
        }
        String this$timeRange = this.getTimeRange();
        String other$timeRange = other.getTimeRange();
        if (this$timeRange == null ? other$timeRange != null : !this$timeRange.equals(other$timeRange)) {
            return false;
        }
        ac this$logging = this.getLogging();
        ac other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !this$logging.equals(other$logging)) {
            return false;
        }
        PolicyAggregationEntity this$policy = this.getPolicy();
        PolicyAggregationEntity other$policy = other.getPolicy();
        return !(this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AclRuleConfigCombinedEditDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $aclId = this.getAclId();
        result = result * 59 + ($aclId == null ? 43 : ((Object)$aclId).hashCode());
        Integer $ruleId = this.getRuleId();
        result = result * 59 + ($ruleId == null ? 43 : ((Object)$ruleId).hashCode());
        Integer $vlanId = this.getVlanId();
        result = result * 59 + ($vlanId == null ? 43 : ((Object)$vlanId).hashCode());
        Integer $dscp = this.getDscp();
        result = result * 59 + ($dscp == null ? 43 : ((Object)$dscp).hashCode());
        Integer $ipTos = this.getIpTos();
        result = result * 59 + ($ipTos == null ? 43 : ((Object)$ipTos).hashCode());
        Integer $ipPre = this.getIpPre();
        result = result * 59 + ($ipPre == null ? 43 : ((Object)$ipPre).hashCode());
        Integer $userPriority = this.getUserPriority();
        result = result * 59 + ($userPriority == null ? 43 : ((Object)$userPriority).hashCode());
        h $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
        MacMaskEntity $sourceMacMask = this.getSourceMacMask();
        result = result * 59 + ($sourceMacMask == null ? 43 : ((Object)$sourceMacMask).hashCode());
        MacMaskEntity $destinationMacMask = this.getDestinationMacMask();
        result = result * 59 + ($destinationMacMask == null ? 43 : ((Object)$destinationMacMask).hashCode());
        String $etherType = this.getEtherType();
        result = result * 59 + ($etherType == null ? 43 : $etherType.hashCode());
        IpV4MaskEntity $sourceIpMask = this.getSourceIpMask();
        result = result * 59 + ($sourceIpMask == null ? 43 : ((Object)$sourceIpMask).hashCode());
        IpV4MaskEntity $destinationIpMask = this.getDestinationIpMask();
        result = result * 59 + ($destinationIpMask == null ? 43 : ((Object)$destinationIpMask).hashCode());
        ay $ipProtocolType = this.getIpProtocolType();
        result = result * 59 + ($ipProtocolType == null ? 43 : $ipProtocolType.hashCode());
        IpProtocolAggregationEntity $ipProtocolBody = this.getIpProtocolBody();
        result = result * 59 + ($ipProtocolBody == null ? 43 : ((Object)$ipProtocolBody).hashCode());
        String $timeRange = this.getTimeRange();
        result = result * 59 + ($timeRange == null ? 43 : $timeRange.hashCode());
        ac $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : $logging.hashCode());
        PolicyAggregationEntity $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AclRuleConfigCombinedEditDTO(super=" + super.toString() + ", aclId=" + this.getAclId() + ", ruleId=" + this.getRuleId() + ", operation=" + this.getOperation() + ", sourceMacMask=" + this.getSourceMacMask() + ", destinationMacMask=" + this.getDestinationMacMask() + ", vlanId=" + this.getVlanId() + ", etherType=" + this.getEtherType() + ", sourceIpMask=" + this.getSourceIpMask() + ", destinationIpMask=" + this.getDestinationIpMask() + ", ipProtocolType=" + this.getIpProtocolType() + ", ipProtocolBody=" + this.getIpProtocolBody() + ", dscp=" + this.getDscp() + ", ipTos=" + this.getIpTos() + ", ipPre=" + this.getIpPre() + ", timeRange=" + this.getTimeRange() + ", userPriority=" + this.getUserPriority() + ", logging=" + this.getLogging() + ", policy=" + this.getPolicy() + ")";
    }
}

