/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.reboot;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceRebootAppDTO
extends DpmsBaseDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceRebootAppDTO.class);
    @NotNull(message="device key list should not be empty")
    @Schema(name="mac", description="List of device keys for devices to be restarted.", requiredMode=Schema.RequiredMode.REQUIRED)
    @a
    private @NotNull(message="device key list should not be empty") String mac;
    @NotNull(message="save current config option should not be null")
    @Schema(name="saveCurrentConfig", description="Whether to save the current configuration.", requiredMode=Schema.RequiredMode.REQUIRED)
    private @NotNull(message="save current config option should not be null") Integer saveCurrentConfig;
    @Schema(name="slots", description="Slot ID list should be within the range of 1 to 4")
    private List<Integer> slots;
    @Schema(name="issu", description="Perform non-disruptive software upgrades, first upgrading the backup control board, then switching the primary and backup roles, and subsequently upgrading the other control board. Issu should be a value as follows: 1:ENABLE;0:DISABLE, effective only on the primary control board.")
    private Integer issu;
    @Null(message="rebootId should not be provided by front")
    @Schema(name="rebootId", description="Generated device batch restart ID.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private @Null(message="rebootId should not be provided by front") String rebootId;
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="token", description="User token")
    private String token;
    @Schema(name="controlType", description="Types of user access to the Omada Controller, such as local web access, etc.")
    private Integer controlType;
    @Schema(name="status", description="Status")
    private Integer status;
    @Schema(name="statusCategory", description="Status category.StatusCategory should be a value as follows:0:Disconnected;1:Connected;2:Pending;3:Heartbeat Missed;4:Isolated.")
    private Integer statusCategory;

    @Generated
    public DeviceRebootAppDTO() {
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public Integer getSaveCurrentConfig() {
        return this.saveCurrentConfig;
    }

    @Generated
    public List<Integer> getSlots() {
        return this.slots;
    }

    @Generated
    public Integer getIssu() {
        return this.issu;
    }

    @Generated
    public String getRebootId() {
        return this.rebootId;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public Integer getControlType() {
        return this.controlType;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Integer getStatusCategory() {
        return this.statusCategory;
    }

    @Generated
    public DeviceRebootAppDTO setMac(String mac) {
        this.mac = mac;
        return this;
    }

    @Generated
    public DeviceRebootAppDTO setSaveCurrentConfig(Integer saveCurrentConfig) {
        this.saveCurrentConfig = saveCurrentConfig;
        return this;
    }

    @Generated
    public DeviceRebootAppDTO setSlots(List<Integer> slots) {
        this.slots = slots;
        return this;
    }

    @Generated
    public DeviceRebootAppDTO setIssu(Integer issu) {
        this.issu = issu;
        return this;
    }

    @Generated
    public DeviceRebootAppDTO setRebootId(String rebootId) {
        this.rebootId = rebootId;
        return this;
    }

    @Generated
    public DeviceRebootAppDTO setToken(String token) {
        this.token = token;
        return this;
    }

    @Generated
    public DeviceRebootAppDTO setControlType(Integer controlType) {
        this.controlType = controlType;
        return this;
    }

    @Generated
    public DeviceRebootAppDTO setStatus(Integer status) {
        this.status = status;
        return this;
    }

    @Generated
    public DeviceRebootAppDTO setStatusCategory(Integer statusCategory) {
        this.statusCategory = statusCategory;
        return this;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof DeviceRebootAppDTO)) {
            return false;
        }
        DeviceRebootAppDTO other = (DeviceRebootAppDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$saveCurrentConfig = this.getSaveCurrentConfig();
        Integer other$saveCurrentConfig = other.getSaveCurrentConfig();
        if (this$saveCurrentConfig == null ? other$saveCurrentConfig != null : !((Object)this$saveCurrentConfig).equals(other$saveCurrentConfig)) {
            return false;
        }
        Integer this$issu = this.getIssu();
        Integer other$issu = other.getIssu();
        if (this$issu == null ? other$issu != null : !((Object)this$issu).equals(other$issu)) {
            return false;
        }
        Integer this$controlType = this.getControlType();
        Integer other$controlType = other.getControlType();
        if (this$controlType == null ? other$controlType != null : !((Object)this$controlType).equals(other$controlType)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$statusCategory = this.getStatusCategory();
        Integer other$statusCategory = other.getStatusCategory();
        if (this$statusCategory == null ? other$statusCategory != null : !((Object)this$statusCategory).equals(other$statusCategory)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        List<Integer> this$slots = this.getSlots();
        List<Integer> other$slots = other.getSlots();
        if (this$slots == null ? other$slots != null : !((Object)this$slots).equals(other$slots)) {
            return false;
        }
        String this$rebootId = this.getRebootId();
        String other$rebootId = other.getRebootId();
        if (this$rebootId == null ? other$rebootId != null : !this$rebootId.equals(other$rebootId)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeviceRebootAppDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $saveCurrentConfig = this.getSaveCurrentConfig();
        result = result * 59 + ($saveCurrentConfig == null ? 43 : ((Object)$saveCurrentConfig).hashCode());
        Integer $issu = this.getIssu();
        result = result * 59 + ($issu == null ? 43 : ((Object)$issu).hashCode());
        Integer $controlType = this.getControlType();
        result = result * 59 + ($controlType == null ? 43 : ((Object)$controlType).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $statusCategory = this.getStatusCategory();
        result = result * 59 + ($statusCategory == null ? 43 : ((Object)$statusCategory).hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        List<Integer> $slots = this.getSlots();
        result = result * 59 + ($slots == null ? 43 : ((Object)$slots).hashCode());
        String $rebootId = this.getRebootId();
        result = result * 59 + ($rebootId == null ? 43 : $rebootId.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeviceRebootAppDTO(mac=" + this.getMac() + ", saveCurrentConfig=" + this.getSaveCurrentConfig() + ", slots=" + this.getSlots() + ", issu=" + this.getIssu() + ", rebootId=" + this.getRebootId() + ", token=" + this.getToken() + ", controlType=" + this.getControlType() + ", status=" + this.getStatus() + ", statusCategory=" + this.getStatusCategory() + ")";
    }
}

