/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.qos.autovoip;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.device.manage.message.body.olt.DeviceResponseBody;
import com.tplink.smb.omada.manager.c.b.ac;
import com.tplink.smb.omada.manager.c.b.t;
import com.tplink.smb.omada.manager.device.api.web.validation.olt.SortedField;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class AutoVoIPPortConfigDTO
extends DpmsBaseDeviceDTO {
    @NotNull(message="port can not be null")
    @SortedField
    private @NotNull(message="port can not be null") String port;
    private t interfaceMode;
    private Integer value;
    private ac cosOverrideStatus;
    private ac portStatus;
    @Range(min=0L, max=63L, message="dcspPriority should be a number between {min}-{max}")
    private @Range(min=0L, max=63L, message="dcspPriority should be a number between {min}-{max}") Integer dscpPriority;

    public OperationResponse<DeviceResponseBody<Void>> check() {
        if (Objects.isNull(this.interfaceMode)) {
            return null;
        }
        switch (this.interfaceMode) {
            case c: {
                if (Objects.isNull(this.value)) {
                    return new OperationResponse(b.d, "When interfaceMode is VLAN_ID, value can not be null", null);
                }
                if (this.value >= 1 && this.value <= 4095) break;
                return new OperationResponse(b.d, "Please configure a valid Value, value must in range 1-4094", null);
            }
            case d: {
                if (Objects.isNull(this.value)) {
                    return new OperationResponse(b.d, "When interfaceMode is DOT1P, value can not be null", null);
                }
                if (this.value >= 0 && this.value <= 7) break;
                return new OperationResponse(b.d, "Please configure a valid Value, value must in range 0-7", null);
            }
            default: {
                return null;
            }
        }
        return null;
    }

    @Generated
    public AutoVoIPPortConfigDTO() {
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public t getInterfaceMode() {
        return this.interfaceMode;
    }

    @Generated
    public Integer getValue() {
        return this.value;
    }

    @Generated
    public ac getCosOverrideStatus() {
        return this.cosOverrideStatus;
    }

    @Generated
    public ac getPortStatus() {
        return this.portStatus;
    }

    @Generated
    public Integer getDscpPriority() {
        return this.dscpPriority;
    }

    @Generated
    public AutoVoIPPortConfigDTO setPort(String port) {
        this.port = port;
        return this;
    }

    @Generated
    public AutoVoIPPortConfigDTO setInterfaceMode(t interfaceMode) {
        this.interfaceMode = interfaceMode;
        return this;
    }

    @Generated
    public AutoVoIPPortConfigDTO setValue(Integer value) {
        this.value = value;
        return this;
    }

    @Generated
    public AutoVoIPPortConfigDTO setCosOverrideStatus(ac cosOverrideStatus) {
        this.cosOverrideStatus = cosOverrideStatus;
        return this;
    }

    @Generated
    public AutoVoIPPortConfigDTO setPortStatus(ac portStatus) {
        this.portStatus = portStatus;
        return this;
    }

    @Generated
    public AutoVoIPPortConfigDTO setDscpPriority(Integer dscpPriority) {
        this.dscpPriority = dscpPriority;
        return this;
    }

    @Generated
    public String toString() {
        return "AutoVoIPPortConfigDTO(port=" + this.getPort() + ", interfaceMode=" + this.getInterfaceMode() + ", value=" + this.getValue() + ", cosOverrideStatus=" + this.getCosOverrideStatus() + ", portStatus=" + this.getPortStatus() + ", dscpPriority=" + this.getDscpPriority() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoVoIPPortConfigDTO)) {
            return false;
        }
        AutoVoIPPortConfigDTO other = (AutoVoIPPortConfigDTO)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$value = this.getValue();
        Integer other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Integer this$dscpPriority = this.getDscpPriority();
        Integer other$dscpPriority = other.getDscpPriority();
        if (this$dscpPriority == null ? other$dscpPriority != null : !((Object)this$dscpPriority).equals(other$dscpPriority)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        t this$interfaceMode = this.getInterfaceMode();
        t other$interfaceMode = other.getInterfaceMode();
        if (this$interfaceMode == null ? other$interfaceMode != null : !this$interfaceMode.equals(other$interfaceMode)) {
            return false;
        }
        ac this$cosOverrideStatus = this.getCosOverrideStatus();
        ac other$cosOverrideStatus = other.getCosOverrideStatus();
        if (this$cosOverrideStatus == null ? other$cosOverrideStatus != null : !this$cosOverrideStatus.equals(other$cosOverrideStatus)) {
            return false;
        }
        ac this$portStatus = this.getPortStatus();
        ac other$portStatus = other.getPortStatus();
        return !(this$portStatus == null ? other$portStatus != null : !this$portStatus.equals(other$portStatus));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AutoVoIPPortConfigDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Integer $dscpPriority = this.getDscpPriority();
        result = result * 59 + ($dscpPriority == null ? 43 : ((Object)$dscpPriority).hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        t $interfaceMode = this.getInterfaceMode();
        result = result * 59 + ($interfaceMode == null ? 43 : $interfaceMode.hashCode());
        ac $cosOverrideStatus = this.getCosOverrideStatus();
        result = result * 59 + ($cosOverrideStatus == null ? 43 : $cosOverrideStatus.hashCode());
        ac $portStatus = this.getPortStatus();
        result = result * 59 + ($portStatus == null ? 43 : $portStatus.hashCode());
        return result;
    }
}

