/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.serviceport;

import com.tplink.smb.omada.manager.c.b.ac;
import com.tplink.smb.omada.manager.c.b.ai;
import com.tplink.smb.omada.manager.c.b.cC;
import com.tplink.smb.omada.manager.c.b.m;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import com.tplink.smb.omada.manager.device.olt.pon.serviceport.ServicePortDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;

public class ServicePortVO
extends DpmsBaseDeviceDTO {
    private static final long serialVersionUID = -4325978769749012332L;
    @Schema(description="ID of service port.Index should be within the range of 1 to 8100", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="index should not be null")
    @Range(min=1L, max=8100L, message="index should be a number between {min}-{max}")
    private @NotNull(message="index should not be null") @Range(min=1L, max=8100L, message="index should be a number between {min}-{max}") Integer index;
    @Schema(description="Whether this service port is active.ActiveStatus should be a value as follows:ACTIVE,INACTIVE")
    private m activeStatus;
    @Schema(description="Description of service port.Description should contain 1 to 32 characters including numbers, Upper and lower letters, -@_:/. .", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotBlank(message="description should not empty")
    @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{1,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.")
    @Length(min=0, max=32, message="description should between {min}~{max} characters")
    private @NotBlank(message="description should not empty") @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{1,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.") @Length(min=0, max=32, message="description should between {min}~{max} characters") String description;
    @Schema(description="OnuId should be within the range of 0 to 127", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="onuId should not be null")
    @Range(min=0L, max=127L, message="onuId should be a number between {min}-{max}")
    private @NotNull(message="onuId should not be null") @Range(min=0L, max=127L, message="onuId should be a number between {min}-{max}") Integer onuId;
    @Schema(description="The enable status of the service flows matched by this Service Port. AdminStatus should be a value as follows: DISABLE,ENABLE. Default value: ENABLE.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="adminStatus should not be null")
    private @NotNull(message="adminStatus should not be null") ac adminStatus;
    @Schema(description="The traffic statistics switch status for the service flows matched by this Service Port. StatisticPerformance should be a value as follows: DISABLE,ENABLE. Default value: DISABLE.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="statisticPerformance should not be null")
    private @NotNull(message="statisticPerformance should not be null") ac statisticPerformance;
    @Schema(description="PonPortId should be within the range of 1 to 16")
    @Range(min=1L, max=16L, message="ponPortId should be a number between {min}-{max}")
    private @Range(min=1L, max=16L, message="ponPortId should be a number between {min}-{max}") Integer ponPortId;
    @Schema(description="String form of pon port", hidden=true)
    private String ponPortStr;
    @Schema(description="SVlan should be within the range of 1 to 4095")
    @Range(min=1L, max=4095L, message="svlan should be a number between {min}-{max}")
    private @Range(min=1L, max=4095L, message="svlan should be a number between {min}-{max}") Integer svlan;
    @Schema(description="GemPortId should be within the range of 1 to 1023")
    @Range(min=1L, max=1023L, message="gemPortId should be a number between {min}-{max}")
    private @Range(min=1L, max=1023L, message="gemPortId should be a number between {min}-{max}") Integer gemPortId;
    @Schema(description="UserVlan should be within the range of 0 to 4095")
    @Range(min=0L, max=4095L, message="userVlan should be a number between {min}-{max}")
    private @Range(min=0L, max=4095L, message="userVlan should be a number between {min}-{max}") Integer userVlan;
    @Schema(description="UserVlanPriority should be within the range of -1 to 7")
    private String userVlanPriority;
    @Schema(description="TagAction should be a value as follows:DEFAULT,TRANSPARENT,TRANSLATE,TRANSLATE_AND_ADD,ADD_DOUBLE")
    private cC tagAction;
    @Schema(description="InnerVlan should be within the range of 0 to 4095")
    @Range(min=0L, max=4095L, message="innerVlan should be a number between {min}-{max}")
    private @Range(min=0L, max=4095L, message="innerVlan should be a number between {min}-{max}") Integer innerVlan;
    @Schema(description="InnerVlanPriority should be within the range of -1 to 7")
    private String innerVlanPriority;
    @Schema(description="EtherType should be a value as follows:NONE,IPV4OE,IPV6OE,PPPOE")
    private ai etherType;
    @Schema(description="InboundTrafficProfileId should be within the range of 0 to 512")
    private String inboundTrafficProfileId;
    @Schema(description="OutboundTrafficProfileId should be within the range of 0 to 512")
    private String outboundTrafficProfileId;

    public ServicePortVO(ServicePortDTO servicePortDTO) {
        this.activeStatus = servicePortDTO.getActiveStatus();
        this.adminStatus = servicePortDTO.getAdminStatus();
        this.description = servicePortDTO.getDescription();
        this.etherType = servicePortDTO.getEtherType();
        this.gemPortId = servicePortDTO.getGemPortId();
        this.inboundTrafficProfileId = servicePortDTO.getInboundTrafficProfileId() == 0 ? "None" : servicePortDTO.getInboundTrafficProfileId().toString();
        this.index = servicePortDTO.getIndex();
        this.innerVlan = servicePortDTO.getInnerVlan();
        this.innerVlanPriority = servicePortDTO.getInnerVlanPriority() == -1 ? "None" : servicePortDTO.getInnerVlanPriority().toString();
        this.onuId = servicePortDTO.getOnuId();
        this.outboundTrafficProfileId = servicePortDTO.getOutboundTrafficProfileId() == 0 ? "None" : servicePortDTO.getOutboundTrafficProfileId().toString();
        this.ponPortId = servicePortDTO.getPonPortId();
        this.ponPortStr = servicePortDTO.getPonPortStr();
        this.statisticPerformance = servicePortDTO.getStatisticPerformance();
        this.svlan = servicePortDTO.getSvlan();
        this.tagAction = servicePortDTO.getTagAction();
        this.userVlan = servicePortDTO.getUserVlan();
        this.userVlanPriority = servicePortDTO.getUserVlanPriority() == -1 ? "None" : servicePortDTO.getUserVlanPriority().toString();
    }

    protected boolean checkUserVlanAndSvlanAndTagActionInvalid() {
        return !Objects.equals(this.userVlan, this.svlan) && Objects.equals(this.tagAction, cC.b);
    }

    protected boolean checkTagActionIsOneOfParameters(cC ... tagActions) {
        boolean result = false;
        for (int i2 = 0; i2 < tagActions.length; ++i2) {
            result |= Objects.equals(this.tagAction, tagActions[i2]);
        }
        return result;
    }

    protected boolean checkUserVlanAndTagActionInvalid() {
        if (Objects.equals(this.userVlan, 0)) {
            return this.checkTagActionIsOneOfParameters(cC.b, cC.c, cC.d) || !Objects.equals(this.userVlanPriority, -1);
        }
        return this.checkTagActionIsOneOfParameters(cC.e);
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ServicePortVO)) {
            return false;
        }
        ServicePortVO other = (ServicePortVO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Integer this$onuId = this.getOnuId();
        Integer other$onuId = other.getOnuId();
        if (this$onuId == null ? other$onuId != null : !((Object)this$onuId).equals(other$onuId)) {
            return false;
        }
        Integer this$ponPortId = this.getPonPortId();
        Integer other$ponPortId = other.getPonPortId();
        if (this$ponPortId == null ? other$ponPortId != null : !((Object)this$ponPortId).equals(other$ponPortId)) {
            return false;
        }
        Integer this$svlan = this.getSvlan();
        Integer other$svlan = other.getSvlan();
        if (this$svlan == null ? other$svlan != null : !((Object)this$svlan).equals(other$svlan)) {
            return false;
        }
        Integer this$gemPortId = this.getGemPortId();
        Integer other$gemPortId = other.getGemPortId();
        if (this$gemPortId == null ? other$gemPortId != null : !((Object)this$gemPortId).equals(other$gemPortId)) {
            return false;
        }
        Integer this$userVlan = this.getUserVlan();
        Integer other$userVlan = other.getUserVlan();
        if (this$userVlan == null ? other$userVlan != null : !((Object)this$userVlan).equals(other$userVlan)) {
            return false;
        }
        Integer this$innerVlan = this.getInnerVlan();
        Integer other$innerVlan = other.getInnerVlan();
        if (this$innerVlan == null ? other$innerVlan != null : !((Object)this$innerVlan).equals(other$innerVlan)) {
            return false;
        }
        m this$activeStatus = this.getActiveStatus();
        m other$activeStatus = other.getActiveStatus();
        if (this$activeStatus == null ? other$activeStatus != null : !this$activeStatus.equals(other$activeStatus)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ac this$adminStatus = this.getAdminStatus();
        ac other$adminStatus = other.getAdminStatus();
        if (this$adminStatus == null ? other$adminStatus != null : !this$adminStatus.equals(other$adminStatus)) {
            return false;
        }
        ac this$statisticPerformance = this.getStatisticPerformance();
        ac other$statisticPerformance = other.getStatisticPerformance();
        if (this$statisticPerformance == null ? other$statisticPerformance != null : !this$statisticPerformance.equals(other$statisticPerformance)) {
            return false;
        }
        String this$ponPortStr = this.getPonPortStr();
        String other$ponPortStr = other.getPonPortStr();
        if (this$ponPortStr == null ? other$ponPortStr != null : !this$ponPortStr.equals(other$ponPortStr)) {
            return false;
        }
        String this$userVlanPriority = this.getUserVlanPriority();
        String other$userVlanPriority = other.getUserVlanPriority();
        if (this$userVlanPriority == null ? other$userVlanPriority != null : !this$userVlanPriority.equals(other$userVlanPriority)) {
            return false;
        }
        cC this$tagAction = this.getTagAction();
        cC other$tagAction = other.getTagAction();
        if (this$tagAction == null ? other$tagAction != null : !this$tagAction.equals(other$tagAction)) {
            return false;
        }
        String this$innerVlanPriority = this.getInnerVlanPriority();
        String other$innerVlanPriority = other.getInnerVlanPriority();
        if (this$innerVlanPriority == null ? other$innerVlanPriority != null : !this$innerVlanPriority.equals(other$innerVlanPriority)) {
            return false;
        }
        ai this$etherType = this.getEtherType();
        ai other$etherType = other.getEtherType();
        if (this$etherType == null ? other$etherType != null : !this$etherType.equals(other$etherType)) {
            return false;
        }
        String this$inboundTrafficProfileId = this.getInboundTrafficProfileId();
        String other$inboundTrafficProfileId = other.getInboundTrafficProfileId();
        if (this$inboundTrafficProfileId == null ? other$inboundTrafficProfileId != null : !this$inboundTrafficProfileId.equals(other$inboundTrafficProfileId)) {
            return false;
        }
        String this$outboundTrafficProfileId = this.getOutboundTrafficProfileId();
        String other$outboundTrafficProfileId = other.getOutboundTrafficProfileId();
        return !(this$outboundTrafficProfileId == null ? other$outboundTrafficProfileId != null : !this$outboundTrafficProfileId.equals(other$outboundTrafficProfileId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServicePortVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Integer $onuId = this.getOnuId();
        result = result * 59 + ($onuId == null ? 43 : ((Object)$onuId).hashCode());
        Integer $ponPortId = this.getPonPortId();
        result = result * 59 + ($ponPortId == null ? 43 : ((Object)$ponPortId).hashCode());
        Integer $svlan = this.getSvlan();
        result = result * 59 + ($svlan == null ? 43 : ((Object)$svlan).hashCode());
        Integer $gemPortId = this.getGemPortId();
        result = result * 59 + ($gemPortId == null ? 43 : ((Object)$gemPortId).hashCode());
        Integer $userVlan = this.getUserVlan();
        result = result * 59 + ($userVlan == null ? 43 : ((Object)$userVlan).hashCode());
        Integer $innerVlan = this.getInnerVlan();
        result = result * 59 + ($innerVlan == null ? 43 : ((Object)$innerVlan).hashCode());
        m $activeStatus = this.getActiveStatus();
        result = result * 59 + ($activeStatus == null ? 43 : $activeStatus.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ac $adminStatus = this.getAdminStatus();
        result = result * 59 + ($adminStatus == null ? 43 : $adminStatus.hashCode());
        ac $statisticPerformance = this.getStatisticPerformance();
        result = result * 59 + ($statisticPerformance == null ? 43 : $statisticPerformance.hashCode());
        String $ponPortStr = this.getPonPortStr();
        result = result * 59 + ($ponPortStr == null ? 43 : $ponPortStr.hashCode());
        String $userVlanPriority = this.getUserVlanPriority();
        result = result * 59 + ($userVlanPriority == null ? 43 : $userVlanPriority.hashCode());
        cC $tagAction = this.getTagAction();
        result = result * 59 + ($tagAction == null ? 43 : $tagAction.hashCode());
        String $innerVlanPriority = this.getInnerVlanPriority();
        result = result * 59 + ($innerVlanPriority == null ? 43 : $innerVlanPriority.hashCode());
        ai $etherType = this.getEtherType();
        result = result * 59 + ($etherType == null ? 43 : $etherType.hashCode());
        String $inboundTrafficProfileId = this.getInboundTrafficProfileId();
        result = result * 59 + ($inboundTrafficProfileId == null ? 43 : $inboundTrafficProfileId.hashCode());
        String $outboundTrafficProfileId = this.getOutboundTrafficProfileId();
        result = result * 59 + ($outboundTrafficProfileId == null ? 43 : $outboundTrafficProfileId.hashCode());
        return result;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public m getActiveStatus() {
        return this.activeStatus;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Integer getOnuId() {
        return this.onuId;
    }

    @Generated
    public ac getAdminStatus() {
        return this.adminStatus;
    }

    @Generated
    public ac getStatisticPerformance() {
        return this.statisticPerformance;
    }

    @Generated
    public Integer getPonPortId() {
        return this.ponPortId;
    }

    @Generated
    public String getPonPortStr() {
        return this.ponPortStr;
    }

    @Generated
    public Integer getSvlan() {
        return this.svlan;
    }

    @Generated
    public Integer getGemPortId() {
        return this.gemPortId;
    }

    @Generated
    public Integer getUserVlan() {
        return this.userVlan;
    }

    @Generated
    public String getUserVlanPriority() {
        return this.userVlanPriority;
    }

    @Generated
    public cC getTagAction() {
        return this.tagAction;
    }

    @Generated
    public Integer getInnerVlan() {
        return this.innerVlan;
    }

    @Generated
    public String getInnerVlanPriority() {
        return this.innerVlanPriority;
    }

    @Generated
    public ai getEtherType() {
        return this.etherType;
    }

    @Generated
    public String getInboundTrafficProfileId() {
        return this.inboundTrafficProfileId;
    }

    @Generated
    public String getOutboundTrafficProfileId() {
        return this.outboundTrafficProfileId;
    }

    @Generated
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Generated
    public void setActiveStatus(m activeStatus) {
        this.activeStatus = activeStatus;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setOnuId(Integer onuId) {
        this.onuId = onuId;
    }

    @Generated
    public void setAdminStatus(ac adminStatus) {
        this.adminStatus = adminStatus;
    }

    @Generated
    public void setStatisticPerformance(ac statisticPerformance) {
        this.statisticPerformance = statisticPerformance;
    }

    @Generated
    public void setPonPortId(Integer ponPortId) {
        this.ponPortId = ponPortId;
    }

    @Generated
    public void setPonPortStr(String ponPortStr) {
        this.ponPortStr = ponPortStr;
    }

    @Generated
    public void setSvlan(Integer svlan) {
        this.svlan = svlan;
    }

    @Generated
    public void setGemPortId(Integer gemPortId) {
        this.gemPortId = gemPortId;
    }

    @Generated
    public void setUserVlan(Integer userVlan) {
        this.userVlan = userVlan;
    }

    @Generated
    public void setUserVlanPriority(String userVlanPriority) {
        this.userVlanPriority = userVlanPriority;
    }

    @Generated
    public void setTagAction(cC tagAction) {
        this.tagAction = tagAction;
    }

    @Generated
    public void setInnerVlan(Integer innerVlan) {
        this.innerVlan = innerVlan;
    }

    @Generated
    public void setInnerVlanPriority(String innerVlanPriority) {
        this.innerVlanPriority = innerVlanPriority;
    }

    @Generated
    public void setEtherType(ai etherType) {
        this.etherType = etherType;
    }

    @Generated
    public void setInboundTrafficProfileId(String inboundTrafficProfileId) {
        this.inboundTrafficProfileId = inboundTrafficProfileId;
    }

    @Generated
    public void setOutboundTrafficProfileId(String outboundTrafficProfileId) {
        this.outboundTrafficProfileId = outboundTrafficProfileId;
    }

    @Generated
    public String toString() {
        return "ServicePortVO(index=" + this.getIndex() + ", activeStatus=" + this.getActiveStatus() + ", description=" + this.getDescription() + ", onuId=" + this.getOnuId() + ", adminStatus=" + this.getAdminStatus() + ", statisticPerformance=" + this.getStatisticPerformance() + ", ponPortId=" + this.getPonPortId() + ", ponPortStr=" + this.getPonPortStr() + ", svlan=" + this.getSvlan() + ", gemPortId=" + this.getGemPortId() + ", userVlan=" + this.getUserVlan() + ", userVlanPriority=" + this.getUserVlanPriority() + ", tagAction=" + this.getTagAction() + ", innerVlan=" + this.getInnerVlan() + ", innerVlanPriority=" + this.getInnerVlanPriority() + ", etherType=" + this.getEtherType() + ", inboundTrafficProfileId=" + this.getInboundTrafficProfileId() + ", outboundTrafficProfileId=" + this.getOutboundTrafficProfileId() + ")";
    }

    @Generated
    public ServicePortVO(Integer index, m activeStatus, String description, Integer onuId, ac adminStatus, ac statisticPerformance, Integer ponPortId, String ponPortStr, Integer svlan, Integer gemPortId, Integer userVlan, String userVlanPriority, cC tagAction, Integer innerVlan, String innerVlanPriority, ai etherType, String inboundTrafficProfileId, String outboundTrafficProfileId) {
        this.index = index;
        this.activeStatus = activeStatus;
        this.description = description;
        this.onuId = onuId;
        this.adminStatus = adminStatus;
        this.statisticPerformance = statisticPerformance;
        this.ponPortId = ponPortId;
        this.ponPortStr = ponPortStr;
        this.svlan = svlan;
        this.gemPortId = gemPortId;
        this.userVlan = userVlan;
        this.userVlanPriority = userVlanPriority;
        this.tagAction = tagAction;
        this.innerVlan = innerVlan;
        this.innerVlanPriority = innerVlanPriority;
        this.etherType = etherType;
        this.inboundTrafficProfileId = inboundTrafficProfileId;
        this.outboundTrafficProfileId = outboundTrafficProfileId;
    }

    @Generated
    public ServicePortVO() {
    }
}

