/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.serviceport;

import com.tplink.smb.omada.manager.c.b.ac;
import com.tplink.smb.omada.manager.device.olt.pon.serviceport.ServicePortBaseDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class ServicePortModifyDTO
extends ServicePortBaseDTO {
    private static final long serialVersionUID = -4325978769749012332L;
    @Schema(description="Service port ID should be within the range of 1 to 8100", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="index should not be null")
    @Range(min=1L, max=8100L, message="index should be a number between {min}-{max}")
    private @NotNull(message="index should not be null") @Range(min=1L, max=8100L, message="index should be a number between {min}-{max}") Integer index;
    @Schema(name="description", description="Description of service port.Description should contain 1 to 32 characters including numbers, Upper and lower letters, -@_:/. .")
    @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{0,32}$", message="only 0-32 bits numbers, Upper and lower letters, -@_:/. are allowed.")
    @Length(min=0, max=32, message="description should between {min}~{max} characters")
    private @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{0,32}$", message="only 0-32 bits numbers, Upper and lower letters, -@_:/. are allowed.") @Length(min=0, max=32, message="description should between {min}~{max} characters") String description;
    @Schema(description="Onu ID should be within the range of 0 to 127", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="onuId should not be null")
    @Range(min=0L, max=127L, message="onuId should be a number between {min}-{max}")
    private @NotNull(message="onuId should not be null") @Range(min=0L, max=127L, message="onuId should be a number between {min}-{max}") Integer onuId;
    @Schema(description="The enable status of the service flows matched by this Service Port. AdminStatus should be a value as follows: DISABLE,ENABLE. Default value: ENABLE.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="adminStatus should not be null")
    private @NotNull(message="adminStatus should not be null") ac adminStatus;
    @Schema(description="The traffic statistics switch status for the service flows matched by this Service Port. StatisticPerformance should be a value as follows: DISABLE,ENABLE. Default value: DISABLE.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="statisticPerformance should not be null")
    private @NotNull(message="statisticPerformance should not be null") ac statisticPerformance;

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ServicePortModifyDTO)) {
            return false;
        }
        ServicePortModifyDTO other = (ServicePortModifyDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Integer this$onuId = this.getOnuId();
        Integer other$onuId = other.getOnuId();
        if (this$onuId == null ? other$onuId != null : !((Object)this$onuId).equals(other$onuId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ac this$adminStatus = this.getAdminStatus();
        ac other$adminStatus = other.getAdminStatus();
        if (this$adminStatus == null ? other$adminStatus != null : !this$adminStatus.equals(other$adminStatus)) {
            return false;
        }
        ac this$statisticPerformance = this.getStatisticPerformance();
        ac other$statisticPerformance = other.getStatisticPerformance();
        return !(this$statisticPerformance == null ? other$statisticPerformance != null : !this$statisticPerformance.equals(other$statisticPerformance));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServicePortModifyDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Integer $onuId = this.getOnuId();
        result = result * 59 + ($onuId == null ? 43 : ((Object)$onuId).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ac $adminStatus = this.getAdminStatus();
        result = result * 59 + ($adminStatus == null ? 43 : $adminStatus.hashCode());
        ac $statisticPerformance = this.getStatisticPerformance();
        result = result * 59 + ($statisticPerformance == null ? 43 : $statisticPerformance.hashCode());
        return result;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Integer getOnuId() {
        return this.onuId;
    }

    @Generated
    public ac getAdminStatus() {
        return this.adminStatus;
    }

    @Generated
    public ac getStatisticPerformance() {
        return this.statisticPerformance;
    }

    @Generated
    public ServicePortModifyDTO setIndex(Integer index) {
        this.index = index;
        return this;
    }

    @Generated
    public ServicePortModifyDTO setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public ServicePortModifyDTO setOnuId(Integer onuId) {
        this.onuId = onuId;
        return this;
    }

    @Generated
    public ServicePortModifyDTO setAdminStatus(ac adminStatus) {
        this.adminStatus = adminStatus;
        return this;
    }

    @Generated
    public ServicePortModifyDTO setStatisticPerformance(ac statisticPerformance) {
        this.statisticPerformance = statisticPerformance;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "ServicePortModifyDTO(index=" + this.getIndex() + ", description=" + this.getDescription() + ", onuId=" + this.getOnuId() + ", adminStatus=" + this.getAdminStatus() + ", statisticPerformance=" + this.getStatisticPerformance() + ")";
    }

    @Generated
    public ServicePortModifyDTO(Integer index, String description, Integer onuId, ac adminStatus, ac statisticPerformance) {
        this.index = index;
        this.description = description;
        this.onuId = onuId;
        this.adminStatus = adminStatus;
        this.statisticPerformance = statisticPerformance;
    }

    @Generated
    public ServicePortModifyDTO() {
    }
}

