/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.serviceport;

import com.tplink.smb.omada.manager.c.b.ai;
import com.tplink.smb.omada.manager.c.b.cC;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class ServicePortBaseDTO
extends DpmsBaseDeviceDTO {
    @Schema(description="PonPortId should be within the range of 1 to 16")
    @Range(min=1L, max=16L, message="ponPortId should be a number between {min}-{max}")
    private @Range(min=1L, max=16L, message="ponPortId should be a number between {min}-{max}") Integer ponPortId;
    @Schema(description="String form of pon port")
    private String ponPortStr;
    @Schema(description="SVlan should be within the range of 1 to 4095")
    @Range(min=1L, max=4095L, message="svlan should be a number between {min}-{max}")
    private @Range(min=1L, max=4095L, message="svlan should be a number between {min}-{max}") Integer svlan;
    @Schema(description="GemPortId should be within the range of 1 to 1023")
    @Range(min=1L, max=1023L, message="gemPortId should be a number between {min}-{max}")
    private @Range(min=1L, max=1023L, message="gemPortId should be a number between {min}-{max}") Integer gemPortId;
    @Schema(description="UserVlan should be within the range of 0 to 4095")
    @Range(min=0L, max=4095L, message="userVlan should be a number between {min}-{max}")
    private @Range(min=0L, max=4095L, message="userVlan should be a number between {min}-{max}") Integer userVlan;
    @Schema(description="UserVlanPriority should be within the range of -1 to 7")
    @Range(min=-1L, max=7L, message="userVlanPriority should be a number between {min}-{max}")
    private @Range(min=-1L, max=7L, message="userVlanPriority should be a number between {min}-{max}") Integer userVlanPriority;
    @Schema(description="TagAction should be a value as follows:DEFAULT,TRANSPARENT,TRANSLATE,TRANSLATE_AND_ADD,ADD_DOUBLE")
    private cC tagAction;
    @Schema(description="InnerVlan should be within the range of 0 to 4095")
    @Range(min=0L, max=4095L, message="innerVlan should be a number between {min}-{max}")
    private @Range(min=0L, max=4095L, message="innerVlan should be a number between {min}-{max}") Integer innerVlan;
    @Schema(description="InnerVlanPriority should be within the range of -1 to 7")
    @Range(min=-1L, max=7L, message="innerVlanPriority should be a number between {min}-{max}")
    private @Range(min=-1L, max=7L, message="innerVlanPriority should be a number between {min}-{max}") Integer innerVlanPriority;
    @Schema(description="EtherType should be a value as follows:NONE,IPV4OE,IPV6OE,PPPOE")
    private ai etherType;
    @Schema(description="InboundTrafficProfileId should be within the range of 0 to 512")
    @Range(min=0L, max=512L, message="inboundTrafficProfileId should be a number between {min}-{max}")
    private @Range(min=0L, max=512L, message="inboundTrafficProfileId should be a number between {min}-{max}") Integer inboundTrafficProfileId;
    @Schema(description="OutboundTrafficProfileId should be within the range of 0 to 512")
    @Range(min=0L, max=512L, message="outboundTrafficProfileId should be a number between {min}-{max}")
    private @Range(min=0L, max=512L, message="outboundTrafficProfileId should be a number between {min}-{max}") Integer outboundTrafficProfileId;

    protected boolean checkUserVlanAndSvlanAndTagActionInvalid() {
        return !Objects.equals(this.userVlan, this.svlan) && Objects.equals(this.tagAction, cC.b);
    }

    protected boolean checkTagActionIsOneOfParameters(cC ... tagActions) {
        boolean result = false;
        for (int i2 = 0; i2 < tagActions.length; ++i2) {
            result |= Objects.equals(this.tagAction, tagActions[i2]);
        }
        return result;
    }

    protected boolean checkUserVlanAndTagActionInvalid() {
        if (Objects.equals(this.userVlan, 0)) {
            return this.checkTagActionIsOneOfParameters(cC.b, cC.c, cC.d) || !Objects.equals(this.userVlanPriority, -1);
        }
        return this.checkTagActionIsOneOfParameters(cC.e);
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ServicePortBaseDTO)) {
            return false;
        }
        ServicePortBaseDTO other = (ServicePortBaseDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$ponPortId = this.getPonPortId();
        Integer other$ponPortId = other.getPonPortId();
        if (this$ponPortId == null ? other$ponPortId != null : !((Object)this$ponPortId).equals(other$ponPortId)) {
            return false;
        }
        Integer this$svlan = this.getSvlan();
        Integer other$svlan = other.getSvlan();
        if (this$svlan == null ? other$svlan != null : !((Object)this$svlan).equals(other$svlan)) {
            return false;
        }
        Integer this$gemPortId = this.getGemPortId();
        Integer other$gemPortId = other.getGemPortId();
        if (this$gemPortId == null ? other$gemPortId != null : !((Object)this$gemPortId).equals(other$gemPortId)) {
            return false;
        }
        Integer this$userVlan = this.getUserVlan();
        Integer other$userVlan = other.getUserVlan();
        if (this$userVlan == null ? other$userVlan != null : !((Object)this$userVlan).equals(other$userVlan)) {
            return false;
        }
        Integer this$userVlanPriority = this.getUserVlanPriority();
        Integer other$userVlanPriority = other.getUserVlanPriority();
        if (this$userVlanPriority == null ? other$userVlanPriority != null : !((Object)this$userVlanPriority).equals(other$userVlanPriority)) {
            return false;
        }
        Integer this$innerVlan = this.getInnerVlan();
        Integer other$innerVlan = other.getInnerVlan();
        if (this$innerVlan == null ? other$innerVlan != null : !((Object)this$innerVlan).equals(other$innerVlan)) {
            return false;
        }
        Integer this$innerVlanPriority = this.getInnerVlanPriority();
        Integer other$innerVlanPriority = other.getInnerVlanPriority();
        if (this$innerVlanPriority == null ? other$innerVlanPriority != null : !((Object)this$innerVlanPriority).equals(other$innerVlanPriority)) {
            return false;
        }
        Integer this$inboundTrafficProfileId = this.getInboundTrafficProfileId();
        Integer other$inboundTrafficProfileId = other.getInboundTrafficProfileId();
        if (this$inboundTrafficProfileId == null ? other$inboundTrafficProfileId != null : !((Object)this$inboundTrafficProfileId).equals(other$inboundTrafficProfileId)) {
            return false;
        }
        Integer this$outboundTrafficProfileId = this.getOutboundTrafficProfileId();
        Integer other$outboundTrafficProfileId = other.getOutboundTrafficProfileId();
        if (this$outboundTrafficProfileId == null ? other$outboundTrafficProfileId != null : !((Object)this$outboundTrafficProfileId).equals(other$outboundTrafficProfileId)) {
            return false;
        }
        String this$ponPortStr = this.getPonPortStr();
        String other$ponPortStr = other.getPonPortStr();
        if (this$ponPortStr == null ? other$ponPortStr != null : !this$ponPortStr.equals(other$ponPortStr)) {
            return false;
        }
        cC this$tagAction = this.getTagAction();
        cC other$tagAction = other.getTagAction();
        if (this$tagAction == null ? other$tagAction != null : !this$tagAction.equals(other$tagAction)) {
            return false;
        }
        ai this$etherType = this.getEtherType();
        ai other$etherType = other.getEtherType();
        return !(this$etherType == null ? other$etherType != null : !this$etherType.equals(other$etherType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServicePortBaseDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $ponPortId = this.getPonPortId();
        result = result * 59 + ($ponPortId == null ? 43 : ((Object)$ponPortId).hashCode());
        Integer $svlan = this.getSvlan();
        result = result * 59 + ($svlan == null ? 43 : ((Object)$svlan).hashCode());
        Integer $gemPortId = this.getGemPortId();
        result = result * 59 + ($gemPortId == null ? 43 : ((Object)$gemPortId).hashCode());
        Integer $userVlan = this.getUserVlan();
        result = result * 59 + ($userVlan == null ? 43 : ((Object)$userVlan).hashCode());
        Integer $userVlanPriority = this.getUserVlanPriority();
        result = result * 59 + ($userVlanPriority == null ? 43 : ((Object)$userVlanPriority).hashCode());
        Integer $innerVlan = this.getInnerVlan();
        result = result * 59 + ($innerVlan == null ? 43 : ((Object)$innerVlan).hashCode());
        Integer $innerVlanPriority = this.getInnerVlanPriority();
        result = result * 59 + ($innerVlanPriority == null ? 43 : ((Object)$innerVlanPriority).hashCode());
        Integer $inboundTrafficProfileId = this.getInboundTrafficProfileId();
        result = result * 59 + ($inboundTrafficProfileId == null ? 43 : ((Object)$inboundTrafficProfileId).hashCode());
        Integer $outboundTrafficProfileId = this.getOutboundTrafficProfileId();
        result = result * 59 + ($outboundTrafficProfileId == null ? 43 : ((Object)$outboundTrafficProfileId).hashCode());
        String $ponPortStr = this.getPonPortStr();
        result = result * 59 + ($ponPortStr == null ? 43 : $ponPortStr.hashCode());
        cC $tagAction = this.getTagAction();
        result = result * 59 + ($tagAction == null ? 43 : $tagAction.hashCode());
        ai $etherType = this.getEtherType();
        result = result * 59 + ($etherType == null ? 43 : $etherType.hashCode());
        return result;
    }

    @Generated
    public Integer getPonPortId() {
        return this.ponPortId;
    }

    @Generated
    public String getPonPortStr() {
        return this.ponPortStr;
    }

    @Generated
    public Integer getSvlan() {
        return this.svlan;
    }

    @Generated
    public Integer getGemPortId() {
        return this.gemPortId;
    }

    @Generated
    public Integer getUserVlan() {
        return this.userVlan;
    }

    @Generated
    public Integer getUserVlanPriority() {
        return this.userVlanPriority;
    }

    @Generated
    public cC getTagAction() {
        return this.tagAction;
    }

    @Generated
    public Integer getInnerVlan() {
        return this.innerVlan;
    }

    @Generated
    public Integer getInnerVlanPriority() {
        return this.innerVlanPriority;
    }

    @Generated
    public ai getEtherType() {
        return this.etherType;
    }

    @Generated
    public Integer getInboundTrafficProfileId() {
        return this.inboundTrafficProfileId;
    }

    @Generated
    public Integer getOutboundTrafficProfileId() {
        return this.outboundTrafficProfileId;
    }

    @Generated
    public void setPonPortId(Integer ponPortId) {
        this.ponPortId = ponPortId;
    }

    @Generated
    public void setPonPortStr(String ponPortStr) {
        this.ponPortStr = ponPortStr;
    }

    @Generated
    public void setSvlan(Integer svlan) {
        this.svlan = svlan;
    }

    @Generated
    public void setGemPortId(Integer gemPortId) {
        this.gemPortId = gemPortId;
    }

    @Generated
    public void setUserVlan(Integer userVlan) {
        this.userVlan = userVlan;
    }

    @Generated
    public void setUserVlanPriority(Integer userVlanPriority) {
        this.userVlanPriority = userVlanPriority;
    }

    @Generated
    public void setTagAction(cC tagAction) {
        this.tagAction = tagAction;
    }

    @Generated
    public void setInnerVlan(Integer innerVlan) {
        this.innerVlan = innerVlan;
    }

    @Generated
    public void setInnerVlanPriority(Integer innerVlanPriority) {
        this.innerVlanPriority = innerVlanPriority;
    }

    @Generated
    public void setEtherType(ai etherType) {
        this.etherType = etherType;
    }

    @Generated
    public void setInboundTrafficProfileId(Integer inboundTrafficProfileId) {
        this.inboundTrafficProfileId = inboundTrafficProfileId;
    }

    @Generated
    public void setOutboundTrafficProfileId(Integer outboundTrafficProfileId) {
        this.outboundTrafficProfileId = outboundTrafficProfileId;
    }

    @Generated
    public String toString() {
        return "ServicePortBaseDTO(ponPortId=" + this.getPonPortId() + ", ponPortStr=" + this.getPonPortStr() + ", svlan=" + this.getSvlan() + ", gemPortId=" + this.getGemPortId() + ", userVlan=" + this.getUserVlan() + ", userVlanPriority=" + this.getUserVlanPriority() + ", tagAction=" + this.getTagAction() + ", innerVlan=" + this.getInnerVlan() + ", innerVlanPriority=" + this.getInnerVlanPriority() + ", etherType=" + this.getEtherType() + ", inboundTrafficProfileId=" + this.getInboundTrafficProfileId() + ", outboundTrafficProfileId=" + this.getOutboundTrafficProfileId() + ")";
    }

    @Generated
    public ServicePortBaseDTO(Integer ponPortId, String ponPortStr, Integer svlan, Integer gemPortId, Integer userVlan, Integer userVlanPriority, cC tagAction, Integer innerVlan, Integer innerVlanPriority, ai etherType, Integer inboundTrafficProfileId, Integer outboundTrafficProfileId) {
        this.ponPortId = ponPortId;
        this.ponPortStr = ponPortStr;
        this.svlan = svlan;
        this.gemPortId = gemPortId;
        this.userVlan = userVlan;
        this.userVlanPriority = userVlanPriority;
        this.tagAction = tagAction;
        this.innerVlan = innerVlan;
        this.innerVlanPriority = innerVlanPriority;
        this.etherType = etherType;
        this.inboundTrafficProfileId = inboundTrafficProfileId;
        this.outboundTrafficProfileId = outboundTrafficProfileId;
    }

    @Generated
    public ServicePortBaseDTO() {
    }
}

