/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.serviceport;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.manager.c.b.ac;
import com.tplink.smb.omada.manager.device.olt.pon.serviceport.ServicePortBaseDTO;
import com.tplink.smb.omada.manager.util.f;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class ServicePortAddDTO
extends ServicePortBaseDTO {
    private static final long serialVersionUID = -4325978769749012332L;
    @Schema(description="ID of service port.Index should be within the range of 1 to 8100")
    @Range(min=1L, max=8100L, message="index should be a number between {min}-{max}")
    private @Range(min=1L, max=8100L, message="index should be a number between {min}-{max}") Integer index;
    @Schema(description="Whether it is batch addition.Default value:false", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="batchConfig can not be null")
    private @NotNull(message="batchConfig can not be null") Boolean batchConfig;
    @Schema(description="Description of service port.Description should be 1-32 characters, including letters, numbers, and symbols (-@_:/.).")
    @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{0,32}$", message="only 0-32 bits numbers, Upper and lower letters, -@_:/. are allowed.")
    private @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{0,32}$", message="only 0-32 bits numbers, Upper and lower letters, -@_:/. are allowed.") String description;
    @Schema(description="OnuId should be within the range of 0 to 127", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="onuId should not be null")
    private @NotNull(message="onuId should not be null") String onuId;
    @Schema(description="The enable status of the service flows matched by this Service Port. AdminStatus should be a value as follows: DISABLE,ENABLE. Default value: ENABLE.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="adminStatus should not be null")
    private @NotNull(message="adminStatus should not be null") ac adminStatus;
    @Schema(description="The traffic statistics switch status for the service flows matched by this Service Port. StatisticPerformance should be a value as follows: DISABLE,ENABLE. Default value: DISABLE.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="statisticPerformance should not be null")
    private @NotNull(message="statisticPerformance should not be null") ac statisticPerformance;

    public <T> OperationResponse<T> check() {
        if (!this.checkId()) {
            return new OperationResponse(b.d, "The ONU ID should be between 1 and 128", null);
        }
        return null;
    }

    private boolean checkId() {
        return f.a((String)this.onuId, (int)0, (int)127);
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ServicePortAddDTO)) {
            return false;
        }
        ServicePortAddDTO other = (ServicePortAddDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Boolean this$batchConfig = this.getBatchConfig();
        Boolean other$batchConfig = other.getBatchConfig();
        if (this$batchConfig == null ? other$batchConfig != null : !((Object)this$batchConfig).equals(other$batchConfig)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$onuId = this.getOnuId();
        String other$onuId = other.getOnuId();
        if (this$onuId == null ? other$onuId != null : !this$onuId.equals(other$onuId)) {
            return false;
        }
        ac this$adminStatus = this.getAdminStatus();
        ac other$adminStatus = other.getAdminStatus();
        if (this$adminStatus == null ? other$adminStatus != null : !this$adminStatus.equals(other$adminStatus)) {
            return false;
        }
        ac this$statisticPerformance = this.getStatisticPerformance();
        ac other$statisticPerformance = other.getStatisticPerformance();
        return !(this$statisticPerformance == null ? other$statisticPerformance != null : !this$statisticPerformance.equals(other$statisticPerformance));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServicePortAddDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Boolean $batchConfig = this.getBatchConfig();
        result = result * 59 + ($batchConfig == null ? 43 : ((Object)$batchConfig).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $onuId = this.getOnuId();
        result = result * 59 + ($onuId == null ? 43 : $onuId.hashCode());
        ac $adminStatus = this.getAdminStatus();
        result = result * 59 + ($adminStatus == null ? 43 : $adminStatus.hashCode());
        ac $statisticPerformance = this.getStatisticPerformance();
        result = result * 59 + ($statisticPerformance == null ? 43 : $statisticPerformance.hashCode());
        return result;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public Boolean getBatchConfig() {
        return this.batchConfig;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getOnuId() {
        return this.onuId;
    }

    @Generated
    public ac getAdminStatus() {
        return this.adminStatus;
    }

    @Generated
    public ac getStatisticPerformance() {
        return this.statisticPerformance;
    }

    @Generated
    public ServicePortAddDTO setIndex(Integer index) {
        this.index = index;
        return this;
    }

    @Generated
    public ServicePortAddDTO setBatchConfig(Boolean batchConfig) {
        this.batchConfig = batchConfig;
        return this;
    }

    @Generated
    public ServicePortAddDTO setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public ServicePortAddDTO setOnuId(String onuId) {
        this.onuId = onuId;
        return this;
    }

    @Generated
    public ServicePortAddDTO setAdminStatus(ac adminStatus) {
        this.adminStatus = adminStatus;
        return this;
    }

    @Generated
    public ServicePortAddDTO setStatisticPerformance(ac statisticPerformance) {
        this.statisticPerformance = statisticPerformance;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "ServicePortAddDTO(index=" + this.getIndex() + ", batchConfig=" + this.getBatchConfig() + ", description=" + this.getDescription() + ", onuId=" + this.getOnuId() + ", adminStatus=" + this.getAdminStatus() + ", statisticPerformance=" + this.getStatisticPerformance() + ")";
    }

    @Generated
    public ServicePortAddDTO(Integer index, Boolean batchConfig, String description, String onuId, ac adminStatus, ac statisticPerformance) {
        this.index = index;
        this.batchConfig = batchConfig;
        this.description = description;
        this.onuId = onuId;
        this.adminStatus = adminStatus;
        this.statisticPerformance = statisticPerformance;
    }

    @Generated
    public ServicePortAddDTO() {
    }
}

