/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.profile.traffic;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.manager.c.b.ac;
import com.tplink.smb.omada.manager.c.b.cH;
import com.tplink.smb.omada.manager.c.b.cI;
import com.tplink.smb.omada.manager.c.b.cJ;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class TrafficProfileBaseDTO
extends DpmsBaseDeviceDTO {
    @Schema(description="Name of the traffic profile. No user configuration is automatically generated by the device. The name should contain 1 to 32 characters, including upper and lower letters, numbers, and symbols (-@_:/.).")
    @Length(min=1, max=32, message="name should between {min}~{max} characters")
    @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{1,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.")
    private @Length(min=1, max=32, message="name should between {min}~{max} characters") @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{1,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.") String name;
    @Schema(description="Whether to enable rate limit.RateLimitStatus should be a value as follows:DISABLE,ENABLE.ENABLE by default.When enabled, CIR must be configured, while CBS, PIR, and PBS parameters are optional.When disabled, the CIR, CBS, PIR, and PBS parameters are grayed out and cannot be configured.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="rateLimitStatus should not be null")
    private @NotNull(message="rateLimitStatus should not be null") ac rateLimitStatus;
    @Schema(description="CirValue should be within the range of 128 to 10240000")
    @Range(min=128L, max=10240000L, message="cirValue should be a number between {min}-{max}")
    private @Range(min=128L, max=10240000L, message="cirValue should be a number between {min}-{max}") Integer cirValue;
    @Schema(description="CbsValue should be within the range of 2000 to 10240000")
    @Range(min=2000L, max=10240000L, message="cbsValue should be a number between {min}-{max}")
    private @Range(min=2000L, max=10240000L, message="cbsValue should be a number between {min}-{max}") Integer cbsValue;
    @Schema(description="PirValue should be within the range of 128 to 10240000")
    @Range(min=128L, max=10240000L, message="pirValue should be a number between {min}-{max}")
    private @Range(min=128L, max=10240000L, message="pirValue should be a number between {min}-{max}") Integer pirValue;
    @Schema(description="PbsValue should be within the range of 2000 to 10240000")
    @Range(min=2000L, max=10240000L, message="pbsValue should be a number between {min}-{max}")
    private @Range(min=2000L, max=10240000L, message="pbsValue should be a number between {min}-{max}") Integer pbsValue;
    @Schema(description="Priority type of the traffic profile.Priority should be a value as follows:ASSIGNED,USER_COS", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="priority should not be null")
    private @NotNull(message="priority should not be null") cI priority;
    @Schema(description="Priority value of the traffic profile.PriorityValue should be within the range of 0 to 7", requiredMode=Schema.RequiredMode.REQUIRED)
    @Range(min=0L, max=7L, message="priorityValue should be a number between {min}-{max}")
    @NotNull(message="priorityValue should not be null")
    private @Range(min=0L, max=7L, message="priorityValue should be a number between {min}-{max}") @NotNull(message="priorityValue should not be null") Integer priorityValue;
    @Schema(description="Inner priority type of the traffic profile,innerPriority should be a value as follows ASSIGNED, NONE, USER_COS, USER_INNER_COS", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="innerPriority should not be null")
    private @NotNull(message="innerPriority should not be null") cH innerPriority;
    @Schema(description="Inner priority value of the traffic profile.InnerPriorityValue should be within the range of 0 to 7")
    @Range(min=0L, max=7L, message="innerPriorityValue should be a number between {min}-{max}")
    private @Range(min=0L, max=7L, message="innerPriorityValue should be a number between {min}-{max}") Integer innerPriorityValue;
    @Schema(description="Traffic priority policy should be a value as follows:LOCAL_SETTING, TAG_IN_PACKAGE, TAG_IN_INGRESS_PACKAGE", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="priorityPolicy should not be null")
    private @NotNull(message="priorityPolicy should not be null") cJ priorityPolicy;
    @Schema(description="Whether the Traffic Profile is in use; if it is in use, it cannot be deleted.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Null(message="isInUse should be null.")
    private @Null(message="isInUse should be null.") Boolean isInUse;

    public OperationResponse check() {
        switch (this.rateLimitStatus) {
            case b: {
                if (!Objects.isNull(this.cirValue)) break;
                return new OperationResponse(b.d, "cirValue should not be null", null);
            }
            case a: {
                if (!Objects.nonNull(this.cirValue) && !Objects.nonNull(this.cbsValue) && !Objects.nonNull(this.pirValue) && !Objects.nonNull(this.pbsValue)) break;
                return new OperationResponse(b.d, "cirValue\u3001cbsValue\u3001pirValue\u3001pbsValue should be null", null);
            }
        }
        if (!Objects.equals(this.innerPriority, cH.b) && Objects.isNull(this.innerPriorityValue)) {
            return new OperationResponse(b.d, "innerPriorityValue should not be null", null);
        }
        return null;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof TrafficProfileBaseDTO)) {
            return false;
        }
        TrafficProfileBaseDTO other = (TrafficProfileBaseDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$cirValue = this.getCirValue();
        Integer other$cirValue = other.getCirValue();
        if (this$cirValue == null ? other$cirValue != null : !((Object)this$cirValue).equals(other$cirValue)) {
            return false;
        }
        Integer this$cbsValue = this.getCbsValue();
        Integer other$cbsValue = other.getCbsValue();
        if (this$cbsValue == null ? other$cbsValue != null : !((Object)this$cbsValue).equals(other$cbsValue)) {
            return false;
        }
        Integer this$pirValue = this.getPirValue();
        Integer other$pirValue = other.getPirValue();
        if (this$pirValue == null ? other$pirValue != null : !((Object)this$pirValue).equals(other$pirValue)) {
            return false;
        }
        Integer this$pbsValue = this.getPbsValue();
        Integer other$pbsValue = other.getPbsValue();
        if (this$pbsValue == null ? other$pbsValue != null : !((Object)this$pbsValue).equals(other$pbsValue)) {
            return false;
        }
        Integer this$priorityValue = this.getPriorityValue();
        Integer other$priorityValue = other.getPriorityValue();
        if (this$priorityValue == null ? other$priorityValue != null : !((Object)this$priorityValue).equals(other$priorityValue)) {
            return false;
        }
        Integer this$innerPriorityValue = this.getInnerPriorityValue();
        Integer other$innerPriorityValue = other.getInnerPriorityValue();
        if (this$innerPriorityValue == null ? other$innerPriorityValue != null : !((Object)this$innerPriorityValue).equals(other$innerPriorityValue)) {
            return false;
        }
        Boolean this$isInUse = this.getIsInUse();
        Boolean other$isInUse = other.getIsInUse();
        if (this$isInUse == null ? other$isInUse != null : !((Object)this$isInUse).equals(other$isInUse)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ac this$rateLimitStatus = this.getRateLimitStatus();
        ac other$rateLimitStatus = other.getRateLimitStatus();
        if (this$rateLimitStatus == null ? other$rateLimitStatus != null : !this$rateLimitStatus.equals(other$rateLimitStatus)) {
            return false;
        }
        cI this$priority = this.getPriority();
        cI other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !this$priority.equals(other$priority)) {
            return false;
        }
        cH this$innerPriority = this.getInnerPriority();
        cH other$innerPriority = other.getInnerPriority();
        if (this$innerPriority == null ? other$innerPriority != null : !this$innerPriority.equals(other$innerPriority)) {
            return false;
        }
        cJ this$priorityPolicy = this.getPriorityPolicy();
        cJ other$priorityPolicy = other.getPriorityPolicy();
        return !(this$priorityPolicy == null ? other$priorityPolicy != null : !this$priorityPolicy.equals(other$priorityPolicy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TrafficProfileBaseDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $cirValue = this.getCirValue();
        result = result * 59 + ($cirValue == null ? 43 : ((Object)$cirValue).hashCode());
        Integer $cbsValue = this.getCbsValue();
        result = result * 59 + ($cbsValue == null ? 43 : ((Object)$cbsValue).hashCode());
        Integer $pirValue = this.getPirValue();
        result = result * 59 + ($pirValue == null ? 43 : ((Object)$pirValue).hashCode());
        Integer $pbsValue = this.getPbsValue();
        result = result * 59 + ($pbsValue == null ? 43 : ((Object)$pbsValue).hashCode());
        Integer $priorityValue = this.getPriorityValue();
        result = result * 59 + ($priorityValue == null ? 43 : ((Object)$priorityValue).hashCode());
        Integer $innerPriorityValue = this.getInnerPriorityValue();
        result = result * 59 + ($innerPriorityValue == null ? 43 : ((Object)$innerPriorityValue).hashCode());
        Boolean $isInUse = this.getIsInUse();
        result = result * 59 + ($isInUse == null ? 43 : ((Object)$isInUse).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ac $rateLimitStatus = this.getRateLimitStatus();
        result = result * 59 + ($rateLimitStatus == null ? 43 : $rateLimitStatus.hashCode());
        cI $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : $priority.hashCode());
        cH $innerPriority = this.getInnerPriority();
        result = result * 59 + ($innerPriority == null ? 43 : $innerPriority.hashCode());
        cJ $priorityPolicy = this.getPriorityPolicy();
        result = result * 59 + ($priorityPolicy == null ? 43 : $priorityPolicy.hashCode());
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ac getRateLimitStatus() {
        return this.rateLimitStatus;
    }

    @Generated
    public Integer getCirValue() {
        return this.cirValue;
    }

    @Generated
    public Integer getCbsValue() {
        return this.cbsValue;
    }

    @Generated
    public Integer getPirValue() {
        return this.pirValue;
    }

    @Generated
    public Integer getPbsValue() {
        return this.pbsValue;
    }

    @Generated
    public cI getPriority() {
        return this.priority;
    }

    @Generated
    public Integer getPriorityValue() {
        return this.priorityValue;
    }

    @Generated
    public cH getInnerPriority() {
        return this.innerPriority;
    }

    @Generated
    public Integer getInnerPriorityValue() {
        return this.innerPriorityValue;
    }

    @Generated
    public cJ getPriorityPolicy() {
        return this.priorityPolicy;
    }

    @Generated
    public Boolean getIsInUse() {
        return this.isInUse;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRateLimitStatus(ac rateLimitStatus) {
        this.rateLimitStatus = rateLimitStatus;
    }

    @Generated
    public void setCirValue(Integer cirValue) {
        this.cirValue = cirValue;
    }

    @Generated
    public void setCbsValue(Integer cbsValue) {
        this.cbsValue = cbsValue;
    }

    @Generated
    public void setPirValue(Integer pirValue) {
        this.pirValue = pirValue;
    }

    @Generated
    public void setPbsValue(Integer pbsValue) {
        this.pbsValue = pbsValue;
    }

    @Generated
    public void setPriority(cI priority) {
        this.priority = priority;
    }

    @Generated
    public void setPriorityValue(Integer priorityValue) {
        this.priorityValue = priorityValue;
    }

    @Generated
    public void setInnerPriority(cH innerPriority) {
        this.innerPriority = innerPriority;
    }

    @Generated
    public void setInnerPriorityValue(Integer innerPriorityValue) {
        this.innerPriorityValue = innerPriorityValue;
    }

    @Generated
    public void setPriorityPolicy(cJ priorityPolicy) {
        this.priorityPolicy = priorityPolicy;
    }

    @Generated
    public void setIsInUse(Boolean isInUse) {
        this.isInUse = isInUse;
    }

    @Generated
    public String toString() {
        return "TrafficProfileBaseDTO(name=" + this.getName() + ", rateLimitStatus=" + this.getRateLimitStatus() + ", cirValue=" + this.getCirValue() + ", cbsValue=" + this.getCbsValue() + ", pirValue=" + this.getPirValue() + ", pbsValue=" + this.getPbsValue() + ", priority=" + this.getPriority() + ", priorityValue=" + this.getPriorityValue() + ", innerPriority=" + this.getInnerPriority() + ", innerPriorityValue=" + this.getInnerPriorityValue() + ", priorityPolicy=" + this.getPriorityPolicy() + ", isInUse=" + this.getIsInUse() + ")";
    }

    @Generated
    public TrafficProfileBaseDTO(String name, ac rateLimitStatus, Integer cirValue, Integer cbsValue, Integer pirValue, Integer pbsValue, cI priority, Integer priorityValue, cH innerPriority, Integer innerPriorityValue, cJ priorityPolicy, Boolean isInUse) {
        this.name = name;
        this.rateLimitStatus = rateLimitStatus;
        this.cirValue = cirValue;
        this.cbsValue = cbsValue;
        this.pirValue = pirValue;
        this.pbsValue = pbsValue;
        this.priority = priority;
        this.priorityValue = priorityValue;
        this.innerPriority = innerPriority;
        this.innerPriorityValue = innerPriorityValue;
        this.priorityPolicy = priorityPolicy;
        this.isInUse = isInUse;
    }

    @Generated
    public TrafficProfileBaseDTO() {
    }
}

