/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.olt.pon.profile.service;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.manager.c.b.aY;
import com.tplink.smb.omada.manager.c.b.aZ;
import com.tplink.smb.omada.manager.c.b.ac;
import com.tplink.smb.omada.manager.c.b.bc;
import com.tplink.smb.omada.manager.c.b.cD;
import com.tplink.smb.omada.manager.device.api.web.validation.olt.SortedField;
import com.tplink.smb.omada.manager.device.olt.DpmsBaseDeviceDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class ServiceProfileDTO
extends DpmsBaseDeviceDTO {
    private static final long serialVersionUID = -4239753826597810851L;
    @Schema(name="serviceId", description="Service profile ID should be within the range of 1 to 512 ", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="profile id should not be null")
    @Range(min=1L, max=512L, message="serviceId should be a number between {min}-{max}")
    @SortedField
    private @NotNull(message="profile id should not be null") @Range(min=1L, max=512L, message="serviceId should be a number between {min}-{max}") Integer serviceId;
    @Schema(hidden=true)
    @Null(message="isSystemProfile should be null, because it's generated by device.")
    private @Null(message="isSystemProfile should be null, because it's generated by device.") Boolean isSystemProfile;
    @Schema(name="isInUse", description="Whether the service profile is in use", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Null(message="isInUse should be null.")
    private @Null(message="isInUse should be null.") Boolean isInUse;
    @Schema(name="name", description="Name of the service profile. No user configuration is automatically generated by the device. The name should contain 1 to 32 characters, including upper and lower letters, numbers, and symbols (-@_:/.).")
    @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{1,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.")
    private @Pattern(regexp="^[a-z0-9A-Z-@_:/.]{1,32}$", message="only 1-32 bits numbers, Upper and lower letters, -@_:/. are allowed.") String name;
    @Schema(name="ethNum", description="Number of eth port.EthNum should be within the range of -1 to 24.-1 indicates that the number of ports is adaptive. The default value is -1.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="ethNum should not be null")
    @Range(min=-1L, max=24L, message="ethNum should be a number between {min}-{max}")
    private @NotNull(message="ethNum should not be null") @Range(min=-1L, max=24L, message="ethNum should be a number between {min}-{max}") Integer ethNum;
    @Schema(name="maxAdaptiveEthNum", description="Set the maximum number of automatically recognized ETH ports.When ethNum is set to -1, a prompt will appear.MaxAdaptiveEthNum should be within the range of 0 to 24")
    @Range(min=0L, max=24L, message="maxAdaptiveEthNum should be a number between {min}-{max}")
    private @Range(min=0L, max=24L, message="maxAdaptiveEthNum should be a number between {min}-{max}") Integer maxAdaptiveEthNum;
    @Schema(name="potsNum", description="Number of ONU pots.PotsNum should be within the range of -1 to 8.-1 indicates that the number of ports is adaptive. The default value is -1.", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="potsNum should not be null")
    @Range(min=-1L, max=8L, message="potsNum should be a number between {min}-{max}")
    private @NotNull(message="potsNum should not be null") @Range(min=-1L, max=8L, message="potsNum should be a number between {min}-{max}") Integer potsNum;
    @Schema(name="maxAdaptivePotsNum", description="Set the maximum number of automatically recognized potsWhen potsNum is set to -1, a prompt will appear.MaxAdaptivePotsNum should be within the range of 0 to 4")
    @Range(min=0L, max=24L, message="maxAdaptivePotsNum should be a number between {min}-{max}")
    private @Range(min=0L, max=24L, message="maxAdaptivePotsNum should be a number between {min}-{max}") Integer maxAdaptivePotsNum;
    @NotNull(message="macLearning should not be null")
    @Schema(name="macLearning", description="Enable/disable ONT MAC address learning function. MacLearning should be a value as follows:DISABLE,ENABLE")
    private @NotNull(message="macLearning should not be null") ac macLearning;
    @Schema(name="nativeVlan", description="The ONT's concern for Native VLAN .NativeVlan should be a value as follows:UNCONCERN,CONCERN", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull(message="nativeVlan should not be null")
    private @NotNull(message="nativeVlan should not be null") bc nativeVlan;
    @NotNull(message="multicastMode should not be null")
    @Schema(name="multicastMode", description="Set the multicast mode of the ONT. MulticastMode should be a value as follows:UNCONCERN,IGMP_SNOOPING,OLT_CONTROL")
    private @NotNull(message="multicastMode should not be null") aZ multicastMode;
    @NotNull(message="multicastForward should not be null")
    @Schema(name="multicastForward", description="Set the multicast packet forwarding mode of the ONT. NativeVlan should be a value as follows:UNCONCERN,TAGGED,UNTAGGED")
    private @NotNull(message="multicastForward should not be null") aY multicastForward;
    @Schema(name="taggedType", description="TaggedType should be a value as follows:TRANSPARENT,TRANSLATION")
    private cD taggedType;
    @Range(min=1L, max=4094L, message="taggedVlanId should be a number between {min}-{max}")
    @Schema(name="taggedVlanId", description="TaggedVlanId should be within the range of 1\u20134094")
    private @Range(min=1L, max=4094L, message="taggedVlanId should be a number between {min}-{max}") Integer taggedVlanId;
    @Schema(name="onuBindNum", description="The number of ONU/ONT instances that use this Service template.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Null(message="onuBindNum should be null.")
    private @Null(message="onuBindNum should be null.") Integer onuBindNum;

    public OperationResponse check() {
        if (Objects.equals(this.multicastForward, aY.b)) {
            if (Objects.isNull(this.taggedType)) {
                return new OperationResponse(b.d, "TaggedType should not be null when multicastForward is Tagged.", null);
            }
            if (Objects.equals(this.taggedType, cD.b) && Objects.isNull(this.taggedVlanId)) {
                return new OperationResponse(b.d, "TaggedVlanId should not be null when taggedType is Translation.", null);
            }
            if (!Objects.equals(this.taggedType, cD.b) && Objects.nonNull(this.taggedVlanId)) {
                return new OperationResponse(b.d, "TaggedVlanId should be null when taggedType is not Translation.", null);
            }
        } else {
            if (Objects.nonNull(this.taggedType)) {
                return new OperationResponse(b.d, "TaggedType should be null when multicastForward is not Tagged.", null);
            }
            if (Objects.nonNull(this.taggedVlanId)) {
                return new OperationResponse(b.d, (Object)"TaggedVlanId should be null when multicastForward is not Tagged.");
            }
        }
        if (Objects.nonNull(this.ethNum) && this.ethNum != -1 && Objects.nonNull(this.maxAdaptiveEthNum)) {
            return new OperationResponse(b.d, (Object)"maxAdaptiveEthNum should be null");
        }
        if (Objects.nonNull(this.potsNum) && this.potsNum != -1 && Objects.nonNull(this.maxAdaptivePotsNum)) {
            return new OperationResponse(b.d, "maxAdaptivePotsNum should be null", null);
        }
        return null;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ServiceProfileDTO)) {
            return false;
        }
        ServiceProfileDTO other = (ServiceProfileDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$serviceId = this.getServiceId();
        Integer other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !((Object)this$serviceId).equals(other$serviceId)) {
            return false;
        }
        Boolean this$isSystemProfile = this.getIsSystemProfile();
        Boolean other$isSystemProfile = other.getIsSystemProfile();
        if (this$isSystemProfile == null ? other$isSystemProfile != null : !((Object)this$isSystemProfile).equals(other$isSystemProfile)) {
            return false;
        }
        Boolean this$isInUse = this.getIsInUse();
        Boolean other$isInUse = other.getIsInUse();
        if (this$isInUse == null ? other$isInUse != null : !((Object)this$isInUse).equals(other$isInUse)) {
            return false;
        }
        Integer this$ethNum = this.getEthNum();
        Integer other$ethNum = other.getEthNum();
        if (this$ethNum == null ? other$ethNum != null : !((Object)this$ethNum).equals(other$ethNum)) {
            return false;
        }
        Integer this$maxAdaptiveEthNum = this.getMaxAdaptiveEthNum();
        Integer other$maxAdaptiveEthNum = other.getMaxAdaptiveEthNum();
        if (this$maxAdaptiveEthNum == null ? other$maxAdaptiveEthNum != null : !((Object)this$maxAdaptiveEthNum).equals(other$maxAdaptiveEthNum)) {
            return false;
        }
        Integer this$potsNum = this.getPotsNum();
        Integer other$potsNum = other.getPotsNum();
        if (this$potsNum == null ? other$potsNum != null : !((Object)this$potsNum).equals(other$potsNum)) {
            return false;
        }
        Integer this$maxAdaptivePotsNum = this.getMaxAdaptivePotsNum();
        Integer other$maxAdaptivePotsNum = other.getMaxAdaptivePotsNum();
        if (this$maxAdaptivePotsNum == null ? other$maxAdaptivePotsNum != null : !((Object)this$maxAdaptivePotsNum).equals(other$maxAdaptivePotsNum)) {
            return false;
        }
        Integer this$taggedVlanId = this.getTaggedVlanId();
        Integer other$taggedVlanId = other.getTaggedVlanId();
        if (this$taggedVlanId == null ? other$taggedVlanId != null : !((Object)this$taggedVlanId).equals(other$taggedVlanId)) {
            return false;
        }
        Integer this$onuBindNum = this.getOnuBindNum();
        Integer other$onuBindNum = other.getOnuBindNum();
        if (this$onuBindNum == null ? other$onuBindNum != null : !((Object)this$onuBindNum).equals(other$onuBindNum)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ac this$macLearning = this.getMacLearning();
        ac other$macLearning = other.getMacLearning();
        if (this$macLearning == null ? other$macLearning != null : !this$macLearning.equals(other$macLearning)) {
            return false;
        }
        bc this$nativeVlan = this.getNativeVlan();
        bc other$nativeVlan = other.getNativeVlan();
        if (this$nativeVlan == null ? other$nativeVlan != null : !this$nativeVlan.equals(other$nativeVlan)) {
            return false;
        }
        aZ this$multicastMode = this.getMulticastMode();
        aZ other$multicastMode = other.getMulticastMode();
        if (this$multicastMode == null ? other$multicastMode != null : !this$multicastMode.equals(other$multicastMode)) {
            return false;
        }
        aY this$multicastForward = this.getMulticastForward();
        aY other$multicastForward = other.getMulticastForward();
        if (this$multicastForward == null ? other$multicastForward != null : !this$multicastForward.equals(other$multicastForward)) {
            return false;
        }
        cD this$taggedType = this.getTaggedType();
        cD other$taggedType = other.getTaggedType();
        return !(this$taggedType == null ? other$taggedType != null : !this$taggedType.equals(other$taggedType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceProfileDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : ((Object)$serviceId).hashCode());
        Boolean $isSystemProfile = this.getIsSystemProfile();
        result = result * 59 + ($isSystemProfile == null ? 43 : ((Object)$isSystemProfile).hashCode());
        Boolean $isInUse = this.getIsInUse();
        result = result * 59 + ($isInUse == null ? 43 : ((Object)$isInUse).hashCode());
        Integer $ethNum = this.getEthNum();
        result = result * 59 + ($ethNum == null ? 43 : ((Object)$ethNum).hashCode());
        Integer $maxAdaptiveEthNum = this.getMaxAdaptiveEthNum();
        result = result * 59 + ($maxAdaptiveEthNum == null ? 43 : ((Object)$maxAdaptiveEthNum).hashCode());
        Integer $potsNum = this.getPotsNum();
        result = result * 59 + ($potsNum == null ? 43 : ((Object)$potsNum).hashCode());
        Integer $maxAdaptivePotsNum = this.getMaxAdaptivePotsNum();
        result = result * 59 + ($maxAdaptivePotsNum == null ? 43 : ((Object)$maxAdaptivePotsNum).hashCode());
        Integer $taggedVlanId = this.getTaggedVlanId();
        result = result * 59 + ($taggedVlanId == null ? 43 : ((Object)$taggedVlanId).hashCode());
        Integer $onuBindNum = this.getOnuBindNum();
        result = result * 59 + ($onuBindNum == null ? 43 : ((Object)$onuBindNum).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ac $macLearning = this.getMacLearning();
        result = result * 59 + ($macLearning == null ? 43 : $macLearning.hashCode());
        bc $nativeVlan = this.getNativeVlan();
        result = result * 59 + ($nativeVlan == null ? 43 : $nativeVlan.hashCode());
        aZ $multicastMode = this.getMulticastMode();
        result = result * 59 + ($multicastMode == null ? 43 : $multicastMode.hashCode());
        aY $multicastForward = this.getMulticastForward();
        result = result * 59 + ($multicastForward == null ? 43 : $multicastForward.hashCode());
        cD $taggedType = this.getTaggedType();
        result = result * 59 + ($taggedType == null ? 43 : $taggedType.hashCode());
        return result;
    }

    @Generated
    public ServiceProfileDTO() {
    }

    @Generated
    public Integer getServiceId() {
        return this.serviceId;
    }

    @Generated
    public Boolean getIsSystemProfile() {
        return this.isSystemProfile;
    }

    @Generated
    public Boolean getIsInUse() {
        return this.isInUse;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getEthNum() {
        return this.ethNum;
    }

    @Generated
    public Integer getMaxAdaptiveEthNum() {
        return this.maxAdaptiveEthNum;
    }

    @Generated
    public Integer getPotsNum() {
        return this.potsNum;
    }

    @Generated
    public Integer getMaxAdaptivePotsNum() {
        return this.maxAdaptivePotsNum;
    }

    @Generated
    public ac getMacLearning() {
        return this.macLearning;
    }

    @Generated
    public bc getNativeVlan() {
        return this.nativeVlan;
    }

    @Generated
    public aZ getMulticastMode() {
        return this.multicastMode;
    }

    @Generated
    public aY getMulticastForward() {
        return this.multicastForward;
    }

    @Generated
    public cD getTaggedType() {
        return this.taggedType;
    }

    @Generated
    public Integer getTaggedVlanId() {
        return this.taggedVlanId;
    }

    @Generated
    public Integer getOnuBindNum() {
        return this.onuBindNum;
    }

    @Generated
    public void setServiceId(Integer serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setIsSystemProfile(Boolean isSystemProfile) {
        this.isSystemProfile = isSystemProfile;
    }

    @Generated
    public void setIsInUse(Boolean isInUse) {
        this.isInUse = isInUse;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEthNum(Integer ethNum) {
        this.ethNum = ethNum;
    }

    @Generated
    public void setMaxAdaptiveEthNum(Integer maxAdaptiveEthNum) {
        this.maxAdaptiveEthNum = maxAdaptiveEthNum;
    }

    @Generated
    public void setPotsNum(Integer potsNum) {
        this.potsNum = potsNum;
    }

    @Generated
    public void setMaxAdaptivePotsNum(Integer maxAdaptivePotsNum) {
        this.maxAdaptivePotsNum = maxAdaptivePotsNum;
    }

    @Generated
    public void setMacLearning(ac macLearning) {
        this.macLearning = macLearning;
    }

    @Generated
    public void setNativeVlan(bc nativeVlan) {
        this.nativeVlan = nativeVlan;
    }

    @Generated
    public void setMulticastMode(aZ multicastMode) {
        this.multicastMode = multicastMode;
    }

    @Generated
    public void setMulticastForward(aY multicastForward) {
        this.multicastForward = multicastForward;
    }

    @Generated
    public void setTaggedType(cD taggedType) {
        this.taggedType = taggedType;
    }

    @Generated
    public void setTaggedVlanId(Integer taggedVlanId) {
        this.taggedVlanId = taggedVlanId;
    }

    @Generated
    public void setOnuBindNum(Integer onuBindNum) {
        this.onuBindNum = onuBindNum;
    }

    @Generated
    public String toString() {
        return "ServiceProfileDTO(serviceId=" + this.getServiceId() + ", isSystemProfile=" + this.getIsSystemProfile() + ", isInUse=" + this.getIsInUse() + ", name=" + this.getName() + ", ethNum=" + this.getEthNum() + ", maxAdaptiveEthNum=" + this.getMaxAdaptiveEthNum() + ", potsNum=" + this.getPotsNum() + ", maxAdaptivePotsNum=" + this.getMaxAdaptivePotsNum() + ", macLearning=" + this.getMacLearning() + ", nativeVlan=" + this.getNativeVlan() + ", multicastMode=" + this.getMulticastMode() + ", multicastForward=" + this.getMulticastForward() + ", taggedType=" + this.getTaggedType() + ", taggedVlanId=" + this.getTaggedVlanId() + ", onuBindNum=" + this.getOnuBindNum() + ")";
    }
}

